/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BanksEnum;
import com.kingdee.eas.cp.bc.EmployeeBankAccountCollection;
import com.kingdee.eas.cp.bc.EmployeeBankAccountFactory;
import com.kingdee.eas.cp.bc.EmployeeBankAccountInfo;
import com.kingdee.eas.cp.bc.ExpEmpBankAccException;
import com.kingdee.eas.cp.bc.client.AbstractEmpBankAccEditUI;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class EmpBankAccEditUI
extends AbstractEmpBankAccEditUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpBankAccEditUI.class);

    public EmpBankAccEditUI() throws Exception {
        this.prmtEmployee.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                EmpBankAccEditUI.this.employeeChange(eventObj);
            }
        });
    }

    private void employeeChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != eventObj.getOldValue()) {
            this.setLinkEmployee((PersonInfo)eventObj.getNewValue());
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPre.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
    }

    protected void setLinkEmployee(PersonInfo applier) {
        if (applier == null) {
            return;
        }
        try {
            IPersonFacade ipf = PersonFacadeFactory.getRemoteInstance();
            AdminOrgUnitCollection aouc = ipf.getAdminOrgUnitByPerson(applier.getId());
            AdminOrgUnitInfo aouInfo = null;
            if (aouc != null && aouc.size() > 0) {
                aouInfo = aouc.get(0);
            }
            this.prmtDepartMent.setValue(aouInfo);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.prmtEmployee.requestFocus();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtBankAccount.requestFocus();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnFirst.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.btnPre.setEnabled(false);
            this.btnNext.setEnabled(false);
        }
        this.txtBankAccount.setRequired(true);
        EmpBankAccEditUI.makeApplierF7(this.prmtEmployee, (CoreUIObject)this);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EmployeeBankAccountFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        EmployeeBankAccountInfo tempInfo = new EmployeeBankAccountInfo();
        tempInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        tempInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tempInfo.setBank(BanksEnum.BANK_OF_CHIAN);
        return tempInfo;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtEmployee.getValue() == null) {
            this.prmtEmployee.requestFocus();
            throw new ExpEmpBankAccException(ExpEmpBankAccException.EMPLOYEE_NOT_NULL);
        }
        if (this.prmtDepartMent.getValue() == null) {
            this.prmtEmployee.requestFocus();
            throw new ExpEmpBankAccException(ExpEmpBankAccException.DEMPARTMENT_NOT_NULL);
        }
        if (this.comboBank.getSelectedItem() == null) {
            this.comboBank.requestFocus();
            throw new ExpEmpBankAccException(ExpEmpBankAccException.BANK_NOT_NULL);
        }
        if (this.txtBankAccount.getText() == null || this.txtBankAccount.getText().trim().length() < 1) {
            this.txtBankAccount.requestFocus();
            throw new ExpEmpBankAccException(ExpEmpBankAccException.ACCOUNT_NOT_NULL);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.checkSame();
        }
        super.beforeStoreFields(e);
    }

    private void checkSame() throws Exception {
        int i;
        String tempEmp = null;
        tempEmp = ((PersonInfo)this.prmtEmployee.getValue()).getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        EmployeeBankAccountInfo tempInfo = null;
        EmployeeBankAccountCollection tempCollection = EmployeeBankAccountFactory.getRemoteInstance().getEmployeeBankAccountCollection("select *,employee.* " + ev.toString());
        int n = tempCollection.size();
        for (i = 0; i < n; ++i) {
            tempInfo = tempCollection.get(i);
            if (!tempInfo.getEmployee().getId().toString().equals(tempEmp)) continue;
            this.prmtEmployee.requestFocus();
            throw new ExpEmpBankAccException(ExpEmpBankAccException.EMPLOYEE_EMP_NOT_SAME);
        }
        tempCollection = EmployeeBankAccountFactory.getRemoteInstance().getEmployeeBankAccountCollection("select * " + ev.toString());
        n = tempCollection.size();
        for (i = 0; i < n; ++i) {
            tempInfo = tempCollection.get(i);
            if (!tempInfo.getBankAccount().equals(this.txtBankAccount.getText())) continue;
            this.txtBankAccount.requestFocus();
            throw new ExpEmpBankAccException(ExpEmpBankAccException.EMPLOYEE_ACC_NOT_SAME);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtBankAccount.requestFocus();
        this.btnSubmit.setEnabled(true);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public static void makeApplierF7(KDBizPromptBox bizBoxProposer, CoreUIObject coreui) {
        bizBoxProposer.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        PersonPromptBox select = new PersonPromptBox((IUIObject)coreui, map);
        bizBoxProposer.setSelector((KDPromptSelector)select);
        bizBoxProposer.setDisplayFormat("$name$");
        bizBoxProposer.setEditFormat("$number$");
        bizBoxProposer.setCommitFormat("$number$");
    }
}

