/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.bc.BudgetBalanceCollection;
import com.kingdee.eas.cp.bc.BudgetBalanceInfo;
import com.kingdee.eas.cp.bc.BudgetControlCollection;
import com.kingdee.eas.cp.bc.BudgetControlFactory;
import com.kingdee.eas.cp.bc.BudgetControlInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBaseBillInfo;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.IBudgetControl;
import com.kingdee.eas.cp.bc.IItemApprovedTree;
import com.kingdee.eas.cp.bc.IVoucherTemplateEntry;
import com.kingdee.eas.cp.bc.ItemApprovedTreeCollection;
import com.kingdee.eas.cp.bc.ItemApprovedTreeFactory;
import com.kingdee.eas.cp.bc.ItemApprovedTreeInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountWKFacadeFactory;
import com.kingdee.eas.cp.bc.VehicleBaseDataInfo;
import com.kingdee.eas.cp.bc.VoucherImplFacadeFactory;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryCollection;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryFactory;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryInfo;
import com.kingdee.eas.cp.bc.client.AbstractExpenseAccountTwoEditUI;
import com.kingdee.eas.cp.bc.client.BudgetControlForViewListUI;
import com.kingdee.eas.cp.bc.util.SourceInfo;
import com.kingdee.eas.cp.bc.util.VoucherImpl;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ExpenseAccountTwoEditUI
extends AbstractExpenseAccountTwoEditUI {
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String RES = "com.kingdee.eas.cp.bc.client.ExpenseAccountResource";
    private static final String RESVOU = "com.kingdee.eas.cp.bc.client.VoucherTemplateResource";
    private static final Logger logger = CoreUIObject.getLogger(ExpenseAccountTwoEditUI.class);
    private BigDecimal oldAmountApproved = null;
    protected boolean tempMark = false;
    private int loadTimes = 0;

    @Override
    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void onLoad() throws Exception {
        OperationInfo oper;
        this.initWorkButton();
        super.onLoad();
        this.initCurrency();
        this.btnToKVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_createcredence"));
        this.kDWorkButton1.setIcon(EASResource.getIcon((String)"imgTbtn_seechecklist"));
        this.txtAmount.setDataType(1);
        this.txtAmount.setPrecision(2);
        this.prmtSortName.setHasCUDefaultFilter(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        evi.setFilter(filter);
        this.prmtSortName.setEntityViewInfo(evi);
        this.prmtSortName.setCommitFormat("$number$");
        this.prmtSortName.setEditFormat("$number$");
        this.prmtSortName.setDisplayFormat("$sortName$");
        this.entryNumber.setRequired(true);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setRemoveingZeroInEdit(false);
        this.txtAmountApproved.setHorizontalAlignment(4);
        this.txtAmountApproved.setRemoveingZeroInDispaly(false);
        this.txtAmountApproved.setRemoveingZeroInEdit(false);
        this.entryNumber.setHorizontalAlignment(4);
        this.prmtPosition.setEnabled(false);
        this.txtAmountApproved.setPrecision(2);
        this.txtAmountApproved.setEditable(true);
        this.kDWorkButton1.setVisible(true);
        this.txtCredt.setEnabled(false);
        this.txtDebt.setEnabled(false);
        this.txtCause.setRequired(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            ExpenseAccountBaseBillInfo tempInfo = this.editData;
            int billState = tempInfo.getState().getValue();
            this.oldAmountApproved = tempInfo.getAmountApproved();
        }
        ExpenseAccountTwoEditUI.makeApplierF7(this.prmtApplier, (CoreUIObject)this);
        this.addListers();
        if (this.isFromWorkFlow() && (oper = (OperationInfo)this.getUIContext().get("OperationInfo")).getName() != null && ("setBudget".equalsIgnoreCase(oper.getName()) || "setBudgetValue".equalsIgnoreCase(oper.getName()))) {
            this.setUIState();
        }
    }

    @Override
    public boolean isFromWorkFlow() {
        return super.isFromWorkFlow();
    }

    private void setBudgetNumber_sort() throws EASBizException, BOSException {
    }

    private void setBudgetNumber_cost() throws EASBizException, BOSException {
        ExpenseSortInfo esInfo = (ExpenseSortInfo)this.prmtSortName.getValue();
        PersonInfo pInfo = (PersonInfo)this.prmtApplier.getValue();
        CostCenterOrgUnitInfo ccouInfo = (CostCenterOrgUnitInfo)this.bizPromptCostedDept.getValue();
        if (esInfo == null || pInfo == null || ccouInfo == null) {
            return;
        }
        String[] tempStr = TravelAccountWKFacadeFactory.getRemoteInstance().getBudgetNumber(esInfo, pInfo, ccouInfo);
        if (tempStr != null) {
            this.txtCredt.setText(tempStr[0]);
            this.txtDebt.setText(tempStr[1]);
        }
    }

    protected void setBudgetNumber_applier() throws EASBizException, BOSException {
        ExpenseSortInfo esInfo = (ExpenseSortInfo)this.prmtSortName.getValue();
        PersonInfo pInfo = (PersonInfo)this.prmtApplier.getValue();
        CostCenterOrgUnitInfo ccouInfo = (CostCenterOrgUnitInfo)this.bizPromptCostedDept.getValue();
        if (esInfo == null || ccouInfo == null || pInfo == null) {
            return;
        }
        String[] tempStr = TravelAccountWKFacadeFactory.getRemoteInstance().getBudgetNumber(esInfo, pInfo, ccouInfo);
        if (tempStr != null) {
            this.txtCredt.setText(tempStr[0]);
            this.txtDebt.setText(tempStr[1]);
        }
    }

    protected void setBudgetNumber() {
        if (!this.tempMark) {
            return;
        }
        ExpenseSortInfo esInfo = (ExpenseSortInfo)this.prmtSortName.getValue();
        PersonInfo pInfo = (PersonInfo)this.prmtApplier.getValue();
        CostCenterOrgUnitInfo ccouInfo = (CostCenterOrgUnitInfo)this.bizPromptCostedDept.getValue();
        if (esInfo == null || pInfo == null || ccouInfo == null) {
            return;
        }
        String tempMark = this.getDetailAccount(esInfo);
        char[] tempCell = null;
        if (tempMark == null || tempMark.equals("")) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"50_ExpenseAccountTwoEditUI"));
            this.txtCredt.setText(null);
            this.txtDebt.setText(null);
            return;
        }
        tempCell = tempMark.toCharArray();
        this.txtCredt.setText(this.getCreditBudgetNumber(ccouInfo, pInfo, null, tempCell));
        this.txtDebt.setText(this.getDebitBudgetNumber(ccouInfo, pInfo, null, tempCell));
    }

    protected String getDetailAccount(ExpenseSortInfo expenseSort) {
        String tempAccount = "";
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseSort.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 ");
        ev.setFilter(filter);
        IVoucherTemplateEntry iVou = null;
        VoucherTemplateEntryCollection vteCollection = null;
        try {
            iVou = VoucherTemplateEntryFactory.getRemoteInstance();
            vteCollection = iVou.getVoucherTemplateEntryCollection(ev);
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"51_ExpenseAccountTwoEditUI"));
            logger.info((Object)e);
            this.abort();
        }
        int size = vteCollection.size();
        if (size <= 0) {
            return tempAccount;
        }
        if (size > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"52_ExpenseAccountTwoEditUI"));
            this.abort();
        } else {
            VoucherTemplateEntryInfo vteInfo = vteCollection.get(0);
            tempAccount = vteInfo.getSimpleName();
        }
        return tempAccount;
    }

    protected String getCreditBudgetNumber(CostCenterOrgUnitInfo costInfo, PersonInfo perInfo, VehicleBaseDataInfo vehInfo, char[] tempCell) {
        StringBuffer tempStr = new StringBuffer();
        String tempBudget = null;
        if (tempCell[0] == '1' && (tempBudget = this.getBudget_K3(costInfo.getId().toString())) != null) {
            tempStr.append(tempBudget);
            tempStr.append(",");
        }
        if (tempCell[1] == '1' && (tempBudget = this.getBudget_K3(perInfo.getId().toString())) != null) {
            tempStr.append(tempBudget);
            tempStr.append(",");
        }
        if (tempStr.lastIndexOf(",") > 0) {
            return tempStr.substring(0, tempStr.lastIndexOf(","));
        }
        return "";
    }

    protected String getDebitBudgetNumber(CostCenterOrgUnitInfo costInfo, PersonInfo perInfo, VehicleBaseDataInfo vehInfo, char[] tempCell) {
        StringBuffer tempStr = new StringBuffer();
        String tempBudget = null;
        if (tempCell[3] == '1' && (tempBudget = this.getBudget_K3(costInfo.getId().toString())) != null) {
            tempStr.append(tempBudget);
            tempStr.append(",");
        }
        if (tempCell[4] == '1' && (tempBudget = this.getBudget_K3(perInfo.getId().toString())) != null) {
            tempStr.append(tempBudget);
            tempStr.append(",");
        }
        if (tempStr.lastIndexOf(",") > 0) {
            return tempStr.substring(0, tempStr.lastIndexOf(","));
        }
        return "";
    }

    private String getBudget_K3(String id) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("linkId", (Object)id, CompareType.EQUALS));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        IItemApprovedTree itemTree = null;
        ItemApprovedTreeCollection itemCollection = null;
        ItemApprovedTreeInfo itemInfo = null;
        try {
            itemTree = ItemApprovedTreeFactory.getRemoteInstance();
            itemCollection = itemTree.getItemApprovedTreeCollection(ev);
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"53_ExpenseAccountTwoEditUI"));
            logger.info((Object)e);
            this.abort();
        }
        int itemClass = -100;
        if (itemCollection != null && itemCollection.size() > 0) {
            itemInfo = itemCollection.get(0);
            return itemInfo.getItemNumber();
        }
        return null;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnToKVoucher.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnPayFormat.setIcon(EASResource.getIcon((String)"imgTbtn_closing"));
        this.btnAddLine.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCopyFrom.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPayFormat.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnToKVoucher.setVisible(true);
        this.btnLast.setVisible(false);
        this.btnWFViewSubmitProccess.setVisible(false);
        this.btnWFViewdoProccess.setVisible(false);
        this.btnSave.setVisible(true);
        this.btnRemoveLine.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnCreateFrom.setVisible(false);
        this.btnCreateFrom.setEnabled(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceUp.setEnabled(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceDown.setVisible(false);
    }

    @Override
    public void loadFields() {
        this.tempMark = false;
        super.loadFields();
        this.initBtnToKVoucher();
        if (OprtState.EDIT.equals(this.getOprtState())) {
            ExpenseAccountBaseBillInfo tempInfo = this.editData;
            int billState = tempInfo.getState().getValue();
            this.oldAmountApproved = tempInfo.getAmountApproved();
        }
        this.tempMark = true;
    }

    protected void initBtnToKVoucher() {
        String billState = null;
        billState = this.editData.getState() == null ? StateEnum.NEW.toString() : this.editData.getState().toString();
        this.btnToKVoucher.setEnabled(false);
        if (billState.equals(StateEnum.DRAFT.toString())) {
            this.menuItemRemove.setEnabled(true);
        } else if (billState.equals(StateEnum.ALREADVOUCHER.toString()) || billState.equals(StateEnum.ALREADIMPORTPAYFORMAT.toString())) {
            this.btnToKVoucher.setEnabled(true);
        }
    }

    protected String getCodeRuleClient(ExpenseAccountBaseBillInfo billInfo) throws EASBizException, BOSException {
        String sysNumber = null;
        String companyID = billInfo.getCompany().getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)billInfo, companyID)) {
            sysNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)billInfo, companyID) ? iCodingRuleManager.readNumber((IObjectValue)billInfo, companyID) : iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        }
        return sysNumber;
    }

    @Override
    public IObjectPK runSave() throws Exception {
        String oprtState = this.getOprtState();
        if (oprtState != null && OprtState.ADDNEW.equals(oprtState)) {
            this.editData.setState(StateEnum.DRAFT);
        }
        return super.runSave();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        BigDecimal obj;
        BigInteger objInt;
        this.txtName.setText(this.txtName.getText().trim());
        if (this.txtName.getText() == null || this.txtName.getText().length() < 1) {
            this.txtName.requestFocus();
            throw new ExpAccException(ExpAccException.NAME_NOT_NULL);
        }
        if (this.prmtApplier.getValue() == null) {
            this.prmtApplier.requestFocus();
            throw new ExpAccException(ExpAccException.APPLIER_NOT_NULL_WK);
        }
        this.txtNumber.setText(this.txtNumber.getText().trim());
        if (this.txtNumber.getText() == null || this.txtNumber.getText().length() < 1) {
            this.txtNumber.requestFocus();
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        if (this.pkBizReqDate.getValue() == null) {
            this.pkBizReqDate.requestFocus();
            throw new ExpAccException(ExpAccException.APPLY_DATE_NOT_NULL);
        }
        if (this.prmtOrgUnit.getValue() == null) {
            this.prmtOrgUnit.requestFocus();
            throw new ExpAccException(ExpAccException.ORGUNIT_NOT_NULL);
        }
        if (this.bizPromptCostedDept.getValue() == null) {
            this.bizPromptCostedDept.requestFocus();
            throw new ExpAccException(ExpAccException.REQDEPARTMENT_NOT_NULL);
        }
        if (this.prmtSortName.getValue() == null) {
            this.prmtSortName.requestFocus();
            throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
        }
        if (this.comboPrior.getSelectedItem() == null) {
            this.comboPrior.requestFocus();
            throw new ExpAccException(ExpAccException.PRIOR_NOT_NULL);
        }
        if (this.comboPayMode.getData() == null) {
            this.comboPayMode.requestFocus();
            throw new ExpAccException(ExpAccException.PAYMODE_NOT_NULL);
        }
        if (this.prmtCurrencyType.getValue() == null) {
            this.initCurrency();
        }
        if (this.txtCause.getText() == null || this.txtCause.getText().trim().length() <= 0) {
            this.txtCause.requestFocus();
            throw new ExpAccException(ExpAccException.CAUSE_NOT_NULL);
        }
        if (this.txtCause.getText() != null && this.txtCause.getText().length() > 15) {
            this.txtCause.requestFocus();
            throw new ExpAccException(ExpAccException.CAUSE_TOO_LONG);
        }
        BigInteger bigInteger = objInt = this.entryNumber.getBigIntegerValue() == null ? BigInteger.ZERO : this.entryNumber.getBigIntegerValue();
        if (objInt.compareTo(BigInteger.ZERO) <= 0) {
            this.entryNumber.requestFocus();
            throw new ExpAccException(ExpAccException.ENTRY_NUMBER_LARGER_ZERO);
        }
        if (objInt.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            this.entryNumber.requestFocus();
            throw new ExpAccException(ExpAccException.ENTRY_NUMBER_LOWER_MAX);
        }
        if (this.txtDesc.getText() != null && this.txtDesc.getText().length() > 200) {
            throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
        }
        BigDecimal max = new BigDecimal("999999999999999999");
        BigDecimal bigDecimal = obj = this.txtAmount.getBigDecimalValue() == null ? new BigDecimal("0.00") : this.txtAmount.getBigDecimalValue();
        if (ExpenseAccountTwoEditUI.toBigDecimal(obj).compareTo(max) > 0) {
            this.txtAmount.requestFocus();
            throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
        }
        if (ExpenseAccountTwoEditUI.toBigDecimal(obj).compareTo(new BigDecimal("0.00")) <= 0) {
            this.txtAmount.requestFocus();
            throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
        }
        this.checkEntry(this.getDetailTable());
        if (this.txtAmountApproved.getBigDecimalValue() == null) {
            this.txtAmountApproved.setValue((Object)this.txtAmount.getBigDecimalValue());
        }
        if (this.txtAmountApproved.getBigDecimalValue().compareTo(max) > 0) {
            this.txtAmountApproved.requestFocus();
            throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
        }
    }

    protected void checkEntry(KDTable table) throws ExpAccException {
    }

    @Override
    public void actionToKVoucher_actionPerformed(ActionEvent e) throws Exception {
        if (!this.checkBillState()) {
            return;
        }
        ArrayList tempList1 = null;
        ArrayList tempList = null;
        VoucherImpl impl = new VoucherImpl();
        if (VoucherImpl.MARK.equals("FAILTURE")) {
            throw new VoucherTempException(VoucherTempException.K3CONNECT_ERROR);
        }
        tempList1 = (ArrayList)VoucherImplFacadeFactory.getRemoteInstance().getResult(this.getDbSql(this.getId()));
        if (tempList1 == null || tempList1.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"BILL_NO_VOUCHERTEMPLATE"));
            return;
        }
        tempList = (ArrayList)impl.voucherImplI(SourceInfo.TARGETFILE, SourceInfo.SOURCEFILE, 2, tempList1, this.getCurFrame(this.getParent()));
        if (tempList != null && tempList.size() > 1) {
            String result = null;
            String[] tempArr = (String[])tempList.get(0);
            result = impl.voucherImplIII(SourceInfo.TARGETFILE, 1, tempArr[tempArr.length - 3], tempArr[tempArr.length - 2], tempArr[tempArr.length - 1]);
            if (result != null && result.indexOf("#SUCCESSFUL#") >= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SUCCESS_TO_VOUCHER"));
                int len = tempArr.length;
                if (tempArr[len - 4] != null && Integer.parseInt(tempArr[len - 4]) == 43) {
                    TravelAccountWKFacadeFactory.getRemoteInstance().setState(BOSUuid.read((String)tempArr[len - 5]), StateEnum.ALREADVOUCHER);
                }
                TravelAccountWKFacadeFactory.getRemoteInstance().setState(this.editData.getId(), StateEnum.ALREADVOUCHER);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FAILTURE_TO_VOUCHER"));
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"SUCCESS_TO_VOUCHER"));
        }
    }

    @Override
    public void actionPayFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionPayFormat_actionPerformed(e);
    }

    private void applierChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != eventObj.getOldValue()) {
            this.setLinkApplier((PersonInfo)eventObj.getNewValue());
        }
    }

    private void txtAmountApprovedChange(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null || eventObj.getNewValue().toString().trim().length() <= 0) {
            if (this.txtAmount.getText() != null && this.txtAmount.getText().trim().length() > 0) {
                this.txtAmountApproved.setCaretColor(new Color(251, 14, 0));
                this.txtAmountApproved.setForeground(new Color(251, 14, 0));
            } else {
                this.txtAmountApproved.setCaretColor(new Color(0, 0, 0));
                this.txtAmountApproved.setForeground(new Color(0, 0, 0));
            }
        } else if (!this.checkBigdecimalEquals(ExpenseAccountTwoEditUI.toBigDecimal(eventObj.getNewValue()), this.txtAmount.getText() == null || this.txtAmount.getText().trim().length() <= 0 ? null : ExpenseAccountTwoEditUI.toBigDecimal(this.txtAmount.getBigDecimalValue()))) {
            this.txtAmountApproved.setCaretColor(new Color(251, 14, 0));
            this.txtAmountApproved.setForeground(new Color(251, 14, 0));
        } else {
            this.txtAmountApproved.setCaretColor(new Color(0, 0, 0));
            this.txtAmountApproved.setForeground(new Color(0, 0, 0));
        }
    }

    protected void checkMonthBalance(DataChangeEvent eventObj) throws BOSException {
        BigDecimal tempBD;
        if (eventObj.getNewValue() == eventObj.getOldValue()) {
            return;
        }
        if (eventObj.getNewValue() == null) {
            return;
        }
        Date date = new Date();
        int year = date.getYear() + 1900;
        int month = date.getMonth();
        ExpenseSortInfo esInfo = this.prmtSortName.getValue() == null ? null : (ExpenseSortInfo)this.prmtSortName.getValue();
        CostCenterOrgUnitInfo ccouInfo = this.bizPromptCostedDept.getValue() == null ? null : (CostCenterOrgUnitInfo)this.bizPromptCostedDept.getValue();
        BigDecimal bigDecimal = tempBD = this.txtAmountApproved.getValue() == null ? new BigDecimal("0.0") : (BigDecimal)this.txtAmountApproved.getValue();
        if (esInfo != null && ccouInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(year), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)new Boolean(true), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)ccouInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)esInfo.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 ");
            ev.setFilter(filter);
            BudgetControlCollection tempCollection = BudgetControlFactory.getRemoteInstance().getBudgetControlCollection(ev);
            if (tempCollection.size() <= 0) {
                this.kDLabel1.setVisible(false);
                return;
            }
            BudgetControlInfo bcInfo = tempCollection.get(0);
            BudgetBalanceCollection bbcCollection = bcInfo.getEntries();
            BudgetBalanceInfo bbInfo = bbcCollection.get(month);
            if (OprtState.EDIT.equals(this.getOprtState()) && 20 != this.editData.getState().getValue()) {
                tempBD = tempBD.subtract(this.oldAmountApproved);
            }
            if (bbInfo.getMonthBalance().compareTo(tempBD) < 0) {
                this.kDLabel1.setVisible(true);
            } else {
                this.kDLabel1.setVisible(false);
            }
        }
    }

    protected void setLinkApplier(PersonInfo applier) {
        if (applier == null) {
            return;
        }
        try {
            IPersonFacade ipf = PersonFacadeFactory.getRemoteInstance();
            AdminOrgUnitCollection aouc = ipf.getAdminOrgUnitByPerson(applier.getId());
            AdminOrgUnitInfo aouInfo = null;
            if (aouc != null && aouc.size() > 0) {
                aouInfo = aouc.get(0);
            }
            this.prmtOrgUnit.setValue(aouInfo);
            IPositionMember iPoMe = PositionMemberFactory.getRemoteInstance();
            PositionMemberCollection poCol = iPoMe.getPositionsByPerson(applier.getId());
            if (poCol == null || poCol.size() < 1) {
                this.prmtPosition.setValue(null);
            } else {
                this.prmtPosition.setValue((Object)poCol.get(0).getPosition());
            }
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }

    protected SelectorItemCollection getBaseSelectors() {
        return super.getSelectors();
    }

    protected String getDbSql(String id) {
        if (id == null || id.trim().length() <= 0) {
            return null;
        }
        StringBuffer querySql = this.getDefaultSql();
        querySql.append("'");
        querySql.append(id);
        querySql.append("'");
        querySql.append(")");
        return querySql.toString();
    }

    protected StringBuffer getDefaultSql() {
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT   distinct");
        querySql.append(" CURDATE() AS FDate, YEAR(NOW()) AS FYear,  ");
        querySql.append(" MONTH(NOW()) AS FPeriod, d.FGroup AS FGroupID, ");
        querySql.append(" 0 AS FNumber,   ");
        querySql.append(" d.FDebitAccountNumber AS FAccountNum, ");
        querySql.append(" d.FDebitAccountName AS FAccountName,   ");
        querySql.append(" d.FCreditAccountNumber AS FAccountNum1, ");
        querySql.append(" d.FCreditAccountName AS FAccountName1,");
        querySql.append(" d.FCurrencyNumber AS FCurrencyNum, ");
        querySql.append(" d.FCurrencyName AS FCurrencyName, ");
        querySql.append(" a.FAmountApproved AS FAmountFor, ");
        querySql.append(" a.FAmountApproved AS FDebit, ");
        querySql.append(" a.FAmountApproved AS FCredit, ");
        querySql.append(" d.FK3user AS FPreparerID, '' AS FCheckID, ");
        querySql.append(" '' AS FApproveID, '' AS FCashierID,");
        querySql.append(" '' AS FHandler, '' AS FSettleTypeID, ");
        querySql.append(" 0 AS FSettleNo, ");
        querySql.append(" CONCAT( CONCAT(CONCAT(ORGUNIT.FName_L2,'_'),APPLIER.FName_L2 ) , CONCAT('_',a.FCause))  AS FExplanation , ");
        querySql.append(" 0 AS FQuantity, 0 AS FMeasureUnitID, ");
        querySql.append(" 0 AS FUnitPrice, ");
        querySql.append(" a.FNumber AS FReference, ");
        querySql.append(" CURDATE() AS FTransDate, 0 AS FTransNo, ");
        querySql.append(" 0 AS FAttachments, 0 AS FSerialNum, ");
        querySql.append(" '' AS FObjectName, '' AS FParameter, ");
        querySql.append(" d.FRate AS FExchangeRate, 0 AS FEntryID, ");
        querySql.append(" a.FCreditNumber AS FCreditItem , ");
        querySql.append(" a.FDebitNumber AS FDebitItem, '' AS FPosted, ");
        querySql.append(" '' AS FInternalInd, '' AS FCashFlow  ,");
        querySql.append(" a.FID,a.FState,e.FK3DataCenter, ");
        querySql.append(" d.FK3user FK3user,d.FK3userPwd AS FK3userPwd ");
        querySql.append(" FROM ");
        querySql.append(this.getTableName());
        querySql.append(" a INNER JOIN\t\t\t\t\t\t\t\t   ");
        querySql.append(" T_BC_ExpenseSort c ON a.FSortName = c.FID INNER JOIN ");
        querySql.append(" T_BC_VoucherTemplateEntry d ON c.FID = d.FExpenseTypeID INNER JOIN ");
        querySql.append(" T_BC_VoucherTemplate e ON d.FVoucherID = e.FID ");
        querySql.append(" INNER JOIN ");
        querySql.append(" T_BD_Person AS  APPLIER  ON  a.FApplierID = APPLIER.FID ");
        querySql.append(" INNER JOIN ");
        querySql.append(" T_ORG_Admin AS  ORGUNIT ON a.FOrgUnitID = ORGUNIT.FID ");
        querySql.append(" AND a.FID IN ( ");
        return querySql;
    }

    protected String getId() {
        return this.editData.getId().toString();
    }

    protected boolean checkBillState() {
        boolean mark = false;
        int tempState = -1;
        try {
            tempState = this.editData.getState().getValue();
        }
        catch (Exception e) {
            tempState = -1;
        }
        if (tempState == 46) {
            mark = true;
        } else if (tempState == 43) {
            mark = true;
        } else if (tempState == 60) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"BILL_NOT_PAYMODE"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"BILL_STATE_NOT_RIGHT"));
        }
        return mark;
    }

    protected boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    protected abstract String getTableName();

    protected abstract String getEntryTableName();

    protected static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        String str = obj.toString().trim();
        if (str.matches("\\d+\\.?\\d*")) {
            return new BigDecimal(str);
        }
        return ZERO;
    }

    protected void initCurrency() throws BOSException {
        CurrencyInfo tempInfo = null;
        CurrencyCollection tempCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection();
        int n = tempCollection.size();
        for (int i = 0; i < n; ++i) {
            tempInfo = tempCollection.get(i);
            if (!tempInfo.getName().toString().equals(EASResource.getString((String)RESVOU, (String)"RENMINBI"))) continue;
            this.prmtCurrencyType.setValue((Object)tempInfo);
            break;
        }
    }

    protected AdminOrgUnitInfo getOrgUnitReferToApplier(PersonInfo applier) {
        if (applier == null || applier.getId() == null) {
            return null;
        }
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getRemoteInstance();
            AdminOrgUnitCollection adminOrgUnitCollection = iPersonFacade.getAdminOrgUnitByPerson(applier.getId());
            if (adminOrgUnitCollection != null && adminOrgUnitCollection.size() > 0) {
                adminOrgUnitInfo = adminOrgUnitCollection.get(0);
            }
        }
        catch (Exception e) {
            return null;
        }
        return adminOrgUnitInfo;
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsertLine_actionPerformed(e);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        super.afterAddLine(table, lineData);
    }

    private boolean checkBigdecimalEquals(BigDecimal a, BigDecimal b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.compareTo(b) == 0;
    }

    @Override
    public void actionBudgetForView_actionPerformed(ActionEvent e) throws Exception {
        UIContext ctx = new UIContext((Object)this);
        Object tempObj = this.bizPromptCostedDept.getValue();
        Object tempSort = this.prmtSortName.getValue();
        if (tempObj == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"PLEASE_COSTDEPT_SELECT"));
            this.abort();
        }
        this.checkBudgetBalance((ExpenseSortInfo)tempSort, (CostCenterOrgUnitInfo)tempObj);
        ctx.put((Object)"expenseSort", this.prmtSortName.getValue());
        ctx.put((Object)"controlObj", this.bizPromptCostedDept.getValue());
        UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BudgetControlForViewListUI.class.getName(), (Map)ctx, null, OprtState.VIEW).show();
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    protected void addListers() {
        this.prmtApplier.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (ExpenseAccountTwoEditUI.this.getOprtState().equals(OprtState.VIEW)) {
                    return;
                }
                ExpenseAccountTwoEditUI.this.applierChange(eventObj);
                ExpenseAccountTwoEditUI.this.setBudgetNumber();
            }
        });
        this.txtAmountApproved.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ExpenseAccountTwoEditUI.this.txtAmountApprovedChange(eventObj);
                try {
                    ExpenseAccountTwoEditUI.this.checkMonthBalance(eventObj);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        });
        this.txtAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() != eventObj.getOldValue()) {
                    ExpenseAccountTwoEditUI.this.setColor(eventObj);
                }
            }
        });
        this.prmtSortName.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    ExpenseAccountTwoEditUI.this.checkMonthBalance(eventObj);
                    if (eventObj.getNewValue() != eventObj.getOldValue()) {
                        ExpenseAccountTwoEditUI.this.setBudgetNumber();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.bizPromptCostedDept.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (eventObj.getNewValue() == null || eventObj.getNewValue() == eventObj.getOldValue()) {
                    return;
                }
                CostCenterOrgUnitInfo tempCost = (CostCenterOrgUnitInfo)eventObj.getNewValue();
                ExpenseAccountTwoEditUI.this.isBizUnit(tempCost);
                try {
                    ExpenseAccountTwoEditUI.this.checkMonthBalance(eventObj);
                    ExpenseAccountTwoEditUI.this.setBudgetNumber();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        });
    }

    @Override
    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        OperationInfo oper = (OperationInfo)this.getUIContext().get("OperationInfo");
        if (e.getSource().equals(this.btnSubmit) && !this.actionSubmit.isInvokeFailed() && oper != null && oper.getName() != null && ("setbudget".equalsIgnoreCase(oper.getName()) || "setBudgetValue".equalsIgnoreCase(oper.getName()))) {
            logger.info((Object)("OPERATER:" + oper.getName().toLowerCase()));
            this.getUIWindow().close();
        }
    }

    protected void initScrollButtons() {
        if (this.idList == null) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            return;
        }
        int oldIndex = this.idList.getCurrentIndex();
        String tempID = this.idList.getLastID();
        if (tempID == null) {
            this.actionFirst.setEnabled(false);
            this.actionPre.setEnabled(false);
            this.actionNext.setEnabled(false);
            this.actionLast.setEnabled(false);
            return;
        }
        if (tempID.equals("0")) {
            this.idList.remove(tempID, false);
        }
        this.idList.setCurrentIndex(oldIndex);
        super.initScrollButtons();
    }

    public static void makeApplierF7(KDBizPromptBox bizBoxProposer, CoreUIObject coreui) {
        bizBoxProposer.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("All_Admins", "YES");
        PersonPromptBox select = new PersonPromptBox((IUIObject)coreui, map);
        bizBoxProposer.setSelector((KDPromptSelector)select);
        bizBoxProposer.setDisplayFormat("$name$");
        bizBoxProposer.setEditFormat("$number$");
        bizBoxProposer.setCommitFormat("$number$");
    }

    protected void setUIState() {
        this.menuFile.setEnabled(false);
        this.menuEdit.setEnabled(false);
        this.menuHelp.setEnabled(false);
        this.menuView.setEnabled(false);
        this.menuWorkflow.setEnabled(false);
        this.btnSubmit.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnWFViewSubmitProccess.setEnabled(false);
        this.kDWorkButton1.setEnabled(false);
        this.comboPrior.setEnabled(false);
        this.txtName.setEnabled(false);
        this.prmtApplier.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.prmtOrgUnit.setEditable(false);
        this.bizPromptCostedDept.setEnabled(false);
        this.pkBizReqDate.setEnabled(false);
        this.prmtSortName.setEnabled(false);
        this.comboState.setEnabled(false);
        this.prmtCompany.setEnabled(false);
        this.comboPayMode.setEnabled(false);
        this.prmtCurrencyType.setEnabled(false);
        this.txtTel.setEnabled(false);
        this.txtAmount.setEnabled(false);
        this.entryNumber.setEnabled(false);
        this.txtCause.setEnabled(false);
        this.txtDesc.setEnabled(false);
        this.txtCredt.setEnabled(false);
        this.txtDebt.setEnabled(false);
        this.txtAmountApproved.setEnabled(true);
    }

    protected void checkBudgetBalance(ExpenseSortInfo esInfo, CostCenterOrgUnitInfo ccouInfo) throws BOSException, EASBizException {
        Object info = null;
        Date date = new Date();
        int currentYear = date.getYear() + 1900;
        int currentMonth = date.getMonth();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(currentYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)ccouInfo.getId().toString(), CompareType.EQUALS));
        if (esInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)esInfo.getId().toString(), CompareType.EQUALS));
            filter.setMaskString("(#0 or #1) and #2 and #3 and #4 and #5");
        } else {
            filter.setMaskString("(#0 or #1) and #2 and #3 and #4 ");
        }
        ev.setFilter(filter);
        BudgetControlCollection tempCollection = BudgetControlFactory.getRemoteInstance().getBudgetControlCollection(ev);
        if (tempCollection.size() <= 0) {
            return;
        }
        IBudgetControl ibc = BudgetControlFactory.getRemoteInstance();
        BudgetControlInfo bcInfo = null;
        BudgetBalanceCollection bbcCollection = null;
        BudgetBalanceInfo tempInfo = null;
        BudgetBalanceInfo foreMonthInfo = null;
        BigDecimal tempBD = null;
        int n = tempCollection.size();
        for (int j = 0; j < n; ++j) {
            bcInfo = tempCollection.get(j);
            bbcCollection = bcInfo.getEntries();
            if (bcInfo.isIsCumulate()) {
                tempInfo = bbcCollection.get(currentMonth);
                if (tempInfo.isIsAdd()) continue;
                tempInfo = bbcCollection.get(0);
                if (!tempInfo.isIsAdd()) {
                    bbcCollection.get(0).setIsAdd(true);
                }
                for (int i = 1; i <= currentMonth; ++i) {
                    tempInfo = bbcCollection.get(i);
                    if (tempInfo.isIsAdd()) continue;
                    foreMonthInfo = bbcCollection.get(i - 1);
                    tempBD = foreMonthInfo.getMonthBalance();
                    bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().add(tempBD));
                    bbcCollection.get(i).setIsAdd(true);
                }
                ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                continue;
            }
            BigDecimal temp1 = null;
            BigDecimal temp2 = null;
            BigDecimal temp3 = null;
            BigDecimal temp4 = null;
            tempInfo = bbcCollection.get(currentMonth);
            temp4 = tempInfo.getFreezeAccount();
            temp1 = bcInfo.getSumAccount();
            temp2 = temp1.divide(new BigDecimal("12"), 2);
            temp3 = temp2.multiply(new BigDecimal(String.valueOf(11 - currentMonth + 1)));
            bcInfo.setYearBalance(temp3.subtract(temp4));
            ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
        }
    }

    public void setColor(DataChangeEvent obj) {
        BigDecimal tempAmount;
        BigDecimal tempApp = this.txtAmountApproved.getBigDecimalValue();
        if (!this.checkBigdecimalEquals(tempApp, tempAmount = this.txtAmount.getBigDecimalValue())) {
            this.txtAmountApproved.setCaretColor(new Color(251, 14, 0));
            this.txtAmountApproved.setForeground(new Color(251, 14, 0));
        } else {
            this.txtAmountApproved.setCaretColor(new Color(0, 0, 0));
            this.txtAmountApproved.setForeground(new Color(0, 0, 0));
        }
    }

    public Frame getCurFrame(Component component) {
        Component child = component;
        for (Container parent = child.getParent(); parent != null; parent = parent.getParent()) {
            child = parent;
        }
        return (Frame)child;
    }

    public void isBizUnit(CostCenterOrgUnitInfo info) {
        try {
            ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getRemoteInstance();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
            filter.setMaskString(" #0 and #1 ");
            ev.setFilter(filter);
            CompanyOrgUnitCollection tempColl = icompany.getCompanyOrgUnitCollection(ev);
            if (tempColl == null || tempColl.size() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"54_ExpenseAccountTwoEditUI"));
                this.bizPromptCostedDept.setValue(null);
                this.bizPromptCostedDept.requestFocus();
            }
        }
        catch (BOSException e) {
            this.bizPromptCostedDept.setValue(null);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"55_ExpenseAccountTwoEditUI"));
            SysUtil.abort();
        }
    }
}

