/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.bc.client.AbstractF7DBUI;
import com.kingdee.eas.cp.bc.client.F7LinkDbUI;
import com.kingdee.eas.cp.bc.client.LinkDBF7Box;
import com.kingdee.eas.cp.bc.util.DbUtilFromClient;
import com.kingdee.eas.cp.bc.util.MapForF7;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class F7DBUI
extends AbstractF7DBUI {
    private static final Logger logger = CoreUIObject.getLogger(F7LinkDbUI.class);
    public boolean isCanceled = false;
    public Object returnValue = "";
    private LinkDBF7Box nf7 = null;
    private IRowSetMetaData rowMetadata = null;
    private IRowSet rowset = null;
    int size = 0;
    public MapForF7 map = new MapForF7();

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.map = null;
        this.isCanceled = true;
        this.destroyWindow();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.setSelectMap();
        this.isCanceled = false;
        this.disposeUIWindow();
    }

    private void setSelectMap() {
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0) {
            return;
        }
        sb = this.tblMain.getSelectManager().get(0);
        if (sb.getTop() <= sb.getBottom()) {
            int selectDefaut = sb.getTop();
            this.map.clear();
            Map dbMap = (Map)this.getUIContext().get("dbMap");
            String returnValueName = (String)dbMap.get("returnValue");
            int columnCount = this.tblMain.getColumnCount();
            String[] columnKey = this.getColumnKey();
            for (int i = 0; i < columnCount; ++i) {
                this.map.put(columnKey[i], this.tblMain.getCell(selectDefaut, i).getValue());
                if (!columnKey[i].equals(returnValueName)) continue;
                this.returnValue = this.tblMain.getCell(selectDefaut, i).getValue();
                this.map.setReturnValue(this.returnValue);
            }
        } else {
            return;
        }
        this.isCanceled = false;
        this.disposeUIWindow();
    }

    private List getSelectIdList() {
        ArrayList<String> list = new ArrayList<String>();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0) {
            return null;
        }
        boolean index = false;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                list.add(this.tblMain.getRow(j).getCell("id").getValue().toString());
            }
        }
        return list;
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() >= 2 && e.getRowIndex() >= 0 && e.getRowIndex() <= this.tblMain.getRowCount()) {
            this.map.clear();
            Map dbMap = (Map)this.getUIContext().get("dbMap");
            String returnValueName = (String)dbMap.get("returnValue");
            int columnCount = this.tblMain.getColumnCount();
            String[] columnKey = this.getColumnKey();
            int rowIndex = e.getRowIndex();
            for (int i = 0; i < columnCount; ++i) {
                this.map.put(columnKey[i], this.tblMain.getCell(rowIndex, i).getValue());
                if (!columnKey[i].equals(returnValueName)) continue;
                this.returnValue = this.tblMain.getCell(rowIndex, i).getValue();
                this.map.setReturnValue(this.returnValue);
            }
            this.isCanceled = false;
            this.disposeUIWindow();
        }
    }

    public String[] getColumnKey() {
        int columnCount = this.tblMain.getColumnCount();
        String[] columnKey = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnKey[i] = (String)this.tblMain.getHeadRow(0).getCell(i).getValue();
        }
        return columnKey;
    }

    protected void disposeUIWindow() {
        if (this.rowMetadata != null) {
            this.rowMetadata = null;
        }
        if (this.rowset != null) {
            this.rowset = null;
        }
        super.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        this.btnExit.setEnabled(true);
        this.btnExit.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnSave.setVisible(true);
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.rowset = this.getRowSetFromDb();
        if (this.rowset != null && this.rowset.size() < 1) {
            return;
        }
        try {
            this.rowMetadata = this.rowset.getRowSetMetaData();
            this.size = this.rowMetadata.getColumnCount();
            this.tblMain.addColumns(this.size);
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLExeption" + exc.getMessage()));
            ExceptionHandler.handle((String)"SQLExeption", (Throwable)exc);
        }
        this.loadHead();
        this.loadBody();
    }

    private void loadBody() {
        String[] attrArray = null;
        String[] attrType = null;
        try {
            for (int i = 0; i < this.size; ++i) {
                attrArray = new String[this.size];
                attrType = new String[this.size];
                attrArray[i] = this.rowMetadata.getColumnName(i + 1);
                attrType[i] = this.rowMetadata.getColumnTypeName(i + 1);
            }
            while (this.rowset.next()) {
                IRow row = this.tblMain.addRow();
                for (int i = 0; i < this.size; ++i) {
                    Object obj = this.rowset.getObject(i + 1);
                    row.getCell(i).setValue(obj);
                }
            }
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLExeption" + exc.getMessage()));
            ExceptionHandler.handle((String)"SQLExeption", (Throwable)exc);
        }
    }

    private void loadHead() {
        IRow row = this.tblMain.addHeadRow();
        try {
            for (int i = 0; i < this.size; ++i) {
                row.getCell(i).setValue((Object)this.rowMetadata.getColumnLabel(i + 1));
            }
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLExeption" + exc.getMessage()));
            ExceptionHandler.handle((String)"SQLExeption", (Throwable)exc);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRowSet getRowSetFromDb() {
        HashMap map = (HashMap)this.getUIContext();
        IRowSet rowset = null;
        Map dbMap = (Map)map.get("dbMap");
        Connection conn = (Connection)dbMap.get("conn");
        String sql = (String)dbMap.get("sql");
        if (conn == null) {
            String dbIp = (String)dbMap.get("dbIp");
            String dbPort = (String)dbMap.get("dbPort");
            String dbName = (String)dbMap.get("dbName");
            String userName = (String)dbMap.get("user");
            String password = (String)dbMap.get("password");
            conn = DbUtilFromClient.getConn(dbIp, dbPort, dbName, userName, password);
        }
        try {
            rowset = this.executeQuery(conn, sql);
        }
        catch (Exception exc) {
            ExceptionHandler.handle((String)"Exeption", (Throwable)exc);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rowset;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public boolean destroyWindow() {
        this.isCanceled = true;
        return super.destroyWindow();
    }

    public IRowSet executeQuery(Connection conn, String sql) throws SQLException {
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            JdbcRowSet jdbcRowSet = rowset;
            return jdbcRowSet;
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLException:" + exc.getMessage()));
            throw new SQLException();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
    }
}

