/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.OptionEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBaseFacadeFactory;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillFactory;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.FixExpenseAccountEntryCollection;
import com.kingdee.eas.cp.bc.FixExpenseAccountEntryInfo;
import com.kingdee.eas.cp.bc.ForPrintFacadeFactory;
import com.kingdee.eas.cp.bc.IExpenseAccountBaseFacade;
import com.kingdee.eas.cp.bc.IForPrintFacade;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractFixExpenseAccountEditUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FixExpenseAccountEditUI
extends AbstractFixExpenseAccountEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FixExpenseAccountEditUI.class);
    private FixExpenseAccountBillInfo newEditData = null;
    protected AbstractObjectValue fixoldData = null;
    private java.util.Date date1 = null;
    private static final String RESOURCE = "com.kingdee.eas.cp.bc.client.ForPrintResource";
    private static final String BILLQUERYNAME = "com.kingdee.eas.cp.bc.app.FixExpenseAccountForPrintQuery";
    private static final String MULTIAPPROVEQUERYNAME = "com.kingdee.eas.base.multiapprove.app.MultiApproveQuery";
    private String id = null;
    private static final String DATAPATH = "/cp/bc/wk/fix";

    @Override
    protected void entry_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.entry.getColumnIndex("amount")) {
            this.countAmountToTotalAmount();
        }
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        this.countAmountToTotalAmount();
    }

    private void countAmountToTotalAmount() {
        BigDecimal totalAmount = new BigDecimal("0.0");
        int size = this.entry.getRowCount();
        for (int i = 0; i < size; ++i) {
            ICell iCell = this.entry.getCell(i, this.entry.getColumnIndex("amount"));
            totalAmount = iCell == null || iCell.getValue() == null ? totalAmount.add(new BigDecimal("0.0")) : totalAmount.add(new BigDecimal(iCell.getValue().toString()));
        }
        this.txtAmount.setValue((Object)totalAmount);
        this.txtAmountApproved.setValue((Object)totalAmount);
    }

    public FixExpenseAccountEditUI() throws Exception {
        this.txtAmount.setDataType(1);
        this.txtAmount.setPrecision(2);
        this.txtAmountApproved.setDataType(1);
        this.txtAmountApproved.setPrecision(2);
        this.txtAmount.setDataVerifierType(12);
        this.txtAmountApproved.setDataVerifierType(12);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("tel"));
        sic.add(new SelectorItemInfo("debitNumber"));
        sic.add(new SelectorItemInfo("creditNumber"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("prior"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("billDate"));
        sic.add(new SelectorItemInfo("biller.name"));
        sic.add(new SelectorItemInfo("biller.number"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("hasCreateVoucher"));
        sic.add(new SelectorItemInfo("hasCreateMode"));
        sic.add(new SelectorItemInfo("sortName.sortName"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("payMode.*"));
        sic.add(new SelectorItemInfo("costedDept.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("entryNumber"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.name"));
        sic.add(new SelectorItemInfo("entries.purpose"));
        sic.add(new SelectorItemInfo("entries.happenTime"));
        sic.add(new SelectorItemInfo("entries.comment"));
        sic.add(new SelectorItemInfo("entries.amount"));
        return sic;
    }

    @Override
    public void loadFields() {
        this.tempMark = false;
        this.dataBinder.loadFields();
        super.initBtnToKVoucher();
        this.editData.setBizReqDate((Date)this.editData.getBizReqDate());
        this.editData.setBillDate(DateTimeUtils.truncateDate((java.util.Date)this.editData.getBillDate()));
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            FixExpenseAccountEntryCollection entries = this.editData.getEntries();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                Date date = (Date)entries.get(0).getHappenTime();
                entries.get(0).setHappenTime(date);
            }
        }
        FixExpenseAccountBillInfo objectValue = this.editData;
        this.fixoldData = (AbstractObjectValue)objectValue.clone();
        this.tempMark = true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setBizReqDate((Date)this.editData.getBizReqDate());
    }

    @Override
    protected IObjectValue createNewData() {
        FixExpenseAccountBillInfo info = null;
        info = super.createNewData() == null ? new FixExpenseAccountBillInfo() : (FixExpenseAccountBillInfo)super.createNewData();
        info.setBiller(this.getDefaultUser());
        info.setBillDate(DateTimeUtils.truncateDate((java.util.Date)new Timestamp(System.currentTimeMillis())));
        info.setBillDate(DateTimeUtils.truncateDate((java.util.Date)new Timestamp(System.currentTimeMillis())));
        info.setBizReqDate(DateTimeUtils.truncateDate((java.util.Date)new Timestamp(System.currentTimeMillis())));
        info.setPrior(PriorEnum.LOW);
        info.setState(StateEnum.NEW);
        info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        info.setName(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"59_FixExpenseAccountEditUI"));
        try {
            ICurrency ic = CurrencyFactory.getRemoteInstance();
            info.setCurrencyType((CurrencyInfo)ic.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency().getId())));
        }
        catch (Exception ic) {
            // empty catch block
        }
        String sysNumber = null;
        try {
            sysNumber = this.getCodeRuleClient(info);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (sysNumber != null && sysNumber.trim().length() > 0) {
            info.setNumber(sysNumber);
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        info.getEntries().add((FixExpenseAccountEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return info;
    }

    @Override
    protected void checkEntry(KDTable table) throws ExpAccException {
        int rows = this.getDetailTable().getRowCount();
        IRow row = null;
        KDTEditManager kdtManager = this.getDetailTable().getEditManager();
        for (int i = 0; i < rows; ++i) {
            Object obj;
            row = this.getDetailTable().getRow(i);
            if (row == null) continue;
            if (this.objectIsNull(row.getCell("purpose").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("purpose"));
                throw new ExpAccException(ExpAccException.PURPOSE_NOT_NULL_ENTRY);
            }
            if (((String)row.getCell("purpose").getValue()).length() > 200) {
                throw new ExpAccException(ExpAccException.PURPOSE_TOO_LONG);
            }
            if (this.objectIsNull(row.getCell("happenTime").getValue())) {
                throw new ExpAccException(ExpAccException.HAPPENDATA_NOT_NULL);
            }
            if (row.getCell("comment").getValue() == null) {
                row.getCell("comment").setValue((Object)"");
            }
            if (row.getCell("comment").getValue().toString().length() > 200) {
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            BigDecimal max = new BigDecimal("999999999999999999");
            Object object = obj = row.getCell("amount") == null ? new BigDecimal("0.00") : row.getCell("amount").getValue();
            if (FixExpenseAccountEditUI.toBigDecimal(obj).compareTo(new BigDecimal("0.00")) <= 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("amount"));
                throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
            }
            if (FixExpenseAccountEditUI.toBigDecimal(obj).compareTo(max) <= 0) continue;
            kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("amount"));
            throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
        }
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        FixExpenseAccountEntryInfo entry = new FixExpenseAccountEntryInfo();
        entry.setHappenTime(DateTimeUtils.truncateDate((java.util.Date)new Timestamp(System.currentTimeMillis())));
        entry.setAmount(new BigDecimal("0.00"));
        return entry;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FixExpenseAccountBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.entry;
    }

    @Override
    public void onLoad() throws Exception {
        int state;
        super.onLoad();
        this.entry.setColumnMoveable(true);
        this.btbWFCancel.setVisible(true);
        this.btbWFCancel.setEnabled(true);
        JButton btnAddRuleNew = this.kdContent.add((Action)this.actionAddLine);
        JButton btnDelRuleNew = this.kdContent.add((Action)this.actionRemoveLine);
        btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddRuleNew.setSize(22, 19);
        btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnDelRuleNew.setSize(22, 19);
        this.btnSubmitAndCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.btbWFCancel.setIcon(EASResource.getIcon((String)"imgTbtn_suspendinstance"));
        KDTDefaultCellEditor defaultEditor = null;
        KDFormattedTextField tkftAmount = new KDFormattedTextField();
        tkftAmount.setDataType(1);
        tkftAmount.setSupportedEmpty(true);
        tkftAmount.setPrecision(2);
        defaultEditor = new KDTDefaultCellEditor((JTextField)tkftAmount);
        this.entry.getColumn("amount").setEditor((ICellEditor)defaultEditor);
        KDDatePicker kdhappenTime = new KDDatePicker();
        kdhappenTime.setTimeEnabled(false);
        kdhappenTime.setMilliSecondEnable(false);
        kdhappenTime.setDateEnabled(true);
        kdhappenTime.setDatePattern(MultilingualUtil.getDateFormatString());
        defaultEditor = new KDTDefaultCellEditor(kdhappenTime);
        this.entry.getColumn("happenTime").setEditor((ICellEditor)defaultEditor);
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        this.btnSubmitAndCopy.setVisible(true);
        this.btnSubmitAndCopy.setEnabled(true);
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.btnPrint.setVisible(true);
            this.btnPrint.setEnabled(true);
            this.btnPrintPreview.setVisible(true);
            this.btnPrintPreview.setEnabled(true);
            this.menuItemPrint.setVisible(true);
            this.menuItemPrint.setEnabled(true);
            this.menuItemPrintPreview.setVisible(true);
            this.menuItemPrintPreview.setEnabled(true);
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData != null && this.editData.getState() != null && (60 == (state = this.editData.getState().getValue()) || 25 == state || 30 == state)) {
            btnAddRuleNew.setEnabled(false);
            btnDelRuleNew.setEnabled(false);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setText(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"60_FixExpenseAccountEditUI"));
    }

    private UserInfo getDefaultUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmitAndCopy_actionPerformed(ActionEvent e) throws Exception {
        HashMap map = this.saveUIBefortSubmit();
        if ("EDIT".equals(this.getOprtState())) {
            this.setOprtState("ADDNEW");
        }
        super.actionSubmit_actionPerformed(e);
        this.createNewData();
        this.setUIAfterSubmit(map);
        this.storeFields();
        FixExpenseAccountBillInfo objectValue = this.editData;
        this.fixoldData = (AbstractObjectValue)objectValue.clone();
        super.actionSubmitAndCopy_actionPerformed(e);
    }

    private void setUIAfterSubmit(HashMap map) {
        this.txtName.setText((String)map.get("name"));
        String obj = map.get("amount") != null ? map.get("amount").toString() : "0.00";
        this.txtAmount.setText(obj);
        this.txtAmountApproved.setText(obj);
        this.txtCause.setText((String)map.get("cause"));
        this.txtDesc.setText((String)map.get("description"));
        this.txtTel.setText((String)map.get("tel"));
        this.prmtCompany.setValue(map.get("company"));
        this.prmtCurrencyType.setValue(map.get("currencyType"));
        this.prmtPosition.setValue(map.get("position"));
        this.prmtSortName.setValue(map.get("sortName"));
        this.comboPayMode.setData(map.get("payMode"));
        this.comboPrior.setSelectedItem(map.get("prior"));
        this.pkBizReqDate.setValue(map.get("BizReqDate"));
        this.entryNumber.setValue(map.get("entryNumber"));
        FixExpenseAccountEntryCollection entr = (FixExpenseAccountEntryCollection)((Object)map.get("entry"));
        if (entr.size() > 0) {
            int size = entr.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.entry.addRow();
                }
                this.entry.getCell(i, 1).setValue((Object)entr.get(i).getPurpose());
                this.entry.getCell(i, 2).setValue((Object)entr.get(i).getHappenTime());
                this.entry.getCell(i, 3).setValue((Object)entr.get(i).getAmount());
                this.entry.getCell(i, 4).setValue((Object)entr.get(i).getComment());
            }
        }
    }

    private HashMap saveUIBefortSubmit() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.clear();
        map.put("name", this.txtName.getText());
        map.put("amount", this.txtAmount.getText());
        map.put("amountApproved", this.txtAmountApproved.getText());
        map.put("cause", this.txtCause.getText());
        map.put("description", this.txtDesc.getText());
        map.put("tel", this.txtTel.getText());
        map.put("company", this.prmtCompany.getValue());
        map.put("currencyType", this.prmtCurrencyType.getValue());
        map.put("position", this.prmtPosition.getValue());
        map.put("sortName", this.prmtSortName.getValue());
        map.put("payMode", this.comboPayMode.getData());
        map.put("prior", this.comboPrior.getSelectedItem());
        map.put("BizReqDate", this.pkBizReqDate.getValue());
        map.put("entryNumber", this.entryNumber.getValue());
        map.put("entry", this.entry.getUserObject());
        return map;
    }

    @Override
    protected String getEntryTableName() {
        return "T_BC_FixExpenseAccountEntry";
    }

    @Override
    protected String getTableName() {
        return "T_BC_FixExpenseAccountBill";
    }

    @Override
    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.fixoldData, (AbstractObjectValue)this.editData);
    }

    @Override
    public void actionWFCancel_actionPerformed(ActionEvent e) throws Exception {
        String resouce = "com.kingdee.eas.cp.bc.client.ExpAccResource";
        StateEnum state = this.editData.getState();
        BOSUuid id = this.editData.getId();
        if (state == null || id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)resouce, (String)"NOTWFCANCELBECAUSENOTSUBMIT"));
            return;
        }
        String stateStr = state.toString();
        if (state.equals((Object)StateEnum.CANCELED) || state.toString().equals((Object)StateEnum.DRAFT) || state.toString().equals((Object)StateEnum.CLOSED)) {
            MsgBox.showInfo((String)EASResource.getString((String)resouce, (String)"NOTWFCANCELBECAUSENOTSUBMIT"));
        } else if (state.equals((Object)StateEnum.SUBMIT)) {
            IExpenseAccountBaseFacade iExp = ExpenseAccountBaseFacadeFactory.getRemoteInstance();
            iExp.WFCancel(id);
            MsgBox.showInfo((String)EASResource.getString((String)resouce, (String)"WF_HAS_CANCEL"));
        } else if (state.equals((Object)StateEnum.CHECKED) || state.equals((Object)StateEnum.CHECKING) || state.equals((Object)StateEnum.CHECKFAILD)) {
            MsgBox.showInfo((String)EASResource.getString((String)resouce, (String)"NOTWFCANCEL_BECAUSEI_ISNOT_SUBMIT_STATE"));
        }
        super.actionWFCancel_actionPerformed(e);
    }

    @Override
    protected void setUIState() {
        super.setUIState();
        this.entry.setEnabled(false);
        this.entry.getStyleAttributes().setLocked(true);
    }

    protected void setEntryNumber() {
        this.entryNumber.setText(String.valueOf(this.entry.getRowCount()));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.methodForPrint(e, true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.methodForPrint(e, false);
    }

    private void methodForPrint(ActionEvent e, boolean noPreview) {
        this.id = this.editData.getId().toString();
        KDNoteHelper appHlp = new KDNoteHelper();
        if (this.id != null) {
            DataProvider data = new DataProvider();
            if (noPreview) {
                appHlp.print(DATAPATH, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            } else {
                appHlp.printPreview(DATAPATH, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"NO_SELECT_ROW"));
        }
    }

    @Override
    public IRowSet parseEnumValue(IRowSet rowSet, String value, String valueAlias, List list) throws SQLException {
        if (rowSet == null) {
            return rowSet;
        }
        if (list == null) {
            return rowSet;
        }
        if (value == null || value.equals("")) {
            return rowSet;
        }
        if (!rowSet.next()) {
            return rowSet;
        }
        Object tempPriorEnum = null;
        String mark = "";
        int tempPrior = rowSet.getInt(value);
        int pos = rowSet.findColumn(valueAlias);
        Iterator ite = null;
        PriorEnum priorenum2 = null;
        rowSet.previous();
        while (rowSet.next()) {
            for (PriorEnum priorenum2 : list) {
                if (tempPrior != priorenum2.getValue()) continue;
                mark = priorenum2.getAlias();
            }
            rowSet.updateString(pos, mark);
        }
        rowSet.beforeFirst();
        return rowSet;
    }

    public Object parseEnumValue1(IRowSet rowSet, String value, String valueAlias, List list) throws SQLException {
        if (rowSet == null) {
            return rowSet;
        }
        if (list == null) {
            return rowSet;
        }
        if (value == null || value.equals("")) {
            return rowSet;
        }
        OptionEnum optenum2 = null;
        String mark = "";
        int tempPrior = -1;
        int pos = -1;
        Iterator ite = null;
        while (rowSet.next()) {
            tempPrior = rowSet.getInt(value);
            for (OptionEnum optenum2 : list) {
                if (tempPrior == optenum2.getValue()) {
                    mark = optenum2.getAlias();
                }
                rowSet.updateString("MultiApprove.id", mark);
            }
            rowSet.updateString("MultiApprove.isPass", rowSet.getString("MultiApprove.isPass").equals("true") ? "???" : "?????");
        }
        rowSet.beforeFirst();
        return rowSet;
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            block7: {
                IRowSet rowSet = null;
                try {
                    Variant paramVal = null;
                    ArrayList ps = ds.getParams();
                    if (ps.size() > 0) {
                        DSParam param = (DSParam)ps.get(0);
                        paramVal = param.getValue();
                    }
                    String oprId = ds.getID();
                    String tempQuery = null;
                    IForPrintFacade ibizForPrint = ForPrintFacadeFactory.getRemoteInstance();
                    if ("fixbill".equals(oprId)) {
                        tempQuery = FixExpenseAccountEditUI.BILLQUERYNAME;
                        rowSet = ibizForPrint.getRowset(FixExpenseAccountEditUI.this.id, tempQuery);
                        if (rowSet.next()) {
                            rowSet.previous();
                        }
                        return FixExpenseAccountEditUI.this.parseEnumValue(rowSet, "prior", "prioralias", PriorEnum.getEnumList());
                    }
                    if ("fixbill_a".equals(oprId)) {
                        tempQuery = FixExpenseAccountEditUI.MULTIAPPROVEQUERYNAME;
                        rowSet = ibizForPrint.getRowset(tempQuery, new String[]{"MultiApprove.billId"}, new String[]{FixExpenseAccountEditUI.this.id});
                        if (rowSet.next()) {
                            rowSet.previous();
                            rowSet = (IRowSet)FixExpenseAccountEditUI.this.parseEnumValue1(rowSet, "MultiApprove.handlerOpinion", "MultiApprove.handlerOpinion", OptionEnum.getEnumList());
                            return rowSet;
                        }
                        break block7;
                    }
                    return null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

