/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseSortFactory;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.IExpenseSort;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractFixExpenseAccountQueryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class FixExpenseAccountQueryUI
extends AbstractFixExpenseAccountQueryUI {
    private String RES = "com.kingdee.eas.cp.bc.client.LoanReqResource";
    private static final Logger logger = CoreUIObject.getLogger(FixExpenseAccountQueryUI.class);
    private final String RES_EXPENSE = "com.kingdee.eas.cp.bc.client.ExpAccResource";
    private final String ALL = EASResource.getString((String)"com.kingdee.eas.cp.bc.client.ExpAccResource", (String)"all");
    private FixExpenseFilterParam param;

    public FixExpenseAccountQueryUI() throws Exception {
        this.initData();
    }

    private void initData() {
        this.btnAlreadyToVoucher.setUserObject((Object)StateEnum.ALREADVOUCHER);
        this.btnStateAudited.setUserObject((Object)StateEnum.CHECKED);
        this.btnStateAuditFailed.setUserObject((Object)StateEnum.CHECKFAILD);
        this.btnStateInAudit.setUserObject((Object)StateEnum.CHECKING);
        this.btnStateCancel.setUserObject((Object)StateEnum.CANCELED);
        this.btnStateSubmit.setUserObject((Object)StateEnum.SUBMIT);
        this.btnAlreadyImportPayFormat.setUserObject((Object)StateEnum.ALREADIMPORTPAYFORMAT);
        this.btnStateNew.setUserObject((Object)StateEnum.DRAFT);
        MakeControl.makeCurrency(this.prmtCurrency);
        this.prmtAppier.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.prmtAppier.setEditFormat("$number$");
        this.prmtAppier.setCommitFormat("$number$");
        this.prmtAppier.setDisplayFormat("$name$");
        this.prmtOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtOrgUnit.setCommitFormat("$number$");
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtExpenseType.setQueryInfo("com.kingdee.eas.cp.bc.app.F7ExpenseSortQuery");
        this.prmtExpenseType.setEditFormat("$sortName$");
        this.prmtExpenseType.setCommitFormat("$id$");
        this.prmtExpenseType.setDisplayFormat("$sortName$");
        this.prmtExpenseType.setEditable(true);
        this.dateBizReqDateFrom.setValue(null);
        this.dateBizReqDateTo.setValue(null);
        this.prmtExpenseType.setHasCUDefaultFilter(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        this.prmtExpenseType.setEntityViewInfo(evi);
    }

    private void checkError() throws ExpAccException {
        Date dtTo;
        if (this.dateBizReqDateFrom.getValue() == null || this.dateBizReqDateTo.getValue() == null) {
            return;
        }
        Date dtFrom = (Date)this.dateBizReqDateFrom.getValue();
        if (dtFrom.compareTo(dtTo = (Date)this.dateBizReqDateTo.getValue()) > 0) {
            throw new ExpAccException(ExpAccException.REQDATE_FROM_GT_TO);
        }
    }

    private Object getSelectedState() {
        Enumeration e = this.btnGroup.getElements();
        int count = 0;
        int bc = this.btnGroup.getButtonCount();
        while (e.hasMoreElements()) {
            KDRadioButton ab = (KDRadioButton)e.nextElement();
            if (this.btnGroup.isSelected(ab.getModel())) {
                return new Integer(((StateEnum)((Object)ab.getUserObject())).getValue());
            }
            if (++count <= bc) continue;
            break;
        }
        return null;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        super.setFilterInfo(filterInfo);
    }

    private void setSelectedState(StateEnum sEnum) {
        Enumeration e = this.btnGroup.getElements();
        int count = 0;
        int bc = this.btnGroup.getButtonCount();
        while (e.hasMoreElements()) {
            KDRadioButton ab = (KDRadioButton)e.nextElement();
            if (sEnum.equals(ab.getUserObject())) {
                this.btnGroup.setSelected(ab.getModel(), true);
            }
            if (++count <= bc) continue;
            break;
        }
    }

    private String trim(String str, String trim) {
        if (str == null) {
            return "";
        }
        if (trim == null || "".equals(trim)) {
            return trim;
        }
        if (str.startsWith(trim)) {
            return this.trim(str.substring(trim.length()), trim);
        }
        if (str.endsWith(trim)) {
            return this.trim(str.substring(0, str.length() - trim.length()), trim);
        }
        return str;
    }

    public FilterInfo getFilterInfo() {
        Object info;
        this.filterInfo = new FilterInfo();
        FilterItemCollection fic = this.filterInfo.getFilterItems();
        int index = 0;
        StringBuffer maskString = new StringBuffer("");
        if (this.dateBizReqDateFrom.getValue() != null && this.dateBizReqDateTo.getValue() != null) {
            Date dtFrom = (Date)this.dateBizReqDateFrom.getValue();
            Date dtTo = (Date)this.dateBizReqDateTo.getValue();
            dtTo = DateTimeUtils.addDay((Date)dtTo, (long)1L);
            fic.add(new FilterItemInfo("bizReqDate", (Object)DateTimeUtils.truncateDate((Date)dtFrom), CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("bizReqDate", (Object)DateTimeUtils.format((Date)dtTo), CompareType.LESS_EQUALS));
            this.makeMaskString(maskString, index++, "AND");
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtCurrency.getData() != null) {
            CurrencyInfo currency = (CurrencyInfo)this.prmtCurrency.getData();
            fic.add(new FilterItemInfo("currencyType.id", (Object)currency.getId().toString(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (!BizCollUtil.objectIsNull(this.txtName.getText())) {
            fic.add(new FilterItemInfo("name", (Object)("%" + this.txtName.getText() + "%"), CompareType.LIKE));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText()) && !BizCollUtil.objectIsNull(this.txtNumberTo.getText())) {
            fic.add(new FilterItemInfo("number", (Object)this.txtNumberFrom.getText(), CompareType.GREATER_EQUALS));
            fic.add(new FilterItemInfo("number", (Object)this.txtNumberTo.getText(), CompareType.LESS_EQUALS));
            this.makeMaskString(maskString, index++, "AND");
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.btnGroup.getSelection() != this.btnStateAll.getModel()) {
            fic.add(new FilterItemInfo("state", this.getSelectedState(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtAppier.getData() != null) {
            PersonInfo person = (PersonInfo)this.prmtAppier.getData();
            fic.add(new FilterItemInfo("applier.id", (Object)person.getId().toString(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtOrgUnit.getValue() != null) {
            info = (OrgUnitInfo)this.prmtOrgUnit.getValue();
            fic.add(new FilterItemInfo("orgUnit.id", (Object)info.getId(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        if (this.prmtExpenseType.getValue() != null) {
            info = (ExpenseSortInfo)this.prmtExpenseType.getData();
            fic.add(new FilterItemInfo("sortName.id", (Object)info.getId(), CompareType.EQUALS));
            this.makeMaskString(maskString, index++, "AND");
        }
        this.filterInfo.setMaskString(maskString.toString());
        return super.getFilterInfo();
    }

    public void loadData(EntityViewInfo view) {
        ObjectUuidPK pk;
        String id;
        Object obj;
        if (view.getFilter() == null) {
            return;
        }
        FilterItemCollection fic = view.getFilter().getFilterItems();
        this.clear();
        if (this.param == null) {
            return;
        }
        int flag = this.param.getFlag();
        int index = 0;
        if ((flag & 0x80) != 0 && fic.size() > index) {
            try {
                Date dtFrom = DateTimeUtils.parseDate((String)fic.get(index++).getCompareValue().toString());
                Date dtTo = DateTimeUtils.parseDate((String)fic.get(index++).getCompareValue().toString());
                this.dateBizReqDateFrom.setValue((Object)dtFrom);
                this.dateBizReqDateTo.setValue((Object)dtTo);
            }
            catch (ParseException e) {
                this.initDate();
            }
        }
        if ((flag & 1) != 0 && fic.size() > index) {
            if ((obj = fic.get(index++).getCompareValue()) == null) {
                return;
            }
            BOSUuid curId = BOSUuid.read((String)obj.toString());
            try {
                ICurrency iCur = CurrencyFactory.getRemoteInstance();
                CurrencyInfo cur = (CurrencyInfo)iCur.getValue((IObjectPK)new ObjectUuidPK(curId));
                this.prmtCurrency.setData((Object)cur);
            }
            catch (BOSException e1) {
                this.prmtCurrency.setData(null);
            }
            catch (EASBizException e) {
                this.prmtCurrency.setData(null);
            }
        }
        if ((flag & 2) != 0 && fic.size() > index) {
            this.txtName.setText(this.trim(fic.get(index++).getCompareValue().toString(), "%"));
        }
        if ((flag & 8) != 0 && fic.size() > index) {
            this.txtNumberFrom.setText(fic.get(index++).getCompareValue().toString());
            this.txtNumberTo.setText(fic.get(index++).getCompareValue().toString());
        }
        if ((flag & 0x20) != 0 && fic.size() > index) {
            Integer state = (Integer)fic.get(index++).getCompareValue();
            StateEnum sEnum = StateEnum.getEnum(state);
            this.setSelectedState(sEnum);
        }
        if ((flag & 0x40) != 0 && fic.size() > index) {
            if ((obj = fic.get(index++).getCompareValue()) == null) {
                return;
            }
            BOSUuid costId = BOSUuid.read((String)obj.toString());
            try {
                IPerson iPerson = PersonFactory.getRemoteInstance();
                PersonInfo person = (PersonInfo)iPerson.getValue((IObjectPK)new ObjectUuidPK(costId));
                this.prmtAppier.setData((Object)person);
            }
            catch (BOSException e1) {
                this.prmtAppier.setData(null);
            }
            catch (EASBizException e) {
                this.prmtAppier.setData(null);
            }
        }
        if ((flag & 0x100) != 0 && fic.size() > index) {
            id = fic.get(index++).getCompareValue().toString();
            pk = new ObjectUuidPK(id);
            try {
                IAdminOrgUnit iOrg = AdminOrgUnitFactory.getRemoteInstance();
                AdminOrgUnitInfo orgInfo = iOrg.getAdminOrgUnitInfo((IObjectPK)pk);
                this.prmtOrgUnit.setValue((Object)orgInfo);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage());
                logger.info((Object)e.getCause());
            }
        }
        if ((flag & 0x200) != 0 && fic.size() > index) {
            id = fic.get(index++).getCompareValue().toString();
            pk = new ObjectUuidPK(id);
            try {
                IExpenseSort iSort = ExpenseSortFactory.getRemoteInstance();
                ExpenseSortInfo sortInfo = iSort.getExpenseSortInfo((IObjectPK)pk);
                this.prmtExpenseType.setValue((Object)sortInfo);
            }
            catch (Exception e) {
                this.prmtExpenseType.setValue(null);
            }
        }
    }

    public Object getParam() {
        if (this.param == null) {
            this.param = new FixExpenseFilterParam();
        }
        int flag = 0;
        if (this.prmtCurrency.getData() != null) {
            flag |= 1;
        }
        if (!BizCollUtil.objectIsNull(this.txtName.getText())) {
            flag |= 2;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText()) && !BizCollUtil.objectIsNull(this.txtNumberTo.getText())) {
            flag |= 8;
        }
        if (this.btnGroup.getSelection() != this.btnStateAll.getModel()) {
            flag |= 0x20;
        }
        if (this.prmtAppier.getData() != null) {
            flag |= 0x40;
        }
        if (this.dateBizReqDateFrom.getValue() != null && this.dateBizReqDateTo != null) {
            flag |= 0x80;
        }
        if (this.prmtExpenseType.getData() != null) {
            flag |= 0x200;
        }
        if (this.prmtOrgUnit.getData() != null) {
            flag |= 0x100;
        }
        this.param.setFlag(flag);
        return this.param;
    }

    public void setParam(Object param) {
        this.param = (FixExpenseFilterParam)param;
    }

    private void initDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.dateBizReqDateFrom.setValue((Object)cal.getTime());
        this.dateBizReqDateTo.setValue((Object)date);
    }

    public void clear() {
        super.clear();
        this.prmtAppier.setValue(null);
        this.prmtCurrency.setValue(null);
        this.prmtExpenseType.setValue(null);
        this.prmtOrgUnit.setValue(null);
        this.dateBizReqDateTo.setValue(null);
        this.dateBizReqDateFrom.setValue(null);
        this.txtName.setText("");
        this.txtNumberFrom.setText("");
        this.txtNumberTo.setText("");
        this.btnAlreadyToVoucher.setSelected(false);
        this.btnStateAll.setSelected(false);
        this.btnStateAudited.setSelected(false);
        this.btnStateAuditFailed.setSelected(false);
        this.btnStateCancel.setSelected(false);
        this.btnAlreadyImportPayFormat.setSelected(false);
        this.btnStateInAudit.setSelected(false);
        this.btnStateNew.setSelected(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnStateAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnStateAll_actionPerformed(e);
    }

    private void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append(" ");
            maskString.append("#" + index);
            maskString.append(" ");
        } else {
            maskString.append(" ");
            maskString.append(logicWord + " #" + index);
            maskString.append(" ");
        }
    }

    public static class FixExpenseFilterParam
    implements Serializable {
        public static final int HAS_CURRENCY = 1;
        public static final int HAS_NAME = 2;
        public static final int HAS_ORGUNIT = 256;
        public static final int HAS_EXPENSETYPE = 512;
        public static final int HAS_BILLNAME = 16;
        public static final int HAS_NUMBER = 8;
        public static final int HAS_COMPANY = 4;
        public static final int HAS_STATE = 32;
        public static final int HAS_REQPERSON = 64;
        public static final int HAS_DATE = 128;
        private int flag = 0;

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int f) {
            this.flag = f;
        }
    }
}

