/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.IOperationTypeCompanyEntry;
import com.kingdee.eas.cp.bc.IOperationTypeCostCenterEntry;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.client.AbstractOperationTypeListUI;
import com.kingdee.eas.cp.bc.client.OperationTypeCompanyMapEditUI;
import com.kingdee.eas.cp.bc.client.OperationTypeCostCenterMapEditUI;
import com.kingdee.eas.cp.bc.client.OperationTypeEditUI;
import com.kingdee.eas.cp.bc.client.OperationTypeSubjectMappingListUI;
import com.kingdee.eas.cp.bc.util.OperationTypeUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;

public class OperationTypeListUI
extends AbstractOperationTypeListUI {
    private static final long serialVersionUID = 2564602372104110310L;
    CompanyOrgUnitInfo currentCompany = null;
    IOperationTypeCostCenterEntry service = OperationTypeCostCenterEntryFactory.getRemoteInstance();
    IOperationTypeCompanyEntry serviceCompany = OperationTypeCompanyEntryFactory.getRemoteInstance();

    public OperationTypeListUI() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                OperationTypeListUI.this.setButtonStatus(e);
            }
        });
        if (this.currentCompany == null || this.currentCompany.isIsOnlyUnion()) {
            this.btnCostCenterMapp.setEnabled(false);
        }
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke(123, 192, false));
    }

    public void onShow() throws Exception {
        super.onShow();
        this.updateCostCenterMappingName();
    }

    protected void execQuery() {
        super.execQuery();
        this.updateCostCenterMappingName();
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (e != null && e.getSource() != null && (e.getSource().equals(this.menuItemAddNew) || e.getSource().equals(this.btnAddNew))) {
            this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        }
        super.refresh(e);
    }

    public void refreshListForOrder() throws Exception {
        super.refreshListForOrder();
        this.updateCostCenterMappingName();
    }

    private void setButtonStatus(KDTSelectEvent e) {
        IBlock sb = null;
        IRow row = null;
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        boolean isBtnEnableEnable = true;
        boolean isBtnDisableEnable = true;
        int nBottomNum = 0;
        for (int i = 0; i < size; ++i) {
            sb = KDTBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            nBottomNum = sb.getBottom();
            for (int j = sb.getTop(); j <= nBottomNum; ++j) {
                row = this.tblMain.getRow(j);
                if (row.getCell("isEnable").getValue() == null) continue;
                if (((Boolean)row.getCell("isEnable").getValue()).booleanValue()) {
                    isBtnEnableEnable = false;
                    continue;
                }
                isBtnDisableEnable = false;
            }
        }
        if (!isBtnDisableEnable) {
            this.btnCostCenterMapp.setEnabled(false);
        } else {
            CompanyOrgUnitInfo cui = SysContext.getSysContext().getCurrentFIUnit();
            if (BizCollUtil.isBizUnitCompany(cui)) {
                this.btnCostCenterMapp.setEnabled(true);
            } else {
                this.btnCostCenterMapp.setEnabled(false);
            }
        }
        this.btnEnable.setEnabled(isBtnEnableEnable);
        this.menuItemEnable.setEnabled(isBtnEnableEnable);
        this.btnDisable.setEnabled(isBtnDisableEnable);
        this.menuItemDisable.setEnabled(isBtnDisableEnable);
        this.btnRemove.setEnabled(isBtnDisableEnable);
        this.menuItemRemove.setEnabled(isBtnDisableEnable);
        this.btnEdit.setEnabled(isBtnDisableEnable);
        this.menuItemEdit.setEnabled(isBtnDisableEnable);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEnable.setEnabled(true);
        this.btnDisable.setEnabled(true);
        this.menuItemEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemEnable.setEnabled(true);
        this.menuItemDisable.setEnabled(true);
        this.btnSubjectMapping.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnCostCenterMapp.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnSubjectMapping.setEnabled(true);
        this.btnCompanyMapp.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        CompanyOrgUnitInfo cui = SysContext.getSysContext().getCurrentFIUnit();
        if (cui.isIsBizUnit()) {
            this.btnCompanyMapp.setEnabled(false);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OperationTypeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return OperationTypeEditUI.class.getName();
    }

    @Override
    public void actionSubjectMapping_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubjectMapping_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
        IUIWindow window = uiFactory.create(OperationTypeSubjectMappingListUI.class.getName(), (Map)uiContext, null, null);
        window.show();
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        OperationTypeFactory.getRemoteInstance().setUsable(this.getSelectedIdList(), false);
        super.refresh(e);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        OperationTypeFactory.getRemoteInstance().setUsable(this.getSelectedIdList(), true);
        super.refresh(e);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        HashSet<String> CUs = new HashSet<String>();
        CompanyOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (unitInfo == null) {
            return filter;
        }
        String[] numbers = StringUtils.split((String)unitInfo.getLongNumber(), (String)"!");
        List<String> numberList = Arrays.asList(numbers);
        for (int i = 0; i < numbers.length; ++i) {
            CUs.add(numbers[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("company.number", CUs, CompareType.INCLUDE));
        try {
            Set operationIdSet;
            if (unitInfo.isIsBizUnit() && (operationIdSet = BizBaseDataWebFacadeFactory.getRemoteInstance().getOperationIdsByCompany(unitInfo)).size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)operationIdSet, CompareType.INCLUDE));
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String companyId = KDTableUtil.getSelectedRow((KDTable)this.tblMain).getCell("companyId").getValue().toString();
        if (!SysContext.getSysContext().getCurrentFIUnit().getId().toString().equals(companyId)) {
            throw new OperationException(OperationException.OPRTTYPE_NOT_BELONGTOCURRCOMPANY);
        }
        super.actionEdit_actionPerformed(e);
    }

    private List<Object> getSelectedIdList() {
        this.checkSelected();
        ArrayList<Object> ids = new ArrayList<Object>();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        int num = 0;
        IRow row = null;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            num = sb.getBottom();
            for (int j = sb.getTop(); j <= num; ++j) {
                row = this.tblMain.getRow(j);
                ids.add(row.getCell("id").getValue());
            }
        }
        return ids;
    }

    protected void applyPreference() {
        super.applyPreference();
    }

    @Override
    public boolean isPrepareActionSubjectMapping() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEdit(itemAction);
        request.put("ID", (Object)this.getSelectedKeyValue());
        return request;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCostCenterMapping_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List<Object> idList = this.getSelectedIdList();
        ArrayList<String> idListLock = new ArrayList<String>(idList.size());
        Iterator<Object> it = idList.iterator();
        while (it.hasNext()) {
            idListLock.add(it.next().toString() + "cost");
        }
        Map selcIdNumber = super.getSelectedIdNumber();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map mutexData = mutexServiceControl.batchRequestObjIDForUpdate(idListLock);
            Iterator iter = mutexData.entrySet().iterator();
            boolean isLock = false;
            StringBuilder lockMsg = new StringBuilder();
            String key = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                isLock = true;
                key = (String)entry.getKey();
                lockMsg.append(selcIdNumber.get(key.substring(0, key.length() - "cost".length())));
                lockMsg.append(",");
            }
            if (isLock) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.bc.OperationResource", (String)"operationLock", (Object[])new Object[]{lockMsg.substring(0, lockMsg.length() - 1)}));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"getSelectedIdList", idList);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(OperationTypeCostCenterMapEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            window.show();
            this.refresh(e);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idListLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCompanyMapping_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        List<Object> idList = this.getSelectedIdList();
        ArrayList<String> idListLock = new ArrayList<String>(idList.size());
        Iterator<Object> it = idList.iterator();
        while (it.hasNext()) {
            idListLock.add(it.next().toString() + "company");
        }
        Map selcIdNumber = super.getSelectedIdNumber();
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map mutexData = mutexServiceControl.batchRequestObjIDForUpdate(idListLock);
            Iterator iter = mutexData.entrySet().iterator();
            boolean isLock = false;
            String key = null;
            StringBuilder lockMsg = new StringBuilder();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                isLock = true;
                key = (String)entry.getKey();
                lockMsg.append(selcIdNumber.get(key.substring(0, key.length() - "company".length())));
                lockMsg.append(",");
            }
            if (isLock) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.cp.bc.OperationResource", (String)"operationLock", (Object[])new Object[]{lockMsg.substring(0, lockMsg.length() - 1)}));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"getSelectedIdList", this.getSelectedIdList());
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create(OperationTypeCompanyMapEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            window.show();
            this.refresh(e);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idListLock);
        }
    }

    protected void updateCostCenterMappingName() {
        int rowCount;
        if (BizCollUtil.objectIsNull(this.currentCompany)) {
            this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (BizCollUtil.objectIsNull(this.service)) {
            try {
                this.service = OperationTypeCostCenterEntryFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (BizCollUtil.objectIsNull(this.serviceCompany)) {
            try {
                this.serviceCompany = OperationTypeCompanyEntryFactory.getRemoteInstance();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (!(this.currentCompany == null && this.currentCompany.isIsOnlyUnion() || (rowCount = this.tblMain.getRowCount()) <= 0)) {
            IRow row = null;
            try {
                int i;
                HashSet<String> operationId = new HashSet<String>();
                for (i = 0; i < rowCount; ++i) {
                    row = this.tblMain.getRow(i);
                    operationId.add(row.getCell("id").getValue().toString());
                }
                Map costCenterName = OperationTypeUtil.getOperationMappedCostcenter(this.service, operationId, this.currentCompany.getId().toString());
                Map companyName = OperationTypeUtil.getOperationMappedCompany(this.serviceCompany, operationId, this.currentCompany.getId().toString());
                for (i = 0; i < rowCount; ++i) {
                    row = this.tblMain.getRow(i);
                    row.getCell("costCenterName").setValue(costCenterName.get(row.getCell("id").getValue().toString()));
                    row.getCell("companyName").setValue(companyName.get(row.getCell("id").getValue().toString()));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }
}

