/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.OtherExpenseBillWKEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillWKFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillWKInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.client.AbstractOtherExpenseWKEditUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OtherExpenseWKEditUI
extends AbstractOtherExpenseWKEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherExpenseWKEditUI.class);
    private static final String OTHEREXPENSEBILLWK_AMOUNT = "amount";
    private static final BigDecimal DEFAULTZERO = new BigDecimal("0.00");
    private static final String BILLNAME = EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"73_OtherExpenseWKEditUI");

    @Override
    public void onLoad() throws Exception {
        int state;
        super.onLoad();
        this.kdtEntries.setColumnMoveable(true);
        JButton btnAddRuleNew = this.kDContainer1.add((Action)this.actionAddLine);
        JButton btnDelRuleNew = this.kDContainer1.add((Action)this.actionRemoveLine);
        btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddRuleNew.setSize(22, 19);
        btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnDelRuleNew.setSize(22, 19);
        this.setColumnFormat(OTHEREXPENSEBILLWK_AMOUNT, "%r-[&]{#,##0.00}n");
        this.initOldData((IObjectValue)this.editData);
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData != null && this.editData.getState() != null && (60 == (state = this.editData.getState().getValue()) || 25 == state || 30 == state)) {
            btnAddRuleNew.setEnabled(false);
            btnDelRuleNew.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        this.tempMark = false;
        this.dataBinder.loadFields();
        super.initBtnToKVoucher();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.initDefaultLine(this.kdtEntries);
        }
        this.tempMark = true;
    }

    public void initDefaultLine(KDTable table) {
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        if (table.getRowCount() <= 0) {
            row = table.addRow();
        }
        this.loadLineFields(table, row, detailData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        OtherExpenseBillWKInfo tempInfo = new OtherExpenseBillWKInfo();
        tempInfo.setName(BILLNAME);
        tempInfo.setBiller(SysContext.getSysContext().getCurrentUserInfo());
        tempInfo.setBillDate(new Timestamp(System.currentTimeMillis()));
        tempInfo.setBizReqDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        tempInfo.setState(StateEnum.NEW);
        tempInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        tempInfo.setPrior(PriorEnum.LOW);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        tempInfo.setBiller(user);
        if (user != null && user.getPerson() != null) {
            try {
                IPerson ip = PersonFactory.getRemoteInstance();
                PersonInfo applier = (PersonInfo)ip.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId()));
                tempInfo.setApplier(applier);
                if (applier != null) {
                    IPositionMember ipm = PositionMemberFactory.getRemoteInstance();
                    PositionInfo poInfo = null;
                    PositionMemberCollection pco = ipm.getPositionsByPerson(applier.getId());
                    poInfo = pco == null || pco.size() == 0 ? null : pco.get(0).getPosition();
                    tempInfo.setPosition(poInfo);
                    tempInfo.setOrgUnit(this.getOrgUnitReferToApplier(applier));
                }
            }
            catch (Exception e) {
                tempInfo.setApplier(null);
                tempInfo.setPosition(null);
                tempInfo.setOrgUnit(null);
            }
        }
        String sysNumber = null;
        try {
            sysNumber = this.getCodeRuleClient(tempInfo);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (sysNumber != null && sysNumber.trim().length() > 0) {
            tempInfo.setNumber(sysNumber);
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        return tempInfo;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        OtherExpenseBillWKEntryInfo info = new OtherExpenseBillWKEntryInfo();
        info.setAmount(new BigDecimal(new String("0.00")));
        return info;
    }

    @Override
    protected void checkEntry(KDTable table) throws ExpAccException {
        int rows = this.getDetailTable().getRowCount();
        IRow row = null;
        if (rows < 1) {
            throw new ExpAccException(ExpAccException.ENTRY_NOT_NULL);
        }
        KDTEditManager kdtManager = this.getDetailTable().getEditManager();
        for (int i = 0; i < rows; ++i) {
            BigDecimal obj;
            row = this.getDetailTable().getRow(i);
            if (row == null) continue;
            if (this.objectIsNull(row.getCell("purpose").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("purpose"));
                throw new ExpAccException(ExpAccException.PURPOSE_NOT_NULL_ENTRY);
            }
            if (((String)row.getCell("purpose").getValue()).length() > 200) {
                throw new ExpAccException(ExpAccException.EXP_TOO_LONG);
            }
            if (row.getCell("comment").getValue() != null && ((String)row.getCell("comment").getValue()).length() > 200) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("comment"));
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            BigDecimal max = new BigDecimal("999999999999999999");
            BigDecimal bigDecimal = obj = row.getCell(OTHEREXPENSEBILLWK_AMOUNT) == null ? DEFAULTZERO : row.getCell(OTHEREXPENSEBILLWK_AMOUNT).getValue();
            if (OtherExpenseWKEditUI.toBigDecimal(obj).compareTo(DEFAULTZERO) <= 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex(OTHEREXPENSEBILLWK_AMOUNT));
                throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
            }
            if (OtherExpenseWKEditUI.toBigDecimal(obj).compareTo(max) <= 0) continue;
            kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex(OTHEREXPENSEBILLWK_AMOUNT));
            throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
        }
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntries_editStopped(e);
        if (e.getColIndex() == this.kdtEntries.getColumnIndex(OTHEREXPENSEBILLWK_AMOUNT)) {
            BigDecimal bd = this.totalAmount(this.kdtEntries);
            this.txtAmount.setValue((Object)bd);
            this.txtAmountApproved.setValue((Object)bd);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getBaseSelectors();
        SelectorItemCollection superSic = super.getSelectors();
        int n = superSic.size();
        for (int i = 0; i < n; ++i) {
            sic.add(superSic.get(i));
        }
        return sic;
    }

    private BigDecimal totalAmount(KDTable table) {
        if (table == null) {
            return new BigDecimal("0.00");
        }
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.00");
        BigDecimal amount = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = table.getRow(i);
            cell = row.getCell(OTHEREXPENSEBILLWK_AMOUNT);
            Object value = cell.getValue();
            amount = BizCollUtil.toBigDecimal(value);
            if (amount == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        return columnAmount;
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        BigDecimal tempValue = this.totalAmount(table);
        this.txtAmount.setValue((Object)tempValue);
        this.txtAmountApproved.setValue((Object)tempValue);
    }

    @Override
    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.txtAmount.setValue((Object)this.totalAmount(this.getDetailTable()));
        super.beforeStoreFields(e);
    }

    @Override
    public void actionToKVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionToKVoucher_actionPerformed(e);
    }

    @Override
    public void actionPayFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionPayFormat_actionPerformed(e);
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return OtherExpenseBillWKFactory.getRemoteInstance();
    }

    @Override
    protected String getEntryTableName() {
        return "T_BC_OtherExpenseBillWKEntry";
    }

    @Override
    protected String getTableName() {
        return "T_BC_OtherExpenseBillWK";
    }

    private void setColumnFormat(String column, String format) {
        KDTDefaultCellEditor itemEditor = null;
        this.kdtEntries.getColumn(column).getStyleAttributes().setNumberFormat(MultilingualUtil.getDecimalFormatString());
        this.kdtEntries.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtHotelQuatity = new KDFormattedTextField(1);
        txtHotelQuatity.setEditable(true);
        txtHotelQuatity.setSupportedEmpty(true);
        txtHotelQuatity.setPrecision(2);
        itemEditor = new KDTDefaultCellEditor((JTextField)txtHotelQuatity);
        this.getDetailTable().getColumn(column).setEditor((ICellEditor)itemEditor);
    }

    @Override
    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldData, (AbstractObjectValue)this.editData);
    }

    protected void initOldData(IObjectValue dataObject) {
        AbstractObjectValue objectValue = (AbstractObjectValue)dataObject;
        this.oldData = (AbstractObjectValue)objectValue.clone();
    }

    @Override
    protected void setUIState() {
        super.setUIState();
        this.kDContainer1.setEnabled(false);
        this.kdtEntries.setEnabled(false);
        this.kdtEntries.getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }
}

