/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CompareSymbolEnum;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.client.AbstractRePayMentbillQueryUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class RePayMentbillQueryUI
extends AbstractRePayMentbillQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(RePayMentbillQueryUI.class);
    protected static final String RES = "com.kingdee.eas.cp.bc.client.ExpenseReqResource";
    private static final String AND = " AND ";
    private static final String ORG_UNIT = "orgUnit";
    private static final String APPLIER = "applier";
    private static final String SUPPORTEDOBJ = "supportedObj";
    private static final String REQ_DATE_FROM = "reqDateFrom";
    private static final String REQ_DATE_TO = "reqDateTo";
    private static final String NUMBER_FROM = "numberFrom";
    private static final String NAME = "name";
    private static final String AMOUNT = "amount";
    private static final String OPERATIONTYPE = "operationType";
    private static final String CURRENCYTYPE = "currencyType";
    private static final String OPRT = "oprt";
    private static final String COSTCOMPANY = "costCompany";
    private static final String APPLIERCOMPANY = "applierCompany";
    private static final String CAUSE = "cause";
    private static final String PRIOR = "prior";
    private static final String PAYMODE = "payMode";
    private static final String STATEAPPROVE = "stateapproving";
    private static final String OTHERSTATE = "otherState";
    private static final String STATEAUDITED = "stateAudited";
    private static final String STATEAUDITFAILED = "stateAuditFailed";
    private static final String STATECANCEL = "stateCancel";
    private static final String STATEVOUCHER = "stateVoucher";
    private static final String STATERECEIVE = "stateReceive";
    private static final String STATENEW = "stateNew";
    private static final int SELECTNULL = -1;
    Map params = null;
    private boolean isCalledByAccount = false;
    boolean guiApplierCompanyFilter = false;

    public RePayMentbillQueryUI() throws Exception {
        MakeControl.makePayMode(this.prmtPayMode);
        this.prmtPayMode.setRequired(false);
        this.cbOprt.addItem((Object)"  ");
        this.cbOprt.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.CompareSymbolEnum").toArray());
        this.bizPromptApplier.setEnabledMultiSelection(true);
        this.initDate();
        this.bizPromptReqDept.requestFocus();
        this.txtAmount.setDataType(1);
        this.txtAmount.setPrecision(2);
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.kDLabelContainer7.setVisible(false);
    }

    public RePayMentbillQueryUI(Map params) throws Exception {
        this();
        this.params = params;
        if (this.params != null) {
            MakeControl.makeReqDepF7(this.bizPromptReqDept, null, params);
            MakeControl.makeCompanyF7(this.prmtCostCompany, (CoreUIObject)this, params, null);
            String uiName = (String)this.params.get("uiName");
            String permItemName = "";
            if (StringUtils.indexOfIgnoreCase((String)uiName, (String)"com.kingdee.eas.cp.bc.client.RePaymentBillListUI") != -1) {
                permItemName = "cp_bc_RePaymentBill_View";
            } else if (StringUtils.indexOfIgnoreCase((String)uiName, (String)"com.kingdee.eas.cp.bc.client.RePaymentBillShareListUI") != -1) {
                permItemName = "cp_bc_web_RePaymentBill_View";
            }
            MakeControl.makeApplierCompanyF7(this.prmtApplierCompany, (CoreUIObject)this, params, null, permItemName);
            MakeControl.makeApplierF7(this.bizPromptApplier, (CoreUIObject)this, false);
        }
    }

    public FilterInfo getFilterInfo() {
        String cause;
        Object[] dataArray;
        Object[] dataArray2;
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        Object data = null;
        data = this.bizPromptReqDept.getData();
        if (!BizCollUtil.objectIsNull(data) && data instanceof AdminOrgUnitInfo) {
            item = new FilterItemInfo("orgUnit.id", (Object)((AdminOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.bizPromptApplier.getData()) != null && data instanceof Object[] && (dataArray2 = (Object[])data).length > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < dataArray2.length; ++i) {
                if (dataArray2[i] == null || !(dataArray2[i] instanceof PersonInfo)) continue;
                set.add(((PersonInfo)dataArray2[i]).getId().toString());
            }
            if (set.size() > 0) {
                item = new FilterItemInfo("applier.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if (!BizCollUtil.objectIsNull(this.dateBizReqDateFrom.getTimestamp())) {
            item = new FilterItemInfo("bizReqDate", (Object)BizCollUtil.covertToSimpleDate(this.dateBizReqDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.dateBizReqDateTo.getTimestamp())) {
            Date end = this.dateBizReqDateTo.getTimestamp();
            Calendar cal = Calendar.getInstance();
            cal.setTime(end);
            cal.add(5, 1);
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            cal.add(13, -1);
            end = cal.getTime();
            item = new FilterItemInfo("bizReqDate", (Object)end, CompareType.LESS_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            item = new FilterItemInfo("number", (Object)("%" + this.txtNumberFrom.getText().trim() + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        data = this.cbOprt.getSelectedItem();
        String amountString = this.txtAmount.getText();
        BigDecimal amount = null;
        if (!StringUtils.isEmpty((String)amountString)) {
            amountString = amountString.replaceAll(",", "");
            amount = new BigDecimal(amountString);
        }
        if (amount != null && data != null && data instanceof CompareSymbolEnum) {
            int oprt = ((CompareSymbolEnum)((Object)data)).getValue();
            CompareType op = null;
            switch (oprt) {
                case 0: {
                    op = CompareType.LESS;
                    break;
                }
                case 1: {
                    op = CompareType.LESS_EQUALS;
                    break;
                }
                case 2: {
                    op = CompareType.EQUALS;
                    break;
                }
                case 3: {
                    op = CompareType.GREATER_EQUALS;
                    break;
                }
                case 4: {
                    op = CompareType.GREATER;
                }
            }
            if (op != null) {
                item = new FilterItemInfo(AMOUNT, (Object)amount, op);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        if ((data = this.prmtCostCompany.getValue()) != null && data instanceof CompanyOrgUnitInfo) {
            item = new FilterItemInfo("costCompany.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.prmtApplierCompany.getValue()) != null && data instanceof CompanyOrgUnitInfo) {
            if (this.isCalledByAccount && !this.guiApplierCompanyFilter) {
                item = new FilterItemInfo("entries.company.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                maskString.append(" and (#" + index);
                item = new FilterItemInfo("applierCompany.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                maskString.append(" or #" + ++index + ")");
                ++index;
            } else {
                item = new FilterItemInfo("applierCompany.id", (Object)((CompanyOrgUnitInfo)data).getId().toString(), CompareType.EQUALS);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        } else if (data != null && data instanceof Object[] && (dataArray = (Object[])data).length > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null || !(dataArray[i] instanceof CompanyOrgUnitInfo)) continue;
                set.add(((CompanyOrgUnitInfo)dataArray[i]).getId().toString());
            }
            if (this.isCalledByAccount && !this.guiApplierCompanyFilter) {
                item = new FilterItemInfo("entries.company.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                maskString.append(" and (#" + index);
                item = new FilterItemInfo("applierCompany.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                maskString.append(" or #" + ++index + ")");
                ++index;
            } else {
                item = new FilterItemInfo("applierCompany.id", set, CompareType.INCLUDE);
                itemCollection.add(item);
                this.makeMaskString(maskString, index, AND);
                ++index;
            }
        }
        data = this.prmtPayMode.getValue();
        if (data != null && data instanceof SettlementTypeInfo) {
            item = new FilterItemInfo("payMode.id", (Object)((SettlementTypeInfo)data).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!StringUtils.isEmpty((String)(cause = this.txtCause.getText()))) {
            item = new FilterItemInfo(CAUSE, (Object)("%" + cause + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((item = this.getFilterStates()) != null) {
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    private FilterItemInfo getFilterStates() {
        FilterItemInfo filterItemInfo = null;
        HashSet<Integer> set = new HashSet<Integer>();
        if (this.btnStateNew.isSelected()) {
            set.add(new Integer(20));
        }
        if (this.btnStateCancel.isSelected()) {
            set.add(new Integer(25));
        }
        if (this.btnStateApproving.isSelected()) {
            set.add(new Integer(30));
        }
        if (this.btnStateAudited.isSelected()) {
            set.add(new Integer(60));
        }
        if (this.btnStateAuditFailed.isSelected()) {
            set.add(new Integer(40));
        }
        if (this.btnStateAlreadyVoucher.isSelected()) {
            set.add(new Integer(45));
        }
        if (this.btnStateAlreadyReceive.isSelected()) {
            set.add(new Integer(140));
        }
        if (this.btnStateAlreadyAbandon.isSelected()) {
            set.add(new Integer(27));
        }
        if (set.size() > 0) {
            filterItemInfo = new FilterItemInfo("state", set, CompareType.INCLUDE);
        }
        return filterItemInfo;
    }

    public boolean verify() {
        Object obj = null;
        Timestamp dateFrom = null;
        Timestamp dateTo = null;
        obj = this.prmtApplierCompany.getValue();
        if (obj == null) {
            this.prmtApplierCompany.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"a_company_notnull"));
            return false;
        }
        if (!(StringUtils.isEmpty((String)this.txtAmount.getText()) || (obj = this.cbOprt.getSelectedItem()) != null && obj instanceof CompareSymbolEnum)) {
            this.cbOprt.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"compareSymbolNotNull"));
            return false;
        }
        obj = this.cbOprt.getSelectedItem();
        if (obj != null && obj instanceof CompareSymbolEnum && StringUtils.isEmpty((String)this.txtAmount.getText())) {
            this.txtAmount.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"amountNotNull"));
            return false;
        }
        obj = this.dateBizReqDateFrom.getValue();
        dateFrom = this.dateBizReqDateFrom.getTimestamp();
        if (obj == null) {
            this.dateBizReqDateFrom.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"dateFromNotNull"));
            return false;
        }
        obj = this.dateBizReqDateTo.getValue();
        dateTo = this.dateBizReqDateTo.getTimestamp();
        if (obj == null) {
            this.dateBizReqDateTo.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"dateToNotNull"));
            return false;
        }
        if (dateTo.compareTo(dateFrom) < 0) {
            this.dateBizReqDateFrom.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bgDateOverEndDate"));
            return false;
        }
        return super.verify();
    }

    public void clear() {
        super.clear();
        this.txtNumberFrom.setText(null);
        this.bizPromptReqDept.setData(null);
        this.bizPromptApplier.setData(null);
        this.txtCause.setText(null);
        this.txtAmount.setText(null);
        this.cbOprt.setSelectedItem(null);
        this.prmtCostCompany.setValue(null);
        this.prmtApplierCompany.setValue(null);
        this.prmtPayMode.setValue(null);
        this.btnStateNew.setSelected(false);
        this.btnStateCancel.setSelected(false);
        this.btnStateApproving.setSelected(false);
        this.btnStateAudited.setSelected(false);
        this.btnStateAuditFailed.setSelected(false);
        this.btnStateAlreadyVoucher.setSelected(false);
        this.btnStateAlreadyReceive.setSelected(false);
        this.initDate();
        this.prmtApplierCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
    }

    private void initDate() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dateFormat = DateFormat.getDateInstance();
        String dateString = dateFormat.format(date);
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.dateBizReqDateFrom.setValue((Object)cal.getTime());
        this.dateBizReqDateTo.setValue((Object)date);
    }

    private void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        Object object = null;
        object = this.bizPromptApplier.getValue();
        if (object != null && object instanceof Object[]) {
            String personId = "";
            Object[] personInfoObject = (Object[])object;
            for (int i = 0; i < personInfoObject.length; ++i) {
                if (personInfoObject[i] == null) continue;
                PersonInfo personInfo = (PersonInfo)personInfoObject[i];
                personId = personId + personInfo.getId().toString() + ",";
            }
            cp.addCustomerParam(APPLIER, personId);
        }
        if (!BizCollUtil.objectIsNull(object = this.bizPromptReqDept.getValue()) && object instanceof AdminOrgUnitInfo) {
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)object;
            cp.addCustomerParam(ORG_UNIT, adminOrgUnitInfo.getId().toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.txtNumberFrom.getText())) {
            cp.addCustomerParam(NUMBER_FROM, object.toString());
        }
        DateFormat df = MultilingualUtil.getDateFormat();
        object = this.dateBizReqDateFrom.getValue();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam(REQ_DATE_FROM, df.format(object));
        }
        if (!BizCollUtil.objectIsNull(object = this.dateBizReqDateTo.getValue())) {
            cp.addCustomerParam(REQ_DATE_TO, df.format(object));
        }
        if ((object = this.cbOprt.getSelectedItem()) != null && object instanceof CompareSymbolEnum) {
            cp.putInt(OPRT, ((CompareSymbolEnum)((Object)object)).getValue());
        } else {
            cp.putInt(OPRT, -1);
        }
        object = this.txtAmount.getText();
        if (!BizCollUtil.objectIsNull(object)) {
            cp.addCustomerParam(AMOUNT, object.toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.prmtCostCompany.getValue()) && object instanceof CompanyOrgUnitInfo) {
            cp.addCustomerParam(COSTCOMPANY, ((CompanyOrgUnitInfo)object).getId().toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.prmtApplierCompany.getValue()) && object instanceof CompanyOrgUnitInfo) {
            cp.addCustomerParam(APPLIERCOMPANY, ((CompanyOrgUnitInfo)object).getId().toString());
        } else if (!BizCollUtil.objectIsNull(object) && object instanceof Object[]) {
            Object[] arry = (Object[])object;
            String ids = "";
            for (int i = 0; i < arry.length; ++i) {
                ids = ids + ((CompanyOrgUnitInfo)arry[i]).getId().toString() + ",";
            }
            cp.addCustomerParam(APPLIERCOMPANY, ids.substring(0, ids.length() - 1));
        }
        object = this.prmtPayMode.getValue();
        if (!BizCollUtil.objectIsNull(object) && object instanceof SettlementTypeInfo) {
            cp.addCustomerParam(PAYMODE, ((SettlementTypeInfo)object).getId().toString());
        }
        if (!BizCollUtil.objectIsNull(object = this.txtCause.getText())) {
            cp.addCustomerParam(CAUSE, object.toString());
        }
        cp.putBoolean(STATENEW, this.btnStateNew.isSelected());
        cp.putBoolean(STATECANCEL, this.btnStateCancel.isSelected());
        cp.putBoolean(STATEAPPROVE, this.btnStateApproving.isSelected());
        cp.putBoolean(STATEAUDITED, this.btnStateAudited.isSelected());
        cp.putBoolean(STATEAUDITFAILED, this.btnStateAuditFailed.isSelected());
        cp.putBoolean(STATEVOUCHER, this.btnStateAlreadyVoucher.isSelected());
        cp.putBoolean(STATERECEIVE, this.btnStateAlreadyReceive.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        try {
            this.prepareCustomerParams(cp).callHandler();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
        }
        CustomerParams result = cp;
        String value = null;
        ObjectUuidPK pk = null;
        this.clear();
        String id = result.getCustomerParam(APPLIER);
        Object[] personValue = null;
        if (id != null) {
            String[] personId = id.split(",");
            personValue = new Object[personId.length];
            for (int i = 0; i < personId.length; ++i) {
                personValue[i] = BizCollUtil.returnObjectValueById(personId[i]);
            }
        }
        this.bizPromptApplier.setData(personValue);
        id = result.getCustomerParam(ORG_UNIT);
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (id != null) {
            try {
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                adminOrgUnitInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.bizPromptReqDept.setData(adminOrgUnitInfo);
        this.txtNumberFrom.setText(result.getCustomerParam(NUMBER_FROM));
        DateFormat df = MultilingualUtil.getDateFormat();
        try {
            this.dateBizReqDateFrom.setValue((Object)df.parse(result.getCustomerParam(REQ_DATE_FROM)));
            this.dateBizReqDateTo.setValue((Object)df.parse(result.getCustomerParam(REQ_DATE_TO)));
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        if (result.getInt(OPRT) != -1) {
            this.cbOprt.setSelectedItem((Object)CompareSymbolEnum.getEnum(result.getInt(OPRT)));
        }
        if (!StringUtils.isEmpty((String)result.getCustomerParam(AMOUNT))) {
            this.txtAmount.setText(result.getCustomerParam(AMOUNT));
        }
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo(NAME));
            value = cp.getCustomerParam(COSTCOMPANY);
            if (!StringUtils.isEmpty((String)value)) {
                ICompanyOrgUnit companyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
                pk = new ObjectUuidPK(value);
                this.prmtCostCompany.setValue((Object)companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk, selector));
            }
            HashSet applierCompanyIds = new HashSet();
            value = cp.getCustomerParam(APPLIERCOMPANY);
            if (!StringUtils.isEmpty((String)value)) {
                Object[] ids = value.split(",");
                CollectionUtils.addAll(applierCompanyIds, (Object[])ids);
            }
            FilterInfo companyFilter = new FilterInfo();
            companyFilter.getFilterItems().add(new FilterItemInfo("id", applierCompanyIds, CompareType.INCLUDE));
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(companyFilter);
            entityView.setSelector(selector);
            CompanyOrgUnitCollection companyCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(entityView);
            this.prmtApplierCompany.setData((Object)companyCollection.toArray());
            value = cp.getCustomerParam(PAYMODE);
            if (!StringUtils.isEmpty((String)value)) {
                ISettlementType settlementType = SettlementTypeFactory.getRemoteInstance();
                pk = new ObjectUuidPK(value);
                this.prmtPayMode.setValue((Object)settlementType.getSettlementTypeInfo((IObjectPK)pk, selector));
            }
        }
        catch (Exception ex) {
            super.handUIException((Throwable)ex);
        }
        if (!StringUtils.isEmpty((String)result.getCustomerParam(CAUSE))) {
            this.txtCause.setText(result.getCustomerParam(CAUSE));
        }
        this.btnStateNew.setSelected(cp.getBoolean(STATENEW));
        this.btnStateCancel.setSelected(cp.getBoolean(STATECANCEL));
        this.btnStateApproving.setSelected(cp.getBoolean(STATEAPPROVE));
        this.btnStateAudited.setSelected(cp.getBoolean(STATEAUDITED));
        this.btnStateAuditFailed.setSelected(cp.getBoolean(STATEAUDITFAILED));
        this.btnStateAlreadyVoucher.setSelected(cp.getBoolean(STATEVOUCHER));
        this.btnStateAlreadyReceive.setSelected(cp.getBoolean(STATERECEIVE));
    }

    public IUIActionPostman prepareCustomerParams(CustomerParams cp) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(UtilRequest.isPrepare((String)"CustomerParams", (CoreUIObject)this));
        if (!handler.isAvailabe()) {
            return handler;
        }
        RequestContext requestContext = new RequestContext();
        requestContext.setClassName(this.getUIHandlerClassName());
        requestContext.setMethodName("handleCustomerParams");
        requestContext.put("customerParams", (Object)cp.getCustomerParamsHashMap());
        requestContext.put("isCalledByAccount", (Object)new Boolean(this.isCalledByAccount));
        handler.setRequestContext((Serializable)requestContext);
        return handler;
    }

    public boolean isPrepareCustomerParams() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

