/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillWKEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillWKFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillWKInfo;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.client.AbstractTravelAccountWKEditUI;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class TravelAccountWKEditUI
extends AbstractTravelAccountWKEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TravelAccountWKEditUI.class);
    private static final String[] columns = new String[]{"taxiExpense", "bussesExpense", "hotelExpense", "subsidyExpense", "otherExpense", "amount"};
    private static final BigDecimal DEFAULTZERO = new BigDecimal("0.00");
    private static final Color countLineColor = new Color(246, 246, 191);

    @Override
    public void loadFields() {
        this.tempMark = false;
        this.setButtonState();
        super.initBtnToKVoucher();
        this.dataBinder.loadHeader();
        this.bindDataToTable(this.kdtEntries, (IObjectCollection)this.editData.getEntries());
        this.initDefaultLines(this.kdtEntries);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            Object obj = this.getUIContext().get("InitDataObject");
            if (obj == null) {
                this.reCalculateColulmnAmount(this.getTotalRow(this.kdtEntries), columns);
            }
        } else {
            this.reCalculateColulmnAmount(this.getTotalRow(this.kdtEntries), columns);
        }
        this.tempMark = true;
    }

    @Override
    public void onLoad() throws Exception {
        int state;
        super.onLoad();
        this.kdtEntries.setColumnMoveable(true);
        this.kDWorkButton1.setVisible(true);
        JButton btnAddRuleNew = this.kDContainer1.add((Action)this.actionAddLine);
        JButton btnDelRuleNew = this.kDContainer1.add((Action)this.actionRemoveLine);
        btnAddRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        btnAddRuleNew.setSize(22, 19);
        btnDelRuleNew.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        btnDelRuleNew.setSize(22, 19);
        this.kdtEntries.getColumn("amount").getStyleAttributes().setLocked(true);
        KDDatePicker dateBox = new KDDatePicker();
        dateBox.setTimeEnabled(false);
        dateBox.setMilliSecondEnable(false);
        dateBox.setDateEnabled(true);
        dateBox.setDatePattern(MultilingualUtil.getDateFormatString());
        this.kdtEntries.getColumn("startDate").setEditor((ICellEditor)new KDTDefaultCellEditor(dateBox));
        KDDatePicker dateEndBox = new KDDatePicker();
        dateEndBox.setTimeEnabled(false);
        dateEndBox.setMilliSecondEnable(false);
        dateEndBox.setDateEnabled(true);
        dateEndBox.setDatePattern(MultilingualUtil.getDateFormatString());
        this.kdtEntries.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(dateEndBox));
        KDComboBox comBox = new KDComboBox();
        comBox.setEditable(true);
        comBox.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.cp.bc.VehicleEnum").toArray());
        this.kdtEntries.getColumn("vehicle").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comBox));
        this.setColumnFormat("amount", "%r-[&]{#,##0.00}n");
        this.setColumnFormat("taxiExpense", "%r-[&]{#,##0.00}n");
        this.setColumnFormat("bussesExpense", "%r-[&]{#,##0.00}n");
        this.setColumnFormat("hotelExpense", "%r-[&]{#,##0.00}n");
        this.setColumnFormat("otherExpense", "%r-[&]{#,##0.00}n");
        this.setColumnFormat("subsidyExpense", "%r-[&]{#,##0.00}n");
        this.initOldData((IObjectValue)this.editData);
        if (OprtState.EDIT.equals(this.getOprtState()) && this.editData != null && this.editData.getState() != null && (60 == (state = this.editData.getState().getValue()) || 25 == state || 30 == state)) {
            btnAddRuleNew.setEnabled(false);
            btnDelRuleNew.setEnabled(false);
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        AbstractObjectValue objectValue = (AbstractObjectValue)dataObject;
        this.oldData = (AbstractObjectValue)objectValue.clone();
    }

    @Override
    public boolean isModify() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        try {
            this.storeFields();
        }
        catch (Exception exc) {
            return false;
        }
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldData, (AbstractObjectValue)this.editData);
    }

    public void bindDataToTable(KDTable table, IObjectCollection detailCollection) {
        if (detailCollection == null) {
            return;
        }
        table.removeRows();
        if (detailCollection != null) {
            table.setUserObject((Object)detailCollection);
        }
        int detailCount = detailCollection.size();
        IObjectValue detailData = null;
        IRow row = null;
        for (int i = 0; i < detailCount; ++i) {
            detailData = detailCollection.getObject(i);
            row = table.addRow();
            row.setUserObject((Object)detailData);
            this.loadLineFields(table, row, detailData);
        }
        super.loadFields();
    }

    public void bindTableToData(KDTable table, IObjectCollection detailCollection) {
        if (detailCollection == null) {
            return;
        }
        detailCollection.clear();
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = table.getRow(i);
            if (this.checkIsCountLine(row)) continue;
            IObjectValue obj = (IObjectValue)row.getUserObject();
            this.storeLineFields2(table, row, obj);
            if (this.checkIsBlankLine((AbstractObjectValue)obj) || !detailCollection.addObject(obj)) continue;
            this.storeLineFields(table, row, obj);
        }
    }

    @Override
    public void storeFields() {
        if (this.editData == null) {
            return;
        }
        this.dataBinder.storeHeader();
        this.bindTableToData(this.kdtEntries, (IObjectCollection)this.editData.getEntries());
    }

    public void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        super.storeLineFields(table, row, obj);
        this.dataBinder.storeLineFields(table, row, obj);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getBaseSelectors();
        SelectorItemCollection superSic = super.getSelectors();
        int n = superSic.size();
        for (int i = 0; i < n; ++i) {
            sic.add(superSic.get(i));
        }
        return sic;
    }

    private void storeLineFields2(KDTable table, IRow row, IObjectValue obj) {
        table.checkParsed();
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getFieldName();
            if (StringUtils.isEmpty((String)bindField)) continue;
            if (bindField.indexOf(".") >= 0) {
                String[] subItems = StringUtils.split((String)bindField, (String)".");
                IObjectValue subObj = obj;
                int l = subItems.length - 1;
                for (int k = 0; k < l && (subObj = (IObjectValue)subObj.get(subItems[k])) != null; ++k) {
                }
                if (subObj == null) continue;
                subObj.put(subItems[subItems.length - 1], row.getCell(i).getValue());
                continue;
            }
            Class<?> type = obj.getClass();
            try {
                String setMethodName = "set" + StringUtils.headCharUpperCase((String)bindField);
                Method[] methods = type.getMethods();
                Method method = null;
                int l = methods.length;
                for (int k = 0; k < l; ++k) {
                    if (!setMethodName.equalsIgnoreCase(methods[k].getName())) continue;
                    method = methods[k];
                    break;
                }
                if (method != null) {
                    method.invoke((Object)obj, row.getCell(i).getValue());
                    continue;
                }
                obj.put(bindField, row.getCell(i).getValue());
                continue;
            }
            catch (Exception e) {
                obj.put(bindField, row.getCell(i).getValue());
            }
        }
    }

    private boolean checkIsBlankLine(AbstractObjectValue objValue) {
        return ObjectValueUtil.objectValueEquals((AbstractObjectValue)((AbstractObjectValue)this.createNewDetailData(this.kdtEntries)), (AbstractObjectValue)objValue);
    }

    @Override
    protected IObjectValue createNewData() {
        TravelAccountBillWKInfo tempInfo = new TravelAccountBillWKInfo();
        tempInfo.setName(BizCollBillTypeEnum.TRAVEL_ACCOUNT.toString());
        tempInfo.setBillDate(new Timestamp(System.currentTimeMillis()));
        tempInfo.setBizReqDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        tempInfo.setState(StateEnum.NEW);
        tempInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        tempInfo.setPrior(PriorEnum.LOW);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        tempInfo.setBiller(user);
        if (user != null && user.getPerson() != null) {
            try {
                IPerson ip = PersonFactory.getRemoteInstance();
                PersonInfo applier = (PersonInfo)ip.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getPerson().getId()));
                tempInfo.setApplier(applier);
                if (applier != null) {
                    IPositionMember ipm = PositionMemberFactory.getRemoteInstance();
                    PositionInfo poInfo = null;
                    PositionMemberCollection pco = ipm.getPositionsByPerson(applier.getId());
                    poInfo = pco == null || pco.size() == 0 ? null : pco.get(0).getPosition();
                    tempInfo.setPosition(poInfo);
                    tempInfo.setOrgUnit(this.getOrgUnitReferToApplier(applier));
                }
            }
            catch (Exception e) {
                tempInfo.setApplier(null);
                tempInfo.setPosition(null);
                tempInfo.setOrgUnit(null);
            }
        }
        String sysNumber = null;
        try {
            sysNumber = this.getCodeRuleClient(tempInfo);
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (sysNumber != null && sysNumber.trim().length() > 0) {
            tempInfo.setNumber(sysNumber);
            this.txtNumber.setEnabled(false);
        } else {
            this.txtNumber.setEnabled(true);
        }
        return tempInfo;
    }

    @Override
    protected IObjectValue createNewDetailData(KDTable table) {
        TravelAccountBillWKEntryInfo lineInfo = new TravelAccountBillWKEntryInfo();
        lineInfo.setStartDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        lineInfo.setEndDate(DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
        lineInfo.setVehicle(VehicleEnum.BUSSES);
        lineInfo.setAmount(new BigDecimal("0.00"));
        return lineInfo;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return TravelAccountBillWKFactory.getRemoteInstance();
    }

    @Override
    protected void checkEntry(KDTable table) throws ExpAccException {
        int rows = this.getDetailTable().getRowCount();
        IRow row = null;
        if (rows < 1) {
            throw new ExpAccException(ExpAccException.ENTRY_NOT_NULL);
        }
        KDTEditManager kdtManager = this.getDetailTable().getEditManager();
        for (int i = 0; i < rows; ++i) {
            Date toDate;
            row = this.getDetailTable().getRow(i);
            if (row == null || this.checkIsCountLine(row)) continue;
            if (this.objectIsNull(row.getCell("startDate").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("startDate"));
                throw new ExpAccException(ExpAccException.BEGINDATE_NOT_NULL);
            }
            if (this.objectIsNull(row.getCell("endDate").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("endDate"));
                throw new ExpAccException(ExpAccException.ENDDATE_NOT_NULL);
            }
            if (this.objectIsNull(row.getCell("from").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("from"));
                throw new ExpAccException(ExpAccException.BEGIN_NOT_NULL);
            }
            if (row.getCell("from").getValue().toString().length() > 80) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("from"));
                throw new ExpAccException(ExpAccException.BEGIN_TOO_LONG);
            }
            if (this.objectIsNull(row.getCell("to").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("to"));
                throw new ExpAccException(ExpAccException.END_NOT_NULL);
            }
            if (row.getCell("to").getValue().toString().length() > 80) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("to"));
                throw new ExpAccException(ExpAccException.END_TOO_LONG);
            }
            if (this.objectIsNull(row.getCell("vehicle").getValue())) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("vehicle"));
                throw new ExpAccException(ExpAccException.VEHICLE_NOT_NULL);
            }
            Date fromDate = (Date)row.getCell("startDate").getValue();
            if (fromDate.compareTo(toDate = (Date)row.getCell("endDate").getValue()) > 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("startDate"));
                throw new ExpAccException(ExpAccException.BEGIN_LT_END);
            }
            BigDecimal obj = row.getCell("amount") == null ? DEFAULTZERO : row.getCell("amount").getValue();
            BigDecimal objTaxi = row.getCell("taxiExpense") == null ? DEFAULTZERO : row.getCell("taxiExpense").getValue();
            BigDecimal objBuss = row.getCell("bussesExpense") == null ? DEFAULTZERO : row.getCell("bussesExpense").getValue();
            BigDecimal objHotel = row.getCell("hotelExpense") == null ? DEFAULTZERO : row.getCell("hotelExpense").getValue();
            BigDecimal objSub = row.getCell("subsidy") == null ? DEFAULTZERO : row.getCell("subsidy").getValue();
            BigDecimal objOther = row.getCell("otherExpense") == null ? DEFAULTZERO : row.getCell("otherExpense").getValue();
            BigDecimal max = new BigDecimal("999999999999999999");
            if (TravelAccountWKEditUI.toBigDecimal(obj).compareTo(DEFAULTZERO) <= 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("amount"));
                throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
            }
            if (TravelAccountWKEditUI.toBigDecimal(obj).compareTo(max) > 0) {
                throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
            }
            if (TravelAccountWKEditUI.toBigDecimal(objTaxi).compareTo(max) > 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("taxiExpense"));
                throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
            }
            if (TravelAccountWKEditUI.toBigDecimal(objBuss).compareTo(max) > 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("bussesExpense"));
                throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
            }
            if (TravelAccountWKEditUI.toBigDecimal(objHotel).compareTo(max) > 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("hotelExpense"));
                throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
            }
            if (TravelAccountWKEditUI.toBigDecimal(objSub).compareTo(max) > 0) {
                kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("subsidy"));
                throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
            }
            if (TravelAccountWKEditUI.toBigDecimal(objOther).compareTo(max) <= 0) continue;
            kdtManager.editCellAt(i, this.getDetailTable().getColumnIndex("otherExpense"));
            throw new ExpAccException(ExpAccException.AMOUNT_MUST_TOOBIG);
        }
    }

    private void setColumnFormat(String column, String format) {
        KDTDefaultCellEditor itemEditor = null;
        this.kdtEntries.getColumn(column).getStyleAttributes().setNumberFormat(format);
        this.kdtEntries.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDFormattedTextField txtHotelQuatity = new KDFormattedTextField(1);
        txtHotelQuatity.setEditable(true);
        txtHotelQuatity.setSupportedEmpty(true);
        txtHotelQuatity.setPrecision(2);
        itemEditor = new KDTDefaultCellEditor((JTextField)txtHotelQuatity);
        this.getDetailTable().getColumn(column).setEditor((ICellEditor)itemEditor);
    }

    @Override
    protected void initDefaultLines(KDTable table) {
        if (table == null) {
            return;
        }
        if (!this.hasTotalLine(table)) {
            this.addTotalLine(table);
        }
        for (int i = table.getRowCount(); i <= 1; ++i) {
            this.addLine(table);
        }
    }

    @Override
    protected boolean checkIsCountLine(IRow row) {
        if (row == null) {
            return false;
        }
        if (row.getCell("startDate").getValue() == null) {
            return false;
        }
        return EASResource.getString((String)"com.kingdee.eas.cp.bc.client.LoanReqResource", (String)"count").equals(row.getCell("startDate").getValue().toString());
    }

    @Override
    protected void addTotalLine(KDTable table) {
        this.addLine(table);
        IRow row = table.getRow(table.getRowCount() - 1);
        row.getCell("startDate").setValue((Object)EASResource.getString((String)"com.kingdee.eas.cp.bc.client.LoanReqResource", (String)"count"));
        row.getCell("endDate").setValue((Object)"");
        row.getCell("vehicle").setValue((Object)"");
        row.getStyleAttributes().setBackground(countLineColor);
        row.getStyleAttributes().setLocked(true);
    }

    protected void addLine(KDTable table) {
        IObjectValue detailData = this.createNewDetailData(table);
        IRow row = null;
        row = table.getRowCount() > 0 ? (this.checkIsCountLine(table.getRow(table.getRowCount() - 1)) ? table.addRow(table.getRowCount() - 1) : table.addRow()) : table.addRow();
        this.loadLineFields(table, row, detailData);
        this.afterAddLine(table, detailData);
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        super.kdtEntries_editStopped(e);
        if (e.getColIndex() == this.kdtEntries.getColumnIndex("taxiExpense") || e.getColIndex() == this.kdtEntries.getColumnIndex("bussesExpense") || e.getColIndex() == this.kdtEntries.getColumnIndex("hotelExpense") || e.getColIndex() == this.kdtEntries.getColumnIndex("otherExpense") || e.getColIndex() == this.kdtEntries.getColumnIndex("subsidyExpense")) {
            this.calculateRowAmount(this.getTotalRow(this.kdtEntries), e.getRowIndex(), false);
            this.calculateColumnAmount(this.getTotalRow(this.kdtEntries), e.getColIndex());
            this.calculateRowAmount(this.getTotalRow(this.kdtEntries), e.getRowIndex(), true);
            BigDecimal bd = this.calculateTotalAmount(this.getTotalRow(this.kdtEntries));
            this.txtAmount.setValue((Object)bd);
            this.txtAmountApproved.setValue((Object)bd);
        }
    }

    @Override
    public IObjectPK runSave() throws Exception {
        String oprtState = this.getOprtState();
        if (oprtState != null && OprtState.ADDNEW.equals(oprtState)) {
            this.editData.setState(StateEnum.DRAFT);
        }
        return super.runSave();
    }

    private void setButtonState() {
        String billState = null;
        String string = billState = this.editData.getState() == null ? StateEnum.NEW.toString() : this.editData.getState().toString();
        if (billState.equals(StateEnum.CHECKED.toString())) {
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnPayFormat.setEnabled(true);
        } else if (billState.equals(StateEnum.DRAFT.toString())) {
            this.btnSave.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.btnPayFormat.setEnabled(false);
        }
    }

    private void calculateColumnAmount(IRow countRow, int indexColumn) {
        if (countRow == null) {
            return;
        }
        KDTable table = this.getDetailTable();
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.0");
        BigDecimal amount = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object value;
            row = table.getRow(i);
            if (this.checkIsCountLine(row) || (amount = BizCollUtil.toBigDecimal(value = (cell = row.getCell(indexColumn)).getValue())) == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        countRow.getCell(indexColumn).setValue((Object)columnAmount);
    }

    private void calculateColumnAmount(IRow countRow, String columnName) {
        if (countRow == null || columnName == null || columnName.equals("")) {
            return;
        }
        KDTable table = this.getDetailTable();
        IRow row = null;
        ICell cell = null;
        BigDecimal columnAmount = new BigDecimal("0.0");
        BigDecimal amount = null;
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object value;
            row = table.getRow(i);
            if (this.checkIsCountLine(row) || (amount = BizCollUtil.toBigDecimal(value = (cell = row.getCell(columnName)).getValue())) == null) continue;
            columnAmount = columnAmount.add(amount);
        }
        countRow.getCell(columnName).setValue((Object)columnAmount);
    }

    private void calculateRowAmount(IRow irow, int rowIndex, boolean isTotalRow) {
        KDTable table = this.getDetailTable();
        IRow countRow = null;
        Object cell = null;
        BigDecimal amount = new BigDecimal("0.00");
        countRow = !isTotalRow ? table.getRow(rowIndex) : table.getRow(table.getRowCount() - 1);
        BigDecimal taxiExpense = null;
        if (countRow.getCell("taxiExpense") != null) {
            taxiExpense = BizCollUtil.toBigDecimal(countRow.getCell("taxiExpense").getValue());
        }
        BigDecimal bussesExpense = null;
        if (countRow.getCell("bussesExpense") != null) {
            bussesExpense = BizCollUtil.toBigDecimal(countRow.getCell("bussesExpense").getValue());
        }
        BigDecimal hotelExpense = null;
        if (countRow.getCell("hotelExpense") != null) {
            hotelExpense = BizCollUtil.toBigDecimal(countRow.getCell("hotelExpense").getValue());
        }
        BigDecimal otherExpense = null;
        if (countRow.getCell("otherExpense") != null) {
            otherExpense = BizCollUtil.toBigDecimal(countRow.getCell("otherExpense").getValue());
        }
        BigDecimal subsidyExpense = null;
        if (countRow.getCell("subsidyExpense") != null) {
            subsidyExpense = BizCollUtil.toBigDecimal(countRow.getCell("subsidyExpense").getValue());
        }
        if (taxiExpense != null) {
            amount = amount.add(taxiExpense);
        }
        if (bussesExpense != null) {
            amount = amount.add(bussesExpense);
        }
        if (hotelExpense != null) {
            amount = amount.add(hotelExpense);
        }
        if (otherExpense != null) {
            amount = amount.add(otherExpense);
        }
        if (subsidyExpense != null) {
            amount = amount.add(subsidyExpense);
        }
        if (!isTotalRow) {
            table.getRow(rowIndex).getCell("amount").setValue((Object)amount);
        } else {
            table.getRow(table.getRowCount() - 1).getCell("amount").setValue((Object)amount);
        }
    }

    private BigDecimal calculateTotalAmount(IRow countRow) {
        BigDecimal amount = new BigDecimal("0.0");
        BigDecimal taxiExpense = null;
        if (countRow.getCell("taxiExpense") != null) {
            taxiExpense = BizCollUtil.toBigDecimal(countRow.getCell("taxiExpense").getValue());
        }
        BigDecimal bussesExpense = null;
        if (countRow.getCell("bussesExpense") != null) {
            bussesExpense = BizCollUtil.toBigDecimal(countRow.getCell("bussesExpense").getValue());
        }
        BigDecimal hotelExpense = null;
        if (countRow.getCell("hotelExpense") != null) {
            hotelExpense = BizCollUtil.toBigDecimal(countRow.getCell("hotelExpense").getValue());
        }
        BigDecimal otherExpense = null;
        if (countRow.getCell("otherExpense") != null) {
            otherExpense = BizCollUtil.toBigDecimal(countRow.getCell("otherExpense").getValue());
        }
        BigDecimal subsidyExpense = null;
        if (countRow.getCell("subsidyExpense") != null) {
            subsidyExpense = BizCollUtil.toBigDecimal(countRow.getCell("subsidyExpense").getValue());
        }
        if (taxiExpense != null) {
            amount = amount.add(taxiExpense);
        }
        if (bussesExpense != null) {
            amount = amount.add(bussesExpense);
        }
        if (hotelExpense != null) {
            amount = amount.add(hotelExpense);
        }
        if (otherExpense != null) {
            amount = amount.add(otherExpense);
        }
        if (subsidyExpense != null) {
            amount = amount.add(subsidyExpense);
        }
        return amount;
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        IRow iRow = null;
        iRow = this.getTotalRow(this.kdtEntries);
        this.reCalculateColulmnAmount(iRow, columns);
        this.calculateRowAmount(this.getTotalRow(this.kdtEntries), 0, true);
        BigDecimal tempValue = this.calculateTotalAmount(this.getTotalRow(this.kdtEntries));
        this.txtAmount.setValue((Object)tempValue);
        this.txtAmountApproved.setValue((Object)tempValue);
    }

    private void reCalculateColulmnAmount(IRow iRow, String[] columnArray) {
        int len = columnArray.length;
        for (int i = 0; i < len; ++i) {
            this.calculateColumnAmount(iRow, columnArray[i]);
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        if (this.hasTotalLine(this.kdtEntries)) {
            return;
        }
        this.addTotalLine(this.kdtEntries);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.getDetailTable().getSelectManager().get().getTop();
        if (this.getDetailTable().getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.checkIsCountLine(this.getDetailTable().getRow(top))) {
            return;
        }
        super.actionRemoveLine_actionPerformed(e);
    }

    @Override
    public void afterActionPerformed(ActionEvent e) {
        super.afterActionPerformed(e);
        this.initDefaultLines(this.kdtEntries);
    }

    @Override
    public void actionPayFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionPayFormat_actionPerformed(e);
        if (this.editData != null && Integer.parseInt(this.editData.get("state").toString()) == 60) {
            this.editData.setState(StateEnum.ALREADYPAYMENT);
        }
    }

    @Override
    public void actionToKVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionToKVoucher_actionPerformed(e);
    }

    @Override
    protected String getEntryTableName() {
        return "T_BC_TravelAccountBillWKEntry";
    }

    @Override
    protected String getTableName() {
        return "T_BC_TravelAccountBillWK";
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void setUIState() {
        super.setUIState();
        this.kDContainer1.setEnabled(false);
        this.kdtEntries.setEnabled(false);
        this.kdtEntries.getStyleAttributes().setLocked(true);
    }

    @Override
    protected AbstractObjectCollection getEntryCollection(BizCollCoreBillBaseInfo editData) {
        return null;
    }
}

