/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.client.AbstractTravelAccountWKQueryUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TravelAccountWKQueryUI
extends AbstractTravelAccountWKQueryUI {
    protected static final String RES = "com.kingdee.eas.cp.bc.client.ExpenseReqResource";
    private static final Logger logger = CoreUIObject.getLogger(TravelAccountWKQueryUI.class);
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String LIKE = " like ";
    private static final String ORG_UNIT = "orgUnit";
    private static final String APPLIER = "applier";
    private static final String REQ_DATE_FROM = "reqDateFrom";
    private static final String REQ_DATE_TO = "reqDateTo";
    private static final String NUMBER_FROM = "numberFrom";
    private static final String NUMBER_TO = "numberTo";
    private static final String CURRENCY = "currency";
    private static final String STATE = "state";
    private static final String BILLTYPE = "billType";
    private static final String NAME = "name";
    private static final String EXPENSE = "expenseType";

    public TravelAccountWKQueryUI() throws Exception {
        AdminF7 adminBox = new AdminF7((IUIObject)this);
        adminBox.setMultiSelect(false);
        adminBox.setTitle(EASResource.getString((String)RES, (String)"requestOrgUnit"));
        adminBox.setRootUnitID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.bizPromptReqDept.setSelector((KDPromptSelector)adminBox);
        this.bizPromptApplier.setEnabledMultiSelection(false);
        this.initDate();
        this.bizPromptReqDept.requestFocus();
        this.expenseType.setHasCUDefaultFilter(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        this.expenseType.setEntityViewInfo(evi);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        String name;
        Object data;
        this.filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = this.filterInfo.getFilterItems();
        FilterItemInfo item = null;
        int index = 0;
        StringBuffer maskString = new StringBuffer();
        if (!BizCollUtil.objectIsNull(this.bizPromptReqDept.getData())) {
            item = new FilterItemInfo("orgUnit.id", (Object)((AdminOrgUnitInfo)this.bizPromptReqDept.getData()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if ((data = this.bizPromptApplier.getData()) != null) {
            item = new FilterItemInfo("applier.id", (Object)((PersonInfo)this.bizPromptApplier.getData()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.dateBizReqDateFrom.getTimestamp())) {
            item = new FilterItemInfo("bizReqDate", (Object)BizCollUtil.covertToSimpleDate(this.dateBizReqDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.dateBizReqDateTo.getTimestamp())) {
            item = new FilterItemInfo("bizReqDate", (Object)BizCollUtil.downTimestamp(this.dateBizReqDateTo.getTimestamp()), CompareType.LESS_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberFrom.getText())) {
            item = new FilterItemInfo("number", (Object)this.txtNumberFrom.getText().trim(), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.txtNumberTo.getText())) {
            item = new FilterItemInfo("number", (Object)this.txtNumberTo.getText().trim(), CompareType.LESS_EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!BizCollUtil.objectIsNull(this.bizPromptCurrency.getData())) {
            item = new FilterItemInfo("currencyType.id", (Object)((CurrencyInfo)this.bizPromptCurrency.getData()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (this.expenseType.getData() != null) {
            item = new FilterItemInfo("sortName.id", (Object)((ExpenseSortInfo)this.expenseType.getData()).getId().toString(), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!this.btnStateAll.isSelected()) {
            int stateValue = 0;
            if (this.btnStateAudited.isSelected()) {
                stateValue = 60;
            } else if (this.btnStateAuditFailed.isSelected()) {
                stateValue = 40;
            } else if (this.btnStateCancel.isSelected()) {
                stateValue = 50;
            } else if (this.btnStateSubmit.isSelected()) {
                stateValue = 25;
            } else if (this.btnStateInAudit.isSelected()) {
                stateValue = 30;
            } else if (this.btnStateDraft.isSelected()) {
                stateValue = 20;
            } else if (this.btnAlreadyToVoucher.isSelected()) {
                stateValue = 46;
            } else if (this.btnAlreadyImportFormat.isSelected()) {
                stateValue = 43;
            }
            item = new FilterItemInfo(STATE, (Object)("" + stateValue), CompareType.EQUALS);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        if (!StringUtils.isEmpty((String)(name = this.txtName.getText()))) {
            item = new FilterItemInfo(NAME, (Object)("%" + name + "%"), CompareType.LIKE);
            itemCollection.add(item);
            this.makeMaskString(maskString, index, AND);
            ++index;
        }
        this.filterInfo.setMaskString(maskString.toString());
        return this.filterInfo;
    }

    public Object getParam() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(ORG_UNIT, this.bizPromptReqDept.getData());
        ret.put(APPLIER, this.bizPromptApplier.getData());
        ret.put(REQ_DATE_FROM, this.dateBizReqDateFrom.getValue());
        ret.put(REQ_DATE_TO, this.dateBizReqDateTo.getValue());
        ret.put(NUMBER_FROM, this.txtNumberFrom.getText());
        ret.put(NUMBER_TO, this.txtNumberTo.getText());
        ret.put(CURRENCY, this.bizPromptCurrency.getData());
        ret.put(EXPENSE, this.expenseType.getData());
        ret.put(STATE, new Integer(this.btnGroup.getValue()));
        ret.put(NAME, this.txtName.getText());
        return ret;
    }

    public void setParam(Object param) {
        Map ret = (Map)param;
        this.bizPromptReqDept.setData(ret.get(ORG_UNIT));
        this.bizPromptApplier.setData(ret.get(APPLIER));
        this.dateBizReqDateFrom.setValue(ret.get(REQ_DATE_FROM));
        this.dateBizReqDateTo.setValue(ret.get(REQ_DATE_TO));
        if (ret.get(NUMBER_FROM) != null) {
            this.txtNumberFrom.setText((String)ret.get(NUMBER_FROM));
        }
        if (ret.get(NUMBER_TO) != null) {
            this.txtNumberTo.setText((String)ret.get(NUMBER_TO));
        }
        this.bizPromptCurrency.setData(ret.get(CURRENCY));
        this.expenseType.setValue(ret.get(EXPENSE));
        this.btnGroup.setValue(((Integer)ret.get(STATE)).intValue());
        this.txtName.setText((String)ret.get(NAME));
    }

    public void clear() {
        super.clear();
        this.bizPromptReqDept.setData(null);
        this.bizPromptCurrency.setData(null);
        this.bizPromptApplier.setData(null);
        this.dateBizReqDateFrom.setValue(null);
        this.dateBizReqDateTo.setValue(null);
        this.expenseType.setValue(null);
    }

    private void initDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.getTime();
        this.dateBizReqDateFrom.setValue((Object)cal.getTime());
        this.dateBizReqDateTo.setValue((Object)date);
        AdminF7 adminBox = new AdminF7((IUIObject)this);
        adminBox.setMultiSelect(false);
        adminBox.setRootUnitID(SysContext.getSysContext().getCurrentAdminUnit().getId().toString());
        this.bizPromptReqDept.setSelector((KDPromptSelector)adminBox);
    }

    private void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }
}

