/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.client.AbstractUpdateReqDateEditUI;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateReqDateEditUI
extends AbstractUpdateReqDateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(UpdateReqDateEditUI.class);
    private String billId = null;
    private Date oldReqDate = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUIParam();
        this.kdtfOldDate.setStringValue(this.oldReqDate.toString());
        this.kdtfOldDate.setEditable(false);
        this.kdcbIsBackBudget.setSelected(true);
        if (BizCollUtil.isNeedBudgetControl()) {
            this.kdcbIsBackBudget.setVisible(true);
            this.kDLabel1.setVisible(true);
        }
    }

    private void initUIParam() {
        Map ctx = this.getUIContext();
        this.billId = (String)ctx.get("billId");
        this.oldReqDate = (Date)ctx.get("reqDate");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionButtonOk_actionPerformed(ActionEvent e) throws Exception {
        Date newDate = (Date)this.kddpNewDate.getValue();
        if (newDate == null || newDate.before(this.oldReqDate)) {
            throw new ExpAccException(ExpAccException.DATEBIGTHENOLD);
        }
        if (newDate.after(this.oldReqDate)) {
            boolean isBackBudget = this.kdcbIsBackBudget.isSelected();
            CommonUtilFacadeFactory.getRemoteInstance().updateReqDate(this.billId, newDate, isBackBudget);
        }
        this.disposeUIWindow();
    }

    @Override
    public void actionButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kdButtonOk.setEnabled(true);
    }
}

