/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.common.VersionInfo;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class VersionUtil {
    private static Logger logger = Logger.getLogger(VersionUtil.class);

    public static void adaptUrl(final Component owner, Component comp, final String url) {
        comp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VersionUtil.gotoSite(url);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                owner.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                owner.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public static void adaptUrl(final Component owner, Component comp, final String url, final boolean isMultiParms) {
        comp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VersionUtil.gotoSite(url, isMultiParms);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                owner.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                owner.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public static boolean isMacOSPlatform() {
        String osname = System.getProperty("os.name");
        return !StringUtils.isEmpty((String)osname) && osname.startsWith("Mac OS");
    }

    public static void gotoSite(String url) {
        if (VersionUtil.isMacOSPlatform()) {
            try {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                Runtime.getRuntime().exec("start iexplore \"" + url + "\"");
            }
            catch (Exception er) {
                try {
                    Runtime.getRuntime().exec("cmd /c start iexplore \"" + url + "\"");
                }
                catch (Exception err) {
                    try {
                        Runtime.getRuntime().exec("command.com /c start iexplore \"" + url + "\"");
                    }
                    catch (Exception errr) {
                        logger.error((Object)errr.getMessage(), (Throwable)errr);
                    }
                }
            }
        }
    }

    public static void gotoSite(String url, boolean isMultiParms) {
        com.kingdee.eas.base.uiframe.client.VersionUtil.gotoSite((String)url, (boolean)isMultiParms);
    }

    public static boolean isShowYS() {
        return !"false".equals(System.getProperty("showYS"));
    }

    public static void matchDcVersion(String clientMetaFile, String dcVersion) throws EASLoginException {
        String[] dcs;
        String clientMetaVersion;
        logger.info((Object)("Client metafile : " + clientMetaFile));
        logger.info((Object)("Datacenter version : " + dcVersion));
        if ("Unknown".equals(dcVersion)) {
            throw new EASLoginException(EASLoginException.UNKNOWN_VERSION);
        }
        try {
            clientMetaVersion = ClientVersionUtil.getMetadataVersion((String)clientMetaFile);
        }
        catch (Exception e) {
            throw new EASLoginException(EASLoginException.UNKNOWN_VERSION2, (Throwable)e);
        }
        logger.info((Object)("Client meta version : " + clientMetaVersion));
        if (ClientVersionUtil.matchVersion((String)clientMetaVersion, (String)dcVersion)) {
            return;
        }
        String[] clients = StringUtil.split((String)clientMetaVersion, (String)".");
        if (clients.length == (dcs = StringUtil.split((String)dcVersion, (String)".")).length && clients.length >= 2) {
            if (clients[0].equals(dcs[0]) && clients[1].equals(dcs[1])) {
                logger.warn((Object)("ClientLibVersion[" + clientMetaVersion + "] does not match DataCenterVersion[" + dcVersion + "]!"));
                return;
            }
            logger.error((Object)("ClientLibVersion[" + clientMetaVersion + "] does not match DataCenterVersion[" + dcVersion + "]!"));
            throw new EASLoginException(EASLoginException.VERSION_MATCH_ERROR);
        }
        logger.error((Object)("ClientLibVersion[" + clientMetaVersion + "] does not match DataCenterVersion[" + dcVersion + "]!"));
        throw new EASLoginException(EASLoginException.VERSION_MATCH_ERROR);
    }

    public static void matchVersions(String clientMetaFile, String serverURL) throws EASLoginException {
        String clientLibVersion;
        String clientMetaVersion;
        try {
            clientMetaVersion = ClientVersionUtil.getMetadataVersion((String)clientMetaFile);
            clientLibVersion = ClientVersionUtil.getCommonLibVersion();
        }
        catch (Exception e) {
            throw new EASLoginException(EASLoginException.UNKNOWN_VERSION2, (Throwable)e);
        }
        VersionInfo serverVer = ClientVersionUtil.getServerVersion((String)serverURL);
        String serverMetaVersion = serverVer.getMetadataVersion();
        String serverLibVersion = serverVer.getCommonLibVersion();
        if (!ClientVersionUtil.matchVersion((String)clientMetaVersion, (String)serverMetaVersion)) {
            logger.error((Object)("ClientMetaVersion[" + clientMetaVersion + "] does not match ServerMetaVersion[" + serverMetaVersion + "]!"));
            throw new EASLoginException(EASLoginException.VERSION_MATCH_ERROR3);
        }
        if (!ClientVersionUtil.matchVersion((String)clientLibVersion, (String)serverLibVersion)) {
            logger.error((Object)("ClientLibVersion[" + clientLibVersion + "] does not match ServerLibVersion[" + serverLibVersion + "]!"));
            throw new EASLoginException(EASLoginException.VERSION_MATCH_ERROR2);
        }
    }
}

