/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryCollection;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryFactory;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryInfo;
import com.kingdee.eas.cp.bc.VoucherTemplateFactory;
import com.kingdee.eas.cp.bc.VoucherTemplateInfo;
import com.kingdee.eas.cp.bc.client.AbstractVoucherTemplateEditUI;
import com.kingdee.eas.cp.bc.client.LinkDBF7Box;
import com.kingdee.eas.cp.bc.client.SelectorForLinkDBF7;
import com.kingdee.eas.cp.bc.util.CheckK3User;
import com.kingdee.eas.cp.bc.util.MapForF7;
import com.kingdee.eas.cp.bc.util.ReadBudgetType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class VoucherTemplateEditUI
extends AbstractVoucherTemplateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(VoucherTemplateEditUI.class);
    protected KDLabelContainer contMyF7;
    private static final String RES = "com.kingdee.eas.cp.bc.client.VoucherTemplateResource";
    private Connection conn = null;
    private LinkDBF7Box pmtNf7Debt;
    private SelectorForLinkDBF7 mySeleDebt;
    private LinkDBF7Box pmtNf7Credit;
    private SelectorForLinkDBF7 mySeleCredit;
    private IObjectPK mainPk = null;
    private static final String CURRENCYSQL = "select FName,FNumber,FExchangeRate from t_Currency";
    private static final String GROUPSQL = "SELECT FName, FGroupID FROM t_VoucherGroup";
    private static final String CREDITSQL = EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"74_VoucherTemplateEditUI");
    private static final String DEBITSQL = EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"75_VoucherTemplateEditUI");
    private static final String NUMBER = EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"76_VoucherTemplateEditUI");
    private Map currencyMap = null;
    private Map groupMap = null;
    private int times = 0;
    private boolean isFirst = true;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    public VoucherTemplateEditUI() throws Exception {
        this.txtCurrencyName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VoucherTemplateEditUI.this.txtCurrencyNumber(e);
            }
        });
        this.txtGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VoucherTemplateEditUI.this.txtGroup(e);
            }
        });
    }

    public void onLoad() throws Exception {
        this.setColor();
        if (this.isFirst) {
            Map tempMap = this.getUIContext();
            this.conn = this.getConn((String)tempMap.get("dbIp"), (String)tempMap.get("dbPort"), (String)tempMap.get("dbName"), (String)tempMap.get("userName"), (String)tempMap.get("password"));
            try {
                this.currencyMap = this.getResult(this.conn, CURRENCYSQL, "currency");
                this.groupMap = this.getResult(this.conn, GROUPSQL, "group");
                this.initCurrencyItem(this.currencyMap);
                this.initGroupItem(this.groupMap);
            }
            catch (Exception e) {
                throw new VoucherTempException(VoucherTempException.DB_ACCESS_ERROR);
            }
            this.isFirst = false;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("conn", this.conn);
            map.put("dbIp", (String)this.getUIContext().get("dbIp"));
            map.put("dbPort", (String)this.getUIContext().get("dbPort"));
            map.put("dbName", (String)this.getUIContext().get("dbName"));
            map.put("user", (String)this.getUIContext().get("userName"));
            map.put("password", (String)this.getUIContext().get("password"));
            String sql = DEBITSQL;
            map.put("sql", sql);
            map.put("returnValue", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"77_VoucherTemplateEditUI"));
            this.pmtNf7Debt = new LinkDBF7Box((Component)((Object)this));
            this.mySeleDebt = new SelectorForLinkDBF7((IUIObject)this, map);
            this.pmtNf7Debt.setSelector(this.mySeleDebt);
            this.pmtNf7Debt.setVisible(true);
            this.contDebitAccountName.setBoundEditor((JComponent)((Object)this.pmtNf7Debt));
            HashMap<String, Object> mapCredit = new HashMap<String, Object>();
            mapCredit.putAll(map);
            sql = CREDITSQL;
            mapCredit.put("sql", sql);
            this.pmtNf7Credit = new LinkDBF7Box((Component)((Object)this));
            this.mySeleCredit = new SelectorForLinkDBF7((IUIObject)this, mapCredit);
            this.pmtNf7Credit.setSelector(this.mySeleCredit);
            this.pmtNf7Credit.setVisible(true);
            this.contCreditAccountName.setBoundEditor((JComponent)((Object)this.pmtNf7Credit));
            this.pmtNf7Credit.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    this.pmtNf7Change(eventObj);
                }

                private void pmtNf7Change(DataChangeEvent eventObj) {
                    Map mapOnlyNow;
                    if (VoucherTemplateEditUI.this.getOprtState().equals(OprtState.VIEW)) {
                        return;
                    }
                    if (eventObj.getNewValue() == null) {
                        return;
                    }
                    if (eventObj.getOldValue() != null && eventObj.getOldValue().equals(eventObj.getNewValue())) {
                        return;
                    }
                    Object creditObj = eventObj.getNewValue();
                    if (creditObj instanceof Map && (mapOnlyNow = (Map)eventObj.getNewValue()).get(NUMBER) != null) {
                        VoucherTemplateEditUI.this.txtCreditAccountNumber.setText((String)mapOnlyNow.get(NUMBER));
                    }
                }
            });
            this.pmtNf7Debt.addDataChangeListener(new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    this.pmtNf7Change(eventObj);
                }

                private void pmtNf7Change(DataChangeEvent eventObj) {
                    Map mapOnlyNow;
                    if (VoucherTemplateEditUI.this.getOprtState().equals(OprtState.VIEW)) {
                        return;
                    }
                    if (eventObj.getNewValue() == null) {
                        return;
                    }
                    if (eventObj.getOldValue() != null && eventObj.getOldValue().equals(eventObj.getNewValue())) {
                        return;
                    }
                    Object debitObj = eventObj.getNewValue();
                    if (debitObj instanceof Map && (mapOnlyNow = (Map)eventObj.getNewValue()).get(NUMBER) != null) {
                        VoucherTemplateEditUI.this.txtDebitAccountNumber.setText((String)mapOnlyNow.get(NUMBER));
                    }
                }
            });
        }
        super.onLoad();
        this.btnCopy.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            MapForF7 myMap;
            if (this.getUIContext().get("debitAccountName") != null) {
                myMap = new MapForF7(this.getUIContext().get("debitAccountName"));
                this.pmtNf7Debt.setValue(myMap);
            }
            if (this.getUIContext().get("creditAccountName") != null) {
                myMap = new MapForF7(this.getUIContext().get("creditAccountName"));
                this.pmtNf7Credit.setValue(myMap);
            }
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.prmtExpenseType.setEnabled(false);
        }
        this.prmtExpenseType.setHasCUDefaultFilter(false);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        this.prmtExpenseType.setEntityViewInfo(evi);
    }

    @Override
    public void loadFields() {
        ++this.times;
        super.loadFields();
        if (this.times > 1) {
            this.pmtNf7Debt.setValue(null);
            this.pmtNf7Credit.setValue(null);
        }
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) {
            String curName = this.editData.getCurrencyName();
            this.txtCurrencyName.setSelectedItem((Object)curName);
            String group = this.editData.getGroup();
            this.txtGroup.setSelectedItem((Object)group);
        } else {
            this.txtCurrencyNumber(null);
            this.txtGroup(null);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currencyName"));
        sic.add(new SelectorItemInfo("group"));
        sic.add(new SelectorItemInfo("debitAccountName"));
        sic.add(new SelectorItemInfo("creditAccountName"));
        return sic;
    }

    public String getSelectedKeyForAll() {
        return super.getSelectedKeyForAll();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        VoucherTemplateEntryInfo entryInfo = new VoucherTemplateEntryInfo();
        VoucherTemplateInfo info = null;
        try {
            info = VoucherTemplateFactory.getRemoteInstance().getVoucherTemplateInfo((IObjectPK)this.getUIContext().get("mainId"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        entryInfo.setVoucher(info);
        return entryInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return VoucherTemplateEntryFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.checkValues();
        if (this.isK3Checked()) {
            Map tempMap = this.getUIContext();
            String tempAccNumber = (String)tempMap.get("accNumber");
            String tempUserName = this.txtK3user.getText();
            String tempPassword = this.txtK3userPwd.getText().trim();
            this.checkUser(tempAccNumber, tempUserName, tempPassword);
        }
        HashMap myMap = (HashMap)this.pmtNf7Credit.getValue();
        this.editData.setCreditAccountName(myMap.toString());
        this.editData.setDebitAccountName(this.pmtNf7Debt.getValue().toString());
        this.editData.setCurrencyName(this.txtCurrencyName.getSelectedItem().toString());
        this.editData.setGroup(this.txtGroup.getSelectedItem().toString());
        this.txtMark.setText(this.getBudgetMark(this.txtCreditAccountNumber.getText()) + this.getBudgetMark(this.txtDebitAccountNumber.getText()));
        super.beforeStoreFields(e);
    }

    protected String getBudgetMark(String budgetNumber) throws SQLException {
        char[] tempMark = new char[]{'0', '0', '0'};
        if (budgetNumber == null || budgetNumber.length() <= 0) {
            return new String(tempMark);
        }
        String sql = this.getK3ApprovedItemSql();
        if (this.conn == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"CONNECT_K3_DB_ERROR"));
            this.abort();
        }
        ResultSet rs = null;
        Object stmt = null;
        PreparedStatement pStmt = null;
        pStmt = this.conn.prepareStatement(sql);
        pStmt.setString(1, budgetNumber);
        rs = pStmt.executeQuery();
        int fitemclassid = -111;
        while (rs.next()) {
            fitemclassid = rs.getInt("fitemclassid");
            if (fitemclassid == ReadBudgetType.DEPARTIDVALUE) {
                tempMark[0] = 49;
                continue;
            }
            if (fitemclassid == ReadBudgetType.PERSONIDVALUE) {
                tempMark[1] = 49;
                continue;
            }
            if (fitemclassid != ReadBudgetType.VEHICLEIDVALUE) continue;
            tempMark[2] = 49;
        }
        return new String(tempMark);
    }

    protected String getK3ApprovedItemSql() {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("   select \tv1.faccountid  AS faccountid, v1.fnumber AS fnumber,");
        tempSql.append("\t\t\tv1.fname AS fname, u1.fitemclassid AS fitemclassid, ");
        tempSql.append("\t\t\tu2.fname AS fname \t");
        tempSql.append(" \tfrom \tt_account v1        ");
        tempSql.append("    inner join t_ItemDetailv    ");
        tempSql.append("\t\t\tu1 on (v1.fdetailid > 0  ");
        tempSql.append(" \t\t\tand v1.fdetailid = u1.fdetailid) ");
        tempSql.append(" \tinner join t_itemclass  ");
        tempSql.append("\t\t\tu2 on (u1.fitemclassid = u2.fitemclassid) ");
        tempSql.append(" \twhere  v1.FNumber = ? ");
        return tempSql.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void txtCurrencyNumber(ItemEvent eventObj) {
        Object tempObj = this.txtCurrencyName.getSelectedItem();
        String currencyName = null;
        if (tempObj == null) {
            if (eventObj.getItem() == null) return;
            currencyName = eventObj.getItem().toString();
        } else {
            currencyName = this.txtCurrencyName.getSelectedItem().toString();
        }
        String[] tempArray = (String[])this.currencyMap.get(currencyName);
        this.txtCurrencyNumber.setText(tempArray[0]);
        this.txtRate.setText(tempArray[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void txtGroup(ItemEvent eventObj) {
        Object tempObj = this.txtGroup.getSelectedItem();
        String group = null;
        if (tempObj == null) {
            if (eventObj.getItem() == null) return;
            group = eventObj.getItem().toString();
            this.txtGroup.setSelectedItem((Object)group);
        } else {
            group = tempObj.toString();
        }
        String groupId = this.groupMap.get(group).toString();
        this.txtGroupID.setText(groupId);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setF7Text();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.txtCreditAccountName.setData(null);
        this.txtDebitAccountName.setData(null);
    }

    private Connection getConn(String dbIp, String dbPort, String dbName, String userName, String password) {
        Connection conn = null;
        String url = "jdbc:microsoft:sqlserver://" + dbIp + ":" + dbPort + ";DatabaseName=" + dbName;
        try {
            Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver").newInstance();
            conn = DriverManager.getConnection(url, userName, password);
        }
        catch (Exception e) {
            conn = null;
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"CONNECT_K3_DB_ERROR"));
            this.abort();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getResult(Connection conn, String sql, String mark) {
        if (conn == null || sql == null || sql.trim().equals("")) {
            return null;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Object tempArray = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (mark.equals("currency")) {
                    valueMap.put(rs.getString(1), new String[]{rs.getString(2), rs.getString(3)});
                    continue;
                }
                valueMap.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"READ_K3_DB_ERROR"));
            logger.info((Object)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ee) {
                rs = null;
                stmt = null;
            }
        }
        return valueMap;
    }

    private void dbClose(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception e) {
                conn = null;
            }
        }
    }

    private void initCurrencyItem(Map valueMap) {
        if (valueMap == null || valueMap.size() <= 0) {
            return;
        }
        HashMap tempMap = (HashMap)valueMap;
        Object[] tempArr = tempMap.keySet().toArray();
        this.txtCurrencyName.addItems(tempArr);
        this.txtCurrencyName.setSelectedItem((Object)EASResource.getString((String)RES, (String)"RENMINBI"));
    }

    private void initGroupItem(Map valueMap) {
        if (valueMap == null || valueMap.size() <= 0) {
            return;
        }
        HashMap tempMap = (HashMap)valueMap;
        Object[] tempArr = tempMap.keySet().toArray();
        this.txtGroup.addItems(tempArr);
    }

    private VoucherTemplateInfo getVoucherTemplateInfo() {
        VoucherTemplateInfo info = null;
        try {
            info = VoucherTemplateFactory.getRemoteInstance().getVoucherTemplateInfo((IObjectPK)this.getUIContext().get("mainId"));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return info;
    }

    private void checkValues() throws EASBizException, BOSException {
        if (this.txtK3user.getText() == null || this.txtK3user.getText().trim().length() < 1) {
            this.txtK3user.requestFocus();
            throw new VoucherTempException(VoucherTempException.LOADUSER_NOT_NULL);
        }
        if (this.txtGroupID.getText() == null || this.txtGroupID.getText().trim().length() < 1) {
            this.txtGroup.requestFocus();
            throw new VoucherTempException(VoucherTempException.GROUPID_NOT_NULL);
        }
        if (this.txtGroup.getSelectedItem() == null) {
            this.txtGroup.requestFocus();
            throw new VoucherTempException(VoucherTempException.GROUP_NOT_NULL);
        }
        if (this.txtDebitAccountNumber.getText() == null || this.txtDebitAccountNumber.getText().trim().length() < 1) {
            this.txtDebitAccountName.requestFocus();
            throw new VoucherTempException(VoucherTempException.DEBTNUM_NOT_NULL);
        }
        if (this.pmtNf7Debt.getData() == null) {
            this.txtDebitAccountName.requestFocus();
            throw new VoucherTempException(VoucherTempException.DEBTNAME_NOT_NULL);
        }
        if (this.txtCreditAccountNumber.getText() == null || this.txtCreditAccountNumber.getText().trim().length() < 1) {
            this.txtCreditAccountName.requestFocus();
            throw new VoucherTempException(VoucherTempException.CREDITNUM_NOT_NULL);
        }
        if (this.pmtNf7Credit.getData() == null) {
            this.txtCreditAccountName.requestFocus();
            throw new VoucherTempException(VoucherTempException.CREDITNAME_NOT_NULL);
        }
        if (this.txtCreditAccountName.getText() == null) {
            this.txtCreditAccountName.requestFocus();
            throw new VoucherTempException(VoucherTempException.CREDITNAME_NOT_NULL);
        }
        if (this.txtCurrencyNumber.getText() == null || this.txtCurrencyNumber.getText().trim().length() < 1) {
            this.txtCurrencyNumber.requestFocus();
            throw new VoucherTempException(VoucherTempException.CURRENCYNUM_NOT_NULL);
        }
        if (this.txtCurrencyName.getSelectedItem() == null) {
            this.txtCurrencyNumber.requestFocus();
            throw new VoucherTempException(VoucherTempException.CURRENCYNAME_NOT_NULL);
        }
        if (this.txtRate.getText() == null) {
            this.txtRate.requestFocus();
            throw new VoucherTempException(VoucherTempException.RATE_NOT_NULL);
        }
        if (this.prmtExpenseType.getValue() == null) {
            this.prmtExpenseType.requestFocus();
            throw new VoucherTempException(VoucherTempException.SORT_NAME_NOT_NULL);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.checkExpenseTypeSame();
        }
    }

    private void checkExpenseTypeSame() throws BOSException, EASBizException {
        String expenseSort = "";
        expenseSort = this.prmtExpenseType.getText();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        Iterator iterator = null;
        VoucherTemplateEntryInfo tempInfo = null;
        VoucherTemplateEntryCollection tempCollection = VoucherTemplateEntryFactory.getRemoteInstance().getVoucherTemplateEntryCollection("SELECT  expenseType.* " + ev.toString());
        iterator = tempCollection.iterator();
        while (iterator.hasNext()) {
            tempInfo = (VoucherTemplateEntryInfo)iterator.next();
            if (!expenseSort.equals(tempInfo.getExpenseType().getSortName())) continue;
            this.prmtExpenseType.requestFocus();
            throw new VoucherTempException(VoucherTempException.SORT_NAME_REPEAT);
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean destroyWindow() {
        boolean isReturn = super.destroyWindow();
        if (isReturn) {
            this.dbClose(this.conn);
        }
        return isReturn;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    private void setColor() {
        this.txtK3user.setRequired(true);
        this.prmtExpenseType.setRequired(true);
        this.txtCurrencyName.setRequired(true);
        this.txtGroup.setRequired(true);
        this.txtCreditAccountName.setRequired(true);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtCreditAccountNumber.setText(null);
        this.txtDebitAccountNumber.setText(null);
    }

    public void checkUser(String accNumber, String userName, String password) {
        if (!CheckK3User.MARK) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"LOAD_C++_DLL_ERROR"));
            SysUtil.abort();
        }
        if (accNumber == null || accNumber.length() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"K3_ACCNUMBER_NULL"));
            SysUtil.abort();
        }
        if (userName == null || userName.length() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"K3_USERNAME_NULL"));
            SysUtil.abort();
        }
        int mark = -1;
        switch (mark) {
            case 0: {
                return;
            }
            case 1: {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"COMPANY_NAME_ERROR"));
                SysUtil.abort();
            }
            case 2: {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"K3_ACCNUMBER_ERROR"));
                SysUtil.abort();
            }
            case 3: {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"K3_USERNAME_PASSWORD_ERROR"));
                SysUtil.abort();
            }
            case 4: {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"LOAD_K3_COMPONENT_ERROR"));
                SysUtil.abort();
            }
            case 5: {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"78_VoucherTemplateEditUI"));
                SysUtil.abort();
            }
            case 999: {
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"UNKNOWED_EXCEPTION"));
                SysUtil.abort();
            }
        }
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"UNKNOWED_EXCEPTION"));
        SysUtil.abort();
    }

    private boolean isK3Checked() {
        int startMark = ReadBudgetType.ISSTART;
        return startMark == 1;
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setF7Text();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setF7Text();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setF7Text();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setF7Text();
    }

    private void setF7Text() {
        VoucherTemplateEntryInfo objValue = this.editData;
        this.pmtNf7Debt.setText(objValue.getDebitAccountName());
        this.pmtNf7Credit.setText(objValue.getCreditAccountName());
    }
}

