/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.ng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfigUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.ng.ConfigUtil");

    public static void loadConfig() {
        Properties nextConfig = ConfigUtil.loadProperties();
        for (Map.Entry<Object, Object> next : nextConfig.entrySet()) {
            ConfigUtil.setProperty(next.getKey().toString(), next.getValue().toString());
        }
    }

    private static void setProperty(String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            System.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() {
        String fileName = ConfigUtil.getFileName();
        Properties p = new Properties();
        File f = new File(fileName);
        if (!f.exists()) {
            logger.error((Object)(fileName + " is not exist!"));
            return p;
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            properties.load(fis);
        }
        catch (Exception e) {
            logger.error((Object)("load nextConfig.properties from " + fileName + " failed!"), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object key = em.nextElement();
            Object value = properties.get(key);
            p.put(key, value);
        }
        return p;
    }

    public static String get(String key) {
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            ConfigUtil.loadConfig();
            value = System.getProperty(key);
        }
        return value;
    }

    private static String getFileName() {
        String tmp = System.getProperty("java.security.auth.login.config");
        int i = tmp.lastIndexOf("/");
        return tmp.substring(0, i) + "/nextConfig.properties";
    }

    public static Boolean enableISC() {
        File f = new File(ConfigUtil.getFileName());
        return f.exists();
    }
}

