/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.base.form.model.list.OpenListParameter;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.IBizAccountOutBill;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.plugins.BizAccountOutBillPlugin;
import com.kingdee.eas.cp.bc.util.BcCommonUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BizAccountOutListPlugin
extends ListPlugin {
    private String state;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.plugins.BizAccountOutListPlugin");

    public void onBeforeQuery(BeforeQueryArg arg) {
        super.onBeforeQuery(arg);
        Object param = this.application.getCustomParameter("state");
        this.state = param == null ? "" : param.toString();
        CompanyOrgUnitInfo company = null;
        try {
            company = (CompanyOrgUnitInfo)this.application.getListModel().getDefaultValueCalculator().evaluateFunction("getOrgUnit(@CONTEXT, LoginOrg, @MAINORGTYPE, NULL)");
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        String sql = " t1.FApplierCompanyID like '" + company.getId() + "%'";
        if ("draft".equals(this.state)) {
            sql = sql + " and t1.Fstate=20";
        } else if ("checking".equals(this.state)) {
            sql = sql + " and t1.Fstate=30 or t1.Fstate=25";
        } else if ("close".equals(this.state)) {
            sql = sql + " and t1.Fstate in(60,27,65,140,70,135,80)";
        }
        arg.setFilterBy(sql);
        arg.setOrderBy(" t1.FBizReqDate desc ");
    }

    public boolean onInitialize(OpenListParameter param) throws BOSException, EASBizException {
        this.checkPermission("cp_bc_BizAccountOutBill_View");
        this.verifyCurrentInfo(this.application.getContext());
        String flowTempId = BizAccountOutBillPlugin.getTemplateId(this.application.getContext());
        if (flowTempId == null || "".equals(flowTempId)) {
            this.application.showConfirm("templateNotExist", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"82_BizAccountOutBillPlugin"), EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"83_BizAccountOutBillPlugin"), 0);
            return false;
        }
        this.application.setCustomParameter("flowTempId", (Object)flowTempId);
        return super.onInitialize(param);
    }

    public void onLoad() {
        super.onLoad();
        try {
            Object param = this.application.getCustomParameter("state");
            String string = this.state = param == null ? "" : param.toString();
            if ("checking".equals(this.state)) {
                this.application.getListView().setBarItemVisible("tbButtonDelete", false);
            } else if ("close".equals(this.state)) {
                this.application.getListView().setBarItemVisible("tbButtonModify", false);
                this.application.getListView().setBarItemVisible("tbButtonDelete", false);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void changeBtnState(boolean isVisible) throws BOSException {
        this.application.getListView().setBarItemVisible("tbButtonModify", isVisible);
        this.application.getListView().setBarItemVisible("tbButtonDelete", isVisible);
    }

    public void beforeBarItemClick(BeforeCommandArg beforeCommandArg) throws BOSException, EASBizException {
        if ("tbButtonDelete".equals(beforeCommandArg.getKey())) {
            this.checkPermission("cp_bc_BizAccountOutBill_Delete");
            beforeCommandArg.setCancel(true);
            String[] pks = this.application.getListView().getSelectedBillIds();
            if (pks == null || pks.length == 0) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"89_BizAccountOutListPlugin"));
                return;
            }
            if (pks.length > 1) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"90_BizAccountOutListPlugin"));
                return;
            }
            String errorMessage = this.checkStatusAndPerson(pks[0]);
            if (errorMessage != null && !"".equals(errorMessage)) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"91_BizAccountOutListPlugin"));
                sb.append(errorMessage);
                this.application.showMessage(sb.toString());
                return;
            }
            this.application.showConfirm("mnuDelete", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"92_BizAccountOutListPlugin"), EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"93_BizAccountOutListPlugin"), 8189);
        } else if ("tbButtonModify".equals(beforeCommandArg.getKey())) {
            beforeCommandArg.setCancel(true);
            String[] pks = this.application.getListView().getSelectedBillIds();
            if (pks == null || pks.length == 0) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"89_BizAccountOutListPlugin"));
                return;
            }
            if (pks.length > 1) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"90_BizAccountOutListPlugin"));
                return;
            }
            String errorMessage = this.checkStatusAndPerson(pks[0]);
            if (errorMessage != null && !"".equals(errorMessage)) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"94_BizAccountOutListPlugin"));
                sb.append(errorMessage);
                this.application.showMessage(sb.toString());
                return;
            }
            beforeCommandArg.setCancel(false);
        } else if ("tbButtonView".equals(beforeCommandArg.getKey())) {
            beforeCommandArg.setCancel(true);
            String[] pks = this.application.getListView().getSelectedBillIds();
            if (pks == null || pks.length == 0) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"89_BizAccountOutListPlugin"));
                return;
            }
            if (pks.length > 1) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"90_BizAccountOutListPlugin"));
                return;
            }
            beforeCommandArg.setCancel(false);
        } else if ("tbButtonViewBudget".equals(beforeCommandArg.getKey())) {
            this.checkPermission("cp_bc_BizAccountOutBill_Budget");
            beforeCommandArg.setCancel(true);
            String[] pks = this.application.getListView().getSelectedBillIds();
            if (pks == null || pks.length == 0) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"89_BizAccountOutListPlugin"));
                return;
            }
            if (pks.length > 1) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"90_BizAccountOutListPlugin"));
                return;
            }
            String sessionId = (String)this.application.getCustomParameter("JSESSIONID");
            StringBuffer params = BcCommonUtil.appendParam("billId", pks[0], true);
            BcCommonUtil.appendParam(params, "viewSource", "DynformWeb", true);
            BcCommonUtil.appendParam(params, "JSESSIONID", sessionId, true);
            String url = "/easweb/cp/bc/bgBalanceView.jsf" + params.toString();
            this.application.popupWindow(url, OpenModeEnum.OpenNewWindow.getValue(), "viewBudget", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"84_BizAccountOutBillPlugin"), 890, 720);
        } else if ("tbButtonAudit".equals(beforeCommandArg.getKey()) || "tbButtonFlow".equals(beforeCommandArg.getKey())) {
            beforeCommandArg.setCancel(true);
            String[] pks = this.application.getListView().getSelectedBillIds();
            if (pks == null || pks.length == 0) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"89_BizAccountOutListPlugin"));
                return;
            }
            if (pks.length > 1) {
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"90_BizAccountOutListPlugin"));
                return;
            }
            beforeCommandArg.setCancel(false);
        }
    }

    private String checkStatusAndPerson(String pk) throws BOSException, EASBizException {
        Locale locale = this.application.getContext().getOriginLocale();
        BizAccountOutBillInfo outBillInfo = BizAccountOutBillFactory.getRemoteInstance().getBizAccountOutBillInfo((IObjectPK)new ObjectUuidPK(pk));
        if (20 != outBillInfo.getState().getValue() && 10 != outBillInfo.getState().getValue() && 25 != outBillInfo.getState().getValue()) {
            StringBuffer sb = new StringBuffer(outBillInfo.getState().getAlias(locale));
            sb.append(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"95_BizAccountOutListPlugin"));
            return sb.toString();
        }
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(this.application.getLoginUserId()));
        BOSUuid creatorId = outBillInfo.getCreator().getId();
        String personId = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(creatorId.toString())).getPerson().getId().toString();
        if (!personId.equals(userInfo.getPerson().getId().toString())) {
            String personName = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId)).getName();
            return personName + EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"96_BizAccountOutListPlugin");
        }
        return null;
    }

    public void fireAfterConfirm(String id, int returnOption) throws BOSException, EASBizException {
        Locale locale = this.application.getContext().getOriginLocale();
        if ("mnuDelete".equals(id)) {
            if (returnOption == 0) {
                String[] pks = this.application.getListView().getSelectedBillIds();
                IBizAccountOutBill iBizAccountOutBill = BizAccountOutBillFactory.getRemoteInstance();
                StringBuffer message = new StringBuffer();
                String number = "";
                IRowSet rowSet = null;
                try {
                    rowSet = this.application.getListModel().getData(0, this.application.getListModel().getRowCount());
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage());
                }
                for (int i = 0; i < pks.length; ++i) {
                    try {
                        rowSet.beforeFirst();
                        rowSet.next();
                        while (!pks[i].equals(rowSet.getString("FID"))) {
                            rowSet.next();
                        }
                        number = rowSet.getString("FBillNumber");
                        int state = rowSet.getInt("FLISTSTATE");
                        if (state == 10 || state == 20) {
                            iBizAccountOutBill.delete((IObjectPK)new ObjectUuidPK(pks[i]));
                            message.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"98_BizAccountOutListPlugin"), String.valueOf(number)));
                            continue;
                        }
                        message.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"99_BizAccountOutListPlugin"), String.valueOf(number), StateEnum.getEnum(state).getAlias(locale)));
                        continue;
                    }
                    catch (Exception e) {
                        message.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"101_BizAccountOutListPlugin"), String.valueOf(number)));
                        logger.error((Object)e.getMessage());
                    }
                }
                this.application.showMessage(message.toString());
                this.application.getListView().refresh();
            }
            return;
        }
    }

    public void doCustomOperation(String operation) {
        if ("munPrint".equalsIgnoreCase(operation)) {
            try {
                String[] pks = this.application.getListView().getSelectedBillIds();
                if (pks == null || pks.length == 0) {
                    this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"89_BizAccountOutListPlugin"));
                    return;
                }
                if (pks.length > 1) {
                    this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"90_BizAccountOutListPlugin"));
                    return;
                }
                String templateId = this.application.getCustomParameter("flowTempId").toString();
                TemplateInfo templateInfo = TemplateFactory.getRemoteInstance().getTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
                String formId = templateInfo.getFormID();
                String layoutId = templateInfo.getLayoutID();
                String[] srcBillPks = new String[]{pks[0]};
                this.application.getListView().print(formId, layoutId, srcBillPks);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public void afterOperation(FormOperation formOperation) {
        try {
            this.application.getListView().refresh();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void verifyCurrentInfo(Context ctx) throws BizCollException {
        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        if (currentCompany == null || currentCompany.isIsOnlyUnion()) {
            throw new BizCollException(BizCollException.COMPANY_IS_UNION);
        }
    }

    private void checkPermission(String permissionItem) throws BOSException, EASBizException {
        Context ctx = this.application.getContext();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        BusinessSeviceUtil.checkFunctionPermission((Context)ctx, (String)cuId, (String)permissionItem);
    }
}

