/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.upgrade.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IUpgradeBillFacade;
import com.kingdee.eas.cp.bc.UpgradeBillFacadeFactory;
import com.kingdee.eas.cp.bc.upgrade.datatask.IUpgradeAdapter;
import com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeTaskSchedule;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeBillCreateVoucherRecordAdapter
implements IUpgradeAdapter {
    private static final String[] billTables = new String[]{"T_BC_DAILYLOANBILL", "T_BC_BIZACCOUNTBILL", "T_BC_EVECTIONLOANBILL", "T_BC_TRAVELACCOUNTBILL", "T_BC_DAILYPURCHASEACCOUNTBILL", "T_BC_BIZACCOUNTOUTBILL"};
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeBillPayEntryAdapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upgrade(Context ctx, String taskId, Map upgradeParam) throws BOSException, EASBizException {
        String billType = (String)upgradeParam.get("billType");
        Object iBizCollBillBase = null;
        String tableName = "T_BC_BIZACCOUNTBILL";
        if ("DailyLoanBill".equals(billType)) {
            tableName = "T_BC_DAILYLOANBILL";
        } else if ("BizAccountBill".equals(billType)) {
            tableName = "T_BC_BIZACCOUNTBILL";
        } else if ("EvectionLoanBill".equals(billType)) {
            tableName = "T_BC_EVECTIONLOANBILL";
        } else if ("TravelAccountBill".equals(billType)) {
            tableName = "T_BC_TRAVELACCOUNTBILL";
        } else if ("BizAccountOutbill".equals(billType)) {
            tableName = "T_BC_BIZACCOUNTOUTBILL";
        } else if ("PurchaseAccountBill".equals(billType)) {
            tableName = "T_BC_DAILYPURCHASEACCOUNTBILL";
        } else {
            UpgradeTaskSchedule.stopTask(taskId);
            return false;
        }
        StringBuffer querySb = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        java.util.Date now = calendar.getTime();
        Date nowDate = new Date(now.getTime());
        calendar.add(1, -1);
        java.util.Date lastYear = calendar.getTime();
        Date lastYearDate = new Date(lastYear.getTime());
        querySb.append("SELECT FID ").append("FROM %s ").append("WHERE FSTATE IN (115, 110, 65, 70, 45, 80) AND (FBIZREQDATE >= {%s} ").append("AND FBIZREQDATE <= {%s}) ORDER BY FAPPLIERCOMPANYID");
        String queryStr = String.format(querySb.toString(), tableName, lastYearDate, nowDate);
        String prevCompanyId = null;
        Map paramMap = new HashMap();
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        IUpgradeBillFacade iUpgradeBill = UpgradeBillFacadeFactory.getLocalInstance(ctx);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            logger.error((Object)e);
        }
        try {
            String countSql = "SELECT COUNT(1) FROM %s WHERE FSTATE IN (115, 110, 65, 70, 45, 80) AND (FBIZREQDATE >= {%s}  AND FBIZREQDATE <= {%s})";
            String countSql2 = String.format(countSql.toString(), tableName, lastYearDate, nowDate);
            statement = conn.createStatement();
            rs = statement.executeQuery(countSql2);
            int size = 0;
            while (rs.next()) {
                size = rs.getInt(1);
            }
            rs = statement.executeQuery(queryStr);
            int i = 0;
            while (rs.next()) {
                BigDecimal percent = new BigDecimal(++i).multiply(new BigDecimal(100)).divide(new BigDecimal(size), 0, 4);
                UpgradeTaskSchedule.updateProcessMap(taskId, percent.intValue());
                String billId = rs.getString("FID");
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK objectUuidPK = new ObjectUuidPK(billId);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("NUMBER"));
                selector.add(new SelectorItemInfo("STATE"));
                selector.add(new SelectorItemInfo("ACTIONFLAG"));
                selector.add(new SelectorItemInfo("APPLIERCOMPANY.ID"));
                selector.add(new SelectorItemInfo("AMOUNTAPPROVED"));
                selector.add(new SelectorItemInfo("RETURNAMOUNT"));
                selector.add(new SelectorItemInfo("AMOUNTPAID"));
                selector.add(new SelectorItemInfo("ISVOUCHERED"));
                selector.add(new SelectorItemInfo("AMOUNTNOTPAID"));
                selector.add(new SelectorItemInfo("AMOUNTENCASHED"));
                BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objectUuidPK.getObjectType(), (IObjectPK)objectUuidPK, selector);
                CompanyOrgUnitInfo company = billInfo.getApplierCompany();
                if (company == null) continue;
                String companyId = company.getId().toString();
                if (!companyId.equals(prevCompanyId)) {
                    paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, companyId);
                    prevCompanyId = companyId;
                }
                iUpgradeBill.updateCreateVoucherRecord(billInfo, paramMap);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup(rs, statement, (Connection)conn);
        }
        UpgradeTaskSchedule.stopTask(taskId);
        return true;
    }
}

