/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteServerHelperUtils;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.bos.workflow.metas.IProcInstBizObj;
import com.kingdee.bos.workflow.metas.ProcInstBizObjCollection;
import com.kingdee.bos.workflow.metas.ProcInstBizObjFactory;
import com.kingdee.bos.workflow.metas.ProcInstBizObjInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AdjustStateEnum;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BillPrintFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CpBudgetCtrlCaller;
import com.kingdee.eas.cp.bc.ForPrintFacadeFactory;
import com.kingdee.eas.cp.bc.IBillPrintFacade;
import com.kingdee.eas.cp.bc.IForPrintFacade;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.util.BizCollBillDataProviderExt;
import com.kingdee.eas.cp.bc.util.CPBCCommonParams;
import com.kingdee.eas.ma.nbudget.face.IBalance;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BizCollBillDataProvider
implements BOSQueryDelegate {
    private List ids = null;
    private IMetaDataPK qpk = null;
    private KDNoteHelper appHlp = null;
    private BOSObjectType bosType = null;
    private Context ctx = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.BizCollBillDataProvider");
    private static final String APPROVEINFO = "com.kingdee.eas.cp.bc.app.MultiApproveQuery";

    public BizCollBillDataProvider() {
    }

    public BizCollBillDataProvider(KDNoteHelper appHlp, BOSObjectType bosType, List ids) {
        this.appHlp = appHlp;
        this.bosType = bosType;
        this.ids = ids;
        logger.error((Object)("---BizCollBillDataProvider ids=" + ids + ",bosType=" + bosType + ",appHlp=" + appHlp));
    }

    public BizCollBillDataProvider(List id, IMetaDataPK qpk) {
        BOSObjectType bosType;
        this.ids = id;
        this.qpk = qpk;
        this.bosType = bosType = BizCollUtil.getBOSType(id.get(0).toString());
        logger.error((Object)("---BizCollBillDataProvider ids=" + this.ids + ",qpk=" + qpk + ",bosType=" + bosType));
    }

    public BizCollBillDataProvider(Context ctx, List id, IMetaDataPK qpk) {
        BOSObjectType bosType;
        this.ids = id;
        this.qpk = qpk;
        this.ctx = ctx;
        this.bosType = bosType = BizCollUtil.getBOSType(id.get(0).toString());
        logger.error((Object)("---BizCollBillDataProvider ctx ids=" + this.ids + ",qpk=" + qpk + ",bosType=" + bosType));
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            IRowSet rowSet = null;
            String str = ds.getID();
            IForPrintFacade ibizForPrint = null;
            IBillPrintFacade billPrintFacade = null;
            IProcInstBizObj iprocInstBizObj = null;
            IMetaDataLoader iMetaDataLoader = null;
            if (this.ctx == null) {
                logger.error((Object)"---BizCollBillDataProvider ctx is null");
                ibizForPrint = ForPrintFacadeFactory.getRemoteInstance();
                billPrintFacade = BillPrintFacadeFactory.getRemoteInstance();
                iprocInstBizObj = ProcInstBizObjFactory.getRemoteInstance();
                iMetaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            } else {
                logger.error((Object)"---BizCollBillDataProvider ctx is not null");
                ibizForPrint = ForPrintFacadeFactory.getLocalInstance(this.ctx);
                billPrintFacade = BillPrintFacadeFactory.getLocalInstance(this.ctx);
                iprocInstBizObj = ProcInstBizObjFactory.getLocalInstance((Context)this.ctx);
                iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
            }
            EntityViewInfo ev = this.getEntityViewSort(ds);
            FilterInfo filterInfo = new FilterInfo();
            HashSet idset = new HashSet(this.ids);
            if ("bill".equalsIgnoreCase(str)) {
                String templatePath;
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                rowSet = this.updateRowSet(rowSet, this.bosType, str);
                if (this.appHlp != null && this.appHlp.isPrintTimesControllable2(templatePath = BizCollUtil.getTemplatePathByBosType(this.bosType))) {
                    BizCollUtil.updatePrintCount(this.ctx, this.bosType, templatePath, this.appHlp, rowSet);
                }
                logger.error((Object)("---BizCollBillDataProvider bill rowSet=" + rowSet));
                return rowSet;
            }
            if ("r1bill".equalsIgnoreCase(str)) {
                HashMap atts;
                String strResult;
                boolean equals;
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                rowSet = this.updateRowSet(rowSet, this.bosType, str);
                String templatePath = null;
                templatePath = BizCollUtil.getTemplatePathByBosType(this.bosType);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                if (this.appHlp != null && this.appHlp.isPrintTimesControllable2(templatePath)) {
                    map.put("prepareTimes", this.appHlp.getCopies());
                    map.put("maxPrintTimes", this.appHlp.getMaxPrintTimes2(templatePath));
                    BizCollUtil.updatePrintCount(this.ctx, this.bosType, templatePath, map, rowSet);
                } else if (this.appHlp == null && (equals = "1".equals(strResult = (atts = (HashMap)KDNoteServerHelperUtils.getAttributes((String)templatePath)) == null ? null : (String)atts.get("isselected")))) {
                    map.put("prepareTimes", 1);
                    map.put("maxPrintTimes", Integer.parseInt((String)atts.get("prttimes")));
                    BizCollUtil.updatePrintCount(this.ctx, this.bosType, templatePath, map, rowSet);
                }
                logger.error((Object)("---BizCollBillDataProvider r1bill rowSet=" + rowSet));
                return rowSet;
            }
            if ("approveInfo".equalsIgnoreCase(str)) {
                ArrayList params = ds.getParams();
                int size = params.size();
                String billId = null;
                boolean showHistory = true;
                String procInstId = null;
                for (int i = 0; i < size; ++i) {
                    Variant value;
                    DSParam dsParam = (DSParam)params.get(i);
                    String paramName = dsParam.getColName();
                    if (paramName.equalsIgnoreCase("billid")) {
                        value = dsParam.getValue();
                        if (value == null || "".equals(value.toString())) continue;
                        billId = value.toString();
                        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)value.toString()));
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("isLastProcInfo") && billId != null) {
                        IRowSet rs;
                        ProcInstBizObjInfo bizObjInfo;
                        Iterator iterator;
                        value = dsParam.getValue();
                        if (value == null || "".equals(value.toString())) continue;
                        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)billId, CompareType.EQUALS));
                        viewInfo.setFilter(filter);
                        SelectorItemCollection selector = viewInfo.getSelector();
                        selector.add(new SelectorItemInfo("procInstID"));
                        selector.add(new SelectorItemInfo("bizObjID"));
                        selector.add(new SelectorItemInfo("orgId"));
                        viewInfo.setSelector(selector);
                        ProcInstBizObjCollection procInstBizObjCollection = iprocInstBizObj.getCollection(viewInfo);
                        if (procInstBizObjCollection != null && !procInstBizObjCollection.isEmpty() && (iterator = procInstBizObjCollection.iterator()).hasNext() && (bizObjInfo = (ProcInstBizObjInfo)iterator.next()).get("procInstID") != null) {
                            procInstId = bizObjInfo.get("procInstID").toString();
                        }
                        if (procInstId == null && (rs = billPrintFacade.queryLastProcInstByBillInfo(billId)) != null && rs.next()) {
                            procInstId = rs.getString("fprocInstId");
                            rs.beforeFirst();
                        }
                        filterInfo.getFilterItems().add(new FilterItemInfo("assign.procInstID", procInstId));
                        continue;
                    }
                    if (paramName.equalsIgnoreCase("isPass")) {
                        value = dsParam.getValue();
                        if (value == null || "".equals(value.toString())) continue;
                        filterInfo.getFilterItems().add(new FilterItemInfo("isPass", (Object)value.toString().toLowerCase()));
                        continue;
                    }
                    if (!paramName.equalsIgnoreCase("showHistory")) continue;
                    value = dsParam.getValue();
                    showHistory = value.booleanValue();
                }
                int filterSize = filterInfo.getFilterItems().size();
                if (filterSize > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < filterSize - 1; ++i) {
                        sb.append("#" + i + " and ");
                    }
                    sb.append("#" + (filterSize - 1));
                    filterInfo.setMaskString(sb.toString());
                }
                return billPrintFacade.queryApproveInfo(filterInfo, showHistory);
            }
            if ("r1entry".equalsIgnoreCase(str)) {
                Variant v = ((DSParam)ds.getParams().get(0)).getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)v.toString()));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                rowSet = this.updateRowSet(rowSet, this.bosType, str);
                logger.error((Object)("---BizCollBillDataProvider r1entry rowSet=" + rowSet));
                return rowSet;
            }
            if ("r1CollectionEntry".equalsIgnoreCase(str)) {
                Variant v = ((DSParam)ds.getParams().get(0)).getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)v.toString()));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                rowSet = this.updateRowSet(rowSet, this.bosType, str);
                logger.error((Object)("---BizCollBillDataProvider r1CollectionEntry rowSet=" + rowSet));
                return rowSet;
            }
            if ("r1AdjustCollectionEntry".equalsIgnoreCase(str)) {
                Variant v = ((DSParam)ds.getParams().get(0)).getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)v.toString()));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                rowSet = this.updateRowSet(rowSet, this.bosType, str);
                logger.error((Object)("---BizCollBillDataProvider r1AdjustCollectionEntry rowSet=" + rowSet));
                return rowSet;
            }
            if ("reqCheck".equalsIgnoreCase(str)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("parentID", (Object)this.ids));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                logger.error((Object)("---BizCollBillDataProvider reqCheck rowSet=" + rowSet));
                return rowSet;
            }
            if ("loanCheck".equalsIgnoreCase(str)) {
                Variant v = ((DSParam)ds.getParams().get(0)).getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("parentID", (Object)v.toString()));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                logger.error((Object)("---BizCollBillDataProvider loanCheck rowSet=" + rowSet));
                return rowSet;
            }
            if ("entrysum".equalsIgnoreCase(str)) {
                Variant v = ((DSParam)ds.getParams().get(0)).getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)v.toString()));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                logger.error((Object)("---BizCollBillDataProvider entrysum rowSet=" + rowSet));
                return rowSet;
            }
            if ("NoHistoryApprove".equalsIgnoreCase(str)) {
                ApproveDataProvider approveData = new ApproveDataProvider();
                return approveData.execute(ds);
            }
            if ("BudgetCtrl".equalsIgnoreCase(str)) {
                BudgetDataProvider budgetData = new BudgetDataProvider();
                return budgetData.execute(ds);
            }
            if ("PageQuery".equalsIgnoreCase(str) || "PageQueryBiz".equalsIgnoreCase(str)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                logger.error((Object)("---BizCollBillDataProvider PageQuery rowSet=" + rowSet));
                return rowSet;
            }
            if ("ticket".equalsIgnoreCase(str)) {
                Variant v = ((DSParam)ds.getParams().get(0)).getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)v.toString()));
                ev.setFilter(filterInfo);
                rowSet = ibizForPrint.getListRowset(this.getReportQueryName(this.bosType, str), ev);
                logger.error((Object)("---BizCollBillDataProvider ticketEntry rowSet=" + rowSet));
                return rowSet;
            }
            if (str != null && str.contains("ext")) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("ibizForPrint", ibizForPrint);
                paramMap.put("billPrintFacade", billPrintFacade);
                paramMap.put("iprocInstBizObj", iprocInstBizObj);
                paramMap.put("appHlp", this.appHlp);
                paramMap.put("ids", this.ids);
                BizCollBillDataProviderExt bizCollBillDataProviderExt = new BizCollBillDataProviderExt();
                rowSet = bizCollBillDataProviderExt.getRowSet_ext(this.ctx, ds, this.bosType, paramMap);
                logger.error((Object)("---BizCollBillDataProvider ext ds=" + str + ", rowSet=" + rowSet));
                return rowSet;
            }
            if (str.contains("cp.bc")) {
                QueryInfo queryInfo = iMetaDataLoader.getQuery((IMetaDataPK)new MetaDataPK(str));
                if (queryInfo == null) {
                    logger.error((Object)("---BizCollBillDataProvider cp.bc query is undefine! query=" + str));
                    throw new RuntimeException(" cp.bc query is undefine! query=" + str);
                }
                ArrayList params = ds.getParams();
                int size = params.size();
                if (size == 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
                } else {
                    DSParam dsParam = null;
                    Variant v = null;
                    for (int i = 0; i < size; ++i) {
                        dsParam = (DSParam)params.get(i);
                        String paramName = dsParam.getColName();
                        v = ((DSParam)ds.getParams().get(i)).getValue();
                        filterInfo.getFilterItems().add(new FilterItemInfo(paramName, (Object)v.toString()));
                    }
                }
                ev.setFilter(filterInfo);
                logger.error((Object)("---BizCollBillDataProvider cp.bc query=" + str + " EntityViewInfo=" + ev.getFilter()));
                rowSet = ibizForPrint.getListRowset(str, ev);
                this.updateBillReprotRowSet(rowSet);
                this.updateEntryReprotRowSet(rowSet, this.bosType);
                this.updateCollectionRowSet(rowSet, this.bosType);
                return rowSet;
            }
        }
        catch (Exception e) {
            logger.error((Object)("rowSet is null " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("BizCollBillDataProvider error", e);
        }
        return null;
    }

    protected EntityViewInfo getEntityViewSort(BOSQueryDataSource ds) {
        int i;
        int c;
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection ori = (SorterItemCollection)evi.getSorter().clone();
        evi.getSorter().clear();
        String str = ds.getID();
        R1PrintDataSortItem[] sorts = ds.getSortFields();
        SorterItemInfo sorterItemInfo = null;
        if (sorts.length == 0 || "id".equals(sorts[0].getSortField())) {
            this.getDefualtSorter(str, evi);
        } else {
            c = sorts.length;
            for (i = 0; i < c; ++i) {
                sorterItemInfo = new SorterItemInfo();
                sorterItemInfo.setPropertyName(sorts[i].getSortField());
                if (sorts[i].getSortType() == 1) {
                    sorterItemInfo.setSortType(SortType.DESCEND);
                } else {
                    sorterItemInfo.setSortType(SortType.ASCEND);
                }
                evi.getSorter().add(sorterItemInfo);
            }
        }
        c = ori.size();
        for (i = 0; i < c; ++i) {
            evi.getSorter().add(ori.get(i));
        }
        return evi;
    }

    protected void getDefualtSorter(String str, EntityViewInfo evi) {
        SorterItemInfo sorterItemInfo = null;
        SorterItemCollection sorterItemCol = new SorterItemCollection();
        if ("bill".equalsIgnoreCase(str)) {
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("bizReqDate");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorterItemCol.add(sorterItemInfo);
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("number");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorterItemCol.add(sorterItemInfo);
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("entries.seq");
            sorterItemInfo.setSortType(SortType.ASCEND);
            sorterItemCol.add(sorterItemInfo);
        } else if ("r1bill".equalsIgnoreCase(str) || "PageQuery".equals(str) || "PageQueryBiz".equalsIgnoreCase(str)) {
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("bizReqDate");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorterItemCol.add(sorterItemInfo);
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("number");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorterItemCol.add(sorterItemInfo);
        } else if ("r1entry".equalsIgnoreCase(str) || "r1CollectionEntry".equalsIgnoreCase(str) || "loanCheck".equalsIgnoreCase(str) || "reqCheck".equalsIgnoreCase(str) || "ticket".equalsIgnoreCase(str)) {
            sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName("seq");
            sorterItemInfo.setSortType(SortType.ASCEND);
            sorterItemCol.add(sorterItemInfo);
        }
        evi.getSorter().addObjectCollection((IObjectCollection)sorterItemCol);
    }

    protected IRowSet updateRowSet(IRowSet rowSet, BOSObjectType bosType, String dsID) throws SQLException {
        if ("bill".equalsIgnoreCase(dsID) || "r1bill".equalsIgnoreCase(dsID)) {
            rowSet = this.updateBillReprotRowSet(rowSet);
        } else if ("r1entry".equalsIgnoreCase(dsID)) {
            rowSet = this.updateEntryReprotRowSet(rowSet, bosType);
        } else if ("r1CollectionEntry".equalsIgnoreCase(dsID)) {
            rowSet = this.updateCollectionRowSet(rowSet, bosType);
        } else if ("r1AdjustCollectionEntry".equalsIgnoreCase(dsID)) {
            rowSet = this.updateAdjustCollectionRowSet(rowSet, bosType);
        }
        return rowSet;
    }

    @Deprecated
    protected IRowSet parsePrintValue(IRowSet rowSet) throws SQLException {
        this.parseAmountCapital(rowSet);
        rowSet = this.parseEnumValue(rowSet, "prior", "prioralias", PriorEnum.getEnumList());
        rowSet = this.parseEnumValue(rowSet, "state", "stateAlias", StateEnum.getEnumList());
        if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.TRAVELBOSTYPE.equals((Object)this.bosType)) {
            rowSet = this.parseEnumValue(rowSet, "entries.vehicle", "vehalias", VehicleEnum.getEnumList());
        }
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)this.bosType)) {
            rowSet = this.parseEnumValue(rowSet, "amountControlType", "amountControlTypeAlias", AmountControlTypeEnum.getEnumList());
        }
        return rowSet;
    }

    protected IRowSet updateBillReprotRowSet(IRowSet rowSet) throws SQLException {
        this.parseAmountCapital(rowSet);
        rowSet = this.parseEnumValue(rowSet, "prior", "prioralias", PriorEnum.getEnumList());
        rowSet = this.parseEnumValue(rowSet, "state", "stateAlias", StateEnum.getEnumList());
        if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.TRAVELBOSTYPE.equals((Object)this.bosType)) {
            rowSet = this.parseEnumValue(rowSet, "entries.vehicle", "vehalias", VehicleEnum.getEnumList());
        }
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)this.bosType)) {
            rowSet = this.parseEnumValue(rowSet, "amountControlType", "amountControlTypeAlias", AmountControlTypeEnum.getEnumList());
        }
        return rowSet;
    }

    protected IRowSet updateEntryReprotRowSet(IRowSet rowSet, BOSObjectType bosType) throws SQLException {
        if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType) || CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType) || CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            return this.parseEnumValue(rowSet, "vehicle", "vehalias", VehicleEnum.getEnumList());
        }
        return rowSet;
    }

    protected IRowSet updateCollectionRowSet(IRowSet rowSet, BOSObjectType bosType) throws SQLException {
        if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType) || CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType) || CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            rowSet = this.parseEnumValue(rowSet, "payerType", "payerTypeAlias", PayerTypeEnum.getEnumList());
            return rowSet;
        }
        return rowSet;
    }

    protected IRowSet updateAdjustCollectionRowSet(IRowSet rowSet, BOSObjectType bosType) throws SQLException {
        if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            rowSet = this.parseEnumValue(rowSet, "payerType", "payerTypeAlias", PayerTypeEnum.getEnumList());
            rowSet = this.parseEnumValue(rowSet, "payerTypeAdjust", "payerTypeAdjustAlias", PayerTypeEnum.getEnumList());
            rowSet = this.parseEnumValue(rowSet, "adjustState", "adjustStateAlias", AdjustStateEnum.getEnumList());
            return rowSet;
        }
        return rowSet;
    }

    protected IRowSet parseAmountCapital(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return rowSet;
        }
        try {
            BigDecimal amount = null;
            String amountField = "amountApproved";
            if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)this.bosType) || CPBCCommonParams.REPAYMENTBILLBOSTYPE.equals((Object)this.bosType)) {
                amountField = "amount";
            }
            rowSet.previous();
            while (rowSet.next()) {
                amount = rowSet.getBigDecimal(amountField);
                if (amount != null && amount.compareTo(new BigDecimal("0.00")) == 0) {
                    amount = new BigDecimal("0.00");
                }
                rowSet.updateString("amountCapital", BizCollUtil.getChineseFormat(amount, false));
            }
        }
        catch (SQLException e) {
            logger.error((Object)("cpbc parseAmountCapital findColumn error. " + e.getMessage()));
        }
        rowSet.beforeFirst();
        return rowSet;
    }

    public IRowSet parseEnumValue(IRowSet rowSet, String value, String valueAlias, List list) throws SQLException {
        int pos;
        if (rowSet == null) {
            return rowSet;
        }
        if (list == null) {
            return rowSet;
        }
        if (value == null || value.equals("")) {
            return rowSet;
        }
        if (rowSet.size() == 0) {
            return rowSet;
        }
        String mark = "";
        try {
            pos = rowSet.findColumn(valueAlias);
            rowSet.findColumn(value);
        }
        catch (SQLException e) {
            logger.error((Object)("cpbc parseEnumValue findColumn error. " + e.getMessage()));
            return rowSet;
        }
        Iterator ite = null;
        IntEnum intenum = null;
        StringEnum strenum = null;
        rowSet.previous();
        while (rowSet.next()) {
            ite = list.iterator();
            Object tempValue = rowSet.getObject(value);
            if (BizCollUtil.objectIsNull(tempValue)) continue;
            while (ite.hasNext()) {
                Object enumname = ite.next();
                if (enumname instanceof IntEnum) {
                    intenum = (IntEnum)enumname;
                    if (Integer.parseInt(tempValue.toString()) == intenum.getValue()) {
                        mark = intenum.getAlias();
                        break;
                    }
                }
                if (!(enumname instanceof StringEnum)) continue;
                strenum = (StringEnum)enumname;
                if (!tempValue.toString().equals(strenum.getValue())) continue;
                mark = strenum.getAlias();
                break;
            }
            rowSet.updateString(pos, mark);
        }
        rowSet.beforeFirst();
        return rowSet;
    }

    private List getSelectIdList() {
        return new ArrayList(this.ids);
    }

    protected String getReportQueryName(BOSObjectType bosType, String dsID) {
        String queryPk = null;
        if ("bill".equalsIgnoreCase(dsID)) {
            queryPk = this.getReportQueryName(bosType);
        } else if ("r1bill".equalsIgnoreCase(dsID) || "PageQuery".equals(dsID) || "PageQueryBiz".equalsIgnoreCase(dsID)) {
            queryPk = this.getR1ReportBillQueryName(bosType);
        } else if ("r1entry".equalsIgnoreCase(dsID)) {
            queryPk = this.getR1ReportEntryQueryName(bosType);
        } else if ("r1CollectionEntry".equalsIgnoreCase(dsID)) {
            queryPk = this.getR1ReportCollectionEntryQueryName(bosType);
        } else if ("r1AdjustCollectionEntry".equalsIgnoreCase(dsID)) {
            queryPk = this.getR1ReportAdjustCollectionEntryQueryName(bosType);
        } else if ("loanCheck".equalsIgnoreCase(dsID)) {
            queryPk = this.getLoanCheckReportEntryQueryName(bosType);
        } else if ("reqCheck".equalsIgnoreCase(dsID)) {
            queryPk = this.getReqCheckReportEntryQueryName(bosType);
        } else if ("ticket".equalsIgnoreCase(dsID)) {
            queryPk = this.getTicketEntryQueryName(bosType);
        } else if ("entrysum".equalsIgnoreCase(dsID)) {
            queryPk = this.getR1ReportEntrySumQueryName(bosType);
        }
        logger.error((Object)("cp.bc getReportQueryName queryPk=" + queryPk));
        return queryPk;
    }

    protected String getR1ReportAdjustCollectionEntryQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillAccountAdjustEntryForPrintQuery";
        }
        return queryPk;
    }

    protected String getReportQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.OtherExpBillForPrintQuery";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DialyLoadBillQueryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountForPrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurAccountForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionReqForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionLoanForPrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillForR1PrintQuery";
        } else if (CPBCCommonParams.REPAYMENTBILLBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.RePaymentBillQueryForPrintQuery";
        }
        return queryPk;
    }

    protected String getR1ReportBillQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.OtherExpenseBillForR1PrintQuery";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyLoanBillForR1PrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillForR1PrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseAccountBillForR1PrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionReqBillForR1PrintQuery";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionLoanBillForR1PrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillForR1PrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillForR1PrintQuery";
        } else if (CPBCCommonParams.REPAYMENTBILLBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.RePaymentBillForR1PrintQuery";
        }
        return queryPk;
    }

    protected String getR1ReportEntryQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.OtherExpenseBillEntryForPrintQuery";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyLoanBillEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillEntryForPrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseAccountBillEntryForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionReqBillEntryForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionLoanBillEntryForPrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillEntryForPrintQuery";
        } else if (CPBCCommonParams.REPAYMENTBILLBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.RePaymentBillEntryForPrintQuery";
        }
        return queryPk;
    }

    protected String getR1ReportCollectionEntryQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyLoanBillAccountEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillAccountEntryForPrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseAccountBillAccountEntryForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionLoanBillAccountEntryForPrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillAccountEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillAccountEntryForPrintQuery";
        }
        return queryPk;
    }

    protected String getR1ReportEntrySumQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionLoanBillEntrySumForPrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillEntrySumForPrintQuery";
        }
        return queryPk;
    }

    protected String getLoanCheckReportEntryQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillLoanCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseLoanCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillLoanCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillLoanCheckEntryForPrintQuery";
        }
        return queryPk;
    }

    protected String getReqCheckReportEntryQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyLoanBillReqCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillReqCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseReqCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.EvectionLoanBillReqCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillReqCheckEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillReqCheckEntryForPrintQuery";
        }
        return queryPk;
    }

    protected String getTicketEntryQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillTicketEntryForPrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseAccountBillTicketEntryForPrintQuery";
        } else if (CPBCCommonParams.EVECTIONREQBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)bosType)) {
            queryPk = "";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillTicketEntryForPrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillTicketEntryForPrintQuery";
        }
        return queryPk;
    }

    class Values
    implements Comparable {
        Object[] _values = null;
        private final int index = 1;

        public Values(Object[] objs) {
            this._values = objs;
        }

        public int compareTo(Object o) {
            Values value = (Values)o;
            Timestamp own = (Timestamp)this._values[1];
            Timestamp other = (Timestamp)value._values[1];
            return own.compareTo(other);
        }
    }

    class BudgetDataProvider {
        private Logger logger = CoreUIObject.getLogger(BudgetDataProvider.class);
        public final String[][] col = new String[][]{{"itemCombinName", ""}, {"orgUnitName", ""}, {"elementName", ""}, {"periodName", ""}, {"bgValue", ""}, {"bizActual", ""}, {"balance", ""}};

        BudgetDataProvider() {
        }

        public IRowSet execute(BOSQueryDataSource ds) {
            ArrayList params = ds.getParams();
            String billId = null;
            for (int i = 0; i < params.size(); ++i) {
                Variant value;
                DSParam dsParam = (DSParam)params.get(i);
                String paramName = dsParam.getColName();
                if (!paramName.equals("billId") && !paramName.equals("billID") || (value = dsParam.getValue()) == null || "".equals(value.toString())) continue;
                billId = value.toString();
            }
            boolean includeUpOrg = true;
            List budgetCtrlCols = null;
            DynamicRowSet drs = null;
            try {
                budgetCtrlCols = CpBudgetCtrlCaller.getBgBalance(BizCollBillDataProvider.this.ctx, billId, true);
                int colLenth = this.col.length;
                drs = new DynamicRowSet(colLenth);
                if (budgetCtrlCols.size() > 0) {
                    String itemNumber = null;
                    String[] object = null;
                    BigDecimal data = new BigDecimal(0);
                    StringBuffer balanceString = new StringBuffer();
                    for (int i = 0; i < budgetCtrlCols.size(); ++i) {
                        balanceString.setLength(0);
                        IBalance balance = (IBalance)budgetCtrlCols.get(i);
                        if ("BudgetCtrl".equalsIgnoreCase(ds.getID())) {
                            for (int j = 0; j < colLenth; ++j) {
                                ColInfo ci = new ColInfo();
                                ci.colType = 12;
                                ci.columnName = this.col[j][0];
                                ci.nullable = 1;
                                drs.setColInfo(j + 1, ci);
                            }
                            drs.moveToInsertRow();
                            this.clearRow((IRowSet)drs);
                            object = balance.getReqItem();
                            String string = itemNumber = object != null && object.length >= 2 ? object[0] : null;
                            if (itemNumber == null) continue;
                            drs.updateString("itemCombinName", object != null && object.length >= 2 ? object[1] : null);
                            object = balance.getOrgUnit();
                            drs.updateString("orgUnitName", object != null && object.length >= 2 ? object[2] : null);
                            object = balance.getElement();
                            drs.updateString("elementName", object != null && object.length >= 2 ? object[2] : null);
                            object = balance.getPeriod();
                            drs.updateString("periodName", object != null && object.length >= 2 ? object[2] : null);
                            data = balance.getBudget() != null ? balance.getBudget() : new BigDecimal(0);
                            drs.updateString("bgValue", CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                            data = balance.getActual() != null ? balance.getActual() : new BigDecimal(0);
                            drs.updateString("bizActual", CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                            BigDecimal bigDecimal = data = balance.getBalance() != null ? balance.getBalance() : new BigDecimal(0);
                            if (balance.getExtBalance() != null) {
                                balanceString.append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(balance.getExtBalance()));
                                balanceString.append("(").append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data)).append(")");
                            } else {
                                balanceString.append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                            }
                            drs.updateString("balance", balanceString.toString());
                        }
                        drs.insertRow();
                    }
                } else if ("BudgetCtrl".equalsIgnoreCase(ds.getID())) {
                    for (int j = 0; j < colLenth; ++j) {
                        ColInfo ci = new ColInfo();
                        ci.colType = 12;
                        ci.columnName = this.col[j][0];
                        ci.nullable = 1;
                        drs.setColInfo(j + 1, ci);
                    }
                    drs.moveToInsertRow();
                    this.clearRow((IRowSet)drs);
                    drs.updateString("itemCombinName", null);
                    drs.updateString("orgUnitName", null);
                    drs.updateString("elementName", null);
                    drs.updateString("periodName", null);
                    drs.updateString("bgValue", null);
                    drs.updateString("bizActual", null);
                    drs.updateString("balance", null);
                    drs.insertRow();
                }
                drs.beforeFirst();
            }
            catch (EASBizException e) {
                this.logger.error((Object)("cp.bc BudgetDataProvider error. " + e.getMessage()), (Throwable)e);
            }
            catch (BOSException e) {
                this.logger.error((Object)("cp.bc BudgetDataProvider error. " + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error((Object)("cp.bc BudgetDataProvider error. " + e.getMessage()), (Throwable)e);
            }
            return drs;
        }

        private void clearRow(IRowSet rs) throws Exception {
            int colCount = rs.getRowSetMetaData().getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                rs.updateString(i, null);
            }
        }
    }

    class ApproveDataProvider
    implements BOSQueryDelegate {
        private Logger logger = CoreUIObject.getLogger(ApproveDataProvider.class);

        ApproveDataProvider() {
        }

        public IRowSet execute(BOSQueryDataSource ds) {
            IRowSet iRowSet = null;
            Boolean tmp = new Boolean(false);
            Object[] initargs = new Object[]{"", tmp, "billId"};
            ArrayList<Values> valueArr = new ArrayList<Values>();
            boolean showHistory = false;
            ArrayList parameters = ds.getParams();
            for (int i = 0; i < parameters.size(); ++i) {
                DSParam parameter = (DSParam)parameters.get(i);
                if (parameter.getColName().equalsIgnoreCase("showhistory")) {
                    if (parameter.getValue().getValue().equals("true")) {
                        showHistory = true;
                        break;
                    }
                } else {
                    if (!parameter.getColName().equalsIgnoreCase("billId")) continue;
                    ArrayList<Object> ids = new ArrayList<Object>();
                    ids.add(parameter.getValue().getValue());
                    initargs[0] = ids;
                }
                parameter.getClass();
            }
            try {
                this.logger.info((Object)"test message by wy");
                Class[] consParas = new Class[]{List.class, Boolean.TYPE, String.class};
                Class[] args = new Class[]{String.class};
                this.logger.info((Object)"get clas");
                Class<?> cls = Class.forName("com.kingdee.eas.framework.print.MultiapproveDataProvider");
                Constructor<?> constructor = cls.getConstructor(consParas);
                Method me = cls.getDeclaredMethod("executeQuery", args);
                this.logger.info((Object)"get method");
                me.setAccessible(true);
                this.logger.info((Object)"invoke...");
                Object[] objs = new Object[]{BizCollBillDataProvider.APPROVEINFO};
                iRowSet = (IRowSet)me.invoke(constructor.newInstance(initargs), objs);
                this.logger.info((Object)"finish invoke");
                DynamicRowSet dset = (DynamicRowSet)iRowSet;
                DynamicRowSet subset = dset.subRowSet(0, 0);
                String AssignDetailId = "";
                while (dset.next()) {
                    String value = dset.getString(12);
                    if (AssignDetailId.equals(value) && !showHistory) {
                        this.logger.info((Object)"no shouHistory");
                        continue;
                    }
                    AssignDetailId = value;
                    Object[] values = this.copy(12, dset);
                    valueArr.add(new Values(values));
                }
                Collections.sort(valueArr);
                for (int i = 0; i < valueArr.size(); ++i) {
                    Values value = (Values)valueArr.get(i);
                    Object[] values = value._values;
                    subset.moveToInsertRow();
                    for (int index = 1; index <= values.length; ++index) {
                        subset.updateObject(index, values[index - 1]);
                    }
                    subset.insertRow();
                }
                iRowSet = subset;
            }
            catch (Exception e) {
                this.logger.error((Object)("cp.bc ApproveDataProvider error. " + e.getMessage()), (Throwable)e);
            }
            return iRowSet;
        }

        private Object[] copy(int size, DynamicRowSet set) {
            Object[] objs = new Object[size];
            for (int i = 0; i < size; ++i) {
                try {
                    objs[i] = set.getObject(i + 1);
                    continue;
                }
                catch (SQLException e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            return objs;
        }
    }
}

