/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.ProjectFactory;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.assistant.ProjectStatus;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.util.AssistantUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IBizCollCoreBillBase;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class BizImportUtil {
    private static final String BCImportRES = "com.kingdee.eas.cp.bc.BCImportExportResource";
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.BizImportUtil");

    public static boolean numberIsEmpty(Object numberdata) throws TaskExternalException {
        return numberdata == null || StringUtils.isEmpty((String)numberdata.toString());
    }

    public static void buildNumber(Context ctx, BizCollCoreBillBaseInfo info, ICodingRuleManager iCodingRuleManager) throws TaskExternalException {
        BizImportUtil.buildNumberBefore(ctx, info);
        String companyId = info.getApplierCompany().getId().toString();
        if (iCodingRuleManager == null) {
            return;
        }
        try {
            if (!iCodingRuleManager.isExist((IObjectValue)info, companyId)) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"HASNOTCODINGRULE", (Locale)ctx.getOriginLocale()));
            }
            info.setNumber(iCodingRuleManager.getNumber((IObjectValue)info, companyId));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public static void buildNumberBefore(Context ctx, BizCollCoreBillBaseInfo info) {
    }

    public static boolean getBooleanParam(Context ctx, String param) throws TaskExternalException {
        if (StringUtils.isEmpty((String)param)) {
            return true;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(param);
        Map paramMap = new HashMap();
        try {
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return paramMap.get(param) == null ? false : new Boolean(paramMap.get(param).toString());
    }

    public static ICodingRuleManager getICodingRuleManager(Context ctx, boolean isNeed) throws TaskExternalException {
        if (isNeed) {
            try {
                return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        return null;
    }

    public static BizCollCoreBillBaseInfo getBillInfoByNumber(Context ctx, IBizCollCoreBillBase iFixBill, String number) throws TaskExternalException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        try {
            CoreBaseCollection col = iFixBill.getCollection(viewInfo);
            if (col.size() > 0) {
                return (BizCollCoreBillBaseInfo)col.get(0);
            }
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
        return null;
    }

    public static void initPaymode(Context ctx, BizCollCoreBillBaseInfo billInfo, Hashtable hsData) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"payMode.name")).data;
        if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
            ISettlementType iSet = SettlementTypeFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(BizCollUtil.getInportFilter(str));
            viewInfo.setSelector(BizCollUtil.getInportSic());
            SettlementTypeCollection collection = iSet.getSettlementTypeCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                SettlementTypeInfo info = collection.get(0);
                if (info != null) {
                    billInfo.put("payMode", info);
                }
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"PAYMODE_ERROR", (Locale)ctx.getOriginLocale()));
            }
        }
    }

    public static BizCollCoreBillBaseInfo dealWithNumberUpdate(Context ctx, IBizCollCoreBillBase iFixBill, Hashtable hsData) throws TaskExternalException {
        Object numberdata = ((DataToken)hsData.get((Object)"number")).data;
        if (BizImportUtil.numberIsEmpty(numberdata)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NUMBERNOTNULL_UPDATE", (Locale)ctx.getOriginLocale()));
        }
        BizCollCoreBillBaseInfo baseInfo = BizImportUtil.getBillInfoByNumber(ctx, iFixBill, numberdata.toString());
        if (baseInfo != null) {
            if (!baseInfo.getState().equals((Object)StateEnum.DRAFT)) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_DRAFT_VALUE", (Locale)ctx.getOriginLocale()));
            }
            return baseInfo;
        }
        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"HASNOBILL_UPDATE", (Locale)ctx.getOriginLocale()));
    }

    public static ObjectUuidPK dealWithNumberAddNew(Context ctx, IBizCollCoreBillBase iFixBill, BizCollCoreBillBaseInfo billInfo, Hashtable hsData, boolean importDataByRule) throws TaskExternalException {
        Object numberdata = ((DataToken)hsData.get((Object)"number")).data;
        if (BizImportUtil.numberIsEmpty(numberdata)) {
            if (!importDataByRule) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NUMBERNOTNULL_ADDNEW", (Locale)ctx.getOriginLocale()));
            }
            return null;
        }
        BizCollCoreBillBaseInfo baseInfo = BizImportUtil.getBillInfoByNumber(ctx, iFixBill, numberdata.toString());
        if (baseInfo != null) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"ALREADYEXISTS_ADDNEW", (Locale)ctx.getOriginLocale()));
        }
        billInfo.setNumber(numberdata.toString());
        return null;
    }

    public static void initStateForLoan(Context ctx, DailyLoanBillInfo billInfo, Hashtable hsData) {
        Object data = ((DataToken)hsData.get((Object)"state")).data;
        String str = null;
        if (data != null) {
            str = data.toString();
            if (str != null && str.trim().length() > 0) {
                if (str.equals("60") || str.equals("\u5ba1\u6838\u901a\u8fc7")) {
                    billInfo.setState(StateEnum.CHECKED);
                    billInfo.setIsImport(true);
                } else if (str.equals("70") || str.equals("\u5df2\u4ed8\u6b3e")) {
                    billInfo.setState(StateEnum.ALREADYPAYMENT);
                    billInfo.setIsImport(true);
                } else {
                    billInfo.setState(StateEnum.DRAFT);
                }
            } else {
                billInfo.setState(StateEnum.DRAFT);
            }
        } else {
            billInfo.setState(StateEnum.DRAFT);
        }
    }

    public static CoreBillEntryBaseInfo initImportEntryCommonData(Context ctx, CoreBillEntryBaseInfo entryInfo, Hashtable hsData, Map cacheMap, Map filterItemsMap) throws TaskExternalException {
        try {
            BizImportUtil.initImportEntryId(ctx, entryInfo, filterItemsMap);
            BizImportUtil.initImportEntryCurrencyType(ctx, entryInfo, hsData, cacheMap, filterItemsMap);
            BizImportUtil.initImportEntryCostCenterAndCompany(ctx, entryInfo, hsData, cacheMap);
            BizImportUtil.initImportEntryExpenseTypeAndOperateType(ctx, entryInfo, hsData, cacheMap, filterItemsMap);
            BizImportUtil.checkImportExpenseType(ctx, (CompanyOrgUnitInfo)entryInfo.get("company"), (ExpenseTypeInfo)entryInfo.get("expenseType"));
        }
        catch (Exception e) {
            logger.error((Object)("cp.bc initImportEntryCommonData error." + e.getMessage()), e.getCause());
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return entryInfo;
    }

    public static Map getParamMap(Context ctx, String companyId) throws EASBizException, BOSException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, companyId);
        return paramMap;
    }

    private static void initImportEntryId(Context ctx, CoreBillEntryBaseInfo entryInfo, Map filterItemsMap) throws TaskExternalException, EASBizException, BOSException {
        boolean CP039;
        boolean bl = CP039 = filterItemsMap.get("CP039") == null ? false : new Boolean(filterItemsMap.get("CP039").toString());
        if (CP039) {
            entryInfo.put("id", (Object)BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        }
    }

    private static void initImportEntryCurrencyType(Context ctx, CoreBillEntryBaseInfo entryInfo, Hashtable hsData, Map cacheMap, Map filterItemsMap) throws TaskExternalException {
        CurrencyInfo currency = null;
        DataToken dataToken = (DataToken)hsData.get("currencyType");
        if (BizImportUtil.isExistData(dataToken)) {
            try {
                String dataCurrencyStr = dataToken.data.toString().trim();
                String mapkey = "currency." + dataCurrencyStr;
                if (cacheMap.containsKey(mapkey)) {
                    currency = (CurrencyInfo)cacheMap.get(mapkey);
                } else {
                    String errorInfoCacheKey = "currency.error." + dataCurrencyStr;
                    TaskExternalException taskExternalException = (TaskExternalException)((Object)cacheMap.get(errorInfoCacheKey));
                    if (taskExternalException != null) {
                        throw taskExternalException;
                    }
                    currency = (CurrencyInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)CurrencyFactory.getLocalInstance((Context)ctx), cacheMap, errorInfoCacheKey, BizImportUtil.getImportSic(), dataToken);
                    cacheMap.put(mapkey, currency);
                }
                entryInfo.put("currencyType", (Object)currency);
                String currencyTypeId = currency.getId().toString();
                String bizReqDateStr = (String)filterItemsMap.get("date");
                String exchageRateKey = currencyTypeId;
                BigDecimal convertRate = null;
                ConvertModeEnum convertMode = null;
                int precision = 4;
                DataToken exchangeRateToken = (DataToken)hsData.get("exchangeRate");
                if (exchangeRateToken != null && exchangeRateToken.data != null && !StringUtils.isEmpty((String)exchangeRateToken.data.toString())) {
                    convertRate = new BigDecimal(exchangeRateToken.data.toString());
                }
                if (cacheMap.containsKey(exchageRateKey)) {
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)cacheMap.get(exchageRateKey);
                    BigDecimal convertRate2 = exchangeRate.getConvertRate();
                    if (convertRate != null && convertRate2.compareTo(convertRate) != 0) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"EXCHANGERATE_NOT_EQUAL", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{convertRate.toString()}));
                    }
                    convertRate = convertRate2;
                    ExchangeAuxInfo exchangeAux = exchangeRate.getExchangeAux();
                    if (exchangeAux != null) {
                        convertMode = exchangeAux.getConvertMode();
                        precision = exchangeAux.getPrecision();
                    }
                } else {
                    String baseCurrencyId = (String)filterItemsMap.get("baseCurrencyID");
                    String companyId = (String)filterItemsMap.get("applierCompanyId");
                    String errorInfoCacheKey = "exchangeRate.error." + currencyTypeId + baseCurrencyId + companyId + bizReqDateStr;
                    TaskExternalException taskExternalException = (TaskExternalException)((Object)cacheMap.get(errorInfoCacheKey));
                    if (taskExternalException != null) {
                        throw taskExternalException;
                    }
                    ExchangeRateInfo exchangeRate = null;
                    if (currencyTypeId.equals(baseCurrencyId)) {
                        exchangeRate = new ExchangeRateInfo();
                        convertRate = new BigDecimal("1.0000");
                        convertMode = ConvertModeEnum.DIRECTEXCHANGERATE;
                        exchangeRate.setConvertRate(convertRate);
                        ExchangeAuxInfo exchangeAux = new ExchangeAuxInfo();
                        exchangeAux.setConvertMode(convertMode);
                        exchangeAux.setPrecision(precision);
                        exchangeRate.setExchangeAux(exchangeAux);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                        Date bizReqDate = sdf.parse(bizReqDateStr);
                        exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(currencyTypeId, baseCurrencyId, companyId, bizReqDate);
                        if (exchangeRate != null) {
                            boolean CP072;
                            String[] split;
                            ExchangeAuxInfo exchangeAux = exchangeRate.getExchangeAux();
                            if (exchangeAux != null) {
                                convertMode = exchangeAux.getConvertMode();
                                precision = exchangeAux.getPrecision();
                            }
                            if (convertRate != null && (split = convertRate.toString().split("\\.")).length == 2 && split[1].length() > precision) {
                                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"PRECISION_ERROR", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{exchangeRateToken.desc, precision}));
                            }
                            boolean bl = CP072 = filterItemsMap.get("CP072") == null ? false : new Boolean(filterItemsMap.get("CP072").toString());
                            if (CP072) {
                                convertRate = convertRate == null ? exchangeRate.getConvertRate() : convertRate;
                            } else {
                                BigDecimal convertRate2 = exchangeRate.getConvertRate();
                                if (convertRate == null) {
                                    convertRate = convertRate2;
                                } else if (convertRate.compareTo(convertRate2) != 0) {
                                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"EXCHANGERATE_EQUAL_TABLE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{convertRate.toString(), convertRate2.toString()}));
                                }
                            }
                            exchangeRate.setConvertRate(convertRate);
                        } else {
                            TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"NO_EXCHANGERATE", (Locale)ctx.getOriginLocale()));
                            cacheMap.put(errorInfoCacheKey, e);
                            throw e;
                        }
                    }
                    cacheMap.put(exchageRateKey, exchangeRate);
                }
                entryInfo.put("exchangeRatePrecision", (Object)precision);
                if (convertRate != null) {
                    String nFormat = BizCollUtil.getFormatString(precision);
                    entryInfo.setBigDecimal("exchangeRate", new BigDecimal(Tools.format((String)nFormat, (Object)convertRate)));
                }
                entryInfo.put("convertMode", (Object)convertMode);
            }
            catch (Exception e) {
                logger.error((Object)("cp.bc initInportEntryCommonData error." + e.getMessage()), e.getCause());
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void initImportEntryAmountAndTaxData(CoreBillEntryBaseInfo entryInfo) throws TaskExternalException {
        boolean noNeedCalcTax;
        BigDecimal amountOri = entryInfo.getBigDecimal("amountOri");
        BigDecimal amount = BizCollUtil.computeAmount(amountOri, (ConvertModeEnum)entryInfo.get("convertMode"), entryInfo.getBigDecimal("exchangeRate"));
        entryInfo.setBigDecimal("amount", amount);
        BigDecimal taxRate = entryInfo.getBigDecimal("taxRate");
        boolean bl = noNeedCalcTax = BigDecimal.ZERO.compareTo(taxRate) == 0;
        if (!noNeedCalcTax) {
            BigDecimal tax = amountOri.multiply(taxRate).divide(taxRate.add(new BigDecimal(100)), 2, 4);
            entryInfo.setBigDecimal("tax", tax);
        }
        BigDecimal amountOriWithoutTax = amountOri.subtract(entryInfo.getBigDecimal("tax"));
        entryInfo.setBigDecimal("amountOriWithoutTax", amountOriWithoutTax);
        BigDecimal amountWithoutTax = BizCollUtil.computeAmount(amountOriWithoutTax, (ConvertModeEnum)entryInfo.get("convertMode"), entryInfo.getBigDecimal("exchangeRate"));
        entryInfo.setBigDecimal("amountWithoutTax", amountWithoutTax);
    }

    private static void initImportEntryCostCenterAndCompany(Context ctx, CoreBillEntryBaseInfo entryInfo, Hashtable hsData, Map cacheMap) throws BOSException, TaskExternalException, EASBizException {
        CostCenterOrgUnitInfo costInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        DataToken costToken = (DataToken)hsData.get("costCenter");
        if (BizImportUtil.isExistData(costToken)) {
            String dataCostCenterStr = costToken.data.toString();
            String mapkey = "costCenter." + dataCostCenterStr;
            if (cacheMap.containsKey(mapkey)) {
                costInfo = (CostCenterOrgUnitInfo)cacheMap.get(mapkey);
            } else {
                String errorInfoCacheKey = "costCenter.error." + dataCostCenterStr;
                SelectorItemCollection importSic = BizImportUtil.getImportSic();
                importSic.add(new SelectorItemInfo("isSealUp"));
                costInfo = (CostCenterOrgUnitInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)CostCenterOrgUnitFactory.getLocalInstance((Context)ctx), cacheMap, errorInfoCacheKey, importSic, costToken);
                if (costInfo.isIsSealUp()) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"ISSEALUP", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{costToken.desc, costToken.data}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
                cacheMap.put(mapkey, costInfo);
            }
            entryInfo.put("costCenter", (Object)costInfo);
        }
        CompanyOrgUnitInfo companyInfo = null;
        DataToken companyToken = (DataToken)hsData.get("company");
        if (BizImportUtil.isExistData(companyToken)) {
            String dataCompanyStr = companyToken.data.toString();
            String mapkey = "company." + dataCompanyStr;
            if (cacheMap.containsKey(mapkey)) {
                companyInfo = (CompanyOrgUnitInfo)cacheMap.get(mapkey);
            } else {
                String errorInfoCacheKey = "company.error." + dataCompanyStr;
                SelectorItemCollection sic = BizImportUtil.getImportSic();
                sic.add(new SelectorItemInfo("isBizUnit"));
                sic.add(new SelectorItemInfo("isSealUp"));
                sic.add(new SelectorItemInfo("CU.id"));
                sic.add(new SelectorItemInfo("CU.longNumber"));
                companyInfo = (CompanyOrgUnitInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)CompanyOrgUnitFactory.getLocalInstance((Context)ctx), cacheMap, errorInfoCacheKey, sic, companyToken);
                if (!companyInfo.isIsBizUnit()) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"ISNOTBIZUNIT", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
                if (companyInfo.isIsSealUp()) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"ISSEALUP", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
                cacheMap.put(mapkey, companyInfo);
            }
            entryInfo.put("company", (Object)companyInfo);
            mapkey = "companyNotCost." + costToken.data + companyToken.data;
            if (!cacheMap.containsKey(mapkey) && costInfo != null && costInfo.getId() != null && companyInfo != null && companyInfo.getId() != null) {
                String existOql = "SELECT ID WHERE typeRelation.fromType =5 AND typeRelation.toType =1 AND fromUnit = '" + costInfo.getId() + "' AND toUnit = '" + companyInfo.getId() + "'";
                if (!OrgUnitRelationFactory.getLocalInstance((Context)ctx).exists(existOql)) {
                    cacheMap.put(mapkey, true);
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIT_RELATION", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data, costToken.desc, costToken.data}));
                }
                cacheMap.put(mapkey, false);
            } else if (((Boolean)cacheMap.get(mapkey)).booleanValue()) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIT_RELATION", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data, costToken.desc, costToken.data}));
            }
        }
        if (entryInfo.get("costCenter") != null && entryInfo.get("company") == null) {
            entryInfo.put("costCenter", null);
        }
    }

    private static void initImportEntryExpenseTypeAndOperateType(Context ctx, CoreBillEntryBaseInfo entryInfo, Hashtable hsData, Map cacheMap, Map filterItemsMap) throws BOSException, TaskExternalException {
        String dataExpenseTypeStr;
        Object dataExpenseType;
        ExpenseTypeInfo exTypeInfo = null;
        OperationTypeInfo exOpTypeInfo = null;
        DataToken operationTypeDataToken = (DataToken)hsData.get("operationType");
        Object operationTypeData = null;
        if (entryInfo instanceof BizAccountBillEntryInfo || entryInfo instanceof BizAccountOutBillEntryInfo || entryInfo instanceof DailyPurchaseAccountBillEntryInfo || entryInfo instanceof TravelAccountBillEntryInfo) {
            operationTypeData = operationTypeDataToken.data;
        }
        String operationTypeStr = null;
        if (operationTypeData != null) {
            operationTypeStr = operationTypeData.toString();
        }
        if ((dataExpenseType = ((DataToken)hsData.get((Object)"expenseType")).data) != null && (dataExpenseTypeStr = dataExpenseType.toString()) != null && dataExpenseTypeStr.trim().length() > 0) {
            String mapkey = "expenseType_operationType." + dataExpenseTypeStr + "." + operationTypeStr;
            if (cacheMap.containsKey(mapkey)) {
                Map eTypeAndOTypeMap = (Map)cacheMap.get(mapkey);
                exTypeInfo = (ExpenseTypeInfo)eTypeAndOTypeMap.get("expenseType");
                entryInfo.put("expenseType", (Object)exTypeInfo);
                exOpTypeInfo = (OperationTypeInfo)eTypeAndOTypeMap.get("operationType");
                entryInfo.put("operationType", (Object)exOpTypeInfo);
            } else {
                String errorInfoCacheKey = "expenseType_operationType.error." + dataExpenseTypeStr + "." + operationTypeStr;
                TaskExternalException taskExternalException = (TaskExternalException)((Object)cacheMap.get(errorInfoCacheKey));
                if (taskExternalException != null) {
                    throw taskExternalException;
                }
                IExpenseType iExpenseType = ExpenseTypeFactory.getLocalInstance(ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataExpenseTypeStr, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)dataExpenseTypeStr, CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
                if (operationTypeStr != null && operationTypeStr.trim().length() > 0) {
                    filter.getFilterItems().add(new FilterItemInfo("operationType.number", (Object)operationTypeStr, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("operationType.name", (Object)operationTypeStr, CompareType.EQUALS));
                    filter.setMaskString("(#0 or #1) and (#2 or #3)");
                }
                viewInfo.setFilter(filter);
                viewInfo.getSelector().add(new SelectorItemInfo("id"));
                viewInfo.getSelector().add(new SelectorItemInfo("name"));
                viewInfo.getSelector().add(new SelectorItemInfo("number"));
                viewInfo.getSelector().add(new SelectorItemInfo("isLeaf"));
                viewInfo.getSelector().add(new SelectorItemInfo("controlMethod"));
                viewInfo.getSelector().add(new SelectorItemInfo("controlType"));
                viewInfo.getSelector().add(new SelectorItemInfo("company.longNumber"));
                viewInfo.getSelector().add(new SelectorItemInfo("operationType.id"));
                viewInfo.getSelector().add(new SelectorItemInfo("operationType.name"));
                viewInfo.getSelector().add(new SelectorItemInfo("operationType.number"));
                viewInfo.getSelector().add(new SelectorItemInfo("operationType.isEnable"));
                ExpenseTypeCollection expenseTypeCollection = iExpenseType.getExpenseTypeCollection(viewInfo);
                if (expenseTypeCollection != null && expenseTypeCollection.size() > 0) {
                    exTypeInfo = expenseTypeCollection.get(0);
                    exOpTypeInfo = exTypeInfo.getOperationType();
                    if (!exOpTypeInfo.isIsEnable()) {
                        TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"IS_DISABLED", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{operationTypeDataToken.desc, operationTypeDataToken.data}));
                        cacheMap.put(errorInfoCacheKey, e);
                        throw e;
                    }
                    entryInfo.put("expenseType", (Object)exTypeInfo);
                    entryInfo.put("operationType", (Object)exOpTypeInfo);
                    HashMap<String, Serializable> eTypeAndOTypeMap = new HashMap<String, Serializable>();
                    eTypeAndOTypeMap.put("expenseType", exTypeInfo);
                    eTypeAndOTypeMap.put("operationType", exOpTypeInfo);
                    cacheMap.put(mapkey, eTypeAndOTypeMap);
                } else if (operationTypeStr != null && operationTypeStr.trim().length() > 0) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"EOPERATERISNOTEXPENSETYPE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{operationTypeStr, dataExpenseTypeStr}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
            }
            BizImportUtil.validateExpepenseOperation(ctx, entryInfo, hsData, cacheMap, filterItemsMap);
        }
    }

    private static void checkImportExpenseType(Context ctx, CompanyOrgUnitInfo company, ExpenseTypeInfo expenseType) throws TaskExternalException {
        if (company == null || expenseType == null) {
            return;
        }
        if (!expenseType.isIsLeaf()) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"EXPENSETYPEISNOTLEAF", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{expenseType.getName()}));
        }
        CompanyOrgUnitInfo expCom = expenseType.getCompany();
        String expComLongNumber = expCom.getLongNumber();
        String companyLongNumber = company.getLongNumber();
        if (!companyLongNumber.startsWith(expComLongNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"EXPENSETYPEUNAVAILABLE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{company.getName(), expenseType.getName()}));
        }
    }

    private static void validateExpenseTypeRelativeBillType(Context ctx, CoreBillEntryBaseInfo entryInfo, Hashtable rowHashtable, String erroInfoCacheKey, Map cacheMap, Map filterItemsMap) throws TaskExternalException {
        ExpenseTypeInfo exTypeInfo = (ExpenseTypeInfo)entryInfo.get("expenseType");
        String expenseTypeId = exTypeInfo.getId().toString();
        FilterInfo queryFilter = new FilterInfo();
        queryFilter.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseTypeId, CompareType.EQUALS));
        EntityViewInfo queryEntity = new EntityViewInfo();
        queryEntity.setFilter(queryFilter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("billType.id"));
        selector.add(new SelectorItemInfo("billType.number"));
        queryEntity.setSelector(selector);
        CoreBaseCollection expenseTypeEntryCon = null;
        try {
            expenseTypeEntryCon = ExpenseTypeEntryFactory.getLocalInstance(ctx).getCollection(queryEntity);
        }
        catch (BOSException e) {
            logger.error((Object)("cp.bc validateExpenseTypeRelativeBillType error." + e.getMessage()), e.getCause());
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        ArrayList<String> billTypeNumber = new ArrayList<String>();
        int is = expenseTypeEntryCon.size();
        for (int i = 0; i < is; ++i) {
            ExpenseTypeEntryInfo info = (ExpenseTypeEntryInfo)expenseTypeEntryCon.get(i);
            if (info.getBillType() == null) continue;
            billTypeNumber.add(info.getBillType().getNumber());
        }
        String billTypeItem = (String)filterItemsMap.get("billType");
        if (!billTypeNumber.contains(billTypeItem)) {
            Object dataExpenseType = ((DataToken)rowHashtable.get((Object)"expenseType")).data;
            TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"EXPENSETYPE_NOT_RELATE_BILLTYPE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataExpenseType.toString()}));
            cacheMap.put(erroInfoCacheKey, e);
            throw e;
        }
    }

    private static void validateExpepenseOperation(Context ctx, CoreBillEntryBaseInfo entryInfo, Hashtable rowHashtable, Map filterItemsMap, Map cacheMap) throws TaskExternalException, BOSException {
        String companyId = ((CompanyOrgUnitInfo)entryInfo.get("company")).getId().toString();
        String costCenterId = ((CostCenterOrgUnitInfo)entryInfo.get("costCenter")).getId().toString();
        String billType = (String)filterItemsMap.get("billType");
        String operationTypeId = ((OperationTypeInfo)entryInfo.get("operationType")).getId().toString();
        Set operIdsInCompany = null;
        String operIdscacheKey = "operIdsInCompanyCost." + costCenterId;
        if (cacheMap.containsKey(operIdscacheKey)) {
            operIdsInCompany = (Set)cacheMap.get(operIdscacheKey);
        } else {
            try {
                operIdsInCompany = BizBaseDataWebFacadeFactory.getLocalInstance(ctx).getOperationIdsByCompany(companyId, billType, costCenterId);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            cacheMap.put(operIdscacheKey, operIdsInCompany);
        }
        if (!operIdsInCompany.contains(operationTypeId)) {
            DataToken operationTypeDataToken = (DataToken)rowHashtable.get("operationType");
            DataToken companyDataToken = (DataToken)rowHashtable.get("company");
            DataToken costCenterDataToken = (DataToken)rowHashtable.get("costCenter");
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NO_OPER_COMPANYCOST", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{operationTypeDataToken.data, companyDataToken.data, costCenterDataToken.data}));
        }
    }

    public static void validateMaxRowNumber(Context ctx, AtomicInteger countNumber, Integer maxRowNumber) throws TaskExternalException {
        int rowNumber = countNumber.getAndIncrement();
        if (rowNumber > maxRowNumber - 1) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"MAX_ROW_NUMBER", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{maxRowNumber}));
        }
    }

    public static void initImportEntryProject(Context ctx, Hashtable hashtable, Map cacheMap, CoreBillEntryBaseInfo entryInfo, Map filterItemsMap) throws TaskExternalException {
        DataToken projectToken;
        boolean CP033;
        boolean bl = CP033 = filterItemsMap.get("CP033") == null ? false : new Boolean(filterItemsMap.get("CP033").toString());
        if (CP033 && BizImportUtil.isExistData(projectToken = (DataToken)hashtable.get("project"))) {
            String projectlsolate;
            String projectData = projectToken.data.toString().trim();
            String mapkey = "project." + projectData;
            ProjectInfo projectInfo = null;
            if (cacheMap.containsKey(mapkey)) {
                projectInfo = (ProjectInfo)cacheMap.get(mapkey);
            } else {
                String errorInfoCacheKey = "project.error." + projectData;
                SelectorItemCollection importSic = BizImportUtil.getImportSic();
                importSic.add(new SelectorItemInfo("status"));
                importSic.add(new SelectorItemInfo("isListItem"));
                importSic.add(new SelectorItemInfo("company.id"));
                importSic.add(new SelectorItemInfo("company.number"));
                try {
                    projectInfo = (ProjectInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)ProjectFactory.getLocalInstance((Context)ctx), cacheMap, errorInfoCacheKey, importSic, projectToken);
                }
                catch (BOSException e) {
                    logger.error((Object)("cp.bc initImportEntryProject error." + e.getMessage()), e.getCause());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (!projectInfo.isIsListItem()) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"PROJECT_NOT_LISTITEM", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{projectToken.data}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
                if (ProjectStatus.CLOSE.equals((Object)projectInfo.getStatus())) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"PROJECT_CLOSE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{projectToken.data}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
                cacheMap.put(mapkey, projectInfo);
            }
            String string = projectlsolate = filterItemsMap.get("Projectlsolate") == null ? "0" : filterItemsMap.get("Projectlsolate").toString();
            if (!projectlsolate.equals("0")) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)entryInfo.get("company");
                String projectNotCompanyKey = "projectNotCompany." + projectData + company.getId();
                if (!cacheMap.containsKey(projectNotCompanyKey)) {
                    if (projectlsolate.equals("1")) {
                        if (!projectInfo.getCompany().getId().equals((Object)company.getId())) {
                            cacheMap.put(projectNotCompanyKey, true);
                            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"PROJECT_NOT_IN_COMPANY", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{projectToken.data, company.getName()}));
                        }
                        cacheMap.put(projectNotCompanyKey, false);
                    } else if (projectlsolate.equals("2")) {
                        CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[]{company};
                        Set cuIds = new HashSet();
                        try {
                            cuIds = AssistantUtil.getOrgIds((Context)ctx, (CompanyOrgUnitInfo[])companys);
                        }
                        catch (BOSException e) {
                            logger.error((Object)("cp.bc initImportEntryProject error." + e.getMessage()), e.getCause());
                            throw new TaskExternalException(e.getMessage(), (Throwable)e);
                        }
                        if (!cuIds.contains(projectInfo.getCompany().getId().toString())) {
                            cacheMap.put(projectNotCompanyKey, true);
                            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"PROJECT_NOT_IN_COMPANY", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{projectToken.data, company.getName()}));
                        }
                        cacheMap.put(projectNotCompanyKey, false);
                    }
                } else if (((Boolean)cacheMap.get(projectNotCompanyKey)).booleanValue()) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"PROJECT_NOT_IN_COMPANY", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{projectToken.data, company.getName()}));
                }
            }
            entryInfo.put("project", (Object)projectInfo);
        }
    }

    public static AbstractObjectValue getObjectInfo(Context ctx, ICoreBase coreBase, Map cacheMap, String errorInfoCacheKey, SelectorItemCollection selectorItemCollection, DataToken dataToken) throws TaskExternalException, BOSException {
        TaskExternalException taskExternalException = (TaskExternalException)((Object)cacheMap.get(errorInfoCacheKey));
        if (taskExternalException != null) {
            throw taskExternalException;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(BizImportUtil.getImportFilter(dataToken.data.toString().trim()));
        viewInfo.setSelector(selectorItemCollection);
        CoreBaseCollection collection = coreBase.getCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataToken.desc, dataToken.data}));
            cacheMap.put(errorInfoCacheKey, e);
            throw e;
        }
        if (collection.size() == 1) {
            return collection.get(0);
        }
        viewInfo.setFilter(BizImportUtil.getImportNumberFilter(dataToken.data.toString().trim()));
        collection = coreBase.getCollection(viewInfo);
        if (collection.size() == 1) {
            return collection.get(0);
        }
        TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"EXIST_SAME", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataToken.desc, dataToken.data}));
        cacheMap.put(errorInfoCacheKey, e);
        throw e;
    }

    public static boolean isExistData(DataToken dataToken) {
        return dataToken != null && dataToken.data != null && !StringUtils.isEmpty((String)dataToken.data.toString());
    }

    public static FilterInfo getImportFilter(String str) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)str, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        return filter;
    }

    public static FilterInfo getImportNumberFilter(String str) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
        return filter;
    }

    public static FilterInfo getImportFilterPayee(String str) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("payee", (Object)str, CompareType.EQUALS));
        return filter;
    }

    public static SelectorItemCollection getImportSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        return sic;
    }

    public static void checkInportPermission(Context ctx, CompanyOrgUnitInfo company, String permitem, Map cashMap) throws TaskExternalException {
        block8: {
            if (StringUtils.isEmpty((String)permitem) || company == null || cashMap == null) {
                return;
            }
            try {
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                String userId = userInfo.getId().toString();
                String companyId = company.getId().toString();
                HashSet<String> permissionSet = (HashSet<String>)cashMap.get("perm.companySet");
                HashSet<String> permissionNoSet = (HashSet<String>)cashMap.get("perm.NocompanySet");
                if (permissionSet == null) {
                    permissionSet = new HashSet<String>();
                }
                if (permissionNoSet == null) {
                    permissionNoSet = new HashSet<String>();
                }
                if (permissionSet.contains(companyId)) break block8;
                if (permissionNoSet.contains(companyId)) {
                    Object[] params = new Object[]{userInfo.getName(), company.getName()};
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)BCImportRES, (String)"HASNOTPERMISSION"), params));
                }
                boolean hasPerm = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyId), permitem);
                if (hasPerm) {
                    permissionSet.add(companyId);
                    cashMap.put("perm.companySet", permissionSet);
                    break block8;
                }
                permissionNoSet.add(companyId);
                cashMap.put("perm.NocompanySet", permissionNoSet);
                Object[] params = new Object[]{userInfo.getName(), company.getName()};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)BCImportRES, (String)"HASNOTPERMISSION"), params));
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void checkRequiredField(Context ctx, Hashtable hsData, String[] IMP_REQUIRED_FIELDS) throws TaskExternalException {
        for (int i = 0; i < IMP_REQUIRED_FIELDS.length; ++i) {
            DataToken dataToken = (DataToken)hsData.get(IMP_REQUIRED_FIELDS[i]);
            if (dataToken == null || dataToken.data != null && !StringUtils.isEmpty((String)dataToken.data.toString())) continue;
            logger.error((Object)(IMP_REQUIRED_FIELDS[i] + " is null!"));
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"REQUIRED_FIELDS_NULL", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataToken.desc == null ? IMP_REQUIRED_FIELDS[i] : dataToken.desc}));
        }
    }

    public static void initInportDateTimeData(Context ctx, BizCollBillBaseInfo info, CoreBillEntryBaseInfo entryInfo, Hashtable hsData, String[] IMP_DATE_FIELDS, String[] IMP_DATE_OBJS) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        for (int i = 0; i < IMP_DATE_FIELDS.length; ++i) {
            DataToken dataToken = (DataToken)hsData.get(IMP_DATE_FIELDS[i]);
            if (dataToken != null && dataToken.data != null && !StringUtils.isEmpty((String)dataToken.data.toString())) {
                Date value;
                Object o = dataToken.data;
                try {
                    o = df.parse(o.toString());
                }
                catch (ParseException pex) {
                    df = (SimpleDateFormat)MultilingualUtil.getDateFormat(ctx);
                    try {
                        o = df.parse(o.toString());
                    }
                    catch (ParseException e) {
                        logger.error((Object)pex.getMessage());
                        throw new TaskExternalException(dataToken.desc == null ? IMP_DATE_FIELDS[i] : dataToken.desc + ResourceBase.getString((String)RES, (String)"DATAERROE", (Locale)ctx.getOriginLocale()));
                    }
                }
                if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
                if (info != null) {
                    info.setDate(IMP_DATE_OBJS[i], value);
                    continue;
                }
                entryInfo.setDate(IMP_DATE_OBJS[i], value);
                continue;
            }
            if (info != null) {
                info.setDate(IMP_DATE_OBJS[i], new Date());
                continue;
            }
            entryInfo.setDate(IMP_DATE_OBJS[i], new Date());
        }
    }

    @Deprecated
    public static Set<String> getCuNumbers(CompanyOrgUnitInfo company) {
        CtrlUnitInfo ctrlUnitInfo = company.getCU();
        HashSet<String> cuNumSet = new HashSet<String>();
        String longNumber = ctrlUnitInfo.getLongNumber();
        String[] longNumbers = longNumber.split("!");
        cuNumSet.addAll(Arrays.asList(longNumbers));
        cuNumSet.add(company.getNumber());
        return cuNumSet;
    }

    public static void initImportPayerId(Context ctx, CoreBillEntryBaseInfo accountEntryInfo, Hashtable hsData, Map objectMap) throws TaskExternalException {
        String isNoSysPayerValue;
        DataToken payerNameTk = (DataToken)(hsData.get("collectionEntries.payerName") == null ? hsData.get("FPayerName") : hsData.get("collectionEntries.payerName"));
        if (payerNameTk == null) {
            return;
        }
        DataToken isNoSysPayer = (DataToken)hsData.get("isNoSysPayer");
        String string = isNoSysPayerValue = isNoSysPayer == null || isNoSysPayer.data == null || StringUtils.isEmpty((String)isNoSysPayer.data.toString()) ? "0" : isNoSysPayer.data.toString();
        if (!"1".equals(isNoSysPayerValue) && !"0".equals(isNoSysPayerValue)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"ILLEGAL_DATA", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{isNoSysPayer.desc}));
        }
        if (payerNameTk != null && payerNameTk.data != null && !StringUtils.isEmpty((String)payerNameTk.data.toString())) {
            String payerName = payerNameTk.data.toString().trim();
            if ("1".equals(isNoSysPayerValue)) {
                return;
            }
            String payerNamekey = "payerName." + payerName;
            String payerNamekeyError = "payerName.error" + payerName;
            PersonInfo personInfo = new PersonInfo();
            if (objectMap.containsKey(payerNamekey)) {
                personInfo = (PersonInfo)objectMap.get(payerNamekey);
                accountEntryInfo.setString("payerId", personInfo.getId().toString());
                accountEntryInfo.setString("payerNumber", personInfo.getNumber());
                accountEntryInfo.setString("payerName", personInfo.getName());
            } else {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("deletedStatus"));
                try {
                    personInfo = (PersonInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)PersonFactory.getLocalInstance((Context)ctx), objectMap, payerNamekeyError, sic, payerNameTk);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (DeletedStatusEnum.DELETED.equals((Object)personInfo.getDeletedStatus())) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"IS_DISABLED", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{payerNameTk.desc, payerNameTk.data}));
                    objectMap.put(payerNamekeyError, e);
                    throw e;
                }
                accountEntryInfo.setString("payerId", personInfo.getId().toString());
                accountEntryInfo.setString("payerNumber", personInfo.getNumber());
                accountEntryInfo.setString("payerName", personInfo.getName());
                objectMap.put(payerNamekey, personInfo);
            }
        }
    }

    public static void initImportPayerIdByPayerType(Context ctx, CoreBillBaseInfo bill, CoreBillEntryBaseInfo accountEntryInfo, Hashtable hsData, PayerTypeEnum payerType, Map<String, Object> objectMap, Map paramMap) throws TaskExternalException {
        DataToken isNoSysPayer;
        String isNoSysPayerValue;
        DataToken payerNameTk = (DataToken)(hsData.get("collectionEntries.payerName") == null ? hsData.get("FPayerName") : hsData.get("collectionEntries.payerName"));
        if (payerNameTk == null) {
            return;
        }
        CompanyOrgUnitInfo applierCompany = (CompanyOrgUnitInfo)bill.get("applierCompany");
        String companyId = applierCompany.getId().toString();
        String payerName = payerNameTk.data.toString().trim();
        boolean cp075 = false;
        if (paramMap.get("CP075") != null) {
            cp075 = (Boolean)paramMap.get("CP075");
        }
        String string = isNoSysPayerValue = (isNoSysPayer = (DataToken)hsData.get("isNoSysPayer")) == null || isNoSysPayer.data == null || StringUtils.isEmpty((String)isNoSysPayer.data.toString()) ? "0" : isNoSysPayer.data.toString();
        if (!"1".equals(isNoSysPayerValue) && !"0".equals(isNoSysPayerValue)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"ILLEGAL_DATA", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{isNoSysPayer.desc}));
        }
        if (cp075 && "1".equals(isNoSysPayerValue)) {
            return;
        }
        int payerTypeVal = payerType.getValue();
        String payerNameKey = "payerName." + payerName + payerTypeVal + companyId;
        String payerNameKeyError = "payerName.error" + payerName + payerTypeVal + companyId;
        TaskExternalException taskExternalException = (TaskExternalException)((Object)objectMap.get(payerNameKeyError));
        if (taskExternalException != null) {
            throw taskExternalException;
        }
        if (objectMap.containsKey(payerNameKey)) {
            CoreBaseInfo payerInfo = (CoreBaseInfo)objectMap.get(payerNameKey);
            accountEntryInfo.setString("payerId", payerInfo.getId().toString());
            accountEntryInfo.setString("payerNumber", payerInfo.getString("number"));
            accountEntryInfo.setString("payerName", payerInfo.getString("name"));
            return;
        }
        ICustomerCompanyInfo iDynInfo = null;
        FilterInfo filterNamOrNum = null;
        FilterInfo filterNum = null;
        SelectorItemCollection sic = null;
        EntityViewInfo viewInfoNameOrNumber = new EntityViewInfo();
        EntityViewInfo viewInfoNumber = new EntityViewInfo();
        try {
            if (PayerTypeEnum.customer.equals((Object)payerType)) {
                iDynInfo = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
                filterNamOrNum = new FilterInfo();
                filterNum = new FilterInfo();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("customer.id"));
                sic.add(new SelectorItemInfo("customer.number"));
                sic.add(new SelectorItemInfo("customer.name"));
                sic.add(new SelectorItemInfo("customer.usedStatus"));
                sic.add(new SelectorItemInfo("usingStatus"));
                filterNamOrNum.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
                filterNamOrNum.getFilterItems().add(new FilterItemInfo("customer.name", (Object)payerName, CompareType.EQUALS));
                filterNamOrNum.getFilterItems().add(new FilterItemInfo("customer.number", (Object)payerName, CompareType.EQUALS));
                filterNamOrNum.setMaskString("#0 AND (#1 OR #2)");
                filterNum.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
                filterNum.getFilterItems().add(new FilterItemInfo("customer.number", (Object)payerName, CompareType.EQUALS));
            } else if (PayerTypeEnum.supplier.equals((Object)payerType)) {
                iDynInfo = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
                filterNamOrNum = new FilterInfo();
                filterNum = new FilterInfo();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("supplier.id"));
                sic.add(new SelectorItemInfo("supplier.number"));
                sic.add(new SelectorItemInfo("supplier.name"));
                sic.add(new SelectorItemInfo("supplier.usedStatus"));
                sic.add(new SelectorItemInfo("usingStatus"));
                filterNamOrNum.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
                filterNamOrNum.getFilterItems().add(new FilterItemInfo("supplier.name", (Object)payerName, CompareType.EQUALS));
                filterNamOrNum.getFilterItems().add(new FilterItemInfo("supplier.number", (Object)payerName, CompareType.EQUALS));
                filterNamOrNum.setMaskString("#0 AND (#1 OR #2)");
                filterNum.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
                filterNum.getFilterItems().add(new FilterItemInfo("supplier.number", (Object)payerName, CompareType.EQUALS));
            }
            viewInfoNameOrNumber.setFilter(filterNamOrNum);
            viewInfoNameOrNumber.setSelector(sic);
            viewInfoNumber.setFilter(filterNum);
            viewInfoNumber.setSelector(sic);
            if (iDynInfo != null) {
                CoreBaseInfo cusSupCompanyInfo = null;
                CoreBaseCollection cusSupCompanyCol = iDynInfo.getCollection(viewInfoNameOrNumber);
                if (cusSupCompanyCol == null || cusSupCompanyCol.size() == 0) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"CUS_SUP_NOTEXIST", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{payerName, bill.getNumber(), applierCompany.getName()}));
                    objectMap.put(payerNameKeyError, (Object)e);
                    throw e;
                }
                if (cusSupCompanyCol.size() == 1) {
                    cusSupCompanyInfo = cusSupCompanyCol.get(0);
                } else {
                    cusSupCompanyCol = iDynInfo.getCollection(viewInfoNumber);
                    if (cusSupCompanyCol.size() == 1) {
                        cusSupCompanyInfo = cusSupCompanyCol.get(0);
                    } else {
                        TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)RES, (String)"CUS_SUP_EXISTSAME", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{payerName}));
                        objectMap.put(payerNameKeyError, (Object)e);
                        throw e;
                    }
                }
                CoreBaseInfo payerInfo = null;
                int usedStatus = 1;
                int usedStatusFI = 0;
                if (PayerTypeEnum.customer.equals((Object)payerType)) {
                    payerInfo = (CoreBaseInfo)cusSupCompanyInfo.get("customer");
                } else if (PayerTypeEnum.supplier.equals((Object)payerType)) {
                    payerInfo = (CoreBaseInfo)cusSupCompanyInfo.get("supplier");
                }
                if (payerInfo != null) {
                    usedStatus = payerInfo.getInt("usedStatus");
                    usedStatusFI = cusSupCompanyInfo.getInt("usingStatus");
                    if (usedStatus == 0 || usedStatus == 2 || usedStatusFI == 1) {
                        TaskExternalException exp = new TaskExternalException(ResourceBase.getString((String)RES, (String)"CUS_SUP_DISABLED", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{payerName}));
                        objectMap.put(payerNameKeyError, (Object)exp);
                        throw exp;
                    }
                    accountEntryInfo.setString("payerId", payerInfo.getId().toString());
                    accountEntryInfo.setString("payerNumber", payerInfo.getString("number"));
                    accountEntryInfo.setString("payerName", payerInfo.getString("name"));
                    objectMap.put(payerNameKey, payerInfo);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean getParams(Context ctx, String companyId, String paramData) throws TaskExternalException, BOSException, EASBizException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(paramData);
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, companyId);
        return new Boolean(paramMap.get(paramData).toString());
    }

    public static void validateNotNullField(Hashtable hsData, String[] notNullFields, String[] notNullColNames) throws TaskExternalException {
        if (notNullFields == null) {
            return;
        }
        String StrData = null;
        int k = notNullFields.length;
        for (int i = 0; i < k; ++i) {
            DataToken checkValue = (DataToken)hsData.get(notNullFields[i]);
            if (checkValue == null) {
                StrData = notNullColNames == null ? notNullFields[i] : notNullColNames[i];
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"OBJECT_NOT_NULL"), StrData));
            }
            if (checkValue.data != null && !StringUtils.isEmpty((String)checkValue.data.toString())) continue;
            StrData = StringUtils.isEmpty((String)checkValue.desc) ? (notNullColNames == null ? notNullFields[i] : notNullColNames[i]) : checkValue.desc;
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"OBJECT_NOT_NULL"), StrData));
        }
    }

    public static PayerTypeEnum getPayerTypeValue(Context ctx, String value) throws TaskExternalException {
        PayerTypeEnum tSaved = null;
        if (value != null) {
            value = value.trim();
            List EnumList = PayerTypeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                PayerTypeEnum payerTypeEnum = (PayerTypeEnum)((Object)EnumList.get(i));
                String enumValue = String.valueOf(payerTypeEnum.getValue());
                String enumName = payerTypeEnum.getName();
                String enumAlias = payerTypeEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = payerTypeEnum;
                break;
            }
        }
        if (tSaved == null) {
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RES, (String)"PAYERTYPE_NOT_EXIST", (Locale)ctx.getLocale()), value));
        }
        return tSaved;
    }

    public static boolean hasDailyInitImportPermission(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, String initImportPermissionItem, Map personPositionMap) {
        boolean isPermission = true;
        try {
            BizCollUtil.checkInportPermission(ctx, companyOrgUnitInfo, initImportPermissionItem, personPositionMap);
        }
        catch (TaskExternalException te) {
            isPermission = false;
        }
        return isPermission;
    }
}

