/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CPBCPermissionUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.CPBCPermissionUtil");

    public static List<String> getViewPermNameForWeb(String uipk, String fromType) {
        ArrayList<String> permList = new ArrayList<String>();
        if (uipk == null) {
            return permList;
        }
        String perm = null;
        if (uipk.contains("OtherExpenseBill_List")) {
            if (StringUtils.isEmpty((String)fromType)) {
                permList.add("cp_bc_Expense_View");
                permList.add("cp_bc_web_OtherExpenseBill_View");
                permList.add("SSC_cp_bc_web_OtherExpenseBill_View");
            } else if ("fromPerson".equals(fromType)) {
                permList.add("cp_bc_Expense_View");
            } else if ("fromBusiness".equals(fromType)) {
                permList.add("cp_bc_web_OtherExpenseBill_View");
            } else if ("fromSSC".equals(fromType)) {
                permList.add("SSC_cp_bc_web_OtherExpenseBill_View");
            }
        } else {
            if (uipk.contains("EvectionLoanBill_List")) {
                perm = "EvectionLoan_View";
            } else if (uipk.contains("DailyLoanBill_List")) {
                perm = "DailyLoan_View";
            } else if (uipk.contains("BizAccountBill_List")) {
                perm = "ExpenseAccount_View";
            } else if (uipk.contains("TravelAccountBill_List")) {
                perm = "TravelAccount_View";
            } else if (uipk.contains("EvectionReqBill_List")) {
                perm = "EvectionReq_View";
            } else if (uipk.contains("PurchaseAccountBill_List")) {
                perm = "DailyAccount_View";
            } else if (uipk.contains("BizAccountOutBill_List")) {
                perm = "BizAccountOutBill_View";
            } else if (uipk.contains("RePaymentBill_List")) {
                perm = "RePaymentBill_View";
            }
            if (perm == null) {
                return permList;
            }
            if (StringUtils.isEmpty((String)fromType)) {
                permList.add("cp_bc_" + perm);
                permList.add("cp_bc_web_" + perm);
                permList.add("SSC_cp_bc_web_" + perm);
            } else if ("fromPerson".equals(fromType)) {
                permList.add("cp_bc_" + perm);
            } else if ("fromBusiness".equals(fromType)) {
                permList.add("cp_bc_web_" + perm);
            } else if ("fromSSC".equals(fromType)) {
                permList.add("SSC_cp_bc_web_" + perm);
            }
        }
        return permList;
    }

    public static List<String> getViewPermNameForGui(String listUiName) {
        ArrayList<String> permList = new ArrayList<String>();
        String perm = null;
        if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.OtherExpenseReqListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.OtherExpenseReqShareListUI") != -1) {
            permList.add("cp_bc_Expense_View");
            permList.add("cp_bc_web_OtherExpenseBill_View");
        } else {
            if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.BizExpenseAccountListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.BizExpenseAccountShareListUI") != -1) {
                perm = "ExpenseAccount_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.TravelExpenseAccountListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.TravelExpenseAccountShareListUI") != -1) {
                perm = "TravelAccount_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.BizAccountOutBillListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.BizAccountOutBillShareListUI") != -1) {
                perm = "BizAccountOutBill_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.DailyExpenseAccountListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.DailyExpenseAccountShareListUI") != -1) {
                perm = "DailyAccount_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.LoanReqListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.LoanReqShareListUI") != -1) {
                perm = "DailyLoan_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.EvectionLoanBillListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.EvectionLoanBillShareListUI") != -1) {
                perm = "EvectionLoan_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.EvectionReqBillListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.EvectionReqBillShareListUI") != -1) {
                perm = "EvectionReq_View";
            } else if (listUiName.indexOf("com.kingdee.eas.cp.bc.client.RePaymentBillListUI") != -1 || listUiName.indexOf("com.kingdee.eas.cp.bc.client.RePaymentBillShareListUI") != -1) {
                perm = "RePaymentBill_View";
            }
            if (perm == null) {
                return permList;
            }
            permList.add("cp_bc_" + perm);
            permList.add("cp_bc_web_" + perm);
        }
        return permList;
    }

    public static void checkMultiPermission(Context ctx, UserInfo user, CompanyOrgUnitInfo applierCompany, List<String> permItemList) throws EASBizException, BOSException {
        IPermission iPermission;
        IPermission iPermission2 = iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        if (permItemList.size() == 1) {
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(applierCompany.getId().toString()), permItemList.get(0));
        } else {
            boolean hasFunctionPermission = false;
            for (int i = 0; i < permItemList.size(); ++i) {
                if (!iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(applierCompany.getId().toString()), permItemList.get(i))) continue;
                hasFunctionPermission = true;
                break;
            }
        }
    }
}

