/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DailyExpenseAccountEntryAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.DailyExpenseAccountEntryAddByExcel");
    public static final String IMPORTRES = "com.kingdee.eas.cp.bc.ImportDataResource";
    Map<String, Object> commonObjectMap = new HashMap<String, Object>(128);
    String[] IMP_REQUIRED_FIELDS = new String[]{"operationType", "expenseType", "currencyType", "happenTime", "priceWithTax", "count", "costCenter", "company"};
    String[] IMP_BIGDECIMAL_FIELDS_EN = new String[]{"priceWithTax", "count", "exchangeRate", "taxRate", "tax"};
    String[] IMP_STRING_FIELDS_EN = new String[]{"name", "purpose"};
    String[] IMP_DATE_FIELDS_EN = new String[]{"happenTime"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        DailyPurchaseAccountBillEntryInfo entryInfo = new DailyPurchaseAccountBillEntryInfo();
        Hashtable hashtable = (Hashtable)hsData.get(0);
        BizImportUtil.checkRequiredField(ctx, hashtable, this.IMP_REQUIRED_FIELDS);
        Map paramMap = this.getContextMap();
        Map<String, String> filterItemsMap = new HashMap();
        if (paramMap != null && paramMap.get("filterItems") != null) {
            filterItemsMap = (Map)paramMap.get("filterItems");
        }
        BizCollUtil.initInportBigDecimalData(ctx, null, entryInfo, hashtable, this.IMP_BIGDECIMAL_FIELDS_EN, this.IMP_BIGDECIMAL_FIELDS_EN);
        filterItemsMap.put("billType", "DailyPurchaseAccountBill");
        BizImportUtil.initImportEntryCommonData(ctx, entryInfo, hashtable, this.commonObjectMap, filterItemsMap);
        BizImportUtil.initImportEntryProject(ctx, hashtable, this.commonObjectMap, entryInfo, filterItemsMap);
        this.initInportMeasureUnit(ctx, hashtable, filterItemsMap, entryInfo);
        this.initInportAmountAndOri(entryInfo);
        BizCollUtil.initInportStringData(ctx, null, entryInfo, hashtable, this.IMP_STRING_FIELDS_EN, this.IMP_STRING_FIELDS_EN);
        BizCollUtil.initInportDateData(ctx, null, entryInfo, hashtable, this.IMP_DATE_FIELDS_EN, this.IMP_DATE_FIELDS_EN);
        return entryInfo;
    }

    public void initInportAmountAndOri(DailyPurchaseAccountBillEntryInfo entryInfo) {
        BigDecimal priceWithTax = entryInfo.getPriceWithTax();
        BigDecimal taxRate = entryInfo.getTaxRate();
        BigDecimal count = entryInfo.getCount();
        BigDecimal tax = entryInfo.getTax();
        if (BizCollUtil.ZERO.compareTo(taxRate) != 0) {
            tax = priceWithTax.multiply(count).multiply(taxRate).multiply(new BigDecimal(100).divide(taxRate.add(new BigDecimal(100)), 2, 4));
            entryInfo.setTax(tax);
        }
        BigDecimal amountOri = priceWithTax.multiply(count);
        entryInfo.setAmountOri(amountOri);
        BigDecimal amount = BizCollUtil.computeAmount(amountOri, entryInfo.getConvertMode(), entryInfo.getExchangeRate());
        entryInfo.setAmount(amount);
        BigDecimal amountOriWithoutTax = amountOri.subtract(tax);
        entryInfo.setAmountOriWithoutTax(amountOriWithoutTax);
        entryInfo.setPrice(amountOriWithoutTax.divide(count, 2, 4));
        BigDecimal amountWithoutTax = BizCollUtil.computeAmount(amountOriWithoutTax, entryInfo.getConvertMode(), entryInfo.getExchangeRate());
        entryInfo.setAmountWithoutTax(amountWithoutTax);
    }

    public void initInportMeasureUnit(Context ctx, Hashtable hashtable, Map cacheMap, DailyPurchaseAccountBillEntryInfo entryInfo) throws TaskExternalException {
        DataToken measureUnitToken = (DataToken)hashtable.get("measurement");
        if (BizImportUtil.isExistData(measureUnitToken)) {
            String measureUnitData = measureUnitToken.data.toString().trim();
            String mapkey = "measurement." + measureUnitData;
            MeasureUnitInfo measureUnitInfo = null;
            if (cacheMap.containsKey(mapkey)) {
                measureUnitInfo = (MeasureUnitInfo)cacheMap.get(mapkey);
            } else {
                String errorInfoCacheKey = "measurement.error." + measureUnitData;
                SelectorItemCollection sic = BizCollUtil.getInportSic();
                sic.add(new SelectorItemInfo("isDisabled"));
                try {
                    measureUnitInfo = (MeasureUnitInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)MeasureUnitFactory.getLocalInstance((Context)ctx), cacheMap, errorInfoCacheKey, sic, measureUnitToken);
                }
                catch (BOSException e) {
                    logger.error((Object)("cp.bc initInportMeasureUnit error." + e.getMessage()), e.getCause());
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                if (measureUnitInfo.isIsDisabled()) {
                    TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)IMPORTRES, (String)"IS_DISABLED", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{measureUnitToken.desc, measureUnitToken.data}));
                    cacheMap.put(errorInfoCacheKey, e);
                    throw e;
                }
                cacheMap.put(mapkey, measureUnitInfo);
            }
            entryInfo.setMeasurement(measureUnitInfo);
        }
    }

    public int getSubmitType() {
        return 2;
    }
}

