/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CostCenterType;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.SqlInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExpenseTypeSubjectMappingAddByExcel
extends BlockDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.ExpenseTypeSubjectMappingAddByExcel");
    private static final String RESOURCE = "com.kingdee.eas.cp.bc.BCImportExportResource";
    private HashSet<Map> dataSet = new HashSet();
    private HashSet<String> permissionSet = new HashSet();
    private static final String[] notNullFields = new String[]{"FCompany_number", "FExpenseTypeId_number", "FAccountId_number"};
    private static final String[] colNames = new String[]{"\u79d1\u76ee\u6620\u5c04\u6240\u5c5e\u516c\u53f8_\u7f16\u7801", "\u8d39\u7528\u7c7b\u578b_\u7f16\u7801", "\u501f\u65b9\u79d1\u76eeid_\u7f16\u7801", "\u8d37\u65b9\u79d1\u76ee_\u7f16\u7801", "\u63cf\u8ff0_l2", "\u63a7\u5236\u5355\u5143_\u7f16\u7801"};
    private Map objectCacheMap = new HashMap();

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.ExpenseTypeSubjectMappingForImporQuery";
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.SQL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SqlInfo toSQL(Context ctx, IRecord rec) throws TaskExternalException {
        try {
            boolean existSame;
            SqlInfo sqlInfo = new SqlInfo();
            this.validateNotNullField(rec);
            String companyNum = (String)rec.get((String)"FCompany_number").data;
            CompanyOrgUnitInfo company = this.getCompanyOrgUnitInfo(ctx, companyNum);
            String companyOrgId = company.getId().toString();
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            String userId = userInfo.getId().toString();
            if (!this.permissionSet.contains(companyOrgId)) {
                boolean hasPerm = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyOrgId), "cp_bc_SubjectMapping_Import");
                if (hasPerm) {
                    this.permissionSet.add(companyOrgId);
                } else {
                    Object[] params = new Object[]{userInfo.getNumber().toString(), company.getNumber().toString()};
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"USERHOSNOTCOMPANY_IMP_PERMISSION"), params));
                }
            }
            String expenseTypeNum = (String)rec.get((String)"FExpenseTypeId_number").data;
            ExpenseTypeInfo expenseType = this.getExpenseTypeInfo(ctx, expenseTypeNum, company);
            int costCenterTypeVal = 10;
            String costCenterId = null;
            DataToken costCenterTypeData = rec.get("FCostCenterType");
            String costCenterTypeStr = (String)costCenterTypeData.data;
            DataToken costCenterData = rec.get("FCostCenterID_number");
            String costCenter = (String)costCenterData.data;
            CostCenterOrgUnitInfo costCenterInfo = null;
            if (!StringUtil.isEmpty((String)costCenter)) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.appendFilterItem("number", (Object)costCenter);
                ev.setFilter(filter);
                CostCenterOrgUnitCollection costCenterCol = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(ev);
                if (costCenterCol != null && costCenterCol.size() <= 0) throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"COSTCENTER_IS_NULL"), costCenter));
                costCenterInfo = costCenterCol.get(0);
                if (costCenterInfo.getBoolean("isSealUp")) {
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"WRONG_STATE"), costCenter));
                }
                costCenterId = costCenterInfo.getId().toString();
                costCenterTypeVal = costCenterInfo.getCostCenterType().getValue();
            } else {
                CostCenterType costCenterType = null;
                if (!StringUtil.isEmpty((String)costCenterTypeStr)) {
                    costCenterType = ExpenseTypeSubjectMappingAddByExcel.getCostCenterTypeValue(costCenterTypeStr);
                    if (costCenterType == null) throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"COSTCENTERTYPE_IS_NULL"), costCenterTypeStr));
                    costCenterTypeVal = costCenterType.getValue();
                }
            }
            String accountId = this.getAccountIdByNumber(ctx, rec.get((String)"FAccountId_number").data, company, "ACCOUNT");
            String loanAccountId = this.getAccountIdByNumber(ctx, rec.get((String)"FLoanAccountID_number").data, company, "LOANACCOUNT");
            String pCaccountId = this.getAccountIdByNumber(ctx, rec.get((String)"FPCaccountId_number").data, company, "PCACCOUNT");
            String pCloanAccountID = this.getAccountIdByNumber(ctx, rec.get((String)"FPCloanAccountID_number").data, company, "PCLOANACCOUNT");
            String description = (String)rec.get((String)"FDescription_l2").data;
            if (description.length() >= 200) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"DESCRIPTION_LENGTH_ERROR"));
            }
            String CU = company.getCU().getId().toString();
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            tmpMap.put("expenseTypeNumber", expenseType.getNumber());
            tmpMap.put("companyId", companyOrgId);
            tmpMap.put("FCostCenterID", costCenterId);
            tmpMap.put("FCostCenterType", costCenterTypeVal);
            if (this.dataSet.contains(tmpMap)) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"NOT_ALLOW_REPEAT"));
            }
            this.dataSet.add(tmpMap);
            StringBuilder operSql = new StringBuilder();
            StringBuilder existOql = new StringBuilder();
            existOql.append("SELECT FID WHERE expenseTypeId = '").append(expenseType.getId().toString()).append("' AND company = '").append(companyOrgId).append("' AND costCenterType = ").append(costCenterTypeVal);
            if (StringUtil.isEmpty((String)costCenterId)) {
                existOql.append(" AND costCenterID IS null");
            } else {
                existOql.append(" AND costCenterID = '").append(costCenterId).append("'");
            }
            ExpenseTypeSubjectMappingCollection expSubMapCol = ExpenseTypeSubjectMappingFactory.getLocalInstance(ctx).getExpenseTypeSubjectMappingCollection(existOql.toString());
            boolean bl = existSame = expSubMapCol.size() > 0;
            if (existSame && !this.isSltImportUpdate()) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"NOT_ALLOW_REPEAT"));
            }
            if (existSame && this.isSltImportUpdate()) {
                ExpenseTypeSubjectMappingInfo expSubMapInfo = expSubMapCol.get(0);
                operSql.append("UPDATE T_BC_ExpenseTypeSubjectMapping SET ").append("FAccountId = '").append(accountId).append("', ").append("FLoanAccountID = '").append(loanAccountId).append("', ").append("FpcaccountId = '").append(pCaccountId).append("', ").append("FpcloanAccountID = '").append(pCloanAccountID).append("', ").append("FDescription_l2 = '").append(description).append("', ").append("FControlUnitID = '").append(CU).append("', ").append("FLASTUPDATEUSERID = '").append(userId).append("', ").append("FCostCenterType = ").append(costCenterTypeVal).append(", ");
                if (!StringUtil.isEmpty((String)costCenterId)) {
                    operSql.append("FCostCenterID = '").append(costCenterId).append("', ");
                } else {
                    operSql.append("FCostCenterID = null, ");
                }
                operSql.append("FLASTUPDATETIME = getdate() ").append(" WHERE fid = '").append(expSubMapInfo.getId().toString()).append("' ");
            } else {
                operSql.append("INSERT INTO T_BC_ExpenseTypeSubjectMapping ").append("(FID, FExpenseTypeId, FAccountId, FLoanAccountID, FCompanyID, FpcaccountId, FpcloanAccountID, ").append("FDescription_l2, FControlUnitID, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME,").append("FCostCenterType,FCostCenterID").append(") VALUES (").append("NEWBOSID('62E067B6')").append(", ").append("'").append(expenseType.getId().toString()).append("', ").append("'").append(accountId).append("', ").append("'").append(loanAccountId).append("', ").append("'").append(companyOrgId).append("', ").append("'").append(pCaccountId).append("', ").append("'").append(pCloanAccountID).append("', ").append("'").append(description).append("', ").append("'").append(CU).append("', ").append("'").append(userId).append("', ").append("getdate(),").append("'").append(userId).append("', ").append("getdate(), ").append(costCenterTypeVal).append(", ");
                if (!StringUtil.isEmpty((String)costCenterId)) {
                    operSql.append("'").append(costCenterId).append("')");
                } else {
                    operSql.append("null)");
                }
            }
            sqlInfo.setSql(operSql.toString());
            return sqlInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExpenseTypeInfo getExpenseTypeInfo(Context ctx, String expenseTypeNum, CompanyOrgUnitInfo companyOrgUnitInfo) throws TaskExternalException, BOSException {
        if (this.objectCacheMap.containsKey(expenseTypeNum)) {
            return (ExpenseTypeInfo)this.objectCacheMap.get(expenseTypeNum);
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("number", (Object)expenseTypeNum));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filterInfo);
        IExpenseType iExpenseType = ExpenseTypeFactory.getLocalInstance(ctx);
        ExpenseTypeCollection expenseTypeCol = iExpenseType.getExpenseTypeCollection(ev);
        ExpenseTypeInfo expenseTypeInfo = null;
        if (expenseTypeCol.size() <= 0) throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"FEXPENSETYPENUMBERISNOTEXISTINBASEINFO"), expenseTypeNum));
        String ln = companyOrgUnitInfo.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            lnUps.add(lnSecs[i]);
        }
        if (!lnUps.isEmpty()) {
            fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
            filterInfo.setMaskString("#0 and #1");
            ev.setFilter(filterInfo);
        }
        if ((expenseTypeCol = iExpenseType.getExpenseTypeCollection(ev)).size() <= 0) throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"HASNOTEXPTYPEPERMISSION_IMP"), expenseTypeNum, companyOrgUnitInfo.getNumber()));
        expenseTypeInfo = expenseTypeCol.get(0);
        if (!expenseTypeInfo.getBoolean("isStart")) {
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"WRONG_STATE"), expenseTypeNum));
        }
        if (!expenseTypeInfo.getBoolean("isLeaf")) {
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"WRONG_ISLEAF"), expenseTypeNum));
        }
        this.objectCacheMap.put(expenseTypeNum, expenseTypeInfo);
        return expenseTypeInfo;
    }

    public static String getCostCenterTypeAlias(String value) {
        String alias = "";
        if (value != null) {
            value = value.trim();
            List EnumList = CostCenterType.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                CostCenterType costCenterTypeEnum = (CostCenterType)((Object)EnumList.get(i));
                String enumValue = String.valueOf(costCenterTypeEnum.getValue());
                String enumName = costCenterTypeEnum.getName();
                String enumAlias = costCenterTypeEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                alias = costCenterTypeEnum.getAlias();
                break;
            }
        }
        return alias;
    }

    public static CostCenterType getCostCenterTypeValue(String value) {
        CostCenterType tSaved = null;
        if (value != null) {
            value = value.trim();
            List EnumList = CostCenterType.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                CostCenterType costCenterTypeEnum = (CostCenterType)((Object)EnumList.get(i));
                String enumValue = String.valueOf(costCenterTypeEnum.getValue());
                String enumName = costCenterTypeEnum.getName();
                String enumAlias = costCenterTypeEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = costCenterTypeEnum;
                break;
            }
        }
        return tSaved;
    }

    private String getAccountIdByNumber(Context ctx, Object data, CompanyOrgUnitInfo company, String type) throws TaskExternalException, EASBizException, BOSException {
        AccountViewInfo account;
        String accountId = "";
        String accountNumber = (String)data;
        if (null != accountNumber && !accountNumber.equals("") && null != (account = this.getAccountViewInfoByNumber(ctx, accountNumber, company, type))) {
            accountId = account.getId().toString();
        }
        return accountId;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        FilterInfo filterInfo = new FilterInfo();
        if (paramMap.get("filterItems") != null) {
            String filterValue = paramMap.get("filterItems").toString();
            try {
                filterInfo = new FilterInfo(filterValue);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            filterInfo = new FilterInfo();
            FilterItemCollection fic = filterInfo.getFilterItems();
            CompanyOrgUnitInfo cui = ContextUtil.getCurrentFIUnit((Context)ctx);
            fic.add(new FilterItemInfo("company.id", (Object)cui.getId().toString()));
            String ln = cui.getLongNumber();
            String[] lnSecs = ln.split("!");
            int size = lnSecs.length;
            HashSet<String> lnUps = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                lnUps.add(lnSecs[i]);
            }
            if (!lnUps.isEmpty()) {
                fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
                filterInfo.setMaskString("#0 or #1");
            }
        }
        return filterInfo;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FExpenseTypeId_number", StringUtils.defaultString((String)rs.getString("expenseTypeId.number")));
            result.put("FCompany_number", StringUtils.defaultString((String)rs.getString("company.number")));
            result.put("FAccountId_number", StringUtils.defaultString((String)rs.getString("accountId.number")));
            result.put("FLoanAccountID_number", StringUtils.defaultString((String)rs.getString("loanAccountID.number")));
            result.put("FDescription_l2", StringUtils.defaultString((String)rs.getString("description")));
            result.put("FPCaccountId_number", StringUtils.defaultString((String)rs.getString("PCaccountId.number")));
            result.put("FPCloanAccountID_number", StringUtils.defaultString((String)rs.getString("PCloanAccountID.number")));
            result.put("FCostCenterType", StringUtils.defaultString((String)ExpenseTypeSubjectMappingAddByExcel.getCostCenterTypeAlias(rs.getString("costCenterType"))));
            result.put("FCostCenterID_number", StringUtils.defaultString((String)rs.getString("costCenterID.number")));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private AccountViewInfo getAccountViewInfoByNumber(Context ctx, String fAccountNumber, CompanyOrgUnitInfo company, String type) throws TaskExternalException, BOSException, EASBizException {
        if (company.getAccountTable() == null) {
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"ACCOUNT_TABLE_DISABLE"), company.getNumber()));
        }
        AccountViewInfo account = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String companyId = company.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fAccountNumber));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)company.getAccountTable().getId().toString()));
        view.setFilter(filter);
        AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (coll != null && coll.size() > 0) {
            account = coll.get(0);
            if (account != null && !account.getBoolean("isLeaf")) {
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"WRONG_ISLEAF"), fAccountNumber));
            }
            if (account != null && account.getBoolean("isCFreeze")) {
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)(type + "_NOT_ENABLE")), fAccountNumber));
            }
        } else {
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)(type + "ID_NOT_IN_COMPANY")), fAccountNumber, company.getNumber()));
        }
        return account;
    }

    @Deprecated
    private AccountViewInfo getLoanAccountViewInfoByNumber(Context ctx, String fAccountNumber, String fCompanyId) throws TaskExternalException, BOSException, EASBizException {
        AccountViewInfo account = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fAccountNumber));
        filter.getFilterItems().add(new FilterItemInfo("companyID", (Object)fCompanyId));
        view.setFilter(filter);
        AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        if (coll != null && coll.size() > 0) {
            int flag = 0;
            for (int i = 0; i < coll.size(); ++i) {
                AccountViewInfo avInfo = coll.get(i);
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("accountTable", (Object)avInfo.getAccountTableID().getId()));
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)fCompanyId, CompareType.EQUALS));
                if (!CompanyOrgUnitFactory.getLocalInstance((Context)ctx).exists(fi)) continue;
                account = coll.get(i);
                ++flag;
            }
            if (flag == 0) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"LOANACCOUNT_NOT_ENABLE"));
            }
        } else {
            throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"LOANACCOUNTID_NOT_IN_COMPANY"));
        }
        return account;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String companyNum) throws TaskExternalException, BOSException {
        if (this.objectCacheMap.containsKey(companyNum)) {
            return (CompanyOrgUnitInfo)this.objectCacheMap.get(companyNum);
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String comSql = " select id, number, isSealUp, isAssistantOrg, accountTable, longNumber, CU.longNumber where number = '" + companyNum + "'";
        CompanyOrgUnitCollection companyOrgUnitCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(comSql);
        if (companyOrgUnitCol.size() > 0) {
            companyOrgUnitInfo = companyOrgUnitCol.get(0);
            if (companyOrgUnitInfo.getBoolean("isSealUp")) {
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"WRONG_STATE"), companyNum));
            }
        } else {
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"FCOMPANYNUMBERISNOTEXISTINBASEINFO"), companyNum));
        }
        this.objectCacheMap.put(companyNum, companyOrgUnitInfo);
        return companyOrgUnitInfo;
    }

    @Deprecated
    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByNumber(Context ctx, String fCompanyNumber) throws TaskExternalException, BOSException {
        CompanyOrgUnitInfo company = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fCompanyNumber));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            Object[] params = new Object[]{"\u79d1\u76ee\u6620\u5c04\u6240\u5c5e\u516c\u53f8_\u7f16\u7801", fCompanyNumber};
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NUMBER_NOT_EXIST"), params));
        }
        company = coll.get(0);
        return company;
    }

    private void validateNotNullField(IRecord rec) throws TaskExternalException {
        DataToken dataToken = new DataToken();
        int il = notNullFields.length;
        for (int i = 0; i < il; ++i) {
            dataToken = rec.get(notNullFields[i]);
            if (dataToken == null) {
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NOT_NULL"), colNames[i]));
            }
            if (dataToken.data != null && !StringUtils.isEmpty((String)dataToken.data.toString())) continue;
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NOT_NULL"), StringUtils.isEmpty((String)dataToken.desc) ? colNames[i] : dataToken.desc));
        }
    }

    @Deprecated
    private ObjectBaseInfo getInfoByNumber(Context ctx, IRecord rec, BOSObjectType type, String propName) throws TaskExternalException {
        try {
            DataToken dataToken = rec.get(propName);
            String number = (String)dataToken.data;
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            StringBuffer queryOql = new StringBuffer();
            queryOql.append("SELECT ID, NUMBER ");
            if (new ExpenseTypeInfo().getBOSType().equals((Object)type)) {
                queryOql.append(", CONTROLTYPE, isLeaf, isStart ");
            }
            queryOql.append("WHERE NUMBER = '%s'");
            IObjectCollection collection = iDynamicObject.getCollection(type, String.format(queryOql.toString(), number));
            if (collection == null || collection.size() == 0) {
                Object[] params = new Object[]{dataToken.desc, number};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NUMBER_NOT_EXIST"), params));
            }
            return (ObjectBaseInfo)collection.getObject(0);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ExpenseTypeSubjectMappingFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            logger.error((Object)bex.getMessage(), (Throwable)bex);
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }
}

