/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteWebServerHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IPrintConfigFacade;
import com.kingdee.eas.common.PrintConfigFacadeFactory;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizOutTicketEntryInfo;
import com.kingdee.eas.cp.bc.CPBCCheckStates;
import com.kingdee.eas.cp.bc.CollectionAccountCoreBaseInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EntryStateEnum;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IExpenseAccountBill;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IInvoiceFacade;
import com.kingdee.eas.cp.bc.IInvoiceType;
import com.kingdee.eas.cp.bc.IInvoiceTypeEntry;
import com.kingdee.eas.cp.bc.InvoiceException;
import com.kingdee.eas.cp.bc.InvoiceFacadeFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeCollection;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryCollection;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryInfo;
import com.kingdee.eas.cp.bc.InvoiceTypeEnum;
import com.kingdee.eas.cp.bc.InvoiceTypeFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeInfo;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.PurTicketEntryCollection;
import com.kingdee.eas.cp.bc.PurTicketEntryInfo;
import com.kingdee.eas.cp.bc.SourceSystem;
import com.kingdee.eas.cp.bc.TicketBaseEntryInfo;
import com.kingdee.eas.cp.bc.TicketEntryInfo;
import com.kingdee.eas.cp.bc.TraTicketEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.util.BizCollBillDataProvider;
import com.kingdee.eas.cp.bc.util.CPBCCommonParams;
import com.kingdee.eas.cp.bc.util.InvoiceConfiguration;
import com.kingdee.eas.cp.bc.util.MD5;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class InvoiceUtil {
    private static Logger logger = Logger.getLogger(InvoiceUtil.class);
    private static final Map<String, String> NonVATInvoiceMap = new HashMap<String, String>();
    private static final Map<String, String> ticketDataByString = new HashMap<String, String>(){
        {
            this.put("invoiceCode", "ticketCode");
            this.put("invoiceNo", "ticketNumber");
            this.put("serialNo", "serialNo");
            this.put("invoiceDate", "billingDate");
            this.put("checkStatus", "checkStates");
            this.put("salerName", "salerName");
        }
    };
    private static final Map<String, String> ticketDataByBigDecimal = new HashMap<String, String>(){
        {
            this.put("taxAmount", "tax");
            this.put("taxRate", "taxRate");
        }
    };
    private static InvoiceConfiguration invoice = InvoiceConfiguration.getInstance();
    private static final String invoiceResource = "com.kingdee.eas.cp.bc.InvoiceResource";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String TAX_NUMBER = "taxNumber";
    private static final String REGISTERED_CODE = "registeredCode";
    private static final String INVOICE_NUM_STR = "\u5f20";
    private static final String INVOICE_STR = "\u53d1\u7968";
    private static final String BIZOUT_BILL = "BizOut";
    private static final String PUR_BILL = "Pur";
    private static final String TRA_BILL = "Tra";
    private static boolean RETURNlOG = true;
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");

    public static String getSaveInvoiceSigniture(String clientId, String clientSecret, Long timeStamp) {
        return MD5.md5crypt(clientId + clientSecret + timeStamp);
    }

    public static String getBindInitSigniture(String clientId, String clientSecret, Long timeStamp) {
        return MD5.md5crypt(clientId + timeStamp + clientSecret);
    }

    private static String getDefaultDescription(Context ctx) {
        return ResourceBase.getString((String)invoiceResource, (String)"REFRETOAPUSIC", (Locale)ctx.getLocale());
    }

    public static Long getTimeStamp() {
        return System.currentTimeMillis();
    }

    @Deprecated
    public static boolean updateInvoiceState(String clientId, String clientSecret, BizCollBillBaseInfo billInfo, Context ctx, int state) throws BOSException, EASBizException {
        JSONObject billJson = InvoiceUtil.getUpdateStateBillJson(ctx, billInfo, state);
        String url = invoice.getInvoiceUrl() + invoice.getUpdateInvoiceState();
        String result = InvoiceUtil.httpsRequestPost(url, billJson.toString(), "utf-8");
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (null != parseObject.get((Object)"errcode") && !"".equals(parseObject.get((Object)"errcode"))) {
            result = parseObject.get((Object)"errcode").toString();
        }
        if (!"0000".equals(result)) {
            throw new InvoiceException(InvoiceException.UPDATETICKETSTATEERROR);
        }
        return true;
    }

    @Deprecated
    public static String updateInvoiceStateReturnString(Context ctx, BOSUuid billId, int stateCode) throws BOSException, EASBizException {
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        BizCollBillBaseInfo billInfo = iBizCollBillBase.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), InvoiceUtil.getBillSic());
        String result = InvoiceUtil.updateInvoiceStateReturnString(ctx, billInfo, stateCode, null);
        return result;
    }

    public static String updateInvoiceStateReturnString(Context ctx, BizCollBillBaseInfo billInfo, int stateCode, Map paramMap) throws BOSException, EASBizException {
        logger.error((Object)("##cpbc updateInvoiceStateReturnString start number=" + billInfo.getNumber()));
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)billInfo.get("tickeEntries");
        if (SourceSystem.CQ.equals((Object)billInfo.getSourceSystem()) || ticketEntries.size() <= 0) {
            return "";
        }
        JSONObject billJson = InvoiceUtil.getUpdateStateBillJson(ctx, billInfo, stateCode, paramMap);
        String description = InvoiceUtil.getDefaultDescription(ctx);
        String url = invoice.getInvoiceUrl() + invoice.getUpdateInvoiceState();
        String result = InvoiceUtil.httpsRequestPost(url, billJson.toString(), "utf-8");
        if (result == null) {
            return null;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            result = parseObject.getString("description");
            throw new InvoiceException(InvoiceException.UPDATETICKETSTATEERRORMESSAGE, new Object[]{"FID:" + billInfo.getId() + ";" + result});
        }
        logger.error((Object)("##cpbc updateInvoiceStateReturnString end number=" + billInfo.getId() + ",result=" + result));
        return result;
    }

    @Deprecated
    public static JSONObject getUpdateStateBillJson(Context ctx, BizCollBillBaseInfo billInfo, int state) throws BOSException, EASBizException {
        return InvoiceUtil.getUpdateStateBillJson(ctx, billInfo, state, null);
    }

    public static JSONObject getUpdateStateBillJson(Context ctx, BizCollBillBaseInfo billInfo, int state, Map paramMap) throws BOSException, EASBizException {
        JSONObject billJson = new JSONObject();
        if (BizCollUtil.objectIsNull(billInfo.getApplierCompany())) {
            throw new InvoiceException(InvoiceException.APPLIERCOMPANYISNULL);
        }
        String applierCompanyId = billInfo.getApplierCompany().getId().toString();
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, billInfo);
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        Long timeStamp = InvoiceUtil.getTimeStamp();
        UserInfo user = billInfo.getBiller();
        if (user == null) {
            logger.error((Object)("#####cpbc \u53cd\u5ba1\u6838111 biller:" + user + "," + billInfo.getBiller() + "###,billInfo:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)billInfo)));
            throw new InvoiceException(InvoiceException.BILLERISNULL);
        }
        String ticketParam = InvoiceUtil.getTicketParam(ctx, applierCompanyId);
        billJson.put("client_id", (Object)clientId);
        billJson.put("client_secret", (Object)clientSecret);
        billJson.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        billJson.put("timestamp", (Object)timeStamp);
        billJson.put("bxd_key", (Object)billInfo.getId().toString());
        billJson.put("billTypeId", (Object)billInfo.getId().getType());
        billJson.put("eid", (Object)user.getId().toString());
        billJson.put("userKey", (Object)"");
        billJson.put("ticketParam", (Object)ticketParam);
        billJson.put("expenseStatus", (Object)state);
        boolean isTicketAndTm = false;
        if (paramMap != null) {
            boolean bl = isTicketAndTm = paramMap.get("isTicketAndTm") == null ? false : new Boolean(paramMap.get("isTicketAndTm").toString());
        }
        if (isTicketAndTm && (state == 1 || state == 60)) {
            JSONArray invoiceData = InvoiceUtil.getInvoiceDataJArray(ctx, billInfo, state);
            billJson.put("invoiceData", (Object)invoiceData);
        }
        return billJson;
    }

    public static String saveInvoiceSigniture(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String url = invoice.getInvoiceUrl() + invoice.getSaveInvoice();
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result == null) {
            return null;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new InvoiceException(InvoiceException.SAVETICKETRELATIONERRORMESSAGE, new Object[]{parseObject.getString("description")});
        }
        return result;
    }

    @Deprecated
    public static boolean saveInvoiceCacheSigniture(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String url = invoice.getInvoiceUrl() + invoice.getSaveCacheInvoice();
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result == null) {
            return false;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new BOSException(parseObject.getString("description"));
        }
        return false;
    }

    public static void saveTicketAndUpdateTicketState(Context ctx, BizCollBillBaseInfo info, Map<String, Object> paramMap, String action) throws EASBizException, BOSException {
        String result = InvoiceUtil.saveTicketRelation(ctx, info, paramMap, action);
        if ("0000".equals(result) && "submit".equals(action)) {
            InvoiceUtil.updateInvoiceStateReturnString(ctx, info, 30, paramMap);
        }
    }

    public static String saveTicketRelation(Context ctx, BizCollBillBaseInfo info, Map<String, Object> paramMap, String action) throws BOSException, EASBizException {
        JSONObject retunObject = InvoiceUtil.getSaveTicketBillJson(ctx, info);
        InvoiceUtil.checkTicketRepeat(ctx, info, action, retunObject, paramMap);
        logger.error((Object)"##### cpbc saveTicketRelation start");
        String result = InvoiceUtil.saveInvoiceSigniture(ctx, retunObject);
        Map<String, String> errorMap = InvoiceUtil.resolvingErrCode(result);
        logger.error((Object)("##### cpbc saveTicketRelation end #####  result= " + result));
        return errorMap.get("errcode");
    }

    public static void checkTicketRepeat(Context ctx, BizCollBillBaseInfo info, String action, JSONObject retunObject, Map<String, Object> paramMap) throws EASBizException, BOSException {
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)info.get("tickeEntries");
        if ("submit".equals(action)) {
            boolean isTicketReportCover;
            boolean isTicketRepeat = paramMap.get("CP03901") == null ? false : new Boolean(paramMap.get("CP03901").toString());
            boolean bl = isTicketReportCover = paramMap.get("CP03907") == null ? false : new Boolean(paramMap.get("CP03907").toString());
            if (!isTicketRepeat && ticketEntries.size() > 0) {
                logger.error((Object)"####### cp03901 is false, check ticket repeat");
                String returnString = InvoiceUtil.checkTicketState(retunObject);
                Map<String, String> returnJson = InvoiceUtil.resolvingErrCode(returnString);
                String errCode = returnJson.get("errcode");
                if (errCode != null && "0423".equals(errCode)) {
                    throw new InvoiceException(InvoiceException.REPEATEDREIMBURSEMENT);
                }
                if (errCode != null && "0424".equals(errCode)) {
                    InvoiceUtil.checkBillState(ctx, returnJson, info);
                }
            }
            if (isTicketReportCover) {
                boolean isFromWFSubmit;
                boolean bl2 = isFromWFSubmit = paramMap.get("isFromWFSubmit") == null ? false : Boolean.valueOf(paramMap.get("isFromWFSubmit").toString());
                if (!isFromWFSubmit) {
                    String encodeBase64String = Base64.encodeBase64String((byte[])InvoiceUtil.getReportCoverStream(ctx, info));
                    retunObject.put("coverBase64", (Object)encodeBase64String);
                    retunObject.put("coverFileType", (Object)"pdf");
                }
            }
            retunObject.put("coverNumber", (Object)info.getImageNo());
        }
    }

    public static JSONObject getSaveTicketBillJson(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        String billTypeId = info.getId().getType().toString();
        JSONArray entriesJson = InvoiceUtil.getEntryAndTicketRelation(ctx, info);
        Long timeStamp = InvoiceUtil.getTimeStamp();
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, info);
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        String taxpayerId = clientMap.get(TAX_NUMBER);
        UserInfo user = info.getBiller();
        if (user == null) {
            throw new InvoiceException(InvoiceException.BILLERISNULL);
        }
        JSONObject retunObject = new JSONObject();
        retunObject.put("userKey", (Object)"");
        retunObject.put("eid", (Object)user.getId().toString());
        retunObject.put("billTypeId", (Object)billTypeId);
        retunObject.put("bxd_key", (Object)info.getId().toString());
        retunObject.put("client_id", (Object)clientId);
        retunObject.put("tin", (Object)taxpayerId);
        retunObject.put("billnumber", (Object)info.getNumber());
        retunObject.put("timestamp", (Object)timeStamp);
        retunObject.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        retunObject.put("data", (Object)entriesJson);
        retunObject.put("billType", (Object)(info.getBillTypeCode() != null ? info.getBillTypeCode().getAlias() : ""));
        retunObject.put("expensePersonId", (Object)(info.getApplier() != null ? info.getApplier().getId().toString() : ""));
        retunObject.put("expensePersonName", (Object)(info.getApplier() != null ? info.getApplier().getName() : ""));
        retunObject.put("realExpenseAmount", (Object)InvoiceUtil.getBillExpenseAmountOriSum(ctx, info));
        retunObject.put("remark", (Object)info.getCause());
        retunObject.put("starrySkyOrgId", (Object)(info.getApplierCompany() != null ? info.getApplierCompany().getNumber() : ""));
        return retunObject;
    }

    private static JSONArray getEntryAndTicketRelation(Context ctx, BizCollBillBaseInfo info) {
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)info.get("tickeEntries");
        AbstractObjectCollection entries = (AbstractObjectCollection)info.get("entries");
        JSONArray entriesJson = new JSONArray();
        if (ticketEntries != null && ticketEntries.size() > 0) {
            InvoiceUtil.getBizRelation(info, entriesJson, ticketEntries, entries);
        }
        return entriesJson;
    }

    public static BigDecimal getBillExpenseAmountOriSum(Context ctx, BizCollBillBaseInfo info) {
        BigDecimal amountOriSum = BigDecimal.ZERO;
        BigDecimal entryAmountOri = BigDecimal.ZERO;
        AbstractObjectCollection entries = (AbstractObjectCollection)info.get("entries");
        for (CoreBillEntryBaseInfo entry : entries) {
            entryAmountOri = entry.getBigDecimal("amountOri") == null ? BigDecimal.ZERO : entry.getBigDecimal("amountOri");
            amountOriSum = amountOriSum.add(entryAmountOri);
        }
        return amountOriSum;
    }

    @Deprecated
    private static void getPurRelation(BizCollBillBaseInfo info, JSONArray entriesJson, AbstractObjectCollection entries) {
        Iterator iterator = entries.iterator();
        String expenseTypeId = null;
        String expenseTypeName = null;
        while (iterator.hasNext()) {
            CoreBillEntryBaseInfo entrie = (CoreBillEntryBaseInfo)iterator.next();
            if (BizCollUtil.objectIsNull(entrie.getString("entrySerialNo"))) continue;
            BOSUuid entryId = entrie.getId();
            ExpenseTypeInfo expenseType = (ExpenseTypeInfo)entrie.get("expenseType");
            if (expenseType != null) {
                expenseTypeId = expenseType.getId().toString();
                expenseTypeName = expenseType.getName();
            }
            JSONObject entryJsonNew = new JSONObject();
            JSONArray fids = new JSONArray();
            fids.add((Object)entrie.getString("entrySerialNo"));
            entryJsonNew.put("entryid", (Object)entryId.toString());
            entryJsonNew.put("fid", (Object)fids);
            entryJsonNew.put("costTypeId", (Object)expenseTypeId);
            entryJsonNew.put("costTypeName", (Object)expenseTypeName);
            entriesJson.add((Object)entryJsonNew);
        }
    }

    private static void getBizRelation(BizCollBillBaseInfo info, JSONArray entriesJson, AbstractObjectCollection ticketEntries, AbstractObjectCollection entries) {
        String fid;
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (CoreBillEntryBaseInfo ticket : ticketEntries) {
            String bizEntryId = InvoiceUtil.getBizEntryBill(ticket);
            if (bizEntryId == null) continue;
            if (entryMap.containsKey(bizEntryId)) {
                fid = (String)entryMap.get(bizEntryId);
                fid = fid + "," + ticket.get("serialNo");
                entryMap.put(bizEntryId, fid);
                continue;
            }
            entryMap.put(bizEntryId, (String)ticket.get("serialNo"));
        }
        for (Map.Entry key : entryMap.entrySet()) {
            fid = (String)key.getValue();
            String entryId = (String)key.getKey();
            ExpenseTypeInfo expenseType = null;
            String expenseTypeId = null;
            String expenseTypeName = null;
            if (!BizCollUtil.objectIsNull(entries.getObject((Object)entryId))) {
                expenseType = (ExpenseTypeInfo)entries.getObject((Object)entryId).get("expenseType");
            }
            if (expenseType != null) {
                expenseTypeId = expenseType.getId().toString();
                expenseTypeName = expenseType.getName();
            }
            if (!StringUtils.isNotBlank((String)fid)) continue;
            String[] split = fid.split(",");
            JSONObject entryJsonNew = new JSONObject();
            entryJsonNew.put("entryid", (Object)entryId);
            entryJsonNew.put("fid", (Object)split);
            entryJsonNew.put("costTypeId", (Object)expenseTypeId);
            entryJsonNew.put("costTypeName", (Object)expenseTypeName);
            entriesJson.add((Object)entryJsonNew);
        }
    }

    public static String checkTicketState(JSONObject jsonObject) throws EASBizException, BOSException {
        String url = invoice.getInvoiceUrl() + invoice.getCheckTicket();
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result != null) {
            logger.error((Object)("#####cpbc runner check ticket state result = " + result));
            return result;
        }
        return null;
    }

    public static Map<String, String> resolvingErrCode(String returnString) {
        String errcode = "";
        String data = "";
        HashMap<String, String> returnJson = new HashMap<String, String>();
        if (!BizCollUtil.objectIsNull(returnString)) {
            try {
                JSONObject parseObject = JSONObject.parseObject((String)returnString);
                if (null != parseObject.get((Object)"errcode")) {
                    errcode = parseObject.get((Object)"errcode").toString();
                }
                if (null != parseObject.getJSONObject("data")) {
                    data = parseObject.getJSONObject("data").toString();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            returnJson.put("errcode", errcode);
            returnJson.put("data", data);
        }
        return returnJson;
    }

    public static void checkBillState(Context ctx, Map<String, String> returnJson, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        String data = returnJson.get("data");
        String expenseId = JSONObject.parseObject((String)data).getString("bxd_key");
        if (expenseId != null) {
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            String[] split = expenseId.split(",");
            String oql = "";
            ICoreBase bizCtrl = null;
            for (String billId : split) {
                if (!StringUtils.isNotBlank((String)billId) || billId.equals(info.getId().toString())) continue;
                BOSObjectType objectType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
                boolean isCpbcBill = false;
                boolean isRepeat = true;
                if (objectType != null) {
                    boolean bl = isCpbcBill = objectType != null && (BizCollUtil.bizAccountBillBosType.equals((Object)objectType) || BizCollUtil.travelAccountBillBosType.equals((Object)objectType) || BizCollUtil.bizAccountOutBillBosType.equals((Object)objectType) || BizCollUtil.dailyPurchaseAccountBillBosType.equals((Object)objectType));
                    if (!isCpbcBill) {
                        bizCtrl = BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)billId));
                        boolean bl2 = isCpbcBill = bizCtrl instanceof IBizCollBillBase;
                    }
                    if (isCpbcBill) {
                        oql = "select id where state not in (20, 27, 40) and id ='" + billId + "'";
                        isRepeat = iDynamicObject.exists(new ObjectUuidPK(billId).getObjectType(), oql);
                    }
                }
                if (!isRepeat) continue;
                JSONArray invoiceDatas = JSONObject.parseArray((String)JSONObject.parseObject((String)data).getString("invoice"));
                StringBuilder invoiceIdArray = new StringBuilder();
                StringBuilder invoiceSeq = new StringBuilder();
                int size = invoiceDatas.size();
                for (int i = 0; i < size; ++i) {
                    JSONObject invoice = invoiceDatas.getJSONObject(i);
                    int state = Integer.parseInt(invoice.get((Object)"status").toString());
                    if (state != 30 && state != 60) continue;
                    invoiceIdArray.append(invoice.getString("fid") + ",");
                }
                IObjectCollection ticketEntrys = (IObjectCollection)info.get("tickeEntries");
                TicketBaseEntryInfo ticketEntry = null;
                int size2 = ticketEntrys.size();
                for (int i = 0; i < size2; ++i) {
                    ticketEntry = (TicketBaseEntryInfo)ticketEntrys.getObject(i);
                    if (invoiceIdArray.indexOf(ticketEntry.getString("serialNo")) == -1) continue;
                    invoiceSeq.append(i + 1).append(",");
                }
                String subString = invoiceSeq.substring(0, invoiceSeq.length() - 1);
                throw new InvoiceException(InvoiceException.INVOICEREPEATREIMBURSE, new Object[]{subString, expenseId});
            }
        }
    }

    public static String showInvoiceSigniture(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String url = invoice.getInvoiceUrl() + invoice.getShowInvoice();
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result == null) {
            return null;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new InvoiceException(InvoiceException.GETUSERKEYERRORMESSAGE, new Object[]{parseObject.getString("description")});
        }
        return result;
    }

    @Deprecated
    public static boolean delInvoice(Context ctx, JSONObject billJson, String clientId, String clientSecret, String billId, String entryId) throws BOSException, EASBizException {
        Long timeStamp = InvoiceUtil.getTimeStamp();
        billJson.put("client_id", (Object)clientId);
        billJson.put("client_secret", (Object)clientSecret);
        billJson.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        billJson.put("timestamp", (Object)timeStamp);
        billJson.put("bxd_key", (Object)billId);
        billJson.put("branch_id", (Object)entryId);
        String description = InvoiceUtil.getDefaultDescription(ctx);
        String url = invoice.getInvoiceUrl() + invoice.getDelInvoice();
        String result = InvoiceUtil.httpsRequestPost(url, billJson.toString(), "utf-8");
        if (result == null) {
            return false;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new InvoiceException(InvoiceException.DELINVOICEERRORMESSAGE, new Object[]{parseObject.getString("description")});
        }
        return true;
    }

    public static String httpsRequestPost(String url, String param, String charset) throws EASBizException, BOSException {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        int readTimeOut = Integer.parseInt(invoice.getReadTimeOut());
        try {
            httpClient = HttpClientBuilder.create().build();
            httpPost = new HttpPost(url);
            int timeout = Integer.parseInt(invoice.getTimeOut());
            JSONObject paramArray = JSONObject.parseObject((String)param);
            paramArray.remove((Object)"coverBase64");
            logger.error((Object)("######cpbc runner httpsRequestPost ticket timeout=" + timeout + " url =" + url + " readTimeOut=" + readTimeOut + " ticket param = " + paramArray));
            StringEntity se = new StringEntity(param, "UTF-8");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
            se.setContentType("application/json");
            httpPost.setEntity((HttpEntity)se);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(readTimeOut).build();
            httpPost.setConfig(config);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
                    if (RETURNlOG) {
                        logger.error((Object)("#####cpbc runner common ticket result = " + result));
                    }
                }
            } else {
                logger.error((Object)("######cpbc runner common ticket result = " + result));
            }
        }
        catch (ConnectTimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new InvoiceException(InvoiceException.HTTPCONNECTTIMEOUTEXCEPTION, e, new Object[]{e.getMessage()});
        }
        catch (SocketTimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new InvoiceException(InvoiceException.HTTPREADTIMEOUTEXCEPTION, e, new Object[]{readTimeOut + "", e.getMessage()});
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new InvoiceException(InvoiceException.HTTPREQUESTERROR, ex, new Object[]{ex.getMessage()});
        }
        return result;
    }

    @Deprecated
    public static InvoiceTypeEnum getTicketType(String invoiceType2) {
        InvoiceTypeEnum num = InvoiceTypeEnum.other;
        switch (Integer.parseInt(invoiceType2)) {
            case 1: {
                num = InvoiceTypeEnum.general;
                break;
            }
            case 2: {
                num = InvoiceTypeEnum.specialElectronic;
                break;
            }
            case 3: {
                num = InvoiceTypeEnum.generalPaper;
                break;
            }
            case 4: {
                num = InvoiceTypeEnum.specialPaper;
                break;
            }
            case 5: {
                num = InvoiceTypeEnum.volume;
                break;
            }
            case 7: {
                num = InvoiceTypeEnum.universal;
                break;
            }
            case 8: {
                num = InvoiceTypeEnum.tax;
                break;
            }
            case 9: {
                num = InvoiceTypeEnum.train;
                break;
            }
            case 10: {
                num = InvoiceTypeEnum.plane;
                break;
            }
            case 11: {
                num = InvoiceTypeEnum.other;
                break;
            }
            case 12: {
                num = InvoiceTypeEnum.vehicle;
                break;
            }
            case 13: {
                num = InvoiceTypeEnum.usedCar;
                break;
            }
            case 14: {
                num = InvoiceTypeEnum.quotaInvoice;
                break;
            }
            case 15: {
                num = InvoiceTypeEnum.tolls;
            }
        }
        return num;
    }

    public static void buildExpenseEntryInfo(CoreBillEntryBaseInfo entry, InvoiceTypeEntryInfo invoiceTypeEntryInfo, BizCollBillBaseInfo baseInfo) {
        if (invoiceTypeEntryInfo != null && invoiceTypeEntryInfo.getExpenseType() != null) {
            ExpenseTypeInfo expensetypeInfo = invoiceTypeEntryInfo.getExpenseType();
            entry.put("expenseType", (Object)expensetypeInfo);
            if (expensetypeInfo.getOperationType() != null) {
                entry.put("operationType", (Object)expensetypeInfo.getOperationType());
            }
        }
        entry.put("purpose", (Object)"");
        entry.put("amountApproved", (Object)BizCollUtil.ZERO);
        entry.put("amountApprovedOri", (Object)BizCollUtil.ZERO);
        entry.put("budgetDo", (Object)BizCollUtil.ZERO);
        entry.put("company", (Object)baseInfo.getCompany());
        entry.put("costCenter", (Object)baseInfo.getCostedDept());
        entry.put("payState", (Object)EntryStateEnum.UNDONE);
        entry.put("receiveState", (Object)BizCollUtil.ZERO);
    }

    @Deprecated
    public static void buildBizEntryInfo(BizAccountBillEntryInfo entry, InvoiceTypeEntryInfo invoiceTypeEntryInfo, BizCollBillBaseInfo baseInfo) {
        InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
    }

    @Deprecated
    public static void buildPurEntryInfo(DailyPurchaseAccountBillEntryInfo entry, InvoiceTypeEntryInfo invoiceTypeEntryInfo, BizCollBillBaseInfo baseInfo) {
        InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
    }

    @Deprecated
    public static void buildBizOutEntryInfo(BizAccountOutBillEntryInfo entry, InvoiceTypeEntryInfo invoiceTypeEntryInfo, BizCollBillBaseInfo baseInfo) {
        InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
    }

    @Deprecated
    public static void buildTraBizEntryInfo(TravelAccountBillEntryInfo entry, InvoiceTypeEntryInfo invoiceTypeEntryInfo, BizCollBillBaseInfo baseInfo) {
        InvoiceUtil.buildExpenseEntryInfo(entry, invoiceTypeEntryInfo, baseInfo);
    }

    public static void buildExpenseTicketEntryInfo(Context ctx, TicketBaseEntryInfo ticketEntry, JSONObject invoiceDataJson, Map entryLinkInvoice, BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        String VATMapSerialNo;
        List VATInvoiceEntryList;
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
        ticketEntry.setId(entryBosId);
        BigDecimal amountWithoutTax = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        boolean isDeduction = false;
        String taxClassNumber = "";
        boolean enIsDeduction = false;
        String enTaxClassNumber = "";
        BigDecimal enDeductionTax = BizCollUtil.ZERO;
        for (Map.Entry<String, String> entry : ticketDataByString.entrySet()) {
            String easEntryKey = entry.getValue();
            String invoiceCloudKey = entry.getKey();
            if (invoiceDataJson.get((Object)invoiceCloudKey) == null || "".equals(invoiceCloudKey)) {
                ticketEntry.put(easEntryKey, null);
                continue;
            }
            ticketEntry.put(easEntryKey, invoiceDataJson.get((Object)invoiceCloudKey));
        }
        String serialNo = invoiceDataJson.getString("serialNo");
        String invoiceType2 = invoiceDataJson.getString("invoiceType");
        ticketEntry.setTicketTypeId(InvoiceUtil.getInvoiceTypeInfo(ctx, baseInfo, spareMap, invoiceType2));
        ticketEntry.setTicketType(InvoiceUtil.getTicketType(invoiceType2));
        JSONArray items = invoiceDataJson.getJSONArray("items");
        if (items != null && !"".equals(items) && items.size() > 0) {
            VATInvoiceEntryList = (List)spareMap.get("VATInvoiceEntryList");
            int size = VATInvoiceEntryList.size();
            for (int i = 0; i < size; ++i) {
                Map VATEntryInfoMap = (Map)VATInvoiceEntryList.get(i);
                VATMapSerialNo = (String)VATEntryInfoMap.get("serialNo");
                if (!VATMapSerialNo.equals(serialNo)) continue;
                VATEntryInfoMap.put("serialNolinkTicketEntryId", entryBosId.toString());
            }
            HashSet<BigDecimal> itemTaxRateSet = new HashSet<BigDecimal>(10);
            int size2 = items.size();
            for (int j = 0; j < size2; ++j) {
                JSONObject jsObject = items.getJSONObject(j);
                BigDecimal detailAmount = jsObject.getBigDecimal("detailAmount");
                BigDecimal detailTaxAmount = jsObject.getBigDecimal("taxAmount");
                taxClassNumber = jsObject.getString("goodsCode");
                BigDecimal taxRate = jsObject.getBigDecimal("taxRate") == null ? BizCollUtil.ZERO : jsObject.getBigDecimal("taxRate");
                itemTaxRateSet.add(taxRate);
                taxAmount = taxAmount.add(detailTaxAmount);
                amountWithoutTax = amountWithoutTax.add(detailAmount);
                isDeduction = InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, taxClassNumber, invoiceType2, baseInfo, null);
                if (!isDeduction) continue;
                enIsDeduction = isDeduction;
                enTaxClassNumber = taxClassNumber;
                enDeductionTax = enDeductionTax.add(detailTaxAmount);
            }
            if (itemTaxRateSet.size() > 1) {
                ticketEntry.setTaxRate(BizCollUtil.MultipleTaxRate.setScale(2, 4));
            } else {
                for (BigDecimal taxR : itemTaxRateSet) {
                    ticketEntry.setTaxRate(taxR.multiply(ONE_HUNDRED).setScale(2, 4));
                }
            }
        } else {
            BigDecimal taxRate;
            if (ticketEntry instanceof TraTicketEntryInfo) {
                VATInvoiceEntryList = (List)spareMap.get("VATInvoiceEntryList");
                int size = VATInvoiceEntryList.size();
                for (int i = 0; i < size; ++i) {
                    Map VATEntryInfoMap = (Map)VATInvoiceEntryList.get(i);
                    VATMapSerialNo = (String)VATEntryInfoMap.get("serialNo");
                    if (!VATMapSerialNo.equals(serialNo)) continue;
                    VATEntryInfoMap.put("serialNolinkTicketEntryId", entryBosId.toString());
                }
            }
            taxRate = (taxRate = invoiceDataJson.getBigDecimal("taxRate")) == null ? BizCollUtil.ZERO : taxRate;
            ticketEntry.setTaxRate(taxRate.setScale(2, 4).multiply(new BigDecimal(100)));
            BigDecimal ammount = invoiceDataJson.getBigDecimal("amount");
            ammount = ammount == null ? BizCollUtil.ZERO : ammount;
            BigDecimal taaxAmount = invoiceDataJson.getBigDecimal("taxAmount");
            taaxAmount = taaxAmount == null ? BizCollUtil.ZERO : taaxAmount;
            amountWithoutTax = amountWithoutTax.add(ammount);
            taxAmount = taxAmount.add(taaxAmount);
            isDeduction = InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, taxClassNumber, invoiceType2, baseInfo, null);
            if (isDeduction) {
                enIsDeduction = isDeduction;
                enDeductionTax = taaxAmount;
            }
        }
        if (ticketEntry instanceof TraTicketEntryInfo) {
            String passengerName = InvoiceUtil.nullToK(invoiceDataJson.getString("passengerName"));
            String seatGrade = InvoiceUtil.nullToK(invoiceDataJson.getString("seatGrade"));
            String placeOfDeparture = InvoiceUtil.nullToK(invoiceDataJson.getString("stationGetOn"));
            String destination = InvoiceUtil.nullToK(invoiceDataJson.getString("stationGetOff"));
            if ("10".equals(invoiceDataJson.getString("invoiceType"))) {
                seatGrade = InvoiceUtil.nullToK(invoiceDataJson.getString("seatGradeName"));
                placeOfDeparture = InvoiceUtil.nullToK(invoiceDataJson.getString("placeOfDeparture"));
                destination = InvoiceUtil.nullToK(invoiceDataJson.getString("destination"));
            }
            ((TraTicketEntryInfo)ticketEntry).setPassengerName(passengerName);
            ((TraTicketEntryInfo)ticketEntry).setSeatClass(seatGrade);
            ((TraTicketEntryInfo)ticketEntry).setPlaceOfDeparture(placeOfDeparture);
            ((TraTicketEntryInfo)ticketEntry).setDestination(destination);
            BigDecimal insurancePremium = InvoiceUtil.AmountNotNull(invoiceDataJson.getBigDecimal("insurancePremium"));
            ticketEntry.put("insurancePremium", insurancePremium);
        }
        ticketEntry.setIsElectronicInvoice(invoiceDataJson.getBoolean("isElectronicInvoice"));
        ticketEntry.setAmout(amountWithoutTax.add(taxAmount));
        ticketEntry.setTax(taxAmount);
        if (!InvoiceUtil.isHeadByInvoiceType(invoiceType2)) {
            if (StringUtils.isNotEmpty((String)enTaxClassNumber)) {
                ticketEntry.setTaxClassNumber(enTaxClassNumber);
            } else {
                ticketEntry.setTaxClassNumber(taxClassNumber);
            }
        }
        ticketEntry.setIsDeduction(enIsDeduction);
        if (ticketEntry.isIsDeduction()) {
            ticketEntry.setDeductionTax(enDeductionTax);
        } else {
            ticketEntry.setDeductionTax(BizCollUtil.ZERO);
        }
        if (ticketEntry instanceof TicketEntryInfo) {
            InvoiceUtil.buildTicketEntryInfo(ticketEntry, invoiceDataJson, entryLinkInvoice);
        } else if (ticketEntry instanceof BizOutTicketEntryInfo) {
            InvoiceUtil.buildBizOutTicketEntryInfo(ticketEntry, invoiceDataJson, entryLinkInvoice);
        } else if (ticketEntry instanceof PurTicketEntryInfo) {
            InvoiceUtil.buildPurTicketEntryInfo(ticketEntry, invoiceDataJson, entryLinkInvoice);
        } else if (ticketEntry instanceof TraTicketEntryInfo) {
            InvoiceUtil.buildTraTicketEntryInfo(ticketEntry, invoiceDataJson, entryLinkInvoice);
        }
    }

    public static InvoiceTypeInfo getInvoiceTypeInfo(Context ctx, BizCollBillBaseInfo baseInfo, Map spareMap, String invoiceType2) throws BOSException, EASBizException {
        InvoiceTypeInfo invoiceTypeInfo = null;
        Map cacheInvoiceTypeMap = (Map)spareMap.get("cacheInvoiceTypeMap");
        if (cacheInvoiceTypeMap != null && cacheInvoiceTypeMap.get(invoiceType2) != null) {
            invoiceTypeInfo = (InvoiceTypeInfo)cacheInvoiceTypeMap.get(invoiceType2);
        } else {
            boolean isReFreshedInvType;
            invoiceTypeInfo = InvoiceUtil.getTicketTypeId(invoiceType2);
            boolean bl = isReFreshedInvType = spareMap.get("isReFreshedInvType") != null ? new Boolean(spareMap.get("isReFreshedInvType").toString()) : false;
            if (invoiceTypeInfo == null && !isReFreshedInvType) {
                try {
                    spareMap.put("isImportInvoice", true);
                    Map map = InvoiceFacadeFactory.getLocalInstance(ctx).refershInvoiceType(baseInfo.getApplierCompany(), spareMap);
                    invoiceTypeInfo = (InvoiceTypeInfo)map.get(invoiceType2);
                    cacheInvoiceTypeMap.putAll(map);
                    spareMap.put("isReFreshedInvType", true);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            cacheInvoiceTypeMap.put(invoiceType2, invoiceTypeInfo);
        }
        return invoiceTypeInfo;
    }

    public static void buildPurTicketEntryInfo(TicketBaseEntryInfo ticketEntry, JSONObject invoiceDataJson, Map entryLinkInvoice) throws BOSException {
        DailyPurchaseAccountBillEntryInfo entryInfo = new DailyPurchaseAccountBillEntryInfo();
        String invoiceId = (String)ticketEntry.get("serialNo");
        if (null != entryLinkInvoice.get("firstEntry")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get("firstEntry").toString()));
        } else {
            for (Map.Entry entry : entryLinkInvoice.entrySet()) {
                String fidString = (String)entry.getValue();
                String entryId = (String)entry.getKey();
                if (BizCollUtil.objectIsNull(fidString) || fidString.indexOf(invoiceId) == -1) continue;
                entryInfo.setId(BOSUuid.read((String)entryId));
            }
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    public static void buildBizOutTicketEntryInfo(TicketBaseEntryInfo ticketEntry, JSONObject invoiceDataJson, Map entryLinkInvoice) throws BOSException {
        String invoiceId = (String)ticketEntry.get("serialNo");
        BizAccountOutBillEntryInfo entryInfo = new BizAccountOutBillEntryInfo();
        if (null != entryLinkInvoice.get("firstEntry")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get("firstEntry").toString()));
        } else {
            for (Map.Entry entry : entryLinkInvoice.entrySet()) {
                String fidString = (String)entry.getValue();
                String entryId = (String)entry.getKey();
                if (BizCollUtil.objectIsNull(fidString) || fidString.indexOf(invoiceId) == -1) continue;
                entryInfo.setId(BOSUuid.read((String)entryId));
            }
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    public static void buildTraTicketEntryInfo(TicketBaseEntryInfo ticketEntry, JSONObject invoiceJsonObject, Map entryLinkInvoice) throws BOSException {
        String invoiceId = ticketEntry.getSerialNo();
        TravelAccountBillEntryInfo entryInfo = new TravelAccountBillEntryInfo();
        if (null != entryLinkInvoice.get("firstEntry")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get("firstEntry").toString()));
        } else {
            for (Map.Entry entry : entryLinkInvoice.entrySet()) {
                String fidString = (String)entry.getValue();
                String entryId = (String)entry.getKey();
                if (BizCollUtil.objectIsNull(fidString) || fidString.indexOf(invoiceId) == -1) continue;
                entryInfo.setId(BOSUuid.read((String)entryId));
            }
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    public static void buildTicketEntryInfo(TicketBaseEntryInfo ticketEntry, JSONObject eJsStrOut, Map entryLinkInvoice) throws BOSException {
        String invoiceId = ticketEntry.getSerialNo();
        BizAccountBillEntryInfo entryInfo = new BizAccountBillEntryInfo();
        if (null != entryLinkInvoice.get("firstEntry")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get("firstEntry").toString()));
        } else {
            for (Map.Entry entry : entryLinkInvoice.entrySet()) {
                String fidString = (String)entry.getValue();
                String entryId = (String)entry.getKey();
                if (BizCollUtil.objectIsNull(fidString) || fidString.indexOf(invoiceId) == -1) continue;
                entryInfo.setId(BOSUuid.read((String)entryId));
            }
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    @Deprecated
    public static Map buildInvoiceIdMap(String entryId, String invoiceIds) {
        String[] invoiceArr = invoiceIds.split(",");
        HashMap<String, String> temp = new HashMap<String, String>();
        int size = invoiceArr.length;
        for (int i = 0; i < size; ++i) {
            temp.put(invoiceArr[i], entryId);
        }
        return temp;
    }

    @Deprecated
    public static void buildPurTicketEntryInfo(PurTicketEntryInfo ticketEntry, JSONObject eJsStrOut, Map entryLinkInvoice) throws BOSException {
        Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
        String invoiceId = null;
        String taxClassNumber = null;
        String invoiceNumber = null;
        BigDecimal ftotalpricetax = BizCollUtil.ZERO;
        BigDecimal ftotaltax = BizCollUtil.ZERO;
        BigDecimal taxRate = BizCollUtil.ZERO;
        String ticketCode = null;
        Date billingDate = null;
        String checkStatus = null;
        if (null != eJsStrOut.getDate("invoiceDate")) {
            billingDate = eJsStrOut.getDate("invoiceDate");
        }
        if (null != eJsStrOut.get((Object)"invoiceNo") && "" != eJsStrOut.get((Object)"invoiceNo").toString()) {
            invoiceNumber = eJsStrOut.get((Object)"invoiceNo").toString();
        }
        if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode").toString()) {
            taxClassNumber = eJsStrOut.get((Object)"goodsCode").toString();
        }
        if (null != eJsStrOut.get((Object)"serialNo") && "" != eJsStrOut.get((Object)"serialNo").toString()) {
            invoiceId = eJsStrOut.get((Object)"serialNo").toString();
        }
        if (null != eJsStrOut.get((Object)"totalAmount") && "" != eJsStrOut.get((Object)"totalAmount").toString()) {
            ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
        }
        if (null != eJsStrOut.get((Object)"totalTaxAmount") && "" != eJsStrOut.get((Object)"totalTaxAmount").toString()) {
            ftotaltax = new BigDecimal(eJsStrOut.get((Object)"totalTaxAmount").toString());
        }
        if (null != eJsStrOut.get((Object)"invoiceCode") && "" != eJsStrOut.get((Object)"invoiceCode").toString()) {
            ticketCode = eJsStrOut.get((Object)"invoiceCode").toString();
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.get((Object)"taxRate"))) {
            taxRate = eJsStrOut.getBigDecimal("taxRate");
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.get((Object)"checkStatus"))) {
            checkStatus = eJsStrOut.getString("checkStatus");
        }
        ticketEntry.setBillingDate(billingDate);
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
        ticketEntry.setId(entryBosId);
        ticketEntry.setTicketType(InvoiceUtil.getTicketType(invoiceTypeOut.toString()));
        ticketEntry.setTicketTypeId(InvoiceUtil.getTicketTypeId(invoiceTypeOut.toString()));
        ticketEntry.setTicketCode(ticketCode);
        ticketEntry.setTicketNumber(invoiceNumber);
        ticketEntry.setAmout(ftotalpricetax);
        ticketEntry.setTax(ftotaltax);
        ticketEntry.setSerialNo(invoiceId);
        if (!InvoiceUtil.isHeadByInvoiceType(invoiceTypeOut)) {
            ticketEntry.setTaxClassNumber(taxClassNumber);
            ticketEntry.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(null, taxClassNumber, InvoiceUtil.getTicketTypeId(invoiceTypeOut.toString())));
        } else {
            ticketEntry.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(null, null, InvoiceUtil.getTicketTypeId(invoiceTypeOut.toString())));
        }
        if (ticketEntry.isIsDeduction()) {
            ticketEntry.setDeductionTax(ftotaltax);
        }
        if (taxRate.compareTo(BizCollUtil.MultipleTaxRate) == 0) {
            ticketEntry.setTaxRate(taxRate.setScale(2, 4));
        } else {
            ticketEntry.setTaxRate(taxRate.setScale(2, 4).multiply(new BigDecimal(100)));
        }
        ticketEntry.setCheckStates(InvoiceUtil.getCheckStatesEnum(checkStatus));
        DailyPurchaseAccountBillEntryInfo entryInfo = new DailyPurchaseAccountBillEntryInfo();
        if (null != entryLinkInvoice.get("firstEntry")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get("firstEntry").toString()));
        } else {
            for (Map.Entry entry : entryLinkInvoice.entrySet()) {
                String fidString = (String)entry.getValue();
                String entryId = (String)entry.getKey();
                if (BizCollUtil.objectIsNull(fidString) || fidString.indexOf(invoiceId) == -1) continue;
                entryInfo.setId(BOSUuid.read((String)entryId));
            }
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    @Deprecated
    public static void buildBizOutTicketEntryInfo(BizOutTicketEntryInfo ticketEntry, JSONObject eJsStrOut, Map entryLinkInvoice) throws BOSException {
        Object invoiceTypeOut = eJsStrOut.get((Object)"invoiceType");
        String invoiceId = null;
        String taxClassNumber = null;
        String invoiceNumber = null;
        BigDecimal ftotalpricetax = BizCollUtil.ZERO;
        BigDecimal ftotaltax = BizCollUtil.ZERO;
        BigDecimal taxRate = BizCollUtil.ZERO;
        String ticketCode = null;
        String serialNo = null;
        Date billingDate = null;
        String checkStatus = null;
        if (null != eJsStrOut.getDate("invoiceDate")) {
            billingDate = eJsStrOut.getDate("invoiceDate");
        }
        if (null != eJsStrOut.get((Object)"serialNo") && "" != eJsStrOut.get((Object)"serialNo").toString()) {
            serialNo = eJsStrOut.get((Object)"serialNo").toString();
        }
        if (null != eJsStrOut.get((Object)"invoiceNo") && "" != eJsStrOut.get((Object)"invoiceNo").toString()) {
            invoiceNumber = eJsStrOut.get((Object)"invoiceNo").toString();
        }
        if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode").toString()) {
            taxClassNumber = eJsStrOut.get((Object)"goodsCode").toString();
        }
        if (null != eJsStrOut.get((Object)"serialNo") && "" != eJsStrOut.get((Object)"serialNo").toString()) {
            invoiceId = eJsStrOut.get((Object)"serialNo").toString();
        }
        if (null != eJsStrOut.get((Object)"totalAmount") && "" != eJsStrOut.get((Object)"totalAmount").toString()) {
            ftotalpricetax = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
        }
        if (null != eJsStrOut.get((Object)"taxAmount") && "" != eJsStrOut.get((Object)"taxAmount").toString()) {
            ftotaltax = new BigDecimal(eJsStrOut.get((Object)"taxAmount").toString());
        }
        if (null != eJsStrOut.get((Object)"invoiceCode") && "" != eJsStrOut.get((Object)"invoiceCode").toString()) {
            ticketCode = eJsStrOut.get((Object)"invoiceCode").toString();
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.get((Object)"taxRate"))) {
            taxRate = eJsStrOut.getBigDecimal("taxRate");
        }
        if (!BizCollUtil.objectIsNull(eJsStrOut.get((Object)"checkStatus"))) {
            checkStatus = eJsStrOut.getString("checkStatus");
        }
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)ticketEntry.getBOSType());
        ticketEntry.setId(entryBosId);
        ticketEntry.setTicketType(InvoiceUtil.getTicketType(invoiceTypeOut.toString()));
        ticketEntry.setTicketTypeId(InvoiceUtil.getTicketTypeId(invoiceTypeOut.toString()));
        ticketEntry.setTicketCode(ticketCode);
        ticketEntry.setTicketNumber(invoiceNumber);
        ticketEntry.setAmout(ftotalpricetax);
        ticketEntry.setTax(ftotaltax);
        ticketEntry.setSerialNo(serialNo);
        ticketEntry.setBillingDate(billingDate);
        if (!InvoiceUtil.isHeadByInvoiceType(invoiceTypeOut)) {
            ticketEntry.setTaxClassNumber(taxClassNumber);
            ticketEntry.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(null, taxClassNumber, InvoiceUtil.getTicketTypeId(invoiceTypeOut.toString())));
        } else {
            ticketEntry.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(null, null, InvoiceUtil.getTicketTypeId(invoiceTypeOut.toString())));
        }
        if (ticketEntry.isIsDeduction()) {
            ticketEntry.setDeductionTax(ftotaltax);
        }
        if (!InvoiceUtil.isHeadByInvoiceType(invoiceTypeOut)) {
            ticketEntry.setTaxClassNumber(taxClassNumber);
        }
        if (taxRate.compareTo(BizCollUtil.MultipleTaxRate) == 0) {
            ticketEntry.setTaxRate(taxRate.setScale(2, 4));
        } else {
            ticketEntry.setTaxRate(taxRate.setScale(2, 4).multiply(new BigDecimal(100)));
        }
        ticketEntry.setCheckStates(InvoiceUtil.getCheckStatesEnum(checkStatus));
        BizAccountOutBillEntryInfo entryInfo = new BizAccountOutBillEntryInfo();
        if (null != entryLinkInvoice.get("firstEntry")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get("firstEntry").toString()));
        } else if (null != entryLinkInvoice.get(invoiceId)) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get(invoiceId).toString()));
        } else if (null != eJsStrOut.get((Object)"goodsCode") && "" != eJsStrOut.get((Object)"goodsCode")) {
            entryInfo.setId(BOSUuid.read((String)entryLinkInvoice.get(eJsStrOut.get((Object)"goodsCode").toString()).toString()));
        }
        InvoiceUtil.setBizEntryBill((CoreBillEntryBaseInfo)ticketEntry, entryInfo);
    }

    @Deprecated
    public static void buildTraTicketEntryInfo(TraTicketEntryInfo traTicketEntryInfo, JSONObject invoiceJsonObject, Context ctx) throws BOSException {
        BigDecimal taxRate = BizCollUtil.ZERO;
        BOSUuid traTicketEntryBosId = BOSUuid.create((BOSObjectType)traTicketEntryInfo.getBOSType());
        traTicketEntryInfo.setId(traTicketEntryBosId);
        traTicketEntryInfo.setBillingDate(invoiceJsonObject.getDate("invoiceDate"));
        traTicketEntryInfo.setTaxClassNumber(invoiceJsonObject.getString("goodsCode"));
        traTicketEntryInfo.setTax(invoiceJsonObject.getBigDecimal("taxAmount"));
        traTicketEntryInfo.setTicketCode(invoiceJsonObject.getString("invoiceCode"));
        traTicketEntryInfo.setTicketType(InvoiceUtil.getTicketType(invoiceJsonObject.getString("invoiceType")));
        traTicketEntryInfo.setTicketTypeId(InvoiceUtil.getTicketTypeId(invoiceJsonObject.getString("invoiceType")));
        traTicketEntryInfo.setTicketNumber(invoiceJsonObject.getString("invoiceNo"));
        traTicketEntryInfo.setCheckStates(InvoiceUtil.getCheckStatesEnum(invoiceJsonObject.getString("checkStatus")));
        if (!InvoiceUtil.isHeadByInvoiceType((Object)traTicketEntryInfo.getTicketType())) {
            traTicketEntryInfo.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, traTicketEntryInfo.getTaxClassNumber(), traTicketEntryInfo.getTicketTypeId()));
        } else {
            traTicketEntryInfo.setIsDeduction(InvoiceUtil.getDeductionByInvoiceTypeEntry(ctx, null, traTicketEntryInfo.getTicketTypeId()));
        }
        traTicketEntryInfo.setAmout(invoiceJsonObject.getBigDecimal("totalAmount").setScale(2, 4));
        taxRate = invoiceJsonObject.getBigDecimal("taxRate");
        if (traTicketEntryInfo.isIsDeduction()) {
            traTicketEntryInfo.setDeductionTax(traTicketEntryInfo.getTax());
        }
        if (taxRate.compareTo(BizCollUtil.MultipleTaxRate) == 0) {
            traTicketEntryInfo.setTaxRate(taxRate.setScale(2, 4));
        } else {
            traTicketEntryInfo.setTaxRate(taxRate.setScale(2, 4).multiply(new BigDecimal(100)));
        }
        traTicketEntryInfo.setSerialNo(invoiceJsonObject.getString("serialNo"));
    }

    @Deprecated
    public static void buildBizAccountOutBillAccountEntryInfo(BizAccountOutBillAccountEntryInfo BizOutBillAccountEntry, JSONObject eJsStrOut) {
        String salerAccount;
        String[] split;
        String payerName = null;
        String payerBank = null;
        String payerAccount = null;
        String accountOpenArea = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal amountOri = BizCollUtil.ZERO;
        if (null != eJsStrOut.get((Object)"salerName") && !"".equals(eJsStrOut.get((Object)"salerName").toString())) {
            payerName = eJsStrOut.get((Object)"salerName").toString();
        }
        if (null != eJsStrOut.get((Object)"salerAccount") && !"".equals(eJsStrOut.get((Object)"salerAccount").toString()) && (split = InvoiceUtil.buildSalerAddressAndSalerAccount(salerAccount = eJsStrOut.get((Object)"salerAccount").toString()).split(",")).length > 1) {
            if (StringUtils.isNotBlank((String)split[0])) {
                payerBank = split[0];
            }
            if (StringUtils.isNotBlank((String)split[1])) {
                payerAccount = split[1];
            }
        }
        if (null != eJsStrOut.get((Object)"salerAddressPhone") && !"".equals(eJsStrOut.get((Object)"salerAddressPhone").toString())) {
            accountOpenArea = eJsStrOut.get((Object)"salerAddressPhone").toString();
        }
        if (null != eJsStrOut.get((Object)"totalAmount") && !"".equals(eJsStrOut.get((Object)"totalAmount").toString())) {
            amount = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
            amountOri = new BigDecimal(eJsStrOut.get((Object)"totalAmount").toString());
        }
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)BizOutBillAccountEntry.getBOSType());
        BizOutBillAccountEntry.setId(entryBosId);
        BizOutBillAccountEntry.setPayerName(payerName);
        BizOutBillAccountEntry.setPayerBank(payerBank);
        BizOutBillAccountEntry.setPayerAccount(payerAccount);
        BizOutBillAccountEntry.setAccountOpenArea(accountOpenArea);
        BizOutBillAccountEntry.setAmount(amount.setScale(2, 4));
        BizOutBillAccountEntry.setAmountOri(amountOri.setScale(2, 4));
    }

    @Deprecated
    public static void buildDailyPurchaseBillAccountEntryInfo(DailyPurchaseAccountBillAccountEntryInfo accountEntry, JSONObject eJsStrOut) {
        String salerAccount;
        String[] split;
        String payerName = null;
        String payerBank = null;
        String payerAccount = null;
        String accountOpenArea = null;
        BigDecimal amount = BizCollUtil.ZERO;
        BigDecimal amountOri = BizCollUtil.ZERO;
        if (null != eJsStrOut.get((Object)"salerName") && !"".equals(eJsStrOut.get((Object)"salerName").toString())) {
            payerName = eJsStrOut.get((Object)"salerName").toString();
        }
        if (null != eJsStrOut.get((Object)"salerAccount") && !"".equals(eJsStrOut.get((Object)"salerAccount").toString()) && (split = InvoiceUtil.buildSalerAddressAndSalerAccount(salerAccount = eJsStrOut.get((Object)"salerAccount").toString()).split(",")).length > 1) {
            if (StringUtils.isNotBlank((String)split[0])) {
                payerBank = split[0];
            }
            if (StringUtils.isNotBlank((String)split[1])) {
                payerAccount = split[1];
            }
        }
        if (null != eJsStrOut.get((Object)"salerAddressPhone") && !"".equals(eJsStrOut.get((Object)"salerAddressPhone").toString())) {
            accountOpenArea = eJsStrOut.get((Object)"salerAddressPhone").toString();
        }
        if (null != eJsStrOut.get((Object)"taxAmount") && !"".equals(eJsStrOut.get((Object)"taxAmount").toString())) {
            BigDecimal taxAmount = new BigDecimal(eJsStrOut.get((Object)"taxAmount").toString());
            BigDecimal unitPrice = new BigDecimal(eJsStrOut.get((Object)"unitPrice").toString());
            amountOri = amount = unitPrice.add(taxAmount);
        }
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)accountEntry.getBOSType());
        accountEntry.setId(entryBosId);
        accountEntry.setPayerName(payerName);
        accountEntry.setPayerBank(payerBank);
        accountEntry.setPayerAccount(payerAccount);
        accountEntry.setAccountOpenArea(accountOpenArea);
        accountEntry.setAmount(amount.setScale(2, 4));
        accountEntry.setAmountOri(amountOri.setScale(2, 4));
    }

    public static void buildPurAndBizOutBillAccountEntryInfo(CollectionAccountCoreBaseInfo accountEntry, JSONObject invoiceData) {
        String[] split;
        String payerBank = null;
        String payerAccount = null;
        BigDecimal amountOri = BizCollUtil.ZERO;
        BigDecimal amountOriWithoutTax = BizCollUtil.ZERO;
        BigDecimal taxAmount = BizCollUtil.ZERO;
        String payerName = invoiceData.getString("salerName");
        String salerAccount = invoiceData.getString("salerAccount");
        String accountOpenArea = invoiceData.getString("salerAddressPhone");
        if (StringUtils.isNotEmpty((String)salerAccount) && (split = InvoiceUtil.buildSalerAddressAndSalerAccount(salerAccount).split(",")).length > 1) {
            if (StringUtils.isNotBlank((String)split[0])) {
                payerBank = split[0];
            }
            if (StringUtils.isNotBlank((String)split[1])) {
                payerAccount = split[1];
            }
        }
        BOSUuid entryBosId = BOSUuid.create((BOSObjectType)accountEntry.getBOSType());
        accountEntry.setId(entryBosId);
        accountEntry.setPayerName(payerName);
        accountEntry.setPayerBank(payerBank);
        accountEntry.setPayerAccount(payerAccount);
        accountEntry.setAccountOpenArea(accountOpenArea);
        JSONArray items = invoiceData.getJSONArray("items");
        if (items != null && !"".equals(items) && items.size() > 0) {
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemData = items.getJSONObject(i);
                amountOriWithoutTax = amountOriWithoutTax.add(itemData.getBigDecimal("detailAmount"));
                BigDecimal taxAmountTemp = itemData.getBigDecimal("taxAmount");
                taxAmount = taxAmountTemp == null ? taxAmount : taxAmount.add(taxAmountTemp);
            }
        } else {
            amountOriWithoutTax = invoiceData.getBigDecimal("amount");
            BigDecimal taxAmountTemp = invoiceData.getBigDecimal("taxAmount");
            taxAmount = taxAmountTemp == null ? taxAmount : taxAmountTemp;
        }
        amountOri = amountOriWithoutTax.add(taxAmount);
        accountEntry.setAmountOri(amountOri);
        accountEntry.setAmount(BizCollUtil.computeAmount(amountOri, accountEntry.getConvertMode(), accountEntry.getExchangeRate()));
        accountEntry.setInt("payerType", PayerTypeEnum.supplier.getValue());
    }

    public static String buildSalerAddressAndSalerAccount(String accountAndAddress) {
        StringBuffer bankAndAccount = new StringBuffer();
        String replaceAccount = accountAndAddress.toString().replaceAll("\\s*", "");
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]+|[0-9_-]+");
        Matcher m = p.matcher(replaceAccount);
        while (m.find()) {
            bankAndAccount.append(m.group() + ",");
        }
        return bankAndAccount.toString();
    }

    public static boolean isHeadByInvoiceType(Object invoiceTypeOut) {
        if (BizCollUtil.objectIsNull(invoiceTypeOut)) {
            return false;
        }
        boolean invoiceType2 = false;
        if ("7".equals(invoiceTypeOut) || "8".equals(invoiceTypeOut) || "9".equals(invoiceTypeOut) || "10".equals(invoiceTypeOut) || "11".equals(invoiceTypeOut) || "12".equals(invoiceTypeOut) || "13".equals(invoiceTypeOut) || "14".equals(invoiceTypeOut) || "16".equals(invoiceTypeOut) || "17".equals(invoiceTypeOut) || "19".equals(invoiceTypeOut) || "20".equals(invoiceTypeOut) || "21".equals(invoiceTypeOut)) {
            invoiceType2 = true;
        }
        return invoiceType2;
    }

    @Deprecated
    public static Map getClientIdAndSecret(Context ctx, String applierCompanyId) throws EASBizException, BOSException {
        HashMap<String, String> mapTemp = new HashMap<String, String>();
        CompanyOrgUnitInfo company = null;
        company = BizCollUtil.objectIsNull(ctx) ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("select TaxNumber,authorizationCode,authorizationKey,name,registeredCode where id='" + applierCompanyId + "'") : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select TaxNumber,authorizationCode,authorizationKey,name,registeredCode where id='" + applierCompanyId + "'");
        if (!BizCollUtil.objectIsNull(company.get("authorizationCode"))) {
            mapTemp.put(CLIENT_ID, company.get("authorizationCode").toString());
        } else {
            logger.info((Object)"############################################# runner cpbc clientId is null");
        }
        if (!BizCollUtil.objectIsNull(company.get("authorizationKey"))) {
            mapTemp.put(CLIENT_SECRET, company.get("authorizationKey").toString());
        } else {
            logger.info((Object)"############################################# runner cpbc clientSecret is null");
        }
        if (!BizCollUtil.objectIsNull(company.getTaxNumber())) {
            mapTemp.put(TAX_NUMBER, company.getTaxNumber());
        }
        if (!BizCollUtil.objectIsNull(company.get(REGISTERED_CODE))) {
            mapTemp.put(REGISTERED_CODE, company.get(REGISTERED_CODE).toString());
        } else {
            mapTemp.put(REGISTERED_CODE, null);
            logger.info((Object)"############################################# runner cpbc registeredCode is null");
        }
        return mapTemp;
    }

    public static Map<String, String> getClientIdAndSecretAndRegisteredCode(Context ctx, BizCollBillBaseInfo info) throws EASBizException, BOSException {
        HashMap<String, String> mapTemp = new HashMap<String, String>(16);
        Map<String, String> paramMap = InvoiceUtil.InitParam(ctx, info);
        boolean isApplierCompany = paramMap.get("CP03905") == null ? false : new Boolean(paramMap.get("CP03905").toString());
        CompanyOrgUnitInfo companyInfo = InvoiceUtil.getClientIdAndClientSecret(ctx, info, mapTemp);
        if (isApplierCompany) {
            if (!BizCollUtil.objectIsNull(companyInfo.getString(REGISTERED_CODE))) {
                mapTemp.put(REGISTERED_CODE, companyInfo.getString(REGISTERED_CODE).replaceAll(" +", ""));
            } else {
                mapTemp.put(REGISTERED_CODE, companyInfo.getName().replaceAll(" +", ""));
            }
            if (BizCollUtil.objectIsNull(companyInfo.getTaxNumber())) {
                throw new InvoiceException(InvoiceException.CONFIGURE, new Object[]{companyInfo.getName()});
            }
            mapTemp.put(TAX_NUMBER, companyInfo.getTaxNumber().replaceAll(" +", ""));
        } else {
            InvoiceUtil.getTaxNumberAndRegisteredCode(ctx, info, mapTemp);
        }
        return mapTemp;
    }

    public static Map<String, String> getClientIdAndSecretAndRegisteredCode(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        HashMap<String, String> mapTemp = new HashMap<String, String>(16);
        CompanyOrgUnitInfo companyInfo = company;
        if (BizCollUtil.objectIsNull(company.getAuthorizationCode()) || BizCollUtil.objectIsNull(company.getAuthorizationKey())) {
            ICompanyOrgUnit icompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = icompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), InvoiceUtil.getClientIdAndSecretSelectors());
        }
        if (BizCollUtil.objectIsNull(companyInfo.get("authorizationCode")) || BizCollUtil.objectIsNull(companyInfo.get("authorizationKey"))) {
            throw new InvoiceException(InvoiceException.CLIENTIDORCLIENTSECRETISNULL, new Object[]{companyInfo.getName()});
        }
        String clientId = companyInfo.getString("authorizationCode").replaceAll(" +", "");
        String clientSecret = companyInfo.getString("authorizationKey").replaceAll(" +", "");
        mapTemp.put(CLIENT_ID, clientId);
        mapTemp.put(CLIENT_SECRET, clientSecret);
        return mapTemp;
    }

    private static CompanyOrgUnitInfo getClientIdAndClientSecret(Context ctx, BizCollBillBaseInfo info, Map<String, String> mapTemp) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        ICompanyOrgUnit companyInstance = null;
        companyInstance = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        companyInfo = companyInstance.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getApplierCompany().getId()), InvoiceUtil.getClientIdAndSecretSelectors());
        if (BizCollUtil.objectIsNull(companyInfo.get("authorizationCode")) || BizCollUtil.objectIsNull(companyInfo.get("authorizationKey"))) {
            throw new InvoiceException(InvoiceException.CLIENTIDORCLIENTSECRETISNULL, new Object[]{companyInfo.getName()});
        }
        String clientId = companyInfo.getString("authorizationCode").replaceAll(" +", "");
        String clientSecret = companyInfo.getString("authorizationKey").replaceAll(" +", "");
        mapTemp.put(CLIENT_ID, clientId);
        mapTemp.put(CLIENT_SECRET, clientSecret);
        return companyInfo;
    }

    private static void getTaxNumberAndRegisteredCode(Context ctx, BizCollBillBaseInfo info, Map<String, String> mapTemp) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        ICompanyOrgUnit companyInstance = null;
        if (info.getCompany() == null) {
            throw new InvoiceException(InvoiceException.CONPANYANDAPPLIERISNOTNULL);
        }
        companyInstance = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        companyInfo = companyInstance.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), InvoiceUtil.getClientIdAndSecretSelectors());
        if (!BizCollUtil.objectIsNull(companyInfo.getString(REGISTERED_CODE))) {
            mapTemp.put(REGISTERED_CODE, companyInfo.getString(REGISTERED_CODE).replaceAll(" +", ""));
        } else {
            mapTemp.put(REGISTERED_CODE, companyInfo.getName().replaceAll(" +", ""));
        }
        if (BizCollUtil.objectIsNull(companyInfo.getTaxNumber())) {
            throw new InvoiceException(InvoiceException.CONFIGURE, new Object[]{companyInfo.getName()});
        }
        mapTemp.put(TAX_NUMBER, companyInfo.getTaxNumber().replaceAll(" +", ""));
    }

    public static SelectorItemCollection getClientIdAndSecretSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(TAX_NUMBER));
        sic.add(new SelectorItemInfo("authorizationCode"));
        sic.add(new SelectorItemInfo("authorizationKey"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo(REGISTERED_CODE));
        return sic;
    }

    public static boolean getTicketinVoice(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        boolean idTicketinVoice = false;
        if (!(info instanceof ExpenseAccountBillInfo)) {
            return idTicketinVoice;
        }
        if (info.getCU() == null) {
            if (info.getApplierCompany() != null && info.getApplierCompany().getCU() != null) {
                info.setCU(info.getApplierCompany().getCU());
            } else {
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        Map paramMap = new HashMap();
        IExpenseCommenFacade iExpenseCommenFacade = null;
        String applierCompanyId = info.getApplierCompany().getId().toString();
        iExpenseCommenFacade = ctx != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx) : ExpenseCommenFacadeFactory.getRemoteInstance();
        paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        idTicketinVoice = new Boolean(paramMap.get("CP039").toString());
        return idTicketinVoice;
    }

    public static boolean getTicketinVoice(Context ctx, String id) throws BOSException, EASBizException {
        IExpenseAccountBill iservice = null;
        BOSObjectType bosType = BizCollUtil.getBOSType(id);
        BizCollBillBaseInfo info = null;
        if (bosType.equals((Object)BizCollUtil.bizAccountBillBosType)) {
            info = new BizAccountBillInfo();
            iservice = ctx == null ? BizAccountBillFactory.getRemoteInstance() : BizAccountBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.travelAccountBillBosType)) {
            info = new TravelAccountBillInfo();
            iservice = ctx == null ? TravelAccountBillFactory.getRemoteInstance() : TravelAccountBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.bizAccountOutBillBosType)) {
            info = new BizAccountOutBillInfo();
            iservice = ctx == null ? BizAccountOutBillFactory.getRemoteInstance() : BizAccountOutBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType)) {
            info = new DailyPurchaseAccountBillInfo();
            iservice = ctx == null ? DailyPurchaseAccountBillFactory.getRemoteInstance() : DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
        } else {
            return false;
        }
        info = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(id), InvoiceUtil.getBillSic());
        return InvoiceUtil.getTicketinVoice(ctx, info);
    }

    public static Map getInvoiceParamMap(Context ctx, BizCollBillBaseInfo info) throws EASBizException, BOSException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP03906");
        paramList.add("CP03910");
        paramList.add("CP03912");
        Map<String, Boolean> paramMap = new HashMap();
        paramMap = info.getApplierCompany() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, info.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        boolean isMergeInvoice = paramMap.get("CP03906") == null ? false : new Boolean(paramMap.get("CP03906").toString());
        boolean isUseDeduction = paramMap.get("CP03910") == null ? false : new Boolean(paramMap.get("CP03910").toString());
        boolean isUseInvoiceAcc = paramMap.get("CP03912") == null ? true : new Boolean(paramMap.get("CP03912").toString());
        paramMap.put("isMergeInvoice", isMergeInvoice);
        paramMap.put("isUseDeduction", isUseDeduction);
        paramMap.put("isUseInvoiceAcc", isUseInvoiceAcc);
        return paramMap;
    }

    public static SelectorItemCollection getBillSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceSystem"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.CU.*"));
        sic.add(new SelectorItemInfo("applierCompany.CU.id"));
        sic.add(new SelectorItemInfo("applierCompany.CU.name"));
        sic.add(new SelectorItemInfo("applierCompany.CU.number"));
        sic.add(new SelectorItemInfo("applierCompany.name"));
        sic.add(new SelectorItemInfo("applierCompany.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("biller.id"));
        sic.add(new SelectorItemInfo("biller.name"));
        sic.add(new SelectorItemInfo("biller.number"));
        sic.add(new SelectorItemInfo("tickeEntries.serialNo"));
        return sic;
    }

    public static SelectorItemCollection getSelectorForTm() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("tickeEntries.id"));
        sic.add(new SelectorItemInfo("tickeEntries.serialNo"));
        sic.add(new SelectorItemInfo("tickeEntries.isDeduction"));
        sic.add(new SelectorItemInfo("tickeEntries.deductionTax"));
        sic.add(new SelectorItemInfo("tickeEntries.transferTax"));
        sic.add(new SelectorItemInfo("tickeEntries.transferCauseStr"));
        return sic;
    }

    public static Map<String, String> InitParam(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        IExpenseCommenFacade iExpenseCommenFacade = null;
        if (BizCollUtil.objectIsNull(info.getApplierCompany())) {
            throw new InvoiceException(InvoiceException.APPLIERCOMPANYISNULL);
        }
        String applierCompanyId = info.getApplierCompany().getId().toString();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        paramList.add("CP03905");
        paramList.add("CP042");
        iExpenseCommenFacade = ctx != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx) : ExpenseCommenFacadeFactory.getRemoteInstance();
        return iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
    }

    @Deprecated
    public static void updateInvoiceNewState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String clientId = null;
        String clientSecret = null;
        IExpenseAccountBill iservice = null;
        BOSObjectType bosType = billId.getType();
        if (bosType.equals((Object)BizCollUtil.bizAccountBillBosType)) {
            iservice = ctx == null ? BizAccountBillFactory.getRemoteInstance() : BizAccountBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.travelAccountBillBosType)) {
            iservice = ctx == null ? TravelAccountBillFactory.getRemoteInstance() : TravelAccountBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.bizAccountOutBillBosType)) {
            iservice = ctx == null ? BizAccountOutBillFactory.getRemoteInstance() : BizAccountOutBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType)) {
            iservice = ctx == null ? DailyPurchaseAccountBillFactory.getRemoteInstance() : DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
        }
        if (iservice == null) {
            return;
        }
        BizCollBillBaseInfo billInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), InvoiceUtil.getBillSic());
        if (billInfo != null) {
            String applierCompanyId;
            String string = applierCompanyId = billInfo.getApplierCompany() == null ? "" : billInfo.getApplierCompany().getId().toString();
            if (!BizCollUtil.objectIsNull(applierCompanyId)) {
                Map map = InvoiceUtil.getClientIdAndSecret(ctx, applierCompanyId);
                if (!BizCollUtil.objectIsNull(map.get(CLIENT_ID))) {
                    clientId = map.get(CLIENT_ID).toString();
                }
                if (!BizCollUtil.objectIsNull(map.get(CLIENT_SECRET))) {
                    clientSecret = map.get(CLIENT_SECRET).toString();
                }
            }
            logger.error((Object)("###cpbc updateInvoiceState start billid:" + billInfo.getId().toString() + " state: 1"));
        }
        InvoiceUtil.updateInvoiceState(clientId, clientSecret, billInfo, ctx, 1);
    }

    public static boolean isBizEntryBill(String id) {
        boolean isBizEntryBill = false;
        if (new BizAccountBillEntryInfo().getBOSType().equals((Object)InvoiceUtil.getBOSType(id))) {
            isBizEntryBill = true;
        }
        return isBizEntryBill;
    }

    public static boolean isBizOutEntryBill(String id) {
        boolean isBizEntryBill = false;
        if (new BizAccountOutBillEntryInfo().getBOSType().equals((Object)InvoiceUtil.getBOSType(id))) {
            isBizEntryBill = true;
        }
        return isBizEntryBill;
    }

    public static boolean isTraEntryBill(String id) {
        boolean isTravelEntryBill = false;
        if (new TravelAccountBillEntryInfo().getBOSType().equals((Object)InvoiceUtil.getBOSType(id))) {
            isTravelEntryBill = true;
        }
        return isTravelEntryBill;
    }

    public static boolean isPurEntryBill(String id) {
        boolean isPruEntryBill = false;
        if (new DailyPurchaseAccountBillEntryInfo().getBOSType().equals((Object)InvoiceUtil.getBOSType(id))) {
            isPruEntryBill = true;
        }
        return isPruEntryBill;
    }

    public static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    public static InvoiceTypeEntryInfo getInvoiceTypeEntryInfo(Context ctx, BizCollBillBaseInfo baseInfo, String ticketTypeNumber, String taxClassNumber, Map spareMap) throws BOSException {
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = null;
        if (baseInfo == null) {
            logger.error((Object)"##cp.bc getInvoiceTypeEntryInfo baseInfo is null ");
            return invoiceTypeEntryInfo;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(InvoiceUtil.getInvoiceTypeEntryInfoSelectors());
        SorterItemInfo sort = new SorterItemInfo("company.longNumber");
        sort.setSortType(SortType.DESCEND);
        view.getSorter().add(sort);
        String ln = baseInfo.getApplierCompany().getLongNumber();
        String[] lnSecs = ln.split("!");
        int lSize = lnSecs.length;
        LinkedHashSet<String> lnUps = new LinkedHashSet<String>();
        for (int i = lSize - 1; i >= 0; --i) {
            lnUps.add(lnSecs[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("ticketTypeId.number", (Object)ticketTypeNumber, CompareType.EQUALS));
        if (!BizCollUtil.objectIsNull(taxClassNumber)) {
            FilterInfo filterTemp = new FilterInfo();
            filterTemp.getFilterItems().add(new FilterItemInfo("taxClassCode", (Object)taxClassNumber, CompareType.EQUALS));
            filterTemp.getFilterItems().add(new FilterItemInfo("taxClassCode", null, CompareType.EQUALS));
            filterTemp.setMaskString("#0 or #1");
            filter.mergeFilter(filterTemp, "and");
        }
        view.setFilter(filter);
        IInvoiceTypeEntry iInvoiceTypeEntry = null;
        iInvoiceTypeEntry = ctx == null ? InvoiceTypeEntryFactory.getRemoteInstance() : InvoiceTypeEntryFactory.getLocalInstance(ctx);
        InvoiceTypeEntryCollection invoiceTypeEntryCollection = iInvoiceTypeEntry.getInvoiceTypeEntryCollection(view);
        InvoiceTypeEntryInfo invoiceTypeEntryInfoTemp = null;
        if (invoiceTypeEntryCollection.size() > 0) {
            for (String lnUp : lnUps) {
                String companyNumber = lnUp.toString();
                for (int i = 0; i < invoiceTypeEntryCollection.size(); ++i) {
                    invoiceTypeEntryInfoTemp = invoiceTypeEntryCollection.get(i);
                    if (!companyNumber.equals(invoiceTypeEntryInfoTemp.getCompany().getNumber())) continue;
                    if (!BizCollUtil.objectIsNull(taxClassNumber)) {
                        if (StringUtils.isNotBlank((String)invoiceTypeEntryInfoTemp.getTaxClassCode())) {
                            invoiceTypeEntryInfo = invoiceTypeEntryInfoTemp;
                            break;
                        }
                        if (invoiceTypeEntryInfo != null) continue;
                        invoiceTypeEntryInfo = invoiceTypeEntryInfoTemp;
                        continue;
                    }
                    if (!StringUtils.isBlank((String)invoiceTypeEntryInfoTemp.getTaxClassCode())) continue;
                    invoiceTypeEntryInfo = invoiceTypeEntryInfoTemp;
                    break;
                }
                if (invoiceTypeEntryInfo == null) continue;
                break;
            }
        }
        if (invoiceTypeEntryInfo == null) {
            logger.error((Object)"##cp.bc getInvoiceTypeEntryInfo invoiceTypeEntryInfo is null ");
        } else {
            logger.error((Object)("##cp.bc getInvoiceTypeEntryInfo invoiceTypeEntryInfo is " + invoiceTypeEntryInfo.toString()));
        }
        return invoiceTypeEntryInfo;
    }

    public static SelectorItemCollection getInvoiceTypeEntryInfoSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("taxClassCode"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("isDeduction"));
        sic.add(new SelectorItemInfo("ticketTypeId.id"));
        sic.add(new SelectorItemInfo("ticketTypeId.name"));
        sic.add(new SelectorItemInfo("ticketTypeId.number"));
        sic.add(new SelectorItemInfo("expenseType.*"));
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("expenseType.name"));
        sic.add(new SelectorItemInfo("expenseType.displayName"));
        sic.add(new SelectorItemInfo("expenseType.typeSimpleName"));
        sic.add(new SelectorItemInfo("expenseType.longNumber"));
        sic.add(new SelectorItemInfo("expenseType.operationType.id"));
        sic.add(new SelectorItemInfo("expenseType.operationType.number"));
        sic.add(new SelectorItemInfo("expenseType.operationType.name"));
        sic.add(new SelectorItemInfo("expenseType.operationType.isEnable"));
        return sic;
    }

    public static String getTicketParam(Context ctx, String applierCompanyId) throws BOSException, EASBizException {
        boolean ticketUsed = false;
        boolean ticketEnterprise = false;
        boolean ticketTaxNumber = false;
        boolean ticketCheckFail = false;
        boolean ticketPersonal = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP03901");
        paramList.add("CP03902");
        paramList.add("CP03903");
        paramList.add("CP03904");
        paramList.add("CP03909");
        IExpenseCommenFacade iExpenseCommenFacade = null;
        iExpenseCommenFacade = ctx != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx) : ExpenseCommenFacadeFactory.getRemoteInstance();
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        ticketUsed = new Boolean(paramMap.get("CP03901").toString());
        ticketEnterprise = new Boolean(paramMap.get("CP03902").toString());
        ticketTaxNumber = new Boolean(paramMap.get("CP03903").toString());
        ticketCheckFail = new Boolean(paramMap.get("CP03904").toString());
        ticketPersonal = new Boolean(paramMap.get("CP03909").toString());
        return (ticketUsed ? "1" : "0") + (ticketEnterprise ? "1" : "0") + (ticketTaxNumber ? "1" : "0") + (ticketCheckFail ? "1" : "0") + (ticketPersonal ? "1" : "0");
    }

    public static void delBillInvoice(Context ctx, CoreBillBaseInfo info) throws EASBizException, BOSException {
        String billTypeId = info.getId().getType().toString();
        if (info.get("applierCompany") != null) {
            String userId;
            String applierCompanyId = ((CompanyOrgUnitInfo)info.get("ApplierCompany")).getId().toString();
            Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, (BizCollBillBaseInfo)info);
            String clientId = clientMap.get(CLIENT_ID);
            String clientSecret = clientMap.get(CLIENT_SECRET);
            Long timeStamp = InvoiceUtil.getTimeStamp();
            String ticketParam = InvoiceUtil.getTicketParam(ctx, applierCompanyId);
            if (info.getCreator() != null) {
                userId = info.getCreator().getId().toString();
            } else {
                UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                userId = user.getId().toString();
            }
            JSONObject retunObject = new JSONObject();
            retunObject.put("userKey", (Object)"");
            retunObject.put("timestamp", (Object)timeStamp);
            retunObject.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
            retunObject.put("client_id", (Object)clientId);
            retunObject.put("bxd_key", (Object)info.getId().toString());
            retunObject.put("ticketParam", (Object)ticketParam);
            retunObject.put("eid", (Object)userId);
            retunObject.put("billTypeId", (Object)billTypeId);
            String description = InvoiceUtil.getDefaultDescription(ctx);
            String url = invoice.getInvoiceUrl() + invoice.getDelBillInvoice();
            String result = InvoiceUtil.httpsRequestPost(url, retunObject.toString(), "utf-8");
            JSONObject parseObject = JSONObject.parseObject((String)result);
            if (!"0000".equals(parseObject.get((Object)"errcode"))) {
                throw new InvoiceException(InvoiceException.DELINVOICEERRORMESSAGE, new Object[]{"FID:" + info.getId() + ";" + parseObject.getString("description")});
            }
        }
    }

    public static InvoiceTypeInfo getTicketTypeId(String invoiceType2) throws BOSException {
        InvoiceTypeInfo invoiceTypeInfo = null;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)invoiceType2, CompareType.EQUALS));
        entityView.setFilter(filter);
        InvoiceTypeCollection invoiceTypeCollection = InvoiceTypeFactory.getRemoteInstance().getInvoiceTypeCollection(entityView);
        if (invoiceTypeCollection.size() > 0) {
            invoiceTypeInfo = invoiceTypeCollection.get(0);
        }
        return invoiceTypeInfo;
    }

    public static InvoiceTypeInfo getTicketTypeId(Context ctx, String invoiceType2) throws BOSException {
        IInvoiceType iInvoiceType = null;
        iInvoiceType = ctx != null ? InvoiceTypeFactory.getLocalInstance(ctx) : InvoiceTypeFactory.getRemoteInstance();
        InvoiceTypeInfo invoiceTypeInfo = null;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)invoiceType2, CompareType.EQUALS));
        entityView.setFilter(filter);
        InvoiceTypeCollection invoiceTypeCollection = iInvoiceType.getInvoiceTypeCollection(entityView);
        if (invoiceTypeCollection.size() > 0) {
            invoiceTypeInfo = invoiceTypeCollection.get(0);
        }
        return invoiceTypeInfo;
    }

    public static String getInvoiceTypeData(Context ctx, BizCollBillBaseInfo baseInfo) throws EASBizException, BOSException {
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, baseInfo);
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        JSONObject billJson = new JSONObject();
        if (clientId != null) {
            billJson.put("client_id", (Object)clientId);
        }
        if (clientSecret != null) {
            billJson.put("client_secret", (Object)clientSecret);
        }
        Long timeStamp = InvoiceUtil.getTimeStamp();
        billJson.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        billJson.put("timestamp", (Object)timeStamp);
        billJson.put("userKey", (Object)"");
        String url = invoice.getInvoiceUrl() + invoice.getInvoiceType();
        String result = InvoiceUtil.httpsRequestPost(url, billJson.toString(), "utf-8");
        if (result != null) {
            logger.error((Object)("#####cpbc runner getInvoiceType result = " + result));
            return result;
        }
        return null;
    }

    public static String getInvoiceTypeData(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, company);
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        JSONObject billJson = new JSONObject();
        if (clientId != null) {
            billJson.put("client_id", (Object)clientId);
        }
        if (clientSecret != null) {
            billJson.put("client_secret", (Object)clientSecret);
        }
        Long timeStamp = InvoiceUtil.getTimeStamp();
        billJson.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        billJson.put("timestamp", (Object)timeStamp);
        billJson.put("userKey", (Object)"");
        String url = invoice.getInvoiceUrl() + invoice.getInvoiceType();
        String result = InvoiceUtil.httpsRequestPost(url, billJson.toString(), "utf-8");
        if (result != null) {
            logger.error((Object)("#####cpbc runner getInvoiceType result = " + result));
            return result;
        }
        return null;
    }

    public static boolean getDeductionByInvoiceTypeEntry(Context ctx, String taxClassNumber, String ticketTypeNumber, BizCollBillBaseInfo baseInfo, Map<String, Object> spareMap) throws BOSException {
        boolean isDeduction = false;
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = InvoiceUtil.getInvoiceTypeEntryInfo(ctx, baseInfo, ticketTypeNumber, taxClassNumber, spareMap);
        if (invoiceTypeEntryInfo != null) {
            isDeduction = invoiceTypeEntryInfo.isIsDeduction();
        }
        return isDeduction;
    }

    @Deprecated
    public static boolean getDeductionByInvoiceTypeEntry(Context ctx, String taxClassNumber, InvoiceTypeInfo invoiceTypeInfo) {
        boolean isDeduction = false;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("taxClassCode"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("isDeduction"));
        view.getSelector().add(new SelectorItemInfo("ticketTypeId.id"));
        view.getSelector().add(new SelectorItemInfo("ticketTypeId.name"));
        view.getSelector().add(new SelectorItemInfo("ticketTypeId.number"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo();
        if (!BizCollUtil.objectIsNull(taxClassNumber)) {
            filterItem = new FilterItemInfo("taxClassCode", (Object)taxClassNumber, CompareType.LIKE);
            filter.getFilterItems().add(filterItem);
            if (!BizCollUtil.objectIsNull(invoiceTypeInfo)) {
                filterItem = new FilterItemInfo("ticketTypeId", (Object)invoiceTypeInfo.getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 or #1");
            }
        } else if (invoiceTypeInfo != null) {
            filterItem = new FilterItemInfo("ticketTypeId", (Object)invoiceTypeInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        view.setFilter(filter);
        IInvoiceTypeEntry iInvoiceTypeEntry = null;
        try {
            InvoiceTypeEntryInfo invoiceTypeEntryInfo;
            int i;
            iInvoiceTypeEntry = ctx == null ? InvoiceTypeEntryFactory.getRemoteInstance() : InvoiceTypeEntryFactory.getLocalInstance(ctx);
            InvoiceTypeEntryCollection invoiceTypeEntryCollection = iInvoiceTypeEntry.getInvoiceTypeEntryCollection(view);
            boolean isExit = true;
            int size = invoiceTypeEntryCollection.size();
            for (i = 0; i < size && isExit; ++i) {
                invoiceTypeEntryInfo = invoiceTypeEntryCollection.get(i);
                if (invoiceTypeEntryInfo == null || BizCollUtil.objectIsNull(taxClassNumber) || !taxClassNumber.equals(invoiceTypeEntryInfo.getNumber())) continue;
                isDeduction = invoiceTypeEntryInfo.isIsDeduction();
                isExit = false;
            }
            for (i = 0; i < size && isExit; ++i) {
                invoiceTypeEntryInfo = invoiceTypeEntryCollection.get(i);
                if (invoiceTypeEntryInfo == null || invoiceTypeInfo == null || !BizCollUtil.objectIsNull(invoiceTypeEntryInfo.getNumber()) || BizCollUtil.objectIsNull(invoiceTypeEntryInfo.getTicketTypeId()) || !invoiceTypeEntryInfo.getTicketTypeId().getNumber().equals(invoiceTypeInfo.getNumber())) continue;
                isDeduction = invoiceTypeEntryInfo.isIsDeduction();
                isExit = false;
            }
        }
        catch (BOSException e) {
            logger.info((Object)("###########cpbc runner #######" + e.getMessage()), (Throwable)e);
        }
        return isDeduction;
    }

    public static void buildPurEntriesJson(Context ctx, BizCollBillBaseInfo info, JSONArray entriesJson, Map paramMap) throws EASBizException, BOSException {
        DailyPurchaseAccountBillInfo purInfo = (DailyPurchaseAccountBillInfo)info;
        DailyPurchaseAccountBillEntryCollection entries = purInfo.getEntries();
        PurTicketEntryCollection tickeEntries = purInfo.getTickeEntries();
        Iterator entriesIterator = entries.iterator();
        while (entriesIterator.hasNext()) {
            DailyPurchaseAccountBillEntryInfo entry = (DailyPurchaseAccountBillEntryInfo)entriesIterator.next();
            String serialNo = entry.getEntrySerialNo();
            if (serialNo == null) continue;
            JSONObject entryJson = new JSONObject();
            entryJson.put("entryid", (Object)entry.getId().toString());
            String[] fid = serialNo.split(",");
            entryJson.put("fid", (Object)fid);
            entriesJson.add((Object)entryJson);
        }
        InvoiceUtil.getBizRelation(info, entriesJson, tickeEntries, entries);
    }

    public static String getAccessToken(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String description = InvoiceUtil.getDefaultDescription(ctx);
        StringBuffer url = new StringBuffer();
        if ("test".equalsIgnoreCase(invoice.getEnv())) {
            url.append(invoice.getApiPiaoZoneTest()).append(invoice.getAccessToken());
        } else {
            url.append(invoice.getApiPiaoZoneProd()).append(invoice.getAccessToken());
        }
        String result = InvoiceUtil.httpsRequestPost(url.toString(), jsonObject.toString(), "utf-8");
        if (result == null) {
            return null;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new InvoiceException(InvoiceException.GETACCESSTOKENERRORMESSAGE, new Object[]{parseObject.getString("description")});
        }
        return parseObject.getString("access_token");
    }

    public static String checkInvoiceTrue(Context ctx, JSONObject jsonObject, String token) throws BOSException, EASBizException {
        String url = invoice.getInvoiceUrl() + invoice.getCheckStates() + "?access_token=" + token;
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result == null) {
            return null;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new InvoiceException(InvoiceException.CHECKSTATESERRORMESSAGE, new Object[]{parseObject.getString("description")});
        }
        return parseObject.getString("data");
    }

    public static CPBCCheckStates getCheckStatesEnum(String checkState) {
        CPBCCheckStates checkTicketState = null;
        switch (Integer.parseInt(checkState)) {
            case 1: {
                checkTicketState = CPBCCheckStates.PASS;
                break;
            }
            case 2: {
                checkTicketState = CPBCCheckStates.NOT_PASS;
                break;
            }
            case 3: {
                checkTicketState = CPBCCheckStates.UNVERIFIED;
                break;
            }
            case 4: {
                checkTicketState = CPBCCheckStates.ARTIFICIAL_PASS;
                break;
            }
            default: {
                checkTicketState = CPBCCheckStates.UNVERIFIED;
            }
        }
        return checkTicketState;
    }

    public static byte[] getReportCoverStream(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        final Context ctxa = ctx;
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        BOSObjectType bosobjecttype = info.getId().getType();
        list.add(info.getId());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String tableName = InvoiceUtil.getR1ReportBillQueryName(bosobjecttype);
        MetaDataPK tdquery = new MetaDataPK(tableName);
        BizCollBillDataProvider data = new BizCollBillDataProvider(ctx, list, (IMetaDataPK)tdquery);
        String tDFileName = InvoiceUtil.getDefaultTemplate(ctx, info);
        WebContextUtil.initRpcConfig((Context)ctxa);
        try {
            KDNoteWebServerHelper helper = new KDNoteWebServerHelper();
            helper.setContextProvider(new IContextProvider(){

                public IBizContext getBizContext(Context bosCtx) {
                    IBizContext bizCtx = null;
                    try {
                        bizCtx = KDNoteHelper.makeContext((Context)ctxa);
                    }
                    catch (ConnectException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return bizCtx;
                }
            });
            boolean exportPDF = helper.exportPDF(tDFileName, (Object)data, (OutputStream)outputStream);
            logger.error((Object)("#####\u83b7\u53d6\u9ed8\u8ba4\u5c01\u9762\u5957\u6253\u7ed3\u679c\uff1a" + exportPDF));
            if (!exportPDF) {
                throw new InvoiceException(InvoiceException.GETDEFAULTREPORTPDFERROR);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new InvoiceException(InvoiceException.GETDEFAULTREPORTSTEAMERROR);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static String getReportCoverTemplateName(BOSObjectType bosType) {
        String tdTemplatePath = null;
        if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            tdTemplatePath = "/FI/CPBC/bizaccount/image";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            tdTemplatePath = "/FI/CPBC/DailyExpenseAccount/image";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            tdTemplatePath = "/FI/CPBC/tra/image";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            tdTemplatePath = "/FI/CPBC/BizAccountOutBill/image";
        }
        return tdTemplatePath;
    }

    private static String getR1ReportBillQueryName(BOSObjectType bosType) {
        String queryPk = null;
        if (CPBCCommonParams.BIZACCOUNTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountBillForR1PrintQuery";
        } else if (CPBCCommonParams.DAILYPURSHASEBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.DailyPurchaseAccountBillForR1PrintQuery";
        } else if (CPBCCommonParams.TRAVELBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.TravelAccountBillForR1PrintQuery";
        } else if (CPBCCommonParams.BIZACCOUNTOUTBOSTYPE.equals((Object)bosType)) {
            queryPk = "com.kingdee.eas.cp.bc.app.BizAccountOutBillForR1PrintQuery";
        }
        return queryPk;
    }

    private static String getOrgUserStr(Context ctx, BizCollBillBaseInfo info) {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        return ((OrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString() + " " + user.getNumber();
    }

    public static String getDefaultTemplate(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        String tdTemplatePath = InvoiceUtil.getReportCoverTemplateName(info.getId().getType());
        String orgUser = InvoiceUtil.getOrgUserStr(ctx, info);
        logger.error((Object)("#####\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u548c\u767b\u5f55\u4eba\u4e3a\uff1a" + orgUser));
        IPrintConfigFacade printConfigFacade = null;
        printConfigFacade = ctx == null ? PrintConfigFacadeFactory.getRemoteInstance() : PrintConfigFacadeFactory.getLocalInstance((Context)ctx);
        String defaultTemplate = printConfigFacade.getDefaultTemplate(orgUser, "/EAS_Note.kdrs" + tdTemplatePath);
        if (!StringUtils.isEmpty((String)defaultTemplate)) {
            logger.error((Object)("#####\u6839\u636e\u5f53\u524d\u767b\u5f55\u7ec4\u7ec7\u83b7\u53d6\u7684\u9ed8\u8ba4\u5957\u6253\u5c01\u9762\u6a21\u677f\u8def\u5f84\u4e3a\uff1a" + defaultTemplate));
            return tdTemplatePath + defaultTemplate;
        }
        throw new InvoiceException(InvoiceException.GETDEFAULTREPORTERROR);
    }

    public static String getCqShowInvoiceUrl(Context ctx, BizCollBillBaseInfo baseInfo, String random, Map<String, Object> spareMap) throws BOSException, EASBizException {
        StringBuffer url = new StringBuffer();
        StringBuffer signiture = new StringBuffer();
        Long timeStamp = InvoiceUtil.getTimeStamp();
        String cqBillerId = (String)baseInfo.get("cqBillerId");
        String cqTaxNumber = (String)baseInfo.get("cqTaxNumber");
        String cqBillIdAndNum = (String)baseInfo.get("cqBillIdAndNum");
        String cqClientId = (String)baseInfo.get("cqClientId");
        String cqClientSecret = (String)baseInfo.get("cqClientSecret");
        signiture.append(cqClientId).append(cqClientSecret).append(cqTaxNumber);
        signiture.append(cqBillerId).append(timeStamp);
        if ("test".equalsIgnoreCase(invoice.getEnv())) {
            url.append(invoice.getApiPiaoZoneTest()).append(invoice.getCqShowInvoice());
        } else {
            url.append(invoice.getApiPiaoZoneProd()).append(invoice.getCqShowInvoice());
        }
        url.append("?eid=").append(cqBillerId);
        url.append("&tin=").append(cqTaxNumber);
        url.append("&bxd_key=").append(cqBillIdAndNum);
        url.append("&billNumber=").append(cqBillIdAndNum);
        url.append("&client_id=").append(cqClientId);
        url.append("&timestamp=").append(timeStamp);
        url.append("&random=").append(random);
        url.append("&sign=").append(MD5.md5crypt(signiture.toString()));
        url.append("&initCache=true");
        return url.toString();
    }

    public static Map batchDelInvoice(BizCollBillBaseInfo baseInfo, Map<String, Object> spareMap, String[] entryIds) throws BOSException, EASBizException {
        StringBuffer loggerStr = new StringBuffer(12);
        HashSet<String> needDelTicketIds = new HashSet<String>();
        logger.error((Object)"######cpbc batch delInvoice start \u6279\u91cf\u5220\u9664--\u5f00\u59cb\uff01       ");
        spareMap.put("delEntryIds", Sets.newHashSet(Arrays.asList(entryIds)));
        for (String entryId : entryIds) {
            Map<String, Object> entryLinkSerialNo = InvoiceUtil.getEntryLinkSerialNo(baseInfo, entryId, spareMap);
            loggerStr.append(entryLinkSerialNo.get("log"));
            needDelTicketIds.addAll((Set)entryLinkSerialNo.get("ticketEntryIds"));
        }
        Map<String, Object> batchDelTickEntry = InvoiceUtil.batchDelTickEntry(needDelTicketIds, baseInfo, spareMap);
        logger.error((Object)"######cpbc batch delInvoice end \u6279\u91cf\u5220\u9664--\u7ed3\u675f\uff01       ");
        return batchDelTickEntry;
    }

    public static Map<String, Object> batchDelTickEntry(Set<String> selectTicketIds, BizCollBillBaseInfo baseInfo, Map<String, Object> spareMap) throws EASBizException, BOSException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (selectTicketIds.size() < 1) {
            return returnMap;
        }
        AbstractObjectCollection entries = (AbstractObjectCollection)baseInfo.get("entries");
        HashSet<String> delEntries = new HashSet<String>(20);
        HashMap<String, CoreBillEntryBaseInfo> editEntries = new HashMap<String, CoreBillEntryBaseInfo>(20);
        ArrayList delTicketEntries = new ArrayList(20);
        HashSet delVatTicketEntries = new HashSet(20);
        String billType = InvoiceUtil.getBillType(baseInfo, spareMap);
        Map paramMap = (Map)spareMap.get("paramMap");
        Boolean isUseDeduction = (Boolean)paramMap.get("isUseDeduction");
        if (spareMap.get("delEntryIds") != null) {
            Set entryids = (Set)spareMap.get("delEntryIds");
            delEntries.addAll(entryids);
            spareMap.remove("delEntryIds");
        }
        StringBuffer loggerStr = new StringBuffer(30);
        Map findTicketEntryInfoMap = InvoiceUtil.findTicketEntryInfoMap(baseInfo, selectTicketIds, spareMap);
        Map serialNoMap = (Map)findTicketEntryInfoMap.get("serialNoMap");
        Set entryIdSet = (Set)findTicketEntryInfoMap.get("entryIdSet");
        Map ticketEntriesMap = (Map)findTicketEntryInfoMap.get("ticketEntriesMap");
        Map findVatEntryInfoMap = InvoiceUtil.findVatEntryInfoMap(baseInfo, spareMap);
        Map vatEntryData = (Map)findVatEntryInfoMap.get("vatEntryData");
        Map vatEntryInfoMap = (Map)findVatEntryInfoMap.get("vatEntryInfoMap");
        for (CoreBillEntryBaseInfo entryInfo : entries) {
            BigDecimal tax;
            String entryId = entryInfo.getString("id");
            if (StringUtils.isEmpty((String)entryInfo.getString("entrySerialNo"))) {
                if (!entryIdSet.contains(entryId)) continue;
                delEntries.add(entryId);
                List ticIdList = (List)ticketEntriesMap.get(entryId);
                delTicketEntries.addAll(ticIdList);
                continue;
            }
            boolean linkSerialNo = false;
            String[] serialNoStr = entryInfo.getString("entrySerialNo").split(",");
            ArrayList entrySerialNoList = Lists.newArrayList(Arrays.asList(serialNoStr));
            for (String serialNo : serialNoStr) {
                if (!serialNoMap.containsKey(serialNo)) continue;
                linkSerialNo = true;
                break;
            }
            if (!linkSerialNo) continue;
            String entryTicNumber = entryInfo.getString("entryTicNumber");
            ArrayList ticketNumList = null;
            BigDecimal entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo, "amountOri");
            BigDecimal entryTax = InvoiceUtil.AmountNotNull(entryInfo, "tax");
            if (entryTicNumber != null) {
                ticketNumList = Lists.newArrayList(Arrays.asList(entryTicNumber.split(",")));
            }
            for (String serialNo : serialNoStr) {
                if (entryTicNumber != null && serialNoMap.containsKey(serialNo)) {
                    String ticketNumber = (String)((Map)serialNoMap.get(serialNo)).get("ticketNumber");
                    if (ticketNumList != null) {
                        ticketNumList.remove(ticketNumber);
                    }
                }
                if (!serialNoMap.containsKey(serialNo)) continue;
                entrySerialNoList.remove(serialNo);
                if (vatEntryData.get(serialNo) != null) {
                    delVatTicketEntries.addAll((Collection)vatEntryData.get(serialNo));
                }
                if (entrySerialNoList.size() < 1) {
                    delEntries.add(entryId);
                    continue;
                }
                String vatMapKey = serialNo + entryId;
                if (TRA_BILL.equals(billType)) {
                    InvoiceUtil.traDelTicketAmountHandler(vatMapKey, vatEntryInfoMap, entryInfo);
                    continue;
                }
                if (PUR_BILL.equals(billType)) {
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    map.put("isUseDeduction", isUseDeduction);
                    InvoiceUtil.purDelTicketAmountHandler(vatMapKey, vatEntryInfoMap, (Map)serialNoMap.get(serialNo), entryInfo, map);
                    continue;
                }
                if (!"".equals(billType) && !BIZOUT_BILL.equals(billType)) continue;
                tax = BizCollUtil.ZERO;
                if (vatEntryData.get(serialNo) != null) {
                    List vatEntryColl = (List)vatEntryInfoMap.get(vatMapKey);
                    if (vatEntryColl == null) {
                        logger.error((Object)("vatMapKey\u4e3a" + vatMapKey + "\u5728vatEntryInfoMap\u4e2d\u627e\u4e0d\u5230\u4e86" + vatEntryInfoMap.toString()));
                        continue;
                    }
                    for (TicketBaseEntryInfo vatInfo : vatEntryColl) {
                        BigDecimal amout = vatInfo.getAmout();
                        tax = vatInfo.getTax();
                        entryAmountOri = entryAmountOri.subtract(amout);
                        entryTax = entryTax.subtract(tax);
                    }
                    continue;
                }
                Map ticketEntryInfo = (Map)serialNoMap.get(serialNo);
                BigDecimal amount = (BigDecimal)ticketEntryInfo.get("amount");
                tax = isUseDeduction != false ? InvoiceUtil.AmountNotNull(ticketEntryInfo.get("deductionTax")) : InvoiceUtil.AmountNotNull(ticketEntryInfo.get("tax"));
                entryAmountOri = entryAmountOri.subtract(amount);
                entryTax = entryTax.subtract(tax);
            }
            if (entrySerialNoList.size() < 1) {
                delEntries.add(entryId);
                continue;
            }
            if (ticketNumList != null) {
                entryInfo.setString("entryTicNumber", StringUtils.join((Object[])ticketNumList.toArray(), (String)","));
            }
            String invoiceNum = "";
            String invoiceStr = "";
            if (spareMap.get("locale") != null) {
                invoiceStr = EASResource.getString((String)invoiceResource, (String)"INVOICE_STR", (Locale)((Locale)spareMap.get("locale")));
                invoiceNum = EASResource.getString((String)invoiceResource, (String)"INVOICE_NUM_STR", (Locale)((Locale)spareMap.get("locale")));
            } else {
                invoiceStr = EASResource.getString((String)invoiceResource, (String)"INVOICE_STR");
                invoiceNum = EASResource.getString((String)invoiceResource, (String)"INVOICE_NUM_STR");
            }
            entryInfo.setString("entrySerialNo", StringUtils.join((Object[])entrySerialNoList.toArray(), (String)","));
            entryInfo.setString("invoiceNum", invoiceStr + entrySerialNoList.size() + invoiceNum);
            BigDecimal entryExRate = entryInfo.getBigDecimal("exchangeRate");
            BigDecimal entryAmount = BizCollUtil.ZERO;
            BigDecimal entryAmountWithoutTax = BizCollUtil.ZERO;
            if (TRA_BILL.equals(billType)) {
                entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("amountOri"));
                tax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("tax"));
                BigDecimal taxiExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("taxiExpenseTax"));
                BigDecimal bussesExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("bussesExpenseTax"));
                BigDecimal otherExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("otherExpenseTax"));
                entryTax = tax.add(taxiExpenseTax).add(bussesExpenseTax).add(otherExpenseTax);
            }
            if (PUR_BILL.equals(billType)) {
                entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("amountOri"));
                entryTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("tax"));
                BigDecimal num = InvoiceUtil.AmountNotNull(entryInfo, "count");
                InvoiceUtil.buildPurEntryPriceAndCount(entryInfo, num);
            }
            BigDecimal entryAmountOriWithoutTax = entryAmountOri.subtract(entryTax).setScale(2, 4);
            entryInfo.setBigDecimal("amountOri", entryAmountOri);
            entryInfo.setBigDecimal("amountOriWithoutTax", entryAmountOriWithoutTax);
            if (!TRA_BILL.equals(billType)) {
                entryInfo.setBigDecimal("tax", entryTax);
            }
            if (entryExRate != null && BizCollUtil.ZERO.compareTo(entryExRate) != 0) {
                if (entryInfo.getInt("convertMode") == 1) {
                    entryAmount = entryAmountOri.divide(entryExRate, 2, 4);
                    entryAmountWithoutTax = entryAmountOriWithoutTax.divide(entryExRate, 2, 4);
                } else {
                    entryAmount = entryAmountOri.multiply(entryExRate).setScale(2, 4);
                    entryAmountWithoutTax = entryAmountOriWithoutTax.multiply(entryExRate).setScale(2, 4);
                }
            }
            entryInfo.setBigDecimal("amount", entryAmount);
            entryInfo.setBigDecimal("amountWithoutTax", entryAmountWithoutTax);
            editEntries.put(entryId, entryInfo);
        }
        delTicketEntries.addAll(Lists.newArrayList(selectTicketIds));
        logger.error((Object)("delTicketEntry billNumber:" + baseInfo.getNumber() + loggerStr.toString()));
        returnMap.put("delEntries", delEntries);
        returnMap.put("delTicketEntries", delTicketEntries);
        returnMap.put("delVatTicketEntries", delVatTicketEntries);
        returnMap.put("editEntries", editEntries);
        return returnMap;
    }

    private static void traDelTicketAmountHandler(String vatMapKey, Map<String, List<TicketBaseEntryInfo>> vatEntryInfoMap, CoreBillEntryBaseInfo entryInfo) {
        List<TicketBaseEntryInfo> vatEntryColl = vatEntryInfoMap.get(vatMapKey);
        if (vatEntryColl == null) {
            logger.error((Object)("\u5dee\u65c5\u5355\uff0cvatMapKey\u4e3a" + vatMapKey + "\u4e0d\u5b58\u5728\u4e8e\u591a\u660e\u7ec6\u53d1\u7968\u5206\u5f55vatEntryInfoMap\u4e2d" + vatEntryInfoMap.toString()));
            return;
        }
        BigDecimal entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo, "amountOri");
        BigDecimal entryTax = InvoiceUtil.AmountNotNull(entryInfo, "tax");
        for (TicketBaseEntryInfo vatInfo : vatEntryColl) {
            BigDecimal amout = vatInfo.getAmout();
            BigDecimal tax = vatInfo.getTax();
            BigDecimal amCadFund = InvoiceUtil.AmountNotNull(vatInfo, "cadFund");
            BigDecimal amoutWithOutTax = amout.subtract(tax).subtract(amCadFund);
            BigDecimal amInsurancePremium = InvoiceUtil.AmountNotNull(vatInfo, "insurancePremium");
            String costType = (String)vatInfo.get("costType");
            if ("city".equals(costType)) {
                BigDecimal taxiExpense = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("taxiExpense"));
                BigDecimal taxiExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("taxiExpenseTax"));
                BigDecimal taxiExpenseWithoutTax = taxiExpense.subtract(taxiExpenseTax);
                entryInfo.setBigDecimal("taxiExpense", taxiExpense.subtract(amout));
                entryInfo.setBigDecimal("taxiExpenseTax", taxiExpenseTax.subtract(tax));
                entryInfo.setBigDecimal("taxiExpenseWithoutTax", taxiExpenseWithoutTax.subtract(amoutWithOutTax));
            } else if ("suburb".equals(costType)) {
                BigDecimal bussesExpense = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("bussesExpense"));
                BigDecimal bussesExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("bussesExpenseTax"));
                BigDecimal cadFund = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("cadFund"));
                BigDecimal bussesExpenseWithoutTax = bussesExpense.subtract(bussesExpenseTax).subtract(cadFund);
                entryInfo.setBigDecimal("bussesExpense", bussesExpense.subtract(amout));
                entryInfo.setBigDecimal("bussesExpenseTax", bussesExpenseTax.subtract(tax));
                entryInfo.setBigDecimal("bussesExpenseWithoutTax", bussesExpenseWithoutTax.subtract(amoutWithOutTax));
                entryInfo.setBigDecimal("cadFund", cadFund.subtract(amCadFund));
                if (amInsurancePremium.compareTo(BizCollUtil.ZERO) > 0) {
                    BigDecimal otherExpense = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("otherExpense"));
                    BigDecimal otherExpenseWithoutTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("otherExpenseWithoutTax"));
                    entryInfo.setBigDecimal("otherExpense", otherExpense.subtract(amInsurancePremium));
                    entryInfo.setBigDecimal("otherExpenseWithoutTax", otherExpenseWithoutTax.subtract(amInsurancePremium));
                }
            } else if ("hotel".equals(costType)) {
                BigDecimal hotelExpense = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("hotelExpense"));
                BigDecimal hotelExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("tax"));
                BigDecimal hotelExpenseWithoutTax = hotelExpense.subtract(hotelExpenseTax);
                entryInfo.setBigDecimal("hotelExpense", hotelExpense.subtract(amout));
                entryInfo.setBigDecimal("tax", hotelExpenseTax.subtract(tax));
                entryInfo.setBigDecimal("hotelExpenseWithoutTax", hotelExpenseWithoutTax.subtract(amoutWithOutTax));
            } else if ("other".equals(costType)) {
                BigDecimal otherExpense = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("otherExpense"));
                BigDecimal otherExpenseTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("otherExpenseTax"));
                BigDecimal otherExpenseWithoutTax = otherExpense.subtract(otherExpenseTax);
                entryInfo.setBigDecimal("otherExpense", otherExpense.subtract(amout));
                entryInfo.setBigDecimal("otherExpenseTax", otherExpenseTax.subtract(tax));
                entryInfo.setBigDecimal("otherExpenseWithoutTax", otherExpenseWithoutTax.subtract(amoutWithOutTax));
            }
            entryAmountOri = entryAmountOri.subtract(amout).subtract(amInsurancePremium);
            entryTax = entryTax.subtract(tax);
        }
        entryInfo.setBigDecimal("amountOri", entryAmountOri);
    }

    private static void purDelTicketAmountHandler(String vatMapKey, Map<String, List<TicketBaseEntryInfo>> vatEntryInfoMap, Map ticketEntryInfo, CoreBillEntryBaseInfo entryInfo, Map spareMap) {
        List<TicketBaseEntryInfo> vatEntryColl = vatEntryInfoMap.get(vatMapKey);
        Boolean isUseDeduction = (Boolean)spareMap.get("isUseDeduction");
        BigDecimal entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo, "amountOri");
        BigDecimal entryTax = InvoiceUtil.AmountNotNull(entryInfo, "tax");
        BigDecimal entryNum = InvoiceUtil.AmountNotNull(entryInfo, "count");
        BigDecimal tax = BizCollUtil.ZERO;
        if (vatEntryColl == null) {
            BigDecimal amount = (BigDecimal)ticketEntryInfo.get("amount");
            tax = isUseDeduction != false ? InvoiceUtil.AmountNotNull(ticketEntryInfo.get("deductionTax")) : InvoiceUtil.AmountNotNull(ticketEntryInfo.get("tax"));
            entryAmountOri = entryAmountOri.subtract(amount);
            entryTax = entryTax.subtract(tax);
            entryNum = entryNum.subtract(BizCollUtil.ONE);
        } else {
            for (TicketBaseEntryInfo vatInfo : vatEntryColl) {
                BigDecimal amout = vatInfo.getAmout();
                tax = vatInfo.getTax();
                BigDecimal num = InvoiceUtil.AmountNotNull(vatInfo, "num");
                entryAmountOri = entryAmountOri.subtract(amout);
                entryTax = entryTax.subtract(tax);
                entryNum = entryNum.subtract(num);
            }
        }
        entryInfo.setBigDecimal("amountOri", entryAmountOri);
        entryInfo.setBigDecimal("tax", entryTax);
        entryInfo.setBigDecimal("num", entryNum);
    }

    private static Map findTicketEntryInfoMap(BizCollBillBaseInfo baseInfo, Set<String> selectTicketIds, Map<String, Object> spareMap) {
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
        HashMap serialNoMap = new HashMap(20);
        HashSet<String> entryIdSet = new HashSet<String>(20);
        HashMap ticketEntriesMap = new HashMap(20);
        for (CoreBillEntryBaseInfo ticketEntryInfo : ticketEntries) {
            String bizEntryId = InvoiceUtil.getBizEntryBill(ticketEntryInfo);
            String ticEntryId = ticketEntryInfo.getId().toString();
            if (ticketEntriesMap.containsKey(bizEntryId)) {
                ((List)ticketEntriesMap.get(bizEntryId)).add(ticEntryId);
            } else {
                ArrayList<String> ticIds = new ArrayList<String>();
                ticIds.add(ticEntryId);
                ticketEntriesMap.put(bizEntryId, ticIds);
            }
            if (!selectTicketIds.contains(ticEntryId)) continue;
            String serialNo = ticketEntryInfo.getString("serialNo");
            String ticketNumber = ticketEntryInfo.getString("ticketNumber");
            String invoiceType2 = ticketEntryInfo.getString("invoiceType");
            String taxClassNumber = ticketEntryInfo.getString("taxClassNumber");
            BigDecimal amout = ticketEntryInfo.getBigDecimal("amout");
            BigDecimal tax = ticketEntryInfo.getBigDecimal("tax");
            BigDecimal deductionTax = ticketEntryInfo.getBigDecimal("deductionTax");
            boolean isDeduction = ticketEntryInfo.getBoolean("isDeduction");
            HashMap<String, Object> ticketEntryMap = new HashMap<String, Object>();
            ticketEntryMap.put("invoiceType", invoiceType2);
            ticketEntryMap.put("taxClassNumber", taxClassNumber);
            ticketEntryMap.put("ticketNumber", ticketNumber);
            ticketEntryMap.put("amount", amout);
            ticketEntryMap.put("tax", tax);
            ticketEntryMap.put("deductionTax", deductionTax);
            ticketEntryMap.put("isDeduction", isDeduction);
            serialNoMap.put(serialNo, ticketEntryMap);
            entryIdSet.add(bizEntryId);
        }
        HashMap<String, Cloneable> returnMap = new HashMap<String, Cloneable>();
        returnMap.put("serialNoMap", serialNoMap);
        returnMap.put("entryIdSet", entryIdSet);
        returnMap.put("ticketEntriesMap", ticketEntriesMap);
        return returnMap;
    }

    private static Map findVatEntryInfoMap(BizCollBillBaseInfo baseInfo, Map<String, Object> spareMap) {
        AbstractObjectCollection vatInvoiceEntries = (AbstractObjectCollection)baseInfo.get("vatInvoiceEntries");
        HashMap vatEntryData = new HashMap(20);
        HashMap vatEntryInfoMap = new HashMap(30);
        for (TicketBaseEntryInfo vatInfo : vatInvoiceEntries) {
            String serialNo = vatInfo.getSerialNo();
            String vatMapKey = serialNo + vatInfo.get("bizEntryBill");
            String vatId = vatInfo.getId().toString();
            if (vatEntryData.containsKey(serialNo)) {
                ((Set)vatEntryData.get(serialNo)).add(vatId);
            } else {
                HashSet<String> delVatId = new HashSet<String>(20);
                delVatId.add(vatId);
                vatEntryData.put(serialNo, delVatId);
            }
            if (vatEntryInfoMap.containsKey(vatMapKey)) {
                ((List)vatEntryInfoMap.get(vatMapKey)).add(vatInfo);
                continue;
            }
            ArrayList<TicketBaseEntryInfo> vatEntryList = new ArrayList<TicketBaseEntryInfo>(16);
            vatEntryList.add(vatInfo);
            vatEntryInfoMap.put(vatMapKey, vatEntryList);
        }
        HashMap<String, HashMap<String, AbstractCollection>> returnMap = new HashMap<String, HashMap<String, AbstractCollection>>();
        returnMap.put("vatEntryData", vatEntryData);
        returnMap.put("vatEntryInfoMap", vatEntryInfoMap);
        return returnMap;
    }

    public static JSONObject getUserkeyJson(Context ctx, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        if (baseInfo.getApplierCompany() == null) {
            throw new InvoiceException(InvoiceException.APPLIERCOMPANYISNULL);
        }
        if (baseInfo.getId() == null) {
            throw new InvoiceException(InvoiceException.BILLID_NOT_NULL);
        }
        UserInfo user = baseInfo.getBiller();
        String userId = user != null ? user.getId().toString() : "";
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, baseInfo);
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        String taxpayerId = clientMap.get(TAX_NUMBER);
        String registeredCode = clientMap.get(REGISTERED_CODE);
        if (taxpayerId == null || taxpayerId.isEmpty() || taxpayerId == "") {
            throw new InvoiceException(InvoiceException.CONFIGURE);
        }
        String billType = InvoiceUtil.getBillType(baseInfo, spareMap);
        String ticketParam = InvoiceUtil.getTicketParam(ctx, applierCompanyId);
        Long timeStamp = InvoiceUtil.getTimeStamp();
        JSONObject retunObject = new JSONObject();
        retunObject.put("client_id", (Object)clientId);
        retunObject.put("bxd_key", (Object)baseInfo.getId().toString());
        retunObject.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        retunObject.put("eid", (Object)userId);
        retunObject.put("timestamp", (Object)timeStamp);
        retunObject.put("tin", (Object)taxpayerId);
        retunObject.put("ghf_mc", (Object)registeredCode);
        retunObject.put("random", spareMap.get("random"));
        retunObject.put("billNumber", (Object)baseInfo.getNumber());
        retunObject.put("billType", (Object)billType);
        retunObject.put("ticketParam", (Object)ticketParam);
        retunObject.put("resource", (Object)2);
        String easLog = "url:" + invoice.getInvoiceUrl() + " clientId:" + clientId + " tin:" + taxpayerId + " registeredCode" + registeredCode;
        retunObject.put("easLog", (Object)easLog);
        retunObject.put("url", (Object)invoice.getInvoiceUrl());
        return retunObject;
    }

    public static Set<String> getTicketEntriesSerialNo(Context ctx, BizCollBillBaseInfo baseInfo, Map spareMap) throws EASBizException, BOSException {
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)baseInfo.get("tickeEntries");
        LinkedHashSet<String> serialNo = new LinkedHashSet<String>();
        if (ticketEntries != null && ticketEntries.size() > 0) {
            for (CoreBillEntryBaseInfo ticket : ticketEntries) {
                serialNo.add(ticket.get("serialNo").toString());
            }
        } else {
            serialNo.add("");
        }
        return serialNo;
    }

    public static JSONObject convertToBaseInvoiceData(JSONObject invoice, Map<String, Object> spareMap) {
        JSONObject jsonO = new JSONObject();
        String invoiceType2 = invoice.getString("invoiceType");
        jsonO = "3".equals(invoiceType2) || "4".equals(invoiceType2) || "1".equals(invoiceType2) || "5".equals(invoiceType2) || "2".equals(invoiceType2) || "15".equals(invoiceType2) || "12".equals(invoiceType2) || "13".equals(invoiceType2) || "26".equals(invoiceType2) || "27".equals(invoiceType2) ? InvoiceUtil.successToBase(invoice) : InvoiceUtil.successToNoVatBase(invoice);
        if (InvoiceUtil.isNotEmpty(invoice.get((Object)"costType"))) {
            jsonO.put("costType", invoice.get((Object)"costType"));
        }
        if (InvoiceUtil.isNotEmpty(invoice.get((Object)"verifyResult"))) {
            jsonO.put("verifyResult", invoice.get((Object)"verifyResult"));
        }
        if (InvoiceUtil.isNotEmpty(invoice.get((Object)"errorLevel"))) {
            jsonO.put("errorLevel", invoice.get((Object)"errorLevel"));
        }
        jsonO.put("expenseStatus", (Object)InvoiceUtil.nullToK(invoice.getString("expendStatus")));
        jsonO.put("rotationAngle", (Object)InvoiceUtil.nullToK(invoice.getString("rotationAngle")));
        jsonO.put("isRevise", (Object)InvoiceUtil.nullToK(invoice.getString("isRevise")));
        jsonO.put("isElectronicInvoice", (Object)(invoice.get((Object)"isElectronicInvoice") != null ? invoice.getBoolean("isElectronicInvoice") : false));
        logger.error((Object)("\u81ea\u5df1\u7ec4\u88c5\u540e\u7684\u5168\u7968\u9762\u6570\u636e\u4e3a\uff1a" + jsonO));
        return jsonO;
    }

    public static JSONObject successToNoVatBase(JSONObject invoice) {
        JSONObject jsonO = new JSONObject();
        jsonO.put("totalAmount", (Object)InvoiceUtil.nullToK(invoice.getString("totalAmount")));
        String taxAmount = "0";
        if (InvoiceUtil.isNotEmpty(invoice.getString("totalTaxAmount"))) {
            jsonO.put("taxAmount", (Object)invoice.getString("totalTaxAmount"));
            if (InvoiceUtil.isNotEmpty(invoice.getString("totalAmount"))) {
                jsonO.put("amount", (Object)invoice.getBigDecimal("totalAmount").subtract(invoice.getBigDecimal("totalTaxAmount")).setScale(2, 4).toString());
            }
        } else {
            jsonO.put("amount", (Object)InvoiceUtil.nullToK(invoice.getString("totalAmount")));
            jsonO.put("taxAmount", (Object)taxAmount);
        }
        String invoiceType2 = InvoiceUtil.nullToK(invoice.getString("invoiceType"));
        jsonO.put("invoiceType", (Object)invoiceType2);
        String invoiceCode = InvoiceUtil.nullToK(invoice.getString("invoiceCode"));
        String invoiceNo = InvoiceUtil.nullToK(invoice.getString("invoiceNo"));
        jsonO.put("invoiceCode", (Object)invoiceCode);
        jsonO.put("invoiceNo", (Object)invoiceNo);
        jsonO.put("taxRate", (Object)(invoice.getString("taxRate") == null ? "0" : invoice.getString("taxRate")));
        jsonO.put("buyerName", (Object)InvoiceUtil.nullToK(invoice.getString("buyerName")));
        jsonO.put("buyerTaxNo", (Object)InvoiceUtil.nullToK(invoice.getString("buyerTaxNo")));
        jsonO.put("buyerAddressPhone", (Object)InvoiceUtil.nullToK(invoice.getString("buyerAddressPhone")));
        jsonO.put("buyerAccount", (Object)InvoiceUtil.nullToK(invoice.getString("buyerAccount")));
        jsonO.put("salerName", (Object)InvoiceUtil.nullToK(invoice.getString("salerName")));
        jsonO.put("salerTaxNo", (Object)InvoiceUtil.nullToK(invoice.getString("salerTaxNo")));
        jsonO.put("salerAddressPhone", (Object)InvoiceUtil.nullToK(invoice.getString("salerAddressPhone")));
        jsonO.put("salerAccount", (Object)InvoiceUtil.nullToK(invoice.getString("salerAccount")));
        jsonO.put("checkStatus", (Object)invoice.getInteger("checkStatus"));
        jsonO.put("num", (Object)BizCollUtil.ONE);
        jsonO.put("serialNo", (Object)InvoiceUtil.nullToK(invoice.getString("serialNo")));
        jsonO.put("snapshotUrl", (Object)InvoiceUtil.nullToK(invoice.getString("snapshotUrl")));
        jsonO.put("totalAmountCn", (Object)"");
        jsonO.put("pixel", (Object)InvoiceUtil.nullToK(invoice.getString("pixel")));
        jsonO.put("region", (Object)InvoiceUtil.nullToK(invoice.getString("region")));
        jsonO.put("trip", (Object)"\u65e0");
        jsonO.put("downloadUrl", (Object)InvoiceUtil.nullToK(invoice.getString("kdcloudUrl")));
        jsonO.put("originalGraphUrl", (Object)InvoiceUtil.nullToK(invoice.getString("downloadUrl")));
        if ("7".equals(invoiceType2) || "23".equals(invoiceType2)) {
            jsonO.put("remark", (Object)InvoiceUtil.nullToK(invoice.getString("remark")));
            if (null != invoice.get((Object)"items") && invoice.getJSONArray("items").size() > 0) {
                jsonO.put("items", (Object)InvoiceUtil.itemConvert(invoice.getJSONArray("items")));
            } else {
                jsonO.put("items", (Object)new JSONArray());
            }
        }
        if ("21".equals(invoiceType2)) {
            invoiceCode = InvoiceUtil.nullToK(invoice.getString("invoiceDate").replaceAll("-", ""));
            invoiceNo = InvoiceUtil.nullToK(invoice.getString("printingSequenceNo"));
            jsonO.put("invoiceCode", (Object)invoiceCode);
            jsonO.put("invoiceNo", (Object)invoiceNo);
            jsonO.put("declareNo", (Object)InvoiceUtil.nullToK(invoice.getString("declareNo")));
            jsonO.put("deptBank", (Object)InvoiceUtil.nullToK(invoice.getString("deptBank")));
            jsonO.put("deptAccount", (Object)InvoiceUtil.nullToK(invoice.getString("deptAccount")));
            if (null != invoice.get((Object)"items") && invoice.getJSONArray("items").size() > 0) {
                jsonO.put("items", (Object)InvoiceUtil.itemConvert(invoice.getJSONArray("items")));
            } else {
                jsonO.put("items", (Object)new JSONArray());
            }
        }
        if ("25".equals(invoiceType2)) {
            jsonO.put("handlingPerson", (Object)InvoiceUtil.nullToK(invoice.getString("handlingPerson")));
            jsonO.put("invoicingPartyCode", (Object)InvoiceUtil.nullToK(invoice.getString("invoicingPartyCode")));
            jsonO.put("invoicingPartyName", (Object)InvoiceUtil.nullToK(invoice.getString("invoicingPartyName")));
            JSONArray itemsArr = new JSONArray();
            if (null != invoice.get((Object)"items") && invoice.getJSONArray("items").size() > 0) {
                for (int i = 0; i < invoice.getJSONArray("items").size(); ++i) {
                    JSONObject item = invoice.getJSONArray("items").getJSONObject(i);
                    JSONObject itemData = new JSONObject();
                    itemData.put("goodsName", (Object)item.getString("itemName"));
                    itemData.put("num", (Object)(item.getString("itemQuantity") == null ? "0" : item.getString("itemQuantity")));
                    itemData.put("unit", (Object)InvoiceUtil.nullToK(item.getString("itemUnit")));
                    itemData.put("standard", (Object)InvoiceUtil.nullToK(item.getString("itemStd")));
                    itemData.put("remark", (Object)InvoiceUtil.nullToK(item.getString("itemRemark")));
                    itemData.put("detailAmount", (Object)InvoiceUtil.nullToK(item.getString("itemAmount")));
                    if (InvoiceUtil.isNotEmpty(item.getString("itemCode"))) {
                        itemData.put("goodsCode", (Object)item.getString("itemCode"));
                    } else {
                        itemData.put("goodsCode", (Object)"3079900000000000000");
                    }
                    itemsArr.add((Object)itemData);
                }
            } else {
                jsonO.put("items", (Object)itemsArr);
            }
        }
        if ("8".equals(invoiceType2)) {
            jsonO.put("licenseNumber", (Object)InvoiceUtil.nullToK(invoice.getString("licenseNumber")));
            jsonO.put("place", (Object)InvoiceUtil.nullToK(invoice.getString("place")));
            jsonO.put("timeGetOn", (Object)InvoiceUtil.nullToK(invoice.getString("timeGetOn")));
            jsonO.put("timeGetOff", (Object)InvoiceUtil.nullToK(invoice.getString("timeGetOff")));
            jsonO.put("price", (Object)InvoiceUtil.nullToK(invoice.getString("price")));
            jsonO.put("mileage", (Object)InvoiceUtil.nullToK(invoice.getString("mileage")));
        }
        if ("9".equals(invoiceType2)) {
            invoiceCode = InvoiceUtil.nullToK(invoice.getString("invoiceDate").replaceAll("-", ""));
            invoiceNo = InvoiceUtil.nullToK(invoice.getString("printingSequenceNo"));
            jsonO.put("invoiceCode", (Object)invoiceCode);
            jsonO.put("invoiceNo", (Object)invoiceNo);
            jsonO.put("seatGrade", (Object)InvoiceUtil.nullToK(invoice.getString("seat")));
            jsonO.put("passengerName", (Object)InvoiceUtil.nullToK(invoice.getString("passengerName")));
            jsonO.put("printingSequenceNo", (Object)InvoiceUtil.nullToK(invoice.getString("printingSequenceNo")));
            jsonO.put("stationGetOn", (Object)InvoiceUtil.nullToK(invoice.getString("stationGetOn")));
            jsonO.put("stationGetOff", (Object)InvoiceUtil.nullToK(invoice.getString("stationGetOff")));
            jsonO.put("trainTime", (Object)InvoiceUtil.nullToK(invoice.getString("trainTime")));
            jsonO.put("trainNum", (Object)InvoiceUtil.nullToK(invoice.getString("trainNum")));
            jsonO.put("trip", (Object)(InvoiceUtil.nullToK(invoice.getString("stationGetOn")) + " - " + InvoiceUtil.nullToK(invoice.getString("stationGetOff"))));
        }
        if ("10".equals(invoiceType2)) {
            invoiceCode = InvoiceUtil.nullToK(invoice.getString("invoiceDate").replaceAll("-", ""));
            invoiceNo = InvoiceUtil.nullToK(invoice.getString("electronicTicketNum").replaceAll("-", ""));
            jsonO.put("invoiceCode", (Object)invoiceCode);
            jsonO.put("invoiceNo", (Object)invoiceNo);
            jsonO.put("seatGrade", (Object)InvoiceUtil.nullToK(invoice.getString("seatGrade")));
            jsonO.put("seatGradeName", (Object)InvoiceUtil.nullToK(invoice.getString("seatGradeName")));
            jsonO.put("passengerName", (Object)InvoiceUtil.nullToK(invoice.getString("customerName")));
            jsonO.put("otherTotalTaxAmount", (Object)InvoiceUtil.nullToK(invoice.getString("otherTotalTaxAmount")));
            jsonO.put("fuelSurcharge", (Object)InvoiceUtil.nullToK(invoice.getString("fuelSurcharge")));
            jsonO.put("insurancePremium", (Object)InvoiceUtil.nullToK(invoice.getString("insurancePremium")));
            jsonO.put("airportConstructionFee", (Object)InvoiceUtil.nullToK(invoice.getString("airportConstructionFee")));
            jsonO.put("placeOfDeparture", (Object)InvoiceUtil.nullToK(invoice.getString("placeOfDeparture")));
            jsonO.put("destination", (Object)InvoiceUtil.nullToK(invoice.getString("destination")));
            jsonO.put("fillingUnit", (Object)InvoiceUtil.nullToK(invoice.getString("fillingUnit")));
            jsonO.put("salesUnitCode", (Object)InvoiceUtil.nullToK(invoice.getString("salesUnitCode")));
            jsonO.put("airTime", (Object)InvoiceUtil.nullToK(invoice.getString("airTime")));
            jsonO.put("flightNum", (Object)InvoiceUtil.nullToK(invoice.getString("flightNum")));
            jsonO.put("customerIdentityNum", (Object)InvoiceUtil.nullToK(invoice.getString("customerIdentityNum")));
            jsonO.put("electronicTicketNum", (Object)InvoiceUtil.nullToK(invoice.getString("electronicTicketNum")));
            jsonO.put("trip", (Object)(InvoiceUtil.nullToK(invoice.getString("placeOfDeparture")) + " - " + InvoiceUtil.nullToK(invoice.getString("destination"))));
        }
        if ("14".equals(invoiceType2)) {
            jsonO.put("remark", (Object)InvoiceUtil.nullToK(invoice.getString("remark")));
            jsonO.put("place", (Object)InvoiceUtil.nullToK(invoice.getString("place")));
            jsonO.put("consumptionType", (Object)InvoiceUtil.nullToK(invoice.getString("consumptionType")));
        }
        if ("16".equals(invoiceType2) || "20".equals(invoiceType2)) {
            jsonO.put("passengerName", (Object)InvoiceUtil.nullToK(invoice.getString("passengerName")));
            jsonO.put("stationGetOn", (Object)InvoiceUtil.nullToK(invoice.getString("stationGetOn")));
            jsonO.put("stationGetOff", (Object)InvoiceUtil.nullToK(invoice.getString("stationGetOff")));
            jsonO.put("time", (Object)InvoiceUtil.nullToK(invoice.getString("time")));
            jsonO.put("currencyType", (Object)InvoiceUtil.nullToK(invoice.getString("currencyType")));
            jsonO.put("taxRate", (Object)InvoiceUtil.nullToK(invoice.getString("taxRate")));
            jsonO.put("trip", (Object)(InvoiceUtil.nullToK(invoice.getString("stationGetOn")) + " - " + InvoiceUtil.nullToK(invoice.getString("stationGetOff"))));
        }
        if ("17".equals(invoiceType2)) {
            jsonO.put("entrance", (Object)InvoiceUtil.nullToK(invoice.getString("entrance")));
            jsonO.put("exit", (Object)InvoiceUtil.nullToK(invoice.getString("exit")));
            jsonO.put("time", (Object)InvoiceUtil.nullToK(invoice.getString("ftime")));
            jsonO.put("place", (Object)InvoiceUtil.nullToK(invoice.getString("place")));
        }
        if ("19".equals(invoiceType2)) {
            jsonO.put("taxPaidProofNo", (Object)InvoiceUtil.nullToK(invoice.getString("taxPaidProofNo")));
            jsonO.put("invoiceNo", (Object)InvoiceUtil.nullToK(invoice.getString("taxPaidProofNo")));
            jsonO.put("taxAuthorityName", (Object)InvoiceUtil.nullToK(invoice.getString("taxAuthorityName")));
        }
        if ("11".equals(invoiceType2)) {
            jsonO.put("remark", (Object)InvoiceUtil.nullToK(invoice.getString("remark")));
            jsonO.put("invoiceNo", (Object)"-");
        }
        if ("14".equals(invoiceType2) || "11".equals(invoiceType2)) {
            jsonO.put("invoiceDate", (Object)InvoiceUtil.nullToK(invoice.getString("billCreateTime")));
        } else {
            jsonO.put("invoiceDate", (Object)InvoiceUtil.nullToK(invoice.getString("invoiceDate")));
        }
        return jsonO;
    }

    public static JSONObject successToBase(JSONObject inputJson) {
        JSONObject succData = new JSONObject();
        succData.put("serialNo", (Object)InvoiceUtil.nullToK(inputJson.getString("serialNo")));
        succData.put("invoiceCode", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceCode")));
        succData.put("invoiceNo", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceNo")));
        succData.put("invoiceDate", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceDate")));
        succData.put("invoiceMoney", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceAmount")));
        succData.put("checkCode", (Object)InvoiceUtil.nullToK(inputJson.getString("checkCode")));
        succData.put("salerName", (Object)InvoiceUtil.nullToK(inputJson.getString("salerName")));
        succData.put("salerTaxNo", (Object)InvoiceUtil.nullToK(inputJson.getString("salerTaxNo")));
        succData.put("salerAddressPhone", (Object)InvoiceUtil.nullToK(inputJson.getString("salerAddressPhone")));
        succData.put("salerAccount", (Object)InvoiceUtil.nullToK(inputJson.getString("salerAccount")));
        succData.put("buyerName", (Object)InvoiceUtil.nullToK(inputJson.getString("buyerName")));
        succData.put("buyerTaxNo", (Object)InvoiceUtil.nullToK(inputJson.getString("buyerTaxNo")));
        succData.put("buyerAddressPhone", (Object)InvoiceUtil.nullToK(inputJson.getString("buyerAddressPhone")));
        succData.put("buyerAccount", (Object)InvoiceUtil.nullToK(inputJson.getString("buyerAccount")));
        succData.put("amount", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceAmount")));
        succData.put("taxAmount", (Object)InvoiceUtil.nullToK(inputJson.getString("totalTaxAmount")));
        succData.put("totalAmount", (Object)InvoiceUtil.nullToK(inputJson.getString("totalAmount")));
        succData.put("totalAmountCn", (Object)"");
        succData.put("invoiceType", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceType")));
        succData.put("invoiceStatus", (Object)InvoiceUtil.nullToK(inputJson.getString("invoiceStatus")));
        succData.put("remark", (Object)InvoiceUtil.nullToK(inputJson.getString("remark")));
        succData.put("checkStatus", (Object)InvoiceUtil.nullToK(inputJson.getInteger("checkStatus")));
        succData.put("pixel", (Object)InvoiceUtil.nullToK(inputJson.getString("pixel")));
        succData.put("region", (Object)InvoiceUtil.nullToK(inputJson.getString("region")));
        succData.put("snapshotUrl", (Object)InvoiceUtil.nullToK(inputJson.getString("snapshotUrl")));
        succData.put("downloadUrl", (Object)InvoiceUtil.nullToK(inputJson.getString("kdcloudUrl")));
        succData.put("originalGraphUrl", (Object)InvoiceUtil.nullToK(inputJson.getString("downloadUrl")));
        succData.put("drawer", (Object)InvoiceUtil.nullToK(inputJson.getString("drawer")));
        succData.put("reviewer", (Object)InvoiceUtil.nullToK(inputJson.getString("reviewer")));
        succData.put("payee", (Object)InvoiceUtil.nullToK(inputJson.getString("payee")));
        if ("13".equals(inputJson.getString("invoiceType"))) {
            succData.put("amount", (Object)InvoiceUtil.nullToK(inputJson.getString("totalAmount")));
        }
        if (InvoiceUtil.isNotEmpty(inputJson.getString("proxyMark")) && inputJson.getString("proxyMark").equals("1")) {
            succData.put("proxyMark", (Object)"1");
        } else {
            succData.put("proxyMark", (Object)"");
        }
        if (InvoiceUtil.isNotEmpty(inputJson.getString("salerName")) && (inputJson.getString("salerName").contains("\u56fd\u5bb6\u7a0e\u52a1") || inputJson.getString("salerName").contains("\u4ee3\u5f00"))) {
            succData.put("proxyMark", (Object)"1");
        }
        if (InvoiceUtil.isNotEmpty(succData.getString("remark")) && succData.getString("remark").contains("\u4ee3\u5f00")) {
            succData.put("proxyMark", (Object)"1");
        }
        if (null != inputJson.get((Object)"items") && inputJson.getJSONArray("items").size() > 0) {
            succData.put("items", (Object)InvoiceUtil.itemConvert(inputJson.getJSONArray("items")));
        } else {
            String taxRate = inputJson.getString("taxRate") == null ? "0" : inputJson.getString("taxRate");
            succData.put("taxRate", (Object)taxRate);
            succData.put("items", (Object)new JSONArray());
            succData.put("num", (Object)BizCollUtil.ZERO);
        }
        return succData;
    }

    public static JSONArray itemConvert(JSONArray jsonArray) {
        JSONArray itemsArr = new JSONArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject item = jsonArray.getJSONObject(i);
            JSONObject itemData = new JSONObject();
            itemData.put("goodsName", (Object)InvoiceUtil.nullToK(item.getString("goodsName")));
            itemData.put("unitPrice", (Object)InvoiceUtil.nullToK(item.getString("unitPrice")));
            String num = item.getString("num") == null ? "0" : item.getString("num");
            itemData.put("num", (Object)num);
            String taxRate = item.getString("taxRate") == null ? "0" : item.getString("taxRate");
            itemData.put("taxRate", (Object)taxRate);
            itemData.put("unit", (Object)InvoiceUtil.nullToK(item.getString("unit")));
            itemData.put("detailAmount", (Object)InvoiceUtil.nullToK(item.getString("detailAmount")));
            itemData.put("specModel", (Object)InvoiceUtil.nullToK(item.getString("specModel")));
            itemData.put("taxAmount", (Object)InvoiceUtil.nullToK(item.getString("taxAmount")));
            if (item.getString("discountType") != null) {
                itemData.put("discountType", (Object)InvoiceUtil.nullToK(item.getString("discountType")));
            }
            if (InvoiceUtil.isNotEmpty(item.getString("goodsCode"))) {
                itemData.put("goodsCode", (Object)InvoiceUtil.nullToK(item.getString("goodsCode")));
            } else {
                itemData.put("goodsCode", (Object)"3079900000000000000");
            }
            itemsArr.add((Object)itemData);
        }
        return itemsArr;
    }

    public static String nullToK(Object input) {
        if (input != null && !"null".equals(input)) {
            return input.toString();
        }
        return "";
    }

    public static boolean isNotEmpty(Object object) {
        if (object == null) {
            return false;
        }
        boolean flag = false;
        try {
            if (!InvoiceUtil.isEmpty(object)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        boolean flag = false;
        try {
            String str = object + "";
            if ("".equals(str) || "null".equals(str) || "undefined".equals(str) || "{}".equals(str) || "[]".equals(str)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    @Deprecated
    public static String getInvoiceData(Context ctx, BizCollBillBaseInfo baseInfo, String serialNoStr, Map<String, Object> spareMap) throws BOSException, EASBizException {
        IInvoiceFacade invoiceFacade = null;
        invoiceFacade = ctx == null ? InvoiceFacadeFactory.getRemoteInstance() : InvoiceFacadeFactory.getLocalInstance(ctx);
        return invoiceFacade.getInvoiceData(baseInfo, serialNoStr, spareMap);
    }

    public static JSONArray getInvoiceDetailData(Context ctx, JSONObject jsonObject, Map<String, Object> spareMap) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        String token = jsonObject.getString("token");
        RETURNlOG = false;
        String url = invoice.getInvoiceUrl() + invoice.getInvoiceDetail() + "?access_token=" + token;
        String result = InvoiceUtil.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result == null) {
            return null;
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new InvoiceException(InvoiceException.GETINVOICEDATADETAILERROR, new Object[]{parseObject.getString("description")});
        }
        RETURNlOG = true;
        logger.error((Object)("cp.bc getInvoiceDetailData finished time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        return JSONObject.parseArray((String)parseObject.getString("data"));
    }

    public static JSONObject getInvoiceDetailDataJson(Context ctx, BizCollBillBaseInfo baseInfo, Map<String, Object> spareMap) throws BOSException, EASBizException {
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, baseInfo);
        String taxpayerId = clientMap.get(TAX_NUMBER);
        String clientId = clientMap.get(CLIENT_ID);
        String clientSecret = clientMap.get(CLIENT_SECRET);
        String registeredCode = clientMap.get(REGISTERED_CODE);
        JSONObject retunObject = new JSONObject();
        String billType = InvoiceUtil.getBillType(baseInfo, spareMap);
        retunObject.put("serialNo", spareMap.get("serialNo"));
        retunObject.put("taxNo", (Object)taxpayerId);
        retunObject.put("companyName", (Object)registeredCode);
        retunObject.put("bxd_key", (Object)baseInfo.getId().toString());
        retunObject.put("ticketParam", (Object)InvoiceUtil.getTicketParam(ctx, baseInfo.getApplierCompany().getId().toString()));
        retunObject.put("resource", (Object)2);
        retunObject.put("billType", (Object)billType);
        Long timeStamp = InvoiceUtil.getTimeStamp();
        JSONObject tokenJson = new JSONObject();
        tokenJson.put("client_id", (Object)clientId);
        tokenJson.put("sign", (Object)InvoiceUtil.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        tokenJson.put("timestamp", (Object)timeStamp);
        String token = InvoiceUtil.getAccessToken(ctx, tokenJson);
        retunObject.put("token", (Object)token);
        return retunObject;
    }

    public static String getBillType(BizCollBillBaseInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        String billType = "";
        if (baseInfo instanceof BizAccountOutBillInfo) {
            billType = BIZOUT_BILL;
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            billType = PUR_BILL;
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            billType = TRA_BILL;
        }
        return billType;
    }

    public static Map<String, Object> getEntryLinkSerialNo(BizCollBillBaseInfo billInfo, String entryId, Map<String, Object> spareMap) throws BOSException, EASBizException {
        AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)billInfo.get("tickeEntries");
        CoreBillEntryBaseInfo entryInfo = (CoreBillEntryBaseInfo)entries.getObject((Object)BOSUuid.read((String)entryId));
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedHashSet<String> serialNoSet = new LinkedHashSet<String>(20);
        HashSet<String> ticketEntryIds = new HashSet<String>(20);
        StringBuffer loggerStr = new StringBuffer(30);
        String entrySerialNo = entryInfo.getString("entrySerialNo");
        if (ticketEntries.size() < 1) {
            map.put("log", "\u53d1\u7968\u5206\u5f55\u5c0f\u4e8e0\uff0c\u76f4\u63a5\u8fd4\u56de\uff01");
            map.put("entryLinkSerialNo", serialNoSet);
            map.put("ticketEntryIds", ticketEntryIds);
            return map;
        }
        if (StringUtils.isNotEmpty((String)entrySerialNo)) {
            String[] entrySer = entrySerialNo.split(",");
            serialNoSet.addAll(Sets.newLinkedHashSet(Arrays.asList(entrySer)));
        }
        String bizEntryId = null;
        CoreBillEntryBaseInfo ticket2 = null;
        String ticketId = null;
        String serialNo = null;
        for (CoreBillEntryBaseInfo ticket2 : ticketEntries) {
            bizEntryId = InvoiceUtil.getBizEntryBill(ticket2);
            ticketId = ticket2.getId().toString();
            serialNo = (String)ticket2.get("serialNo");
            if (StringUtils.isEmpty((String)entrySerialNo) && entryId.equalsIgnoreCase(bizEntryId)) {
                serialNoSet.add(serialNo);
                ticketEntryIds.add(ticketId);
            }
            if (!serialNoSet.contains(serialNo)) continue;
            ticketEntryIds.add(ticketId);
        }
        loggerStr.append("\u5206\u5f55id\uff1a" + entryId + " \u5173\u8054\u7684\u53d1\u7968\uff1a" + ((Object)serialNoSet).toString());
        map.put("log", loggerStr);
        map.put("entryLinkSerialNo", serialNoSet);
        map.put("ticketEntryIds", ticketEntryIds);
        return map;
    }

    public static BigDecimal AmountNotNull(CoreBillEntryBaseInfo entryInfo, String name) {
        return entryInfo.getBigDecimal(name) == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal(name).setScale(2, 4);
    }

    public static BigDecimal AmountNotNull(Object value) {
        if (value == null) {
            return BizCollUtil.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return BizCollUtil.ZERO;
        }
        return value instanceof Map && ((Map)value).size() == 0 ? BizCollUtil.ZERO : new BigDecimal(strVal);
    }

    public static void buildPurEntryPriceAndCount(CoreBillEntryBaseInfo entryInfo, BigDecimal num) {
        BigDecimal taxRate = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("taxRate"));
        BigDecimal entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("amountOri"));
        BigDecimal entryAmountOriWithoutTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("amountOriWithoutTax"));
        if (BizCollUtil.ZERO.compareTo(taxRate) == 0) {
            entryInfo.setBigDecimal("priceWithTax", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("price", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("count", BizCollUtil.ZERO);
        } else if (BizCollUtil.ZERO.compareTo(entryAmountOriWithoutTax) >= 0) {
            entryInfo.setBigDecimal("priceWithTax", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("price", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("count", BizCollUtil.ZERO);
        } else if (num == null || BizCollUtil.ZERO.compareTo(num) == 0) {
            entryInfo.setBigDecimal("priceWithTax", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("price", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("count", BizCollUtil.ZERO);
        } else {
            BigDecimal unitPrice = entryAmountOriWithoutTax.divide(num, 2, 4);
            taxRate = taxRate.divide(ONE_HUNDRED).setScale(2, 4);
            BigDecimal add = BizCollUtil.ONE.add(taxRate);
            entryInfo.setBigDecimal("priceWithTax", unitPrice.multiply(add).setScale(2, 4));
            entryInfo.setBigDecimal("price", unitPrice);
            entryInfo.setBigDecimal("count", num);
        }
    }

    public static void buildPurEntryPriceAndCountForBill(CoreBillEntryBaseInfo entryInfo, BigDecimal num) {
        BigDecimal taxAmount = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("tax"));
        BigDecimal taxRate = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("taxRate"));
        BigDecimal entryAmountOri = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("amountOri"));
        BigDecimal entryAmountOriWithoutTax = InvoiceUtil.AmountNotNull(entryInfo.getBigDecimal("amountOriWithoutTax"));
        if (BizCollUtil.ZERO.compareTo(entryAmountOriWithoutTax) >= 0) {
            entryInfo.setBigDecimal("priceWithTax", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("price", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("count", BizCollUtil.ZERO);
        } else if (num == null || BizCollUtil.ZERO.compareTo(num) == 0) {
            entryInfo.setBigDecimal("priceWithTax", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("price", BizCollUtil.ZERO);
            entryInfo.setBigDecimal("count", BizCollUtil.ZERO);
        } else if (BizCollUtil.ZERO.compareTo(taxRate) == 0 && BizCollUtil.ZERO.compareTo(taxAmount) <= 0) {
            BigDecimal unitPrice = entryAmountOriWithoutTax.divide(num, 2, 4);
            BigDecimal priceWithTax = entryAmountOriWithoutTax.add(taxAmount).divide(num, 2, 4);
            entryInfo.setBigDecimal("priceWithTax", priceWithTax);
            entryInfo.setBigDecimal("price", unitPrice);
            entryInfo.setBigDecimal("count", num);
        } else {
            BigDecimal unitPrice = entryAmountOriWithoutTax.divide(num, 2, 4);
            taxRate = taxRate.divide(ONE_HUNDRED).setScale(2, 4);
            BigDecimal add = BizCollUtil.ONE.add(taxRate);
            entryInfo.setBigDecimal("priceWithTax", unitPrice.multiply(add).setScale(2, 4));
            entryInfo.setBigDecimal("price", unitPrice);
            entryInfo.setBigDecimal("count", num);
        }
    }

    public static Map<String, Object> getTicketInfoSerialNo(BizCollBillBaseInfo billInfo, String entryId, Map<String, Object> spareMap) throws BOSException, EASBizException {
        AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)billInfo.get("tickeEntries");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<String> serialNoSet = new HashSet<String>(20);
        HashSet<String> ticketEntryIds = new HashSet<String>(20);
        StringBuffer loggerStr = new StringBuffer(30);
        if (ticketEntries.size() < 1) {
            map.put("log", "\u53d1\u7968\u5206\u5f55\u5c0f\u4e8e0\uff0c\u76f4\u63a5\u8fd4\u56de\uff01");
            map.put("entryLinkSerialNo", serialNoSet);
            map.put("ticketEntryIds", ticketEntryIds);
            return map;
        }
        CoreBillEntryBaseInfo ticket2 = null;
        String ticketId = null;
        String serialNo = null;
        for (CoreBillEntryBaseInfo ticket2 : ticketEntries) {
            ticketId = ticket2.getId().toString();
            serialNo = (String)ticket2.get("serialNo");
            if (!entryId.equalsIgnoreCase(ticketId)) continue;
            serialNoSet.add(serialNo);
            ticketEntryIds.add(ticketId);
        }
        loggerStr.append("\u53d1\u7968id\uff1a" + entryId + " \u7684\u53d1\u7968\u6d41\u6c34\u53f7\uff1a" + ((Object)serialNoSet).toString());
        map.put("log", loggerStr);
        map.put("entryLinkSerialNo", serialNoSet);
        map.put("ticketEntryIds", ticketEntryIds);
        return map;
    }

    public static void setBizEntryBill(CoreBillEntryBaseInfo ticketEntry, CoreBillEntryBaseInfo entry) {
        Object bizEntryBill = ticketEntry.get("bizEntryBill");
        if (bizEntryBill != null && bizEntryBill instanceof CoreBillEntryBaseInfo) {
            ticketEntry.put("bizEntryBill", (Object)entry);
        } else {
            ticketEntry.put("bizEntryBill", (Object)entry.getString("id"));
        }
    }

    public static void setBizEntryBill(CoreBillEntryBaseInfo ticketEntry, String entryId) {
        Object bizEntryBill = ticketEntry.get("bizEntryBill");
        if (bizEntryBill != null && bizEntryBill instanceof CoreBillEntryBaseInfo) {
            ((CoreBillEntryBaseInfo)bizEntryBill).setId(BOSUuid.read((String)entryId));
        } else {
            ticketEntry.put("bizEntryBill", (Object)entryId);
        }
    }

    public static String getBizEntryBill(CoreBillEntryBaseInfo ticketEntry) {
        String entryId = null;
        Object bizEntryBill = ticketEntry.get("bizEntryBill");
        entryId = bizEntryBill != null && bizEntryBill instanceof CoreBillEntryBaseInfo ? ((CoreBillEntryBaseInfo)bizEntryBill).getString("id") : ticketEntry.getString("bizEntryBill");
        return entryId;
    }

    public static void setVehicle(CoreBillEntryBaseInfo entry, String ticketTypeId) {
        if ("8".equals(ticketTypeId) || "16".equals(ticketTypeId)) {
            entry.put("vehicle", (Object)VehicleEnum.BUSSES);
        } else if ("9".equals(ticketTypeId)) {
            entry.put("vehicle", (Object)VehicleEnum.TRAIN);
        } else if ("10".equals(ticketTypeId)) {
            entry.put("vehicle", (Object)VehicleEnum.AIRPLANE);
        } else if ("20".equals(ticketTypeId)) {
            entry.put("vehicle", (Object)VehicleEnum.SHIP);
        } else {
            entry.put("vehicle", (Object)VehicleEnum.OTHER);
        }
    }

    public static JSONArray getInvoiceDataJArray(Context ctx, BizCollBillBaseInfo billInfo, int state) throws BOSException {
        JSONArray jsonArray = new JSONArray();
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)billInfo.get("tickeEntries");
        int size = ticketEntries.size();
        for (int i = 0; i < size; ++i) {
            TicketBaseEntryInfo ticketEntryInfo = (TicketBaseEntryInfo)ticketEntries.getObject(i);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)ticketEntryInfo.getSerialNo());
            jsonObject.put("canBeDeduction", (Object)(ticketEntryInfo.isIsDeduction() ? "1" : "0"));
            if (state == 60) {
                jsonObject.put("entryAmount", (Object)ticketEntryInfo.getDeductionTax());
                jsonObject.put("outputAmount", (Object)ticketEntryInfo.getTransferTax());
                jsonObject.put("outputReason", (Object)ticketEntryInfo.getTransferCauseStr());
            } else {
                jsonObject.put("entryAmount", (Object)"");
                jsonObject.put("outputAmount", (Object)"");
                jsonObject.put("outputReason", (Object)"");
            }
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }
}

