/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryInfo;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OperationTypeLinkCostCenterAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.OperationTypeCostCenterEntryAddByExcel");
    private static final String BCImportRES = "com.kingdee.eas.cp.bc.BCImportExportResource";
    private static final String ImportRES = "com.kingdee.eas.cp.bc.ImportDataResource";
    Map<String, Object> commonObjectMap = new HashMap<String, Object>(128);
    private HashSet<Map> dataSet = new HashSet();
    String[] IMP_REQUIRED_FIELDS = new String[]{"operationType", "costCenter", "company"};
    String[] IMP_REQUIRED_FIELDS_NAME = new String[]{"\u4e1a\u52a1\u7c7b\u522b", "\u4e1a\u52a1\u7c7b\u522b\u5173\u8054\u6210\u672c\u4e2d\u5fc3", "\u5173\u8054\u6210\u672c\u4e2d\u5fc3\u6240\u5c5e\u516c\u53f8"};

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.OperationTypeLinkCostCenterImport";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        FilterInfo filterInfo = BizCollUtil.getExportFilterForQuery(ctx, paramMap);
        return filterInfo;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        OperationTypeCostCenterEntryInfo info = new OperationTypeCostCenterEntryInfo();
        BizImportUtil.validateNotNullField(hsData, this.IMP_REQUIRED_FIELDS, this.IMP_REQUIRED_FIELDS_NAME);
        try {
            DataToken companyToken = (DataToken)hsData.get("company");
            CompanyOrgUnitInfo companyInfo = this.getCompany(ctx, companyToken);
            BizImportUtil.checkInportPermission(ctx, companyInfo, "cp_bc_OperationtypeCostCenter_Import", this.commonObjectMap);
            DataToken operationTypeToken = (DataToken)hsData.get("operationType");
            OperationTypeInfo operationType = this.getOperatrionType(ctx, operationTypeToken);
            DataToken costCenterToken = (DataToken)hsData.get("costCenter");
            CostCenterOrgUnitInfo costCenter = this.getCostCenter(ctx, costCenterToken);
            String operationTypeId = operationType.getId().toString();
            String costCenterId = costCenter.getId().toString();
            this.checkOperCostSameAndExist(ctx, operationTypeId, costCenterId);
            String companyId = companyInfo.getId().toString();
            this.checkCostInCompany(ctx, companyId, costCenterId, companyToken, costCenterToken);
            this.checkOperInCompany(ctx, operationType, companyInfo, operationTypeToken, companyToken);
            info.setOperationTypeId(operationTypeId);
            info.setCostCenter(costCenter);
            info.setCompany(companyInfo);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private OperationTypeInfo getOperatrionType(Context ctx, DataToken operationTypeToken) throws TaskExternalException, BOSException {
        OperationTypeInfo operationType = null;
        String operationTypeData = operationTypeToken.data.toString().trim();
        String operationTypeKey = "operationType." + operationTypeData;
        if (this.commonObjectMap.containsKey(operationTypeKey)) {
            operationType = (OperationTypeInfo)this.commonObjectMap.get(operationTypeKey);
        } else {
            String errorInfoCacheKey = "operationType.error." + operationTypeData;
            SelectorItemCollection sic = BizCollUtil.getInportSic();
            sic.add(new SelectorItemInfo("isEnable"));
            sic.add(new SelectorItemInfo("company.number"));
            operationType = (OperationTypeInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)OperationTypeFactory.getLocalInstance(ctx), this.commonObjectMap, errorInfoCacheKey, sic, operationTypeToken);
            if (!operationType.isIsEnable()) {
                TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)BCImportRES, (String)"NUMBER_NOTSTARTORLEAF", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{operationTypeToken.desc, operationTypeToken.data}));
                this.commonObjectMap.put(errorInfoCacheKey, (Object)e);
                throw e;
            }
            this.commonObjectMap.put(operationTypeKey, operationType);
        }
        return operationType;
    }

    private CostCenterOrgUnitInfo getCostCenter(Context ctx, DataToken costCenterToken) throws TaskExternalException, BOSException {
        CostCenterOrgUnitInfo costCenter = null;
        String costCenterData = costCenterToken.data.toString().trim();
        String costCenterMapkey = "costCenter." + costCenterData;
        if (this.commonObjectMap.containsKey(costCenterMapkey)) {
            costCenter = (CostCenterOrgUnitInfo)this.commonObjectMap.get(costCenterMapkey);
        } else {
            String errorInfoCacheKey = "costCenter.error." + costCenterData;
            SelectorItemCollection sic = BizCollUtil.getInportSic();
            sic.add(new SelectorItemInfo("isSealUp"));
            sic.add(new SelectorItemInfo("isBizUnit"));
            costCenter = (CostCenterOrgUnitInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)CostCenterOrgUnitFactory.getLocalInstance((Context)ctx), this.commonObjectMap, errorInfoCacheKey, sic, costCenterToken);
            if (!costCenter.isIsBizUnit()) {
                TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)ImportRES, (String)"ISNOTCOSTBIZUNIT", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{costCenterToken.desc, costCenterToken.data}));
                this.commonObjectMap.put(errorInfoCacheKey, (Object)e);
                throw e;
            }
            if (costCenter.isIsSealUp()) {
                TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)BCImportRES, (String)"ISSEALUP", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{costCenterToken.desc, costCenterToken.data}));
                this.commonObjectMap.put(errorInfoCacheKey, (Object)e);
                throw e;
            }
        }
        return costCenter;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, DataToken companyToken) throws TaskExternalException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        String companydata = companyToken.data.toString();
        String companyMapkey = "company." + companydata;
        if (this.commonObjectMap.containsKey(companyMapkey)) {
            companyInfo = (CompanyOrgUnitInfo)this.commonObjectMap.get(companyMapkey);
        } else {
            String errorInfoCacheKey = "company.error." + companydata;
            SelectorItemCollection sic = BizCollUtil.getInportSic();
            sic.add(new SelectorItemInfo("isBizUnit"));
            sic.add(new SelectorItemInfo("isSealUp"));
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("cu.id"));
            companyInfo = (CompanyOrgUnitInfo)BizImportUtil.getObjectInfo(ctx, (ICoreBase)CompanyOrgUnitFactory.getLocalInstance((Context)ctx), this.commonObjectMap, errorInfoCacheKey, sic, companyToken);
            if (!companyInfo.isIsBizUnit()) {
                TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)ImportRES, (String)"ISNOTBIZUNIT", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data}));
                this.commonObjectMap.put(errorInfoCacheKey, (Object)e);
                throw e;
            }
            if (companyInfo.isIsSealUp()) {
                TaskExternalException e = new TaskExternalException(ResourceBase.getString((String)BCImportRES, (String)"ISSEALUP", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data}));
                this.commonObjectMap.put(errorInfoCacheKey, (Object)e);
                throw e;
            }
            this.commonObjectMap.put(companyMapkey, companyInfo);
        }
        return companyInfo;
    }

    private void checkCostInCompany(Context ctx, String companyId, String costCenterId, DataToken companyToken, DataToken costCenterToken) throws TaskExternalException, EASBizException, BOSException {
        String costCompanyMapkey = "companyNotCost." + companyId + costCenterId;
        if (!this.commonObjectMap.containsKey(costCompanyMapkey)) {
            String existOql = "SELECT ID WHERE typeRelation.fromType =5 AND typeRelation.toType =1 AND fromUnit = '" + costCenterId + "' AND toUnit = '" + companyId + "'";
            if (!OrgUnitRelationFactory.getLocalInstance((Context)ctx).exists(existOql)) {
                this.commonObjectMap.put(costCompanyMapkey, true);
                throw new TaskExternalException(ResourceBase.getString((String)ImportRES, (String)"NOT_EXIT_RELATION", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data, costCenterToken.desc, costCenterToken.data}));
            }
            this.commonObjectMap.put(costCompanyMapkey, false);
        } else if (((Boolean)this.commonObjectMap.get(costCompanyMapkey)).booleanValue()) {
            throw new TaskExternalException(ResourceBase.getString((String)ImportRES, (String)"NOT_EXIT_RELATION", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data, costCenterToken.desc, costCenterToken.data}));
        }
    }

    private void checkOperInCompany(Context ctx, OperationTypeInfo operationType, CompanyOrgUnitInfo companyInfo, DataToken operationTypeToken, DataToken companyToken) throws TaskExternalException {
        boolean isOperInCompany = false;
        String operInCompanyMapkey = "operInCompany" + operationTypeToken.data + companyInfo.getId().toString();
        if (!this.commonObjectMap.containsKey(operInCompanyMapkey)) {
            String number = operationType.getCompany().getNumber();
            String longNumber = companyInfo.getLongNumber();
            isOperInCompany = longNumber.indexOf(number) != -1;
            this.commonObjectMap.put(operInCompanyMapkey, isOperInCompany);
        } else {
            isOperInCompany = (Boolean)this.commonObjectMap.get(operInCompanyMapkey);
        }
        if (!isOperInCompany) {
            throw new TaskExternalException(ResourceBase.getString((String)ImportRES, (String)"NOT_EXIT_RELATION", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{companyToken.desc, companyToken.data, operationTypeToken.desc, operationTypeToken.data}));
        }
    }

    private void checkOperCostSameAndExist(Context ctx, String operationTypeId, String costCenterId) throws EASBizException, BOSException, TaskExternalException {
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        tmpMap.put("operationType", operationTypeId);
        tmpMap.put("costCenter", costCenterId);
        if (this.dataSet.contains(tmpMap)) {
            throw new TaskExternalException(EASResource.getString((String)BCImportRES, (String)"NOT_ALLOW_REPEAT"));
        }
        this.dataSet.add(tmpMap);
        String existOql = "SELECT FID WHERE operationTypeId = '%s' AND costCenter = '%s' ";
        boolean isExistSame = OperationTypeCostCenterEntryFactory.getLocalInstance(ctx).exists(String.format(existOql, operationTypeId, costCenterId));
        if (isExistSame) {
            throw new TaskExternalException(EASResource.getString((String)BCImportRES, (String)"NOT_ALLOW_REPEAT"));
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("operationType", rs.getString("operationType"));
            result.put("costCenter", rs.getString("costCenter"));
            result.put("company", rs.getString("company"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return OperationTypeCostCenterEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }
}

