/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class OutputExcelUtil
extends FileFilter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.OutputExcelUtil");

    @Override
    public boolean accept(File f) {
        File file = f;
        if (f.isDirectory()) {
            return true;
        }
        String extension = OutputExcelUtil.getExtension(f);
        if (extension != null) {
            return extension.equals("xls");
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "EXCEL FILE";
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public String appendToExcel(KDTable tblMain, boolean withHead, boolean withIndex, String sheetName) throws Exception {
        if (tblMain == null) {
            return null;
        }
        KDFileChooser m_chooserSave = new KDFileChooser();
        m_chooserSave.setFileFilter((FileFilter)this);
        int result = m_chooserSave.showSaveDialog((Component)tblMain);
        if (result != 0) {
            return null;
        }
        File file = m_chooserSave.getSelectedFile();
        if (null != file.getParentFile() && !file.getParentFile().isDirectory()) {
            throw new ExpAccException(ExpAccException.OUTPUT_FILE_ERROR);
        }
        String fileName = null;
        fileName = file.getAbsolutePath().endsWith(".xls") ? file.getAbsolutePath() : file.getAbsolutePath() + ".xls";
        KDSBook book = null;
        file = new File(fileName);
        if (file.exists()) {
            if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.org.client.OrgResource.FILE_IS_EXIST")) != 0) {
                return null;
            }
            if (!file.canWrite()) {
                throw new ExpAccException(ExpAccException.CAN_NOT_WRITE);
            }
        } else {
            try {
                file.createNewFile();
                file.delete();
            }
            catch (IOException e) {
                throw new ExpAccException(ExpAccException.FILE_NAME_ERROR);
            }
        }
        book = new KDSBook(file.getName());
        try {
            book.addSheet(null, tblMain.getIOManager().saveToKDSSheet(book, withHead, withIndex, sheetName));
        }
        catch (IllegalArgumentException err) {
            throw new ExpAccException(ExpAccException.REPEAT_SHEET_NAME);
        }
        catch (Exception e) {
            throw new ExpAccException(ExpAccException.ERROR_OPEN_EXCEL);
        }
        ExportManager man = new ExportManager();
        try {
            man.exportToExcel(book, fileName);
        }
        catch (POIExportException e) {
            logger.error((Object)e.getMessage());
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.base.BASEAutoGenerateResource", (String)"116_OutputExcelUtil"));
        }
        return fileName;
    }
}

