/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.VehicleEnum;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TravelExpenseAccountEntryAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.TravelExpenseAccountEntryAddByExcel");
    public static final String IMPORTRES = "com.kingdee.eas.cp.bc.ImportDataResource";
    Map<String, Object> commonObjectMap = new HashMap<String, Object>(128);
    String[] IMP_REQUIRED_FIELDS = new String[]{"operationType", "expenseType", "currencyType", "costCenter", "company"};
    String[] IMP_BIGDECIMAL_FIELDS_EN = new String[]{"taxiExpense", "bussesExpense", "cadFund", "hotelExpense", "otherExpense", "eventionSubsidy", "taxiExpenseTaxRate", "bussesExpenseTaxRate", "taxRate", "otherExpenseTaxRate", "taxiExpenseTax", "bussesExpenseTax", "tax", "otherExpenseTax", "exchangeRate"};
    String[] IMP_DATE_FIELDS_EN = new String[]{"startDate", "endDate"};
    String[] IMP_STRING_FIELDS_EN = new String[]{"from", "to"};
    int[] IMP_String_LENGTH = new int[]{80, 80};
    String[] AMOUNTORI_FIELDS_EN = new String[]{"taxiExpense", "bussesExpense", "hotelExpense", "otherExpense", "eventionSubsidy"};
    String[] TAXI_FIELDS_EN = new String[]{"taxiExpense", "taxiExpenseTaxRate", "taxiExpenseTax", "taxiExpenseWithoutTax"};
    String[] BUSSES_FIELDS_EN = new String[]{"bussesExpense", "bussesExpenseTaxRate", "bussesExpenseTax", "bussesExpenseWithoutTax"};
    String[] HOTEL_FIELDS_EN = new String[]{"hotelExpense", "taxRate", "tax", "hotelExpenseWithoutTax"};
    String[] OTHER_FIELDS_EN = new String[]{"otherExpense", "otherExpenseTaxRate", "otherExpenseTax", "otherExpenseWithoutTax"};
    String[] TAXAPPROVED_FIELDS_EN = new String[]{"taxiExpenseTax", "bussesExpenseTax", "tax", "otherExpenseTax"};
    String[][] AMOUNTANDORI_FIELDS = new String[][]{{"amountOri", "amountOriWithoutTax"}, {"amount", "amountWithoutTax"}};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TravelAccountBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable hashtable = (Hashtable)hsData.get(0);
        BizImportUtil.checkRequiredField(ctx, hashtable, this.IMP_REQUIRED_FIELDS);
        Map paramMap = this.getContextMap();
        Map<String, String> filterItemsMap = new HashMap();
        if (paramMap != null && paramMap.get("filterItems") != null) {
            filterItemsMap = (Map)paramMap.get("filterItems");
        }
        TravelAccountBillEntryInfo entryInfo = new TravelAccountBillEntryInfo();
        this.handleDateTimeData(ctx, hashtable, entryInfo);
        BizCollUtil.initInportBigDecimalData(ctx, null, entryInfo, hashtable, this.IMP_BIGDECIMAL_FIELDS_EN, this.IMP_BIGDECIMAL_FIELDS_EN);
        this.handleVehicle(ctx, hashtable, entryInfo);
        filterItemsMap.put("billType", "TravelAccountBill");
        BizImportUtil.initImportEntryCommonData(ctx, entryInfo, hashtable, this.commonObjectMap, filterItemsMap);
        BizImportUtil.initImportEntryProject(ctx, hashtable, this.commonObjectMap, entryInfo, filterItemsMap);
        BigDecimal amountOri = this.totalAmount(entryInfo, this.AMOUNTORI_FIELDS_EN);
        entryInfo.setAmountOri(amountOri);
        BigDecimal amount = BizCollUtil.computeAmount(amountOri, entryInfo.getConvertMode(), entryInfo.getExchangeRate());
        entryInfo.setAmount(amount);
        this.handleAmountAndRate(entryInfo, this.TAXI_FIELDS_EN, BizCollUtil.ZERO);
        this.handleAmountAndRate(entryInfo, this.BUSSES_FIELDS_EN, entryInfo.getCadFund());
        this.handleAmountAndRate(entryInfo, this.HOTEL_FIELDS_EN, BizCollUtil.ZERO);
        this.handleAmountAndRate(entryInfo, this.OTHER_FIELDS_EN, BizCollUtil.ZERO);
        BigDecimal taxTatal = this.totalAmount(entryInfo, this.TAXAPPROVED_FIELDS_EN);
        BigDecimal amountOriWithoutTax = amountOri.subtract(taxTatal);
        entryInfo.setAmountOriWithoutTax(amountOriWithoutTax);
        BigDecimal amountWithoutTax = BizCollUtil.computeAmount(amountOriWithoutTax, entryInfo.getConvertMode(), entryInfo.getExchangeRate());
        entryInfo.setAmountWithoutTax(amountWithoutTax);
        BizCollUtil.initInportStringData(ctx, null, entryInfo, hashtable, this.IMP_STRING_FIELDS_EN, this.IMP_STRING_FIELDS_EN);
        return entryInfo;
    }

    private void handleDateTimeData(Context ctx, Hashtable hashtable, TravelAccountBillEntryInfo entryInfo) throws TaskExternalException {
        BizImportUtil.initInportDateTimeData(ctx, null, entryInfo, hashtable, this.IMP_DATE_FIELDS_EN, this.IMP_DATE_FIELDS_EN);
        Date startDate = entryInfo.getStartDate();
        Date endDate = entryInfo.getEndDate();
        if (startDate.after(endDate)) {
            throw new TaskExternalException(ResourceBase.getString((String)IMPORTRES, (String)"STARTDATE_BIGGER_ENDDATE", (Locale)ctx.getOriginLocale()));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal days = BigDecimal.ZERO;
        try {
            days = new BigDecimal((df.parse(df.format(endDate)).getTime() - df.parse(df.format(startDate)).getTime()) / 86400000L);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("startDate/endDate" + ResourceBase.getString((String)IMPORTRES, (String)"DATAERROE", (Locale)ctx.getOriginLocale()));
        }
        entryInfo.setRoomDays(days);
        entryInfo.setAllowanceDays(days.add(BigDecimal.ONE));
    }

    private BigDecimal totalAmount(CoreBillEntryBaseInfo entryInfo, String[] FIELDS) {
        BigDecimal amount = new BigDecimal("0.00");
        for (int i = 0; i < FIELDS.length; ++i) {
            amount = amount.add((BigDecimal)entryInfo.get(FIELDS[i]));
        }
        return amount;
    }

    private void handleAmountAndRate(CoreBillEntryBaseInfo entryInfo, String[] FIELDS, BigDecimal cadFund) {
        BigDecimal expense = (BigDecimal)entryInfo.get(FIELDS[0]);
        BigDecimal taxRate = (BigDecimal)entryInfo.get(FIELDS[1]);
        BigDecimal tax = (BigDecimal)entryInfo.get(FIELDS[2]);
        if (BizCollUtil.ZERO.compareTo(taxRate) != 0) {
            tax = expense.subtract(cadFund).multiply(taxRate).divide(taxRate.add(new BigDecimal(100)), 2, 4);
            entryInfo.put(FIELDS[2], (Object)tax);
        }
        entryInfo.put(FIELDS[3], (Object)expense.subtract(cadFund).subtract(tax));
    }

    private void handleVehicle(Context ctx, Hashtable hashtable, TravelAccountBillEntryInfo entryInfo) throws TaskExternalException {
        DataToken dataToken = (DataToken)hashtable.get("vehicle");
        if (dataToken != null && dataToken.data != null && !StringUtils.isEmpty((String)dataToken.data.toString())) {
            String value = dataToken.data.toString().trim();
            VehicleEnum vehicle = null;
            List enumList = VehicleEnum.getEnumList();
            int num = enumList.size();
            for (int i = 0; i < num; ++i) {
                VehicleEnum veEnum = (VehicleEnum)((Object)enumList.get(i));
                String enumValue = String.valueOf(veEnum.getValue());
                String enumName = veEnum.getName();
                String enumAlias = veEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                vehicle = veEnum;
                break;
            }
            if (vehicle == null) {
                throw new TaskExternalException(ResourceBase.getString((String)IMPORTRES, (String)"NOT_EXIST", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{dataToken.desc, dataToken.data}));
            }
            entryInfo.setVehicle(vehicle);
        } else {
            entryInfo.setVehicle(VehicleEnum.AIRPLANE);
        }
    }

    public int getSubmitType() {
        return 2;
    }
}

