/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.carm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.carm.CarAdminCollection;
import com.kingdee.eas.cp.carm.CarAdminFactory;
import com.kingdee.eas.cp.carm.CarSettingCollection;
import com.kingdee.eas.cp.carm.CarSettingFactory;
import com.kingdee.eas.cp.carm.CarSettingInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class CarmWebUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.carm.web.CarmWebUtil");

    public static CarSettingInfo getCarSettingOfCurrentCU(Context ctx) {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        try {
            CarSettingCollection carSettingCollection = CarSettingFactory.getLocalInstance(ctx).getCarSettingCollection("select * where CU.id ='" + cuId + "'");
            CarSettingInfo carSetting = carSettingCollection.get(0);
            if (carSetting != null) {
                return carSetting;
            }
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IRowSet getCarRequestIRowSet(Context ctx) {
        try {
            EntityViewInfo tempEVI = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            Timestamp currTime = new Timestamp(System.currentTimeMillis());
            currTime.setHours(0);
            currTime.setMinutes(0);
            currTime.setSeconds(0);
            filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("sendTimePlan", (Object)currTime, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf("1"), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf("2"), CompareType.EQUALS));
            filterInfo.setMaskString(" #0 and #1 and (#2 or #3)");
            tempEVI.setFilter(filterInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.carm.app", "CarRequestPortalQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            exec.setObjectView(tempEVI);
            IRowSet rowSet = null;
            rowSet = exec.executeQuery();
            return rowSet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static IRowSet getCarDisatptchIRowSet(Context ctx) {
        try {
            EntityViewInfo tempEVI = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            Timestamp currTime = new Timestamp(System.currentTimeMillis());
            currTime.setHours(0);
            currTime.setMinutes(0);
            currTime.setSeconds(0);
            filterInfo.getFilterItems().add(new FilterItemInfo("UserEntry.user.id", (Object)personInfo.getId(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("sendTimePlan", (Object)currTime, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf("1"), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf("2"), CompareType.EQUALS));
            filterInfo.setMaskString(" #0 and  #1 and (#2 or #3) ");
            tempEVI.setFilter(filterInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.carm.app", "CarDispatchPortalQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            exec.setObjectView(tempEVI);
            IRowSet rowSet = null;
            rowSet = exec.executeQuery();
            return rowSet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean isCarAdmin(Context ctx) {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            FilterItemInfo fii = new FilterItemInfo("admin.id", (Object)personInfo.getId().toString(), CompareType.EQUALS);
            fi.getFilterItems().add(fii);
            evi.setFilter(fi);
            CarAdminCollection col = CarAdminFactory.getLocalInstance(ctx).getCarAdminCollection(evi);
            if (col.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String forMatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm");
        String str = df.format(date);
        return str;
    }

    public static int setWordsLenReq(int divWidth) {
        int wordsLen = 10;
        if (divWidth - 140 - 150 > 0) {
            wordsLen = (divWidth - 140 - 150) / 17;
        }
        return wordsLen;
    }

    public static int setWordsLenDispatch(int divWidth) {
        int wordsLen = 6;
        if (divWidth - 115 - 70 - 140 > 0) {
            wordsLen = (divWidth - 115 - 70 - 140) / 20;
        }
        return wordsLen;
    }

    public static String trim(String str, int specialCharsLength) {
        if (str == null || "".equals(str) || specialCharsLength < 1) {
            return "";
        }
        char[] chars = str.toCharArray();
        int charsLength = CarmWebUtil.getCharsLength(chars, specialCharsLength);
        return new String(chars, 0, charsLength);
    }

    public static int getCharsLength(char[] chars, int specialCharsLength) {
        int specialCharLength;
        int count = 0;
        int normalCharsLength = 0;
        for (int i = 0; i < chars.length && count <= specialCharsLength - (specialCharLength = CarmWebUtil.getSpecialCharLength(chars[i])); ++i) {
            count += specialCharLength;
            ++normalCharsLength;
        }
        return normalCharsLength;
    }

    private static int getSpecialCharLength(char c) {
        if (CarmWebUtil.isLetter(c)) {
            return 1;
        }
        return 2;
    }

    public static int getCharLength(char[] chars) {
        int length = 0;
        if (chars == null) {
            return length;
        }
        for (int i = 0; i < chars.length; ++i) {
            length += CarmWebUtil.getSpecialCharLength(chars[i]);
        }
        return length;
    }

    private static boolean isLetter(char c) {
        int k = 128;
        return c / k == 0;
    }

    public static void setAbandonAfterCurrentDate(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        Timestamp d = new Timestamp(new Date().getTime());
        Object[] params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), d};
        sql.append("update T_CP_CarDispatch set FStatus='3' where FControlUnitID=? and FSendTimePlan>?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
    }
}

