/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMCommentCollection;
import com.kingdee.eas.cp.eip.cm.CMCommentFactory;
import com.kingdee.eas.cp.eip.cm.CMCommentInfo;
import com.kingdee.eas.cp.eip.cm.CMContentCollection;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.app.ContentAndCommentInfo;
import com.kingdee.eas.cp.eip.cm.web.CmBaseDispatchAction;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CommentManageAction
extends CmBaseDispatchAction {
    private static String licenseClassName = "com.kingdee.eas.cp.eip.cm.web.CommentManageAction";
    private static Logger logger = Logger.getLogger((String)CommentManageAction.class.getName());
    private static String cmRes = "com.kingdee.eas.cp.eip.cm.ContentManage";

    public ActionForward personalComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("personalComment");
    }

    public ActionForward adminComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean hasLicense = this.checkLicense(request, licenseClassName);
        if (!hasLicense) {
            return mapping.findForward("cpLicenseInvalid");
        }
        return mapping.findForward("adminComment");
    }

    public ActionForward editComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("editCommentByPersonal");
    }

    public ActionForward personalCommentReadQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String userID = ctx.getCaller().toString();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("creator.id", (Object)userID);
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterInfo searchFilter = this.getSearchFilter(request);
        if (searchFilter.getFilterItems().size() > 0) {
            filterInfo.mergeFilter(searchFilter, "and");
        }
        this.readCommentDataByQuery(request, filterInfo);
        return mapping.findForward("queryPersonalComment");
    }

    public ActionForward adminCommentReadQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("CU.id", (Object)user.getCU().getId().toString());
        filterInfo.getFilterItems().add(filterItemInfo);
        FilterInfo searchFilter = this.getSearchFilter(request);
        if (searchFilter.getFilterItems().size() > 0) {
            filterInfo.mergeFilter(searchFilter, "and");
        }
        this.readCommentDataByQuery(request, filterInfo);
        return mapping.findForward("queryAdminComment");
    }

    private FilterInfo getSearchFilter(HttpServletRequest request) {
        FilterInfo filter = new FilterInfo();
        String commentTheme = "";
        String commentContent = "";
        String commentator = "";
        String commentStateStr = "";
        String beginDate = "";
        String endDate = "";
        String score = "";
        commentTheme = request.getParameter("contentTitle");
        commentContent = request.getParameter("commentContent");
        commentator = request.getParameter("commentator");
        commentStateStr = request.getParameter("commentState");
        beginDate = request.getParameter("beginDate");
        endDate = request.getParameter("endDate");
        score = request.getParameter("score");
        if (!StringUtil.isEmptyString((String)endDate)) {
            String[] nowTimeArray = new String[6];
            StringTokenizer stringTokenizer = new StringTokenizer(endDate, "- :");
            int j = 0;
            while (stringTokenizer.hasMoreElements()) {
                nowTimeArray[j++] = stringTokenizer.nextToken();
            }
            nowTimeArray[3] = "23";
            nowTimeArray[4] = "59";
            nowTimeArray[5] = "59.9";
            try {
                int year = Integer.parseInt(nowTimeArray[0]);
                int month = Integer.parseInt(nowTimeArray[1]);
                int date = Integer.parseInt(nowTimeArray[2]);
                GregorianCalendar calendar = new GregorianCalendar(year, month, date);
                endDate = calendar.get(1) + "-" + calendar.get(2) + "-" + calendar.get(5) + " " + nowTimeArray[3] + ":" + nowTimeArray[4] + ":" + nowTimeArray[5];
            }
            catch (Exception e) {
                logger.error((Object)"\u65e5\u671f\u5904\u7406\u51fa\u9519", (Throwable)e);
            }
        }
        int i = 0;
        boolean mark = true;
        StringBuffer markString = new StringBuffer();
        if (commentTheme != null && !"".equals(commentTheme) && !"null".equals(commentTheme)) {
            filter.getFilterItems().add(new FilterItemInfo("CMCONTENT.TITLE", (Object)("%" + commentTheme + "%"), CompareType.LIKE));
            markString.append(" #" + i);
            mark = false;
            ++i;
        }
        if (commentContent != null && !"".equals(commentContent) && !"null".equals(commentContent)) {
            filter.getFilterItems().add(new FilterItemInfo("COMMENTCONTENT", (Object)("%" + commentContent + "%"), CompareType.LIKE));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (commentator != null && !"".equals(commentator) && !"null".equals(commentator)) {
            filter.getFilterItems().add(new FilterItemInfo("creator.name", (Object)("%" + commentator + "%"), CompareType.LIKE));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (commentStateStr != null) {
            if ("1".equals(commentStateStr)) {
                filter.getFilterItems().add(new FilterItemInfo("STATE", (Object)Integer.valueOf(commentStateStr), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("STATE", null, CompareType.EQUALS));
                if (!mark) {
                    markString.append(" and ( #" + i + " or #" + ++i + " )");
                } else {
                    markString.append(" (#" + i + " or #" + ++i + " )");
                    mark = false;
                }
                ++i;
            } else if ("2".equals(commentStateStr)) {
                filter.getFilterItems().add(new FilterItemInfo("STATE", (Object)Integer.valueOf(commentStateStr), CompareType.EQUALS));
                if (!mark) {
                    markString.append(" and #" + i);
                } else {
                    markString.append(" #" + i);
                    mark = false;
                }
                ++i;
            }
        }
        if (beginDate != null && !"".equals(beginDate) && !"null".equals(beginDate)) {
            filter.getFilterItems().add(new FilterItemInfo("COMMENTTIME", (Object)Timestamp.valueOf(beginDate), CompareType.GREATER_EQUALS));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (endDate != null && !"".equals(endDate) && !"null".equals(endDate)) {
            filter.getFilterItems().add(new FilterItemInfo("COMMENTTIME", (Object)Timestamp.valueOf(endDate), CompareType.LESS_EQUALS));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        if (!(score == null || "".equals(score) || "null".equals(score) || "0".equals(score))) {
            filter.getFilterItems().add(new FilterItemInfo("SCORE", (Object)Integer.valueOf(score), CompareType.EQUALS));
            if (!mark) {
                markString.append(" and #" + i);
            } else {
                markString.append(" #" + i);
                mark = false;
            }
            ++i;
        }
        filter.setMaskString(markString.toString());
        return filter;
    }

    private void readCommentDataByQuery(HttpServletRequest request, FilterInfo filter) {
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        int currentPage = 0;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String page = request.getParameter("pageNumber");
        String pageSizeStr = request.getParameter("pageSize");
        String title = request.getParameter("title");
        String orderByField = request.getParameter("sortFieldName");
        String orderType = request.getParameter("sortType");
        String operate = request.getParameter("operate");
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "commentTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        entityViewInfo.setFilter(filter);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "CommentContentQuery");
        MetaDataPK queryCountPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "CommentContentCountQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)queryCountPK, entityViewInfo, ctx);
            logger.debug((Object)("executor search content count sql is:" + exec.getSQL()));
            countRowSet = exec.executeQuery();
            if (countRowSet.next()) {
                total = countRowSet.getInt(1);
                logger.debug((Object)("record total is\uff1a" + total));
            }
            totalPage = (total - 1) / pageSize + 1;
            logger.debug((Object)("total page is:" + totalPage));
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            currentPage = pageNo;
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            request.setAttribute("totalCount", (Object)Integer.toString(total));
            request.setAttribute("ctListData", (Object)rowSet);
        }
        catch (Exception e) {
            logger.error((Object)("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private CMContentInfo getContentByComment(ICMContent icm, String id) throws BOSException, EASBizException, UuidException {
        return icm.getCMContentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
    }

    private CMCommentCollection getPersonalComment(Context ctx) throws BOSException, EASBizException, UuidException {
        String userID = ctx.getCaller().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        CMCommentCollection cols = CMCommentFactory.getLocalInstance(ctx).getCMCommentCollection(ev);
        return cols;
    }

    private CMCommentCollection getAdminComment(Context ctx) throws EASBizException, BOSException {
        String userID = ctx.getCaller().toString();
        UserInfo user = null;
        user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)user.getCU().getId(), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        CMContentCollection conCols = this.getContentCollection(ctx, ev);
        if (conCols != null && conCols.size() > 0) {
            Iterator ite = conCols.iterator();
            while (ite.hasNext()) {
                CMContentInfo conInfo = (CMContentInfo)ite.next();
            }
        }
        CMCommentCollection cols = CMCommentFactory.getLocalInstance(ctx).getCMCommentCollection(ev);
        return cols;
    }

    private CMContentCollection getContentCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        CMContentCollection cols = CMContentFactory.getLocalInstance(ctx).getCMContentCollection(ev);
        return cols;
    }

    private List getPersonalCommentAndContent(Context ctx) throws BOSException, EASBizException, UuidException {
        CMCommentCollection cols = this.getPersonalComment(ctx);
        if (cols == null || cols.size() <= 0) {
            return null;
        }
        ArrayList<ContentAndCommentInfo> dataList = new ArrayList<ContentAndCommentInfo>();
        Iterator ite = cols.iterator();
        ContentAndCommentInfo cc = null;
        ICMContent icm = CMContentFactory.getLocalInstance(ctx);
        while (ite.hasNext()) {
            CMCommentInfo comInfo = (CMCommentInfo)ite.next();
            CMContentInfo conInfo = this.getContentByComment(icm, comInfo.getContentID().toString());
            cc = new ContentAndCommentInfo();
            cc.setComInfo(comInfo);
            cc.setConInfo(conInfo);
            dataList.add(cc);
        }
        return dataList;
    }
}

