/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.KDTreeNode;

public class NodeTreeBuilder {
    private ILNTreeNodeCtrl ctrl;
    private int initalLevel;
    private int expandLevel;
    private FilterInfo filter;

    public NodeTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
    }

    public NodeTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
    }

    public String buildTree() throws Exception {
        StringBuffer tree = new StringBuffer();
        KDTreeNode rootNode = new KDTreeNode(null);
        AbstractObjectCollection col = this.filter != null ? this.ctrl.getChildren(null, this.initalLevel, this.filter) : this.ctrl.getChildren(null, this.initalLevel);
        tree = this.buildChildren(tree, rootNode, col, this.initalLevel);
        return tree.toString();
    }

    private StringBuffer buildChildren(StringBuffer tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) {
        KDTreeNode beforeTreeNode = parentNode;
        for (TreeBaseInfo treeNodeInfo : col) {
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level) {
                tree.append("\r\n\t\t");
            } else {
                tree.append("\r\n\t");
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = beforeTreeNode.getChildCount();
                tree.append("\r\n\t-" + treeNodeInfo.getName());
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)beforeTreeNode.getParent();
                }
                int index = beforeTreeNode.getChildCount();
                tree.append("--" + treeNodeInfo.getName());
            }
            beforeTreeNode = treeNode;
        }
        return tree;
    }
}

