/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.eas.cp.eip.cm.web.util.CmUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DesktopCMPermissionUtil {
    public static boolean ifCMAdmin(Context ctx) throws BOSException {
        boolean isCMAdmin = false;
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        try {
            iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "cm_manager");
            isCMAdmin = true;
        }
        catch (Exception e) {
            isCMAdmin = false;
        }
        return isCMAdmin;
    }

    public static boolean checkNoticeDate(String columnTypeID, Date beginDate, Date endDate) {
        boolean dateValid = false;
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        if (beginDate.compareTo(cal.getTime()) <= 0 && endDate.compareTo(cal.getTime()) >= 0) {
            dateValid = true;
        }
        return !DesktopCMPermissionUtil.isNotice(columnTypeID) || dateValid;
    }

    public static boolean hasColumnPermision(Context ctx, String columnID) throws Exception {
        Set hasPermissionReadColumnIDSet = DesktopCMPermissionUtil.getReadColumnIDStr(ctx);
        return hasPermissionReadColumnIDSet.contains(columnID);
    }

    public static Set getReadColumnIDStr(Context ctx) throws Exception {
        String sqlStr = null;
        Object[] params = null;
        if (DesktopCMPermissionUtil.ifCMAdmin(ctx)) {
            params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
            StringBuffer sqlBf = new StringBuffer();
            sqlBf.append("select FID");
            sqlBf.append(",FName_");
            sqlBf.append(ctx.getLocale().toString());
            sqlBf.append(",FSubEditOrWorkFlow");
            sqlBf.append(" from T_CM_Column ");
            sqlBf.append(" where FEffect=1 and (FControlUnitID = ? or FCuFilter = 1)");
            sqlStr = sqlBf.toString();
        } else {
            params = new Object[]{ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getCaller().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()};
            StringBuffer sqlBfFilter = new StringBuffer();
            sqlBfFilter.append(" select distinct(FID)");
            sqlBfFilter.append(",FName_");
            sqlBfFilter.append(ctx.getLocale().toString());
            sqlBfFilter.append(",FSubEditOrWorkFlow");
            sqlBfFilter.append(" from (");
            sqlBfFilter.append(" select a.FID");
            sqlBfFilter.append(",a.FName_");
            sqlBfFilter.append(ctx.getLocale().toString());
            sqlBfFilter.append(",a.FSubEditOrWorkFlow");
            sqlBfFilter.append(" from T_CM_Column a, T_CM_ColumnReadRight b, T_PM_UserRoleOrg c");
            sqlBfFilter.append(" where a.FEffect=1 and (a.FControlUnitID = ? or FCuFilter = 1)");
            sqlBfFilter.append(" and a.FID = b.FColumnID and b.FRoleID = c.FRoleID");
            sqlBfFilter.append(" and c.FUserID = ?");
            sqlBfFilter.append(" union select FID ");
            sqlBfFilter.append(",FName_");
            sqlBfFilter.append(ctx.getLocale().toString());
            sqlBfFilter.append(",FSubEditOrWorkFlow ");
            sqlBfFilter.append(" from T_CM_Column where FEffect=1 and (FControlUnitID = ? or FCuFilter = 1) and FID not in ( select FColumnID from T_CM_ColumnReadRight)");
            sqlBfFilter.append(") a");
            sqlStr = sqlBfFilter.toString();
        }
        HashSet<String> set = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])params);
        if (rowSet != null && rowSet.size() > 0) {
            while (rowSet.next()) {
                set.add(rowSet.getString("FID"));
            }
        }
        return set;
    }

    public static boolean isNotice(String columnType) {
        return ColumnTypeEnum.NOTICE.getAlias().equals(columnType);
    }

    public static boolean hasReleaseRangePermissionRead(Context ctx, String contentID) {
        IRowSet rowSet = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        filterItemInfo = new FilterItemInfo("id", (Object)contentID, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("CMRolePerson.personId", (Object)currentPerson.getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        AdminOrgUnitInfo currentAdmin = null;
        try {
            currentAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(currentPerson.getId());
            if (currentAdmin == null || currentAdmin.isIsSealUp()) {
                AdminOrgUnitCollection orgUnitCol = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(currentPerson.getId());
                currentAdmin = null;
                for (int i = orgUnitCol.size() - 1; i >= 0 && (currentAdmin = orgUnitCol.get(i)).isIsSealUp(); --i) {
                    currentAdmin = null;
                }
            }
            if (currentAdmin == null) {
                currentAdmin = ContextUtil.getCurrentAdminUnit((Context)ctx);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(false), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("CMRoleAdmin.adminOrgId", (Object)currentAdmin.getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(true), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        HashSet<String> adminNumber = new HashSet<String>();
        String[] currentNumber = currentAdmin.getLongNumber().split("!");
        String longNumber = "";
        if (currentNumber != null && currentNumber.length > 0) {
            int size = currentNumber.length;
            for (int i = 0; i < size; ++i) {
                longNumber = longNumber + currentNumber[i];
                adminNumber.add(longNumber);
                if (i == size - 1) continue;
                longNumber = longNumber + "!";
            }
        }
        filterItemInfo = new FilterItemInfo("AdminOrgUnit.longNumber", adminNumber, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        Set rolePermSet = CmUtil.getUserRolePerm(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (rolePermSet.size() == 0) {
            rolePermSet.add(new Integer(0));
        }
        filterItemInfo = new FilterItemInfo("CMRoleRole.roleId", (Object)rolePermSet, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("User.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.setMaskString("#0 and #1 and #3 and (#2 or (#4 and #5) or (#6 and #7) or #8 or #9)");
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        try {
            IQueryExecutor exec = DesktopCMPermissionUtil.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            rowSet = exec.executeQuery();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return rowSet != null && rowSet.size() >= 1;
    }

    public static boolean isRoleControl(Context ctx, String contentID) {
        try {
            String sql = "select count(*) from T_CM_Content where fid ='" + contentID + "' and fisRoleControl=1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowSet.next()) {
                    return rowSet != null && rowSet.getInt(1) != 0;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static IRowSet getAllContextPublishToDesktop(Context ctx) {
        IRowSet rowSet = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = null;
            filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("publishToDesktop", (Object)new Integer(1), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            entityViewInfo.setFilter(filterInfo);
            SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sorterItemInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
            IQueryExecutor exec = DesktopCMPermissionUtil.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            return exec == null ? null : exec.executeQuery();
        }
        catch (Exception e) {
            e.printStackTrace();
            return rowSet;
        }
    }

    public static IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public static EntityViewInfo getReadColumnEntityViewInfo(Context ctx, Set hashSet) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("columnID", (Object)hashSet, CompareType.INCLUDE);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("publishToDesktop", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        boolean isRoleControl = false;
        filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(0), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        try {
            isRoleControl = DesktopCMPermissionUtil.setRangeFilter(filterInfo, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isRoleControl) {
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                filterInfo.setMaskString("(#0 and #1 and #2 and #3) or (#4 and #1 and #2 and (#5 or (#6 and #7) or (#8 and #9) or #10 or #11))");
            } else {
                filterInfo.setMaskString("(#0 and #1 and #2 and #3) or (#4 and #1 and #2 and (#5 or #6))");
            }
        } else {
            filterInfo.setMaskString("#0 and #1 and #2 ");
        }
        entityViewInfo.setFilter(filterInfo);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        return entityViewInfo;
    }

    public static EntityViewInfo getPublishRangeEntityViewInfo(Context ctx) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("status", (Object)new Integer(2), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("publishToDesktop", (Object)new Integer(1), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        try {
            if (DesktopCMPermissionUtil.setRangeFilter(filterInfo, ctx)) {
                if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                    filterInfo.setMaskString("#0 and #1 and #2 and (#3 or (#4 and #5) or (#6 and #7) or #8 or #9)");
                } else {
                    filterInfo.setMaskString("#0 and #1 and #2 and (#3 or #4)");
                }
                entityViewInfo.setFilter(filterInfo);
                SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
                sorterItemInfo.setSortType(SortType.DESCEND);
                entityViewInfo.getSorter().add(sorterItemInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entityViewInfo;
    }

    public static IRowSet getRecentContent(Context ctx, int index, int size) {
        try {
            Set hashSet = DesktopCMPermissionUtil.getReadColumnIDStr(ctx);
            if (hashSet != null && hashSet.size() > 0) {
                EntityViewInfo entityViewInfo = DesktopCMPermissionUtil.getReadColumnEntityViewInfo(ctx, hashSet);
                MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
                IQueryExecutor exec = DesktopCMPermissionUtil.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
                exec.option().isAutoTranslateEnum = false;
                IRowSet rowSet = null;
                rowSet = exec.executeQuery(index, size);
                return rowSet;
            }
            EntityViewInfo entityViewInfo = DesktopCMPermissionUtil.getPublishRangeEntityViewInfo(ctx);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
            IQueryExecutor exec = DesktopCMPermissionUtil.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            exec.option().isAutoTranslateEnum = false;
            IRowSet rowSet = null;
            rowSet = exec.executeQuery(index, size);
            return rowSet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getUnreadContentCount(Context ctx) {
        Set hashSet = null;
        HashSet<String> allContentIDSet = new HashSet<String>();
        int unReadCount = 0;
        boolean allCount = false;
        try {
            hashSet = DesktopCMPermissionUtil.getReadColumnIDStr(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EntityViewInfo entityViewInfo = hashSet != null && hashSet.size() > 0 ? DesktopCMPermissionUtil.getReadColumnEntityViewInfo(ctx, hashSet) : DesktopCMPermissionUtil.getPublishRangeEntityViewInfo(ctx);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        try {
            IQueryExecutor exec = DesktopCMPermissionUtil.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            IRowSet rowSet = null;
            rowSet = exec.executeQuery();
            while (rowSet.next()) {
                allContentIDSet.add(rowSet.getString("id"));
            }
            allContentIDSet.removeAll(DesktopCMPermissionUtil.getHasReadContentList(ctx));
            unReadCount = allContentIDSet.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unReadCount;
    }

    public static List getHasReadContentList(Context ctx) {
        String sql = "select fcontentid from t_cm_reader where  freader='" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName() + "'";
        IRowSet readerRowSet = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            readerRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (readerRowSet.next()) {
                    list.add(readerRowSet.getString(1));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean setRangeFilter(FilterInfo filterInfo, Context ctx) throws Exception {
        boolean isRoleControl = false;
        FilterItemInfo filterItemInfo = null;
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
            Set rolePermSet;
            filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(1), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                filterItemInfo = new FilterItemInfo("CMRolePerson.personId", (Object)currentPerson.getId().toString(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                AdminOrgUnitInfo currentAdmin = null;
                currentAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(currentPerson.getId());
                if (currentAdmin == null || currentAdmin.isIsSealUp()) {
                    AdminOrgUnitCollection orgUnitCol = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(currentPerson.getId());
                    currentAdmin = null;
                    for (int i = orgUnitCol.size() - 1; i >= 0 && (currentAdmin = orgUnitCol.get(i)).isIsSealUp(); --i) {
                        currentAdmin = null;
                    }
                }
                if (currentAdmin == null) {
                    currentAdmin = ContextUtil.getCurrentAdminUnit((Context)ctx);
                }
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(false), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.adminOrgId", (Object)currentAdmin.getId().toString(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(true), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                HashSet<String> adminNumber = new HashSet<String>();
                String[] currentNumber = currentAdmin.getLongNumber().split("!");
                String longNumber = "";
                if (currentNumber != null && currentNumber.length > 0) {
                    int size = currentNumber.length;
                    for (int i = 0; i < size; ++i) {
                        longNumber = longNumber + currentNumber[i];
                        adminNumber.add(longNumber);
                        if (i == size - 1) continue;
                        longNumber = longNumber + "!";
                    }
                }
                filterItemInfo = new FilterItemInfo("AdminOrgUnit.longNumber", adminNumber, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
            }
            if ((rolePermSet = CmUtil.getUserRolePerm(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString())).size() == 0) {
                rolePermSet.add(new Integer(0));
            }
            filterItemInfo = new FilterItemInfo("CMRoleRole.roleId", (Object)rolePermSet, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("User.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            isRoleControl = true;
        }
        return isRoleControl;
    }
}

