/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.cm.CMColumnFactory;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ContentStatus;
import com.kingdee.eas.cp.eip.cm.ICMColumn;
import com.kingdee.eas.cp.eip.cm.web.service.PublishContent;
import com.kingdee.eas.cp.eip.cm.xt.CMNewsAdapter;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.XTServiceFacade;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class CMNewsPublishObserver
implements Observer {
    private static Logger logger = Logger.getLogger((String)CMNewsPublishObserver.class.getName());

    @Override
    public void update(Observable arg0, Object obj) {
        try {
            PublishContent pContent = (PublishContent)arg0;
            Context ctx = pContent.ctx;
            CMContentInfo info = (CMContentInfo)obj;
            logger.info((Object)"CMNewsPublishObserver : CM NEWS status has updated");
            if (info.getStatus().equals((Object)ContentStatus.PUBLISH)) {
                logger.info((Object)"CMNewsPublishObserver : CM NEWS has published");
                if (this.isPublishToXT(ctx, info)) {
                    logger.info((Object)"CMNewsPublishObserver : CM NEWS isPublishToXT=true");
                    XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
                    if (xTServiceConfig.getPubEnabled(xTServiceConfig.getEidByDbCode(ctx.getAIS()), "XTNews")) {
                        XTServiceFacade.pushMessage((Context)ctx, (IMessageAdapter)new CMNewsAdapter(info.getId().toString(), ctx), (String)"XTNews");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)("observer exception:" + e.getMessage()));
        }
    }

    private boolean isPublishToXT(Context ctx, CMContentInfo contentInfo) {
        try {
            ICMColumn iCMColumn = CMColumnFactory.getLocalInstance(ctx);
            CMColumnInfo columnInfo = (CMColumnInfo)iCMColumn.getValue((IObjectPK)new ObjectUuidPK(contentInfo.getColumnID()));
            return columnInfo.isPublishToXTtop() || columnInfo.isPublishToDesktop();
        }
        catch (BOSException e) {
            logger.info((Object)("isPublishToXT BOSException:" + e.getMessage()));
        }
        catch (EASBizException e) {
            logger.info((Object)("isPublishToXT EASBizException:" + e.getMessage()));
        }
        return false;
    }
}

