/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.de.web;

import com.kingdee.eas.cp.eip.de.web.DataBaseInfo;
import com.kingdee.eas.cp.eip.de.web.DataContent;
import com.kingdee.eas.cp.eip.de.web.DataExtraInfo;
import com.kingdee.eas.cp.eip.de.web.DataHead;
import com.kingdee.eas.cp.eip.de.web.DataPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class DataPackageSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPackage(HttpServletResponse response, DataPackage dataPackage) {
        ServletOutputStream out = null;
        DataHead dataHead = dataPackage.getHead();
        DataBaseInfo info = dataPackage.getInfo();
        DataContent content = dataPackage.getContent();
        DataExtraInfo extraInfo = dataPackage.getExtraInfo();
        FileInputStream fis = null;
        int headLen = 0;
        int infoLen = 0;
        int contentLen = 0;
        int extraInfoLen = 0;
        if (dataHead != null) {
            headLen = dataHead.getHeadLen();
        }
        if (info != null) {
            infoLen = info.getInfoLen();
        }
        if (content != null) {
            contentLen = content.getContentLen();
        }
        if (extraInfo != null) {
            extraInfoLen = extraInfo.getExtraInfoLen();
        }
        dataHead.setDocInfoSize(infoLen);
        dataHead.setContentSize(contentLen);
        dataHead.setExtraInfoSize(extraInfoLen);
        try {
            out = response.getOutputStream();
            out.write(this.assembleHead(dataHead));
            out.write(this.assembleBaseInfo(info));
            if (contentLen > 0) {
                if (content.getTxtContent() != null) {
                    out.write(content.getTxtContent().getBytes("UTF-8"));
                } else if (content.getByteContent() != null) {
                    out.write(content.getByteContent());
                } else if (content.getFileContent() != null) {
                    File file = new File(content.getFileContent());
                    fis = new FileInputStream(file);
                    int bufferSize = 2048;
                    int readTimes = contentLen / bufferSize;
                    int remaining = 0;
                    boolean totalBytes = false;
                    byte[] buffer = new byte[bufferSize];
                    for (int i = 0; i < readTimes; ++i) {
                        fis.read(buffer);
                        out.write(buffer);
                    }
                    remaining = contentLen - bufferSize * readTimes;
                    if (remaining > 0) {
                        byte[] remainByte = new byte[remaining];
                        fis.read(remainByte);
                        out.write(remainByte);
                    }
                    fis.close();
                    file.delete();
                }
            }
            if (extraInfoLen > 0) {
                // empty if block
            }
            out.flush();
            out.close();
        }
        catch (UnsupportedEncodingException encodingEx) {
            encodingEx.getMessage();
        }
        catch (IOException ioe) {
            ioe.getMessage();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private byte[] assembleHead(DataHead head) {
        ByteBuffer buffer = ByteBuffer.allocate(head.getHeadLen());
        buffer.put(this.writeInt(head.getDataPackageVersion()));
        buffer.put(this.writeInt(head.getDocInfoSize()));
        buffer.put(this.writeInt(head.getContentSize()));
        buffer.put(this.writeInt(head.getExtraInfoSize()));
        buffer.flip();
        return buffer.array();
    }

    private byte[] assembleBaseInfo(DataBaseInfo info) throws UnsupportedEncodingException {
        ByteBuffer buffer = ByteBuffer.allocate(info.getInfoLen());
        if ("save".equalsIgnoreCase(info.getOperateCommand())) {
            buffer.put((byte)1);
        } else if ("delete".equalsIgnoreCase(info.getOperateCommand())) {
            buffer.put((byte)2);
        } else if ("load".equalsIgnoreCase(info.getOperateCommand())) {
            buffer.put((byte)3);
        }
        if ("saveError".equalsIgnoreCase(info.getOperateCommand())) {
            buffer.put((byte)-127);
        } else if ("deleteError".equalsIgnoreCase(info.getOperateCommand())) {
            buffer.put((byte)-126);
        } else if ("loadError".equalsIgnoreCase(info.getOperateCommand())) {
            buffer.put((byte)-125);
        }
        if ("txt".equalsIgnoreCase(info.getDataType())) {
            buffer.put((byte)1);
        } else if ("att".equalsIgnoreCase(info.getDataType())) {
            buffer.put((byte)2);
        } else if ("lis".equalsIgnoreCase(info.getDataType())) {
            buffer.put((byte)3);
        }
        System.out.println("is zip :" + info.isZip() + "dataType" + info.getDataType());
        if (info.isZip()) {
            buffer.put((byte)1);
        } else {
            buffer.put((byte)0);
        }
        if (info.getUserName() != null) {
            buffer.put(this.writeShort(info.getUserName().getBytes("UTF-8").length));
            buffer.put(info.getUserName().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        if (info.getTargetDocumentLib() != null) {
            buffer.put(this.writeShort(info.getTargetDocumentLib().getBytes("UTF-8").length));
            buffer.put(info.getTargetDocumentLib().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        if (info.getUuid() != null) {
            buffer.put(this.writeShort(info.getUuid().getBytes("UTF-8").length));
            buffer.put(info.getUuid().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        System.out.println("docType is = " + info.getDocType());
        if ("body".equalsIgnoreCase(info.getDocType())) {
            buffer.put((byte)0);
        } else if ("attech".equalsIgnoreCase(info.getDocType())) {
            buffer.put((byte)0);
        } else if ("title".equalsIgnoreCase(info.getDocType())) {
            buffer.put((byte)1);
        } else if ("url".equalsIgnoreCase(info.getDocType())) {
            buffer.put((byte)1);
        } else if ("path".equalsIgnoreCase(info.getDocType())) {
            buffer.put((byte)2);
        } else if ("lis".equalsIgnoreCase(info.getDocType())) {
            buffer.put((byte)0);
        }
        if (info.getAttechId() != null) {
            buffer.put(this.writeShort(info.getAttechId().getBytes("UTF-8").length));
            buffer.put(info.getAttechId().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        if (info.getFileName() != null) {
            buffer.put(this.writeShort(info.getFileName().getBytes("UTF-8").length));
            buffer.put(info.getFileName().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        if (info.getLastUpdate() != null) {
            buffer.put(this.writeShort(info.getLastUpdate().getBytes("UTF-8").length));
            buffer.put(info.getLastUpdate().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        buffer.put(this.writeLong(info.getFileSize()));
        if (info.getVerifyWord() != null) {
            buffer.put(this.writeShort(info.getVerifyWord().getBytes("UTF-8").length));
            buffer.put(info.getVerifyWord().getBytes("UTF-8"));
        } else {
            buffer.put(this.writeShort(0));
        }
        buffer.flip();
        byte[] returnByteArr = new byte[buffer.limit()];
        buffer.get(returnByteArr);
        return returnByteArr;
    }

    public byte[] writeShort(int i) {
        byte[] byteShort = new byte[]{(byte)(i >>> 0 & 0xFF), (byte)(i >>> 8 & 0xFF)};
        return byteShort;
    }

    public byte[] writeInt(int i) {
        byte[] byteShort = new byte[]{(byte)(i >>> 0 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 24 & 0xFF)};
        return byteShort;
    }

    public byte[] writeLong(long l) {
        byte[] byteShort = new byte[]{(byte)(l >>> 0 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 56 & 0xFFL)};
        return byteShort;
    }
}

