/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.archive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.fme.app.BusiDocCollection;
import com.kingdee.eas.base.fme.app.BusiDocFactory;
import com.kingdee.eas.base.fme.app.DocumentCollection;
import com.kingdee.eas.base.fme.dao.FMEDaoFactory;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DMArchiveException;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.ICategory;
import com.kingdee.eas.cp.dm.IDocument;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentInterface;
import com.kingdee.eas.cp.dm.archive.ArchiveDocumentParamsInfo;
import com.kingdee.eas.cp.dm.archive.ArchiveResultInfo;
import com.kingdee.eas.cp.dm.archive.ArchiveUtil;
import com.kingdee.eas.cp.dm.archive.AttachHandleFTP;
import com.kingdee.eas.cp.dm.archive.AttachHandleHttp;
import com.kingdee.eas.cp.dm.archive.util.ArchiveUtils;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ArchiveDocumentImpl
implements ArchiveDocumentInterface {
    protected IFMEDao fmeDao;
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.archive.ArchiveDocumentImpl");

    @Override
    public ArchiveResultInfo archiveDocument(Context ctx, ArchiveDocumentParamsInfo paramsInfo, InputStream bodyStream, String bizId, boolean archiveAttach) throws EASBizException, BOSException, Exception {
        List tempList;
        DocumentInfo docInfo = this.contructDocument(ctx, paramsInfo);
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        String[] fileNames = null;
        InputStream[] streams = null;
        if (archiveAttach && (tempList = this.getAttach(ctx, bizId)) != null && tempList.size() >= 2) {
            streams = (InputStream[])tempList.get(0);
            fileNames = (String[])tempList.get(1);
        }
        return this.executeArchiveDocument(ctx, docInfo, bodyStream, streams, fileNames, bizId);
    }

    @Override
    public ArchiveResultInfo archiveDocument(Context ctx, ArchiveDocumentParamsInfo paramsInfo, File body, File[] files) throws EASBizException, BOSException {
        DocumentInfo docInfo = this.contructDocument(ctx, paramsInfo);
        return null;
    }

    @Override
    public ArchiveResultInfo archiveDocument(Context ctx, ArchiveDocumentParamsInfo paramsInfo, InputStream bodyStream, InputStream[] fileStreams, String[] fileNames) throws EASBizException, BOSException, Exception {
        DocumentInfo docInfo = this.contructDocument(ctx, paramsInfo);
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        return this.executeArchiveDocument(ctx, docInfo, bodyStream, fileStreams, fileNames);
    }

    @Override
    public ArchiveResultInfo archiveDocument(Context ctx, ArchiveDocumentParamsInfo paramsInfo, InputStream bodyStream, InputStream[] fileStreams, String[] fileNames, String bizId) throws EASBizException, BOSException, Exception {
        DocumentInfo docInfo = this.contructDocument(ctx, paramsInfo);
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        return this.executeArchiveDocument(ctx, docInfo, bodyStream, fileStreams, fileNames, bizId);
    }

    @Override
    public ArchiveResultInfo archiveDocument(Context ctx, ArchiveDocumentParamsInfo paramsInfo, OutputStream bodyStream, String bizId, boolean archiveAttach) throws EASBizException, BOSException, Exception {
        List tempList;
        DocumentInfo docInfo = this.contructDocument(ctx, paramsInfo);
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        String[] fileNames = null;
        InputStream[] streams = null;
        if (archiveAttach && (tempList = this.getAttach(ctx, bizId)) != null && tempList.size() >= 2) {
            streams = (InputStream[])tempList.get(0);
            fileNames = (String[])tempList.get(1);
        }
        return this.executeArchiveDocument(ctx, docInfo, bodyStream, streams, fileNames, bizId);
    }

    private ArchiveResultInfo executeArchiveDocument(Context ctx, DocumentInfo docInfo, OutputStream bodyStream, InputStream[] fileStreams, String[] fileNames) throws Exception {
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        if (fileStreams != null && fileStreams.length > 0) {
            FMEParameter fmeParameter = new FMEParameter();
            this.initFMEParameter(fmeParameter, docInfo);
            AttachHandleFTP ftpHandle = new AttachHandleFTP();
            ServiceResult result = ftpHandle.saveAttach(ctx, fileStreams, fileNames, id.toString(), fmeParameter);
            if (result == null || !result.isResult()) {
                throw new DMArchiveException(DMArchiveException.ARCHIVEERROR, new Object[]{result.getResultMessge()});
            }
            docInfo.setDisplayAttachSize(ArchiveUtils.getFileSize(result.getFileSize()));
        } else {
            logger.info((Object)"executeArchiveDocument: no attach,\u65e0\u9644\u4ef6");
        }
        if (bodyStream != null) {
            this.addAttache(ctx, id.toString(), bodyStream, docInfo.getContentType().getName().toLowerCase());
        } else {
            logger.info((Object)"executeArchiveDocument:no body attach,\u65e0\u6b63\u6587");
        }
        IDocument idoc = DocumentFactory.getLocalInstance(ctx);
        idoc.dmSubmit((IObjectValue)docInfo);
        ArchiveResultInfo resultInfo = new ArchiveResultInfo();
        resultInfo.setDocId(id.toString());
        return this.contructResult(ctx, id.toString(), resultInfo);
    }

    private ArchiveResultInfo executeArchiveDocument(Context ctx, DocumentInfo docInfo, OutputStream bodyStream, InputStream[] fileStreams, String[] fileNames, String bizId) throws Exception {
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        String[] str = this.addAttach4Ftp(ctx, bizId, id.toString());
        logger.info((Object)("executeArchiveDocument-----------------ftp attachSize:" + str[1] + "|attachNum:" + str[0]));
        if (fileStreams != null && fileStreams.length > 0) {
            FMEParameter fmeParameter = new FMEParameter();
            this.initFMEParameter(fmeParameter, docInfo);
            AttachHandleFTP ftpHandle = new AttachHandleFTP();
            ServiceResult result = ftpHandle.saveAttach(ctx, fileStreams, fileNames, id.toString(), fmeParameter);
            if (result == null || !result.isResult()) {
                throw new DMArchiveException(DMArchiveException.ARCHIVEERROR, new Object[]{result.getResultMessge()});
            }
            docInfo.setDisplayAttachSize(ArchiveUtils.getFileSize(result.getFileSize() + Long.parseLong(str[1])));
            docInfo.setDisplayAttachNumber(fileStreams.length + Integer.parseInt(str[0]));
        } else {
            docInfo.setDisplayAttachSize(ArchiveUtils.getFileSize(Long.parseLong(str[1])));
            docInfo.setDisplayAttachNumber(Integer.parseInt(str[0]));
            logger.info((Object)"executeArchiveDocument: no attach,\u65e0\u9644\u4ef6");
        }
        if (bodyStream != null) {
            this.addAttache(ctx, id.toString(), bodyStream, docInfo.getContentType().getName().toLowerCase());
        } else {
            logger.info((Object)"executeArchiveDocument:no body attach,\u65e0\u6b63\u6587");
        }
        IDocument idoc = DocumentFactory.getLocalInstance(ctx);
        idoc.dmSubmit((IObjectValue)docInfo);
        ArchiveResultInfo resultInfo = new ArchiveResultInfo();
        resultInfo.setDocId(id.toString());
        return this.contructResult(ctx, id.toString(), resultInfo);
    }

    /*
     * Unable to fully structure code
     */
    private ArchiveResultInfo executeArchiveDocument(Context ctx, DocumentInfo docInfo, InputStream bodyStream, InputStream[] fileStreams, String[] fileNames) throws Exception {
        id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        if (null != docInfo.getId()) {
            ArchiveDocumentImpl.logger.info((Object)("ArchiveDocumentImpl::executeArchiveDocument()----begin---docInfo.id = " + docInfo.getId().toString()));
        }
        attachCount = 0;
        attachSize = "";
        flieSizeLong = 0L;
        if (fileStreams != null && fileStreams.length > 0) {
            attachCount = fileStreams.length;
            fmeParameter = new FMEParameter();
            this.initFMEParameter(fmeParameter, docInfo);
            ftpHandle = new AttachHandleFTP();
            result = ftpHandle.saveAttach(ctx, fileStreams, fileNames, id.toString(), fmeParameter);
            if (result == null || !result.isResult()) {
                throw new DMArchiveException(DMArchiveException.ARCHIVEERROR, new Object[]{result.getResultMessge()});
            }
            flieSizeLong = result.getFileSize();
        }
        if (null != docInfo.getBizID() && !"".equals(docInfo.getBizID())) {
            sql = "select fdocumentid,fsize,fdescription from t_fme_document where fdocumentid in (select fdocumentid from t_fme_busidoc where fbusinessid ='" + docInfo.getBizID() + "')";
            ArchiveDocumentImpl.logger.info((Object)("ArchiveDocumentImpl::executeArchiveDocument()----------get fmeDocuments's sql = " + sql));
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (null == rs) ** GOTO lbl60
                documentIDArray = new String[rs.size()];
                displayName = new String[rs.size()];
                fileSize = new String[rs.size()];
                i = 0;
                while (rs.next()) {
                    documentIDArray[i] = rs.getString("fdocumentid");
                    fileSize[i] = rs.getString("fsize");
                    displayName[i] = description = rs.getString("fdescription");
                    if (description.lastIndexOf("\\") != -1) {
                        displayName[i] = description.substring(description.lastIndexOf("\\") + 1);
                    }
                    ++i;
                }
                if (null == this.fmeDao) {
                    this.fmeDao = FMEDaoFactory.getFMEDaoInstance((Context)ctx);
                }
                this.fmeDao.insertBusiDoc(docInfo.getId().toString(), documentIDArray, displayName);
                ArchiveDocumentImpl.logger.info((Object)"ArchiveDocumentImpl::executeArchiveDocument()-----fmeDao.insertBusiDoc is ok!");
                if (null != documentIDArray) {
                    for (j = 0; j < documentIDArray.length; ++j) {
                        ArchiveDocumentImpl.logger.info((Object)("ArchiveDocumentImpl::executeArchiveDocument()-----insert document" + j + " = " + documentIDArray[j]));
                        this.fmeDao.insertOperLog(documentIDArray[j], 3);
                    }
                }
                for (k = 0; k < fileSize.length; ++k) {
                    flieSizeStr = fileSize[k];
                    flieSizeLong += Long.parseLong(flieSizeStr);
                }
            }
            catch (BOSException e) {
                ArchiveDocumentImpl.logger.info((Object)("ArchiveDocumentImpl::executeArchiveDocument()-----fmeDao.insertBusiDoc is failed! BOSException = " + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            ArchiveDocumentImpl.logger.info((Object)"executeArchiveDocument: no attach,\u65e0\u9644\u4ef6");
        }
lbl60:
        // 4 sources

        docInfo.setDisplayAttachSize(ArchiveUtils.getFileSize(flieSizeLong));
        if (bodyStream != null) {
            this.addAttache(ctx, id.toString(), bodyStream, docInfo.getContentType().getName().toLowerCase());
        } else {
            ArchiveDocumentImpl.logger.info((Object)"executeArchiveDocument:no body attach,\u65e0\u6b63\u6587");
        }
        idoc = DocumentFactory.getLocalInstance(ctx);
        idoc.dmSubmit((IObjectValue)docInfo);
        resultInfo = new ArchiveResultInfo();
        resultInfo.setDocId(id.toString());
        return this.contructResult(ctx, id.toString(), resultInfo);
    }

    private ArchiveResultInfo executeArchiveDocument(Context ctx, DocumentInfo docInfo, InputStream bodyStream, InputStream[] fileStreams, String[] fileNames, String bizId) throws Exception {
        BOSUuid id = docInfo.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)docInfo.getBOSType());
            docInfo.setId(id);
        }
        int attachCount = 0;
        String attachSize = "";
        String[] str = this.addAttach4Ftp(ctx, bizId, id.toString());
        logger.info((Object)("executeArchiveDocument-----------------ftp attachSize:" + str[1] + "|attachNum:" + str[0]));
        if (fileStreams != null && fileStreams.length > 0) {
            attachCount = fileStreams.length;
            FMEParameter fmeParameter = new FMEParameter();
            this.initFMEParameter(fmeParameter, docInfo);
            AttachHandleFTP ftpHandle = new AttachHandleFTP();
            ServiceResult result = ftpHandle.saveAttach(ctx, fileStreams, fileNames, id.toString(), fmeParameter);
            if (result == null || !result.isResult()) {
                throw new DMArchiveException(DMArchiveException.ARCHIVEERROR, new Object[]{result.getResultMessge()});
            }
            docInfo.setDisplayAttachSize(ArchiveUtils.getFileSize(result.getFileSize() + Long.parseLong(str[1])));
            docInfo.setDisplayAttachNumber(fileStreams.length + Integer.parseInt(str[0]));
        } else {
            docInfo.setDisplayAttachSize(ArchiveUtils.getFileSize(Long.parseLong(str[1])));
            docInfo.setDisplayAttachNumber(Integer.parseInt(str[0]));
            logger.info((Object)"executeArchiveDocument: no attach,\u65e0\u9644\u4ef6(\u6570\u636e\u5e93\u4e2d)");
        }
        if (bodyStream != null) {
            this.addAttache(ctx, id.toString(), bodyStream, docInfo.getContentType().getName().toLowerCase());
        } else {
            logger.info((Object)"executeArchiveDocument:no body attach,\u65e0\u6b63\u6587");
        }
        IDocument idoc = DocumentFactory.getLocalInstance(ctx);
        idoc.dmSubmit((IObjectValue)docInfo);
        ArchiveResultInfo resultInfo = new ArchiveResultInfo();
        resultInfo.setDocId(id.toString());
        return this.contructResult(ctx, id.toString(), resultInfo);
    }

    private DocumentInfo contructDocument(Context ctx, ArchiveDocumentParamsInfo paramsInfo) throws EASBizException, BOSException {
        CategoryInfo categoryInfo;
        DocumentInfo docInfo = new DocumentInfo();
        if (paramsInfo == null) {
            throw new DMArchiveException(DMArchiveException.ARCHIVE_SOURCECE_IS_NULL);
        }
        paramsInfo.valid(ctx);
        String categoryId = paramsInfo.getCategoryId();
        if (categoryId != null) {
            categoryInfo = this.initCategory(ctx, categoryId);
            if (categoryInfo == null) {
                throw new DMArchiveException(DMArchiveException.CATEGORY_PATH_NOT_EXIST);
            }
        } else {
            throw new DMArchiveException(DMArchiveException.CATEGORY_ID_NULL);
        }
        docInfo.setCategory(categoryInfo);
        docInfo.setIsPrintAttach(categoryInfo.isIsPrintAttach());
        docInfo.setCanCopy(categoryInfo.isCanCopy());
        docInfo.setCanDownload(categoryInfo.isCanDownload());
        docInfo.setNumber(paramsInfo.getNumber());
        docInfo.setTitle(paramsInfo.getTitle());
        docInfo.setVersion(paramsInfo.getVersion());
        docInfo.setDocMarkNumber(paramsInfo.getDescription());
        docInfo.setCreateTime(paramsInfo.getCreateTime());
        docInfo.setTag(paramsInfo.getTag());
        docInfo.setSummary(paramsInfo.getSummary());
        docInfo.setIsTop(false);
        docInfo.setIsRed(false);
        docInfo.setIsLatest(false);
        docInfo.setReadCount(0);
        docInfo.setCommentCount(0);
        docInfo.setPublishCount(0);
        docInfo.setState(DmState.ENABLE);
        docInfo.setWfState(DocWfState.PUBLISH);
        docInfo.setDocMarkNumber(paramsInfo.getDocNumber());
        String moduleName = paramsInfo.getModuleName();
        docInfo.setArchivedModule(moduleName);
        if (paramsInfo.getAuthor() == null) {
            docInfo.setAuthor(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        } else {
            docInfo.setAuthor(paramsInfo.getAuthor());
        }
        docInfo.setCreatePerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
        docInfo.setCanCopy(paramsInfo.isCanCopy());
        docInfo.setIsHistory(false);
        docInfo.setDocDept(ContextUtil.getCurrentAdminUnit((Context)ctx));
        docInfo.setIsArchive(true);
        docInfo.setBizID(paramsInfo.getBizID());
        docInfo.setContentType(paramsInfo.getContentType());
        docInfo.setDisplayAttachSize("");
        return docInfo;
    }

    private String addAttache(Context ctx, String bizId, InputStream bodyStream, String attachType) throws EASBizException, BOSException, Exception {
        String fileName = ArchiveUtil.getRandomFileName(attachType);
        AttachHandleHttp httpSave = new AttachHandleHttp();
        return httpSave.saveAttach(ctx, fileName, bizId, bodyStream);
    }

    public String addAttache(Context ctx, String bizId, OutputStream bodyStream, String attachType) throws EASBizException, BOSException, Exception {
        String fileName = ArchiveUtil.getRandomFileName(attachType);
        AttachHandleHttp httpSave = new AttachHandleHttp();
        return httpSave.saveAttach(ctx, fileName, bizId, bodyStream);
    }

    private String[] addAttach4Ftp(Context ctx, String bizId, String docId) {
        long size = 0L;
        int number = 0;
        if (this.isHasAttachByBizId4Ftp(ctx, bizId)) {
            String oql = "select * where BusinessID = '" + bizId + "'";
            BusiDocCollection busiDocColl = null;
            BusiDocCollection aimBusiDocColl = new BusiDocCollection();
            ArrayList<String> attachIdList = new ArrayList<String>();
            try {
                busiDocColl = BusiDocFactory.getLocalInstance((Context)ctx).getCollection(oql);
                aimBusiDocColl = (BusiDocCollection)busiDocColl.clone();
                logger.info((Object)("addAttach4Ftp-----------------aimBusiDocColl:" + aimBusiDocColl));
                int len = aimBusiDocColl.size();
                for (int i = 0; i < len; ++i) {
                    attachIdList.add(aimBusiDocColl.get(i).getDocumentID());
                    aimBusiDocColl.get(i).setBusinessID(docId);
                    aimBusiDocColl.get(i).setID(null);
                    BusiDocFactory.getLocalInstance((Context)ctx).addnew(aimBusiDocColl.get(i));
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            String oql2 = "select * where DocumentID in " + CommonUtils.getStrFromList(attachIdList);
            DocumentCollection docColl = null;
            try {
                docColl = com.kingdee.eas.base.fme.app.DocumentFactory.getLocalInstance((Context)ctx).getCollection(oql2.toString());
                int len = docColl.size();
                for (int i = 0; i < len; ++i) {
                    ++number;
                    size += (long)docColl.get(i).getSize();
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        String[] str = new String[]{String.valueOf(number), String.valueOf(size)};
        return str;
    }

    private List getAttach(Context ctx, String bizId) throws BOSException {
        ByteArrayInputStream[] stream = null;
        String[] fileNames = null;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(2);
        List atts = this.getAttacheByBizID(ctx, bizId);
        if (atts != null) {
            int size = atts.size();
            fileNames = new String[size];
            stream = new ByteArrayInputStream[size];
            Iterator ite = atts.iterator();
            int i = 0;
            while (ite.hasNext()) {
                AttachmentInfo attInfo = (AttachmentInfo)ite.next();
                if (null != attInfo && attInfo.getFile() == null) {
                    try {
                        byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attInfo.getId().toString());
                        attInfo.setFile(files);
                    }
                    catch (BOSException e) {
                        logger.error((Object)("ArchiveDocumentImpl::getAttach()---downLoad attachmentInfo ,the id = " + attInfo.getId().toString() + " , is fail: "), (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (EASBizException e) {
                        logger.error((Object)("ArchiveDocumentImpl::getAttach()---downLoad attachmentInfo ,the id = " + attInfo.getId().toString() + " , is fail: "), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (null != attInfo && null != attInfo.getFile()) {
                    stream[i] = new ByteArrayInputStream(attInfo.getFile());
                }
                fileNames[i] = attInfo.getSimpleName();
                ++i;
            }
        }
        dataList.add(stream);
        dataList.add(fileNames);
        return dataList;
    }

    private List getAttacheByBizID(Context ctx, String seleID) throws BOSException {
        ArrayList<AttachmentInfo> atts = new ArrayList<AttachmentInfo>();
        IBoAttchAsso boAtt = null;
        Object info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("attachment.id"));
        selector.add(new SelectorItemInfo("attachment.file"));
        selector.add(new SelectorItemInfo("attachment.type"));
        selector.add(new SelectorItemInfo("attachment.sizeInByte"));
        selector.add(new SelectorItemInfo("attachment.size"));
        selector.add(new SelectorItemInfo("attachment.name"));
        selector.add(new SelectorItemInfo("attachment.simpleName"));
        ev.setSelector(selector);
        Object attachInfo = null;
        boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        cols = boAtt.getBoAttchAssoCollection(ev);
        int leng = cols.size();
        for (int i = 0; i < leng; ++i) {
            atts.add(cols.get(i).getAttachment());
        }
        return atts;
    }

    private boolean isHasAttachByBizId4Ftp(Context ctx, String bizId) {
        String oql = "select * where BusinessID = '" + bizId + "'";
        boolean isExists = false;
        try {
            isExists = BusiDocFactory.getLocalInstance((Context)ctx).exists(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return isExists;
    }

    private FMEParameter initFMEParameter(Context ctx, FMEParameter fmeParams, String categoryId) throws EASBizException, BOSException {
        FMEParameter params = fmeParams;
        if (params == null) {
            params = new FMEParameter();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("isVerSet"));
        sic.add(new SelectorItemInfo("attachSet"));
        sic.add(new SelectorItemInfo("attachTypes"));
        sic.add(new SelectorItemInfo("attachSizes"));
        sic.add(new SelectorItemInfo("isAnonymous"));
        sic.add(new SelectorItemInfo("docArea.id"));
        sic.add(new SelectorItemInfo("docArea.ftpPath"));
        sic.add(new SelectorItemInfo("docArea.state"));
        sic.add(new SelectorItemInfo("category.canReSelectTemplate"));
        CategoryInfo cateInfo = CategoryFactory.getLocalInstance(ctx).getCategoryInfo((IObjectPK)new ObjectUuidPK(categoryId), sic);
        if (cateInfo != null) {
            params.setNewPathID(cateInfo.getDocArea().getFtpPath());
            params.setNewCategoryInfo(categoryId);
        }
        return params;
    }

    private FMEParameter initFMEParameter(FMEParameter fmeParams, DocumentInfo docInfo) throws EASBizException, BOSException {
        FMEParameter params = fmeParams;
        if (params == null) {
            params = new FMEParameter();
        }
        params.setNewPathID(docInfo.getCategory().getDocArea().getFtpPath());
        params.setNewCategoryInfo(docInfo.getCategory().getId().toString());
        return params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CategoryInfo initCategory(Context ctx, String categoryId) throws BOSException, DMArchiveException, EASBizException {
        CategoryInfo cateInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("isArchive"));
        sic.add(new SelectorItemInfo("isVerSet"));
        sic.add(new SelectorItemInfo("attachSet"));
        sic.add(new SelectorItemInfo("attachTypes"));
        sic.add(new SelectorItemInfo("attachSizes"));
        sic.add(new SelectorItemInfo("isAnonymous"));
        sic.add(new SelectorItemInfo("docArea.id"));
        sic.add(new SelectorItemInfo("docArea.ftpPath"));
        sic.add(new SelectorItemInfo("docArea.state"));
        sic.add(new SelectorItemInfo("category.canReSelectTemplate"));
        sic.add(new SelectorItemInfo("isPrintAttach"));
        sic.add(new SelectorItemInfo("canDownload"));
        sic.add(new SelectorItemInfo("canCopy"));
        ICategory iCategory = CategoryFactory.getLocalInstance(ctx);
        if (!iCategory.exists((IObjectPK)new ObjectUuidPK(categoryId))) throw new DMArchiveException(DMArchiveException.CATEGORY_PATH_NOT_EXIST);
        cateInfo = iCategory.getCategoryInfo((IObjectPK)new ObjectUuidPK(categoryId), sic);
        if (cateInfo == null) throw new DMArchiveException(DMArchiveException.CATEGORY_PATH_NOT_EXIST);
        if (DmState.ENABLE.equals((Object)cateInfo.getState()) && cateInfo.isIsArchive()) return cateInfo;
        throw new DMArchiveException(DMArchiveException.CATEGORY_ID_NOT_ENABLE);
    }

    private ArchiveResultInfo contructResult(Context ctx, String docId, ArchiveResultInfo resultInfo) throws BOSException, EASBizException {
        ArchiveResultInfo tempResult = resultInfo;
        if (tempResult == null) {
            tempResult = new ArchiveResultInfo();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("title"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("category.longNumber"));
        sic.add(new SelectorItemInfo("category.docArea.name"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)new ObjectUuidPK(docId), sic);
        if (docInfo != null) {
            resultInfo.setDocId(docId);
            resultInfo.setTitle(docInfo.getTitle());
            resultInfo.setDocNumber(docInfo.getNumber());
            resultInfo.setCategoryName(docInfo.getCategory().getName());
            resultInfo.setAreaName(docInfo.getCategory().getDocArea().getName());
        }
        return tempResult;
    }
}

