/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.archive.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.common.EASBizException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ArchiveUtils {
    public static Logger logger = Logger.getLogger(ArchiveUtils.class);

    public static String getFileSize(long fileLen) {
        String fileSize = "";
        String fileSizeStr = "" + fileLen;
        String endSizeName = "KB";
        if (fileLen < 1000L) {
            endSizeName = "byte";
            fileSize = fileSizeStr + endSizeName;
        } else if (fileLen < 1000000L) {
            endSizeName = "KB";
            int endPos = fileSizeStr.length() - 3;
            fileSize = fileSizeStr.substring(0, endPos) + "." + fileSizeStr.substring(endPos, endPos + 1) + endSizeName;
        } else if (fileLen < 1000000000L) {
            endSizeName = "MB";
            int endPos = fileSizeStr.length() - 6;
            fileSize = fileSizeStr.substring(0, endPos) + "." + fileSizeStr.substring(endPos, endPos + 1) + endSizeName;
        } else {
            endSizeName = "GB";
            int endPos = fileSizeStr.length() - 9;
            fileSize = fileSizeStr.substring(0, endPos) + "." + fileSizeStr.substring(endPos, endPos + 1) + endSizeName;
        }
        return fileSize;
    }

    public static List getAttach(Context ctx, String bizId) throws BOSException {
        ByteArrayInputStream[] stream = null;
        String[] fileNames = null;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(2);
        List atts = ArchiveUtils.getAttacheByBizID(ctx, bizId);
        if (atts != null) {
            int size = atts.size();
            fileNames = new String[size];
            stream = new ByteArrayInputStream[size];
            Iterator ite = atts.iterator();
            int i = 0;
            while (ite.hasNext()) {
                stream[i] = null;
                AttachmentInfo attInfo = (AttachmentInfo)ite.next();
                if (null != attInfo && null == attInfo.getFile()) {
                    try {
                        byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attInfo.getId().toString());
                        attInfo.setFile(files);
                    }
                    catch (BOSException e) {
                        logger.error((Object)("ArchiveUtils::getAttach()---downLoad attachmentInfo ,the id = " + attInfo.getId().toString() + " , is fail: "), (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (EASBizException e) {
                        logger.error((Object)("ArchiveUtils::getAttach()---downLoad attachmentInfo ,the id = " + attInfo.getId().toString() + " , is fail: "), (Throwable)e);
                        e.printStackTrace();
                    }
                }
                if (null != attInfo && null != attInfo.getFile()) {
                    stream[i] = new ByteArrayInputStream(attInfo.getFile());
                }
                fileNames[i] = attInfo.getName() + "." + attInfo.getSimpleName();
                ++i;
            }
        }
        dataList.add(stream);
        dataList.add(fileNames);
        return dataList;
    }

    public static List getAttacheByBizID(Context ctx, String seleID) throws BOSException {
        ArrayList<AttachmentInfo> atts = new ArrayList<AttachmentInfo>();
        IBoAttchAsso boAtt = null;
        Object info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("attachment.id"));
        selector.add(new SelectorItemInfo("attachment.file"));
        selector.add(new SelectorItemInfo("attachment.type"));
        selector.add(new SelectorItemInfo("attachment.sizeInByte"));
        selector.add(new SelectorItemInfo("attachment.size"));
        selector.add(new SelectorItemInfo("attachment.name"));
        selector.add(new SelectorItemInfo("attachment.simpleName"));
        ev.setSelector(selector);
        Object attachInfo = null;
        boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        cols = boAtt.getBoAttchAssoCollection(ev);
        int leng = cols.size();
        for (int i = 0; i < leng; ++i) {
            atts.add(cols.get(i).getAttachment());
        }
        return atts;
    }
}

