/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.dm.DocKnowLedgePortletCollection;
import com.kingdee.eas.cp.dm.DocKnowLedgePortletFactory;
import com.kingdee.eas.cp.dm.DocKnowLedgePortletInfo;
import com.kingdee.eas.cp.dm.DocKnowLedgeSettingCollection;
import com.kingdee.eas.cp.dm.DocKnowLedgeSettingFactory;
import com.kingdee.eas.cp.dm.DocKnowLedgeSettingInfo;
import com.kingdee.eas.cp.dm.IDocKnowLedgePortlet;
import com.kingdee.eas.cp.dm.IDocKnowLedgeSetting;
import com.kingdee.eas.cp.dm.service.DocKnowledgePortletDaoImpl;
import com.kingdee.eas.cp.dm.service.IDocKnowledgePortletService;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DocKnowledgePortletServiceImpl
implements IDocKnowledgePortletService {
    private Logger logger = Logger.getLogger((String)DocKnowledgePortletServiceImpl.class.getName());
    private static IDocKnowledgePortletService docKnowledgePortletServiceImpl = null;

    public static IDocKnowledgePortletService getInstance() {
        return null == docKnowledgePortletServiceImpl ? new DocKnowledgePortletServiceImpl() : docKnowledgePortletServiceImpl;
    }

    @Override
    public Map getDocKnowledgeSetting(String type, String personId, Context ctx) throws Exception {
        Map map = DocKnowledgePortletDaoImpl.getInstance().getDocKnowledgeSetting(type, personId, ctx);
        return map;
    }

    @Override
    public JSONObject getLatestArticle(int start, int limit, int maxCount, String operStr, String userId, String personId, String orgId, Context ctx) throws Exception {
        JSONObject data = new JSONObject();
        JSONArray records = new JSONArray();
        int totalCount = DocKnowledgePortletDaoImpl.getInstance().getLatestArticleCount(operStr, userId, personId, orgId, ctx);
        if (maxCount == 0) {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        } else if (maxCount == -1) {
            data.put("totalCount", 0);
            maxCount = 0;
        } else if (totalCount > maxCount) {
            data.put("totalCount", maxCount);
        } else {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        }
        IRowSet rowSet = DocKnowledgePortletDaoImpl.getInstance().getLatestArticle(start, limit, maxCount, operStr, userId, personId, orgId, ctx);
        if (rowSet != null) {
            String id = null;
            String title = null;
            String authorName = null;
            int readCount = 0;
            int commentCount = 0;
            Timestamp issueTime = null;
            while (rowSet.next()) {
                JSONObject object = new JSONObject();
                id = rowSet.getString("fid");
                title = rowSet.getString("ftitle");
                authorName = rowSet.getString("authorName");
                readCount = rowSet.getInt("FReadCount");
                commentCount = rowSet.getInt("fcommentCount");
                issueTime = rowSet.getTimestamp("FIssueTime");
                boolean isRead = DocKnowledgePortletDaoImpl.getInstance().isRead(ctx, userId, id);
                object.put("isRead", isRead);
                object.put("id", (Object)id);
                object.put("title", (Object)title);
                object.put("authorName", (Object)authorName);
                object.put("issueTime", (Object)issueTime);
                object.put("readCount", readCount);
                object.put("commentCount", commentCount);
                records.put((Object)object);
            }
        }
        data.put("records", (Object)records);
        return data;
    }

    @Override
    public JSONObject getHotspotRank(int start, int limit, int maxCount, String operStr, String userId, String personId, String orgId, Context ctx) throws Exception {
        JSONObject data = new JSONObject();
        JSONArray records = new JSONArray();
        int totalCount = DocKnowledgePortletDaoImpl.getInstance().getHotspotRankCount(operStr, userId, personId, orgId, ctx);
        if (maxCount == 0) {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        } else if (maxCount == -1) {
            data.put("totalCount", 0);
            maxCount = 0;
        } else if (totalCount > maxCount) {
            data.put("totalCount", maxCount);
        } else {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        }
        IRowSet rowSet = DocKnowledgePortletDaoImpl.getInstance().getHotspotRank(start, limit, maxCount, operStr, userId, personId, orgId, ctx);
        if (rowSet != null) {
            String id = null;
            String title = null;
            String authorName = null;
            int readCount = 0;
            int commentCount = 0;
            Timestamp issueTime = null;
            while (rowSet.next()) {
                JSONObject object = new JSONObject();
                id = rowSet.getString("fid");
                title = rowSet.getString("ftitle");
                authorName = rowSet.getString("authorName");
                readCount = rowSet.getInt("FReadCount");
                commentCount = rowSet.getInt("fcommentCount");
                issueTime = rowSet.getTimestamp("FIssueTime");
                object.put("id", (Object)id);
                object.put("title", (Object)title);
                object.put("authorName", (Object)authorName);
                object.put("issueTime", (Object)issueTime);
                object.put("readCount", readCount);
                object.put("commentCount", commentCount);
                records.put((Object)object);
            }
        }
        data.put("records", (Object)records);
        return data;
    }

    @Override
    public JSONObject getLatestReply(int start, int limit, int maxCount, String operStr, String userId, String personId, String orgId, Context ctx) throws Exception {
        JSONObject data = new JSONObject();
        JSONArray records = new JSONArray();
        int totalCount = DocKnowledgePortletDaoImpl.getInstance().getLatestReplyCount(operStr, userId, personId, orgId, ctx);
        if (maxCount == 0) {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        } else if (maxCount == -1) {
            data.put("totalCount", 0);
            maxCount = 0;
        } else if (totalCount > maxCount) {
            data.put("totalCount", maxCount);
        } else {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        }
        IRowSet rowSet = DocKnowledgePortletDaoImpl.getInstance().getLatestReply(start, limit, maxCount, operStr, userId, personId, orgId, ctx);
        if (rowSet != null) {
            String id = null;
            String title = null;
            String commentName = null;
            int commentCount = 0;
            Timestamp replyTime = null;
            boolean isAnonymity = false;
            while (rowSet.next()) {
                JSONObject object = new JSONObject();
                id = rowSet.getString("fid");
                title = rowSet.getString("ftitle");
                commentName = rowSet.getString("commentName");
                commentCount = rowSet.getInt("fcommentCount");
                replyTime = rowSet.getTimestamp("FcreateTime");
                isAnonymity = rowSet.getBoolean("fisanonymity");
                object.put("id", (Object)id);
                object.put("title", (Object)title);
                object.put("commentName", (Object)commentName);
                object.put("commentCount", commentCount);
                object.put("replyTime", (Object)replyTime);
                object.put("isAnonymity", isAnonymity);
                records.put((Object)object);
            }
        }
        data.put("records", (Object)records);
        return data;
    }

    @Override
    public JSONObject getCommendRank(int start, int limit, int maxCount, String operStr, String userId, String personId, String orgId, Context ctx) throws Exception {
        JSONObject data = new JSONObject();
        JSONArray records = new JSONArray();
        int totalCount = DocKnowledgePortletDaoImpl.getInstance().getCommendRankCount(operStr, userId, personId, orgId, ctx);
        if (maxCount == 0) {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        } else if (maxCount == -1) {
            data.put("totalCount", 0);
            maxCount = 0;
        } else if (totalCount > maxCount) {
            data.put("totalCount", maxCount);
        } else {
            data.put("totalCount", totalCount);
            maxCount = totalCount;
        }
        IRowSet rowSet = DocKnowledgePortletDaoImpl.getInstance().getCommendRank(start, limit, maxCount, operStr, userId, personId, orgId, ctx);
        if (rowSet != null) {
            String id = null;
            String title = null;
            String authorName = null;
            int readCount = 0;
            int commentCount = 0;
            int commendCount = 0;
            Timestamp issueTime = null;
            while (rowSet.next()) {
                JSONObject object = new JSONObject();
                id = rowSet.getString("fid");
                title = rowSet.getString("ftitle");
                authorName = rowSet.getString("authorName");
                readCount = rowSet.getInt("FReadCount");
                commentCount = rowSet.getInt("fcommentCount");
                commendCount = rowSet.getInt("frecommendCount");
                issueTime = rowSet.getTimestamp("FIssueTime");
                object.put("id", (Object)id);
                object.put("title", (Object)title);
                object.put("authorName", (Object)authorName);
                object.put("issueTime", (Object)issueTime);
                object.put("readCount", readCount);
                object.put("commentCount", commentCount);
                object.put("commendCount", commendCount);
                records.put((Object)object);
            }
        }
        data.put("records", (Object)records);
        return data;
    }

    @Override
    public JSONObject loadTreeNodeInfo(String portletNumber, Context ctx) throws Exception {
        JSONObject jsonObject = DocKnowledgePortletDaoImpl.getInstance().loadTreeNodeInfo(portletNumber, ctx);
        return jsonObject;
    }

    @Override
    public JSONObject getDocKnowLedgeList(String personId, Context ctx) throws Exception {
        JSONObject jsonObject = DocKnowledgePortletDaoImpl.getInstance().getDocKnowLedgeList(personId, ctx);
        return jsonObject;
    }

    @Override
    public JSONArray getDocKnowLedgeTreeList(String personId, Context ctx) throws Exception {
        JSONArray jsonArray = DocKnowledgePortletDaoImpl.getInstance().getDocKnowLedgeTreeList(personId, ctx);
        return jsonArray;
    }

    @Override
    public JSONArray getDocMyReceivedList(String personId, Context ctx, String lineNum) throws Exception {
        return DocKnowledgePortletDaoImpl.getInstance().getDocMyReceivedList(personId, ctx, lineNum);
    }

    @Override
    public int getDocMyReceivedCount(String personId, Context ctx) throws Exception {
        return DocKnowledgePortletDaoImpl.getInstance().getDocMyReceivedCount(personId, ctx);
    }

    @Override
    public int getDocMyBorrowedCount(String personId, Context ctx) throws Exception {
        return DocKnowledgePortletDaoImpl.getInstance().getDocMyBorrowedCount(personId, ctx);
    }

    @Override
    public JSONArray getDocMyBorrowedList(String personId, Context ctx, String lineNum) throws Exception {
        return DocKnowledgePortletDaoImpl.getInstance().getDocMyBorrowedList(personId, ctx, lineNum);
    }

    @Override
    public JSONArray getDocMyBookMarkList(String personId, Context ctx, String lineNum) throws Exception {
        return DocKnowledgePortletDaoImpl.getInstance().getDocMyBookMarkList(personId, ctx, lineNum);
    }

    @Override
    public int getDocMyBookMarkCount(String personId, Context ctx) throws Exception {
        return DocKnowledgePortletDaoImpl.getInstance().getDocMyBookMarkCount(personId, ctx);
    }

    @Override
    public DocKnowLedgePortletInfo synDocKnowledgePortletSetting(DocKnowLedgePortletInfo knowLedgePortletInfo, Context ctx) {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#synDocKnowledgePortletSetting _ !this.isExistPersonPortletSetting(ctx) :" + !this.isExistPersonPortletSetting(ctx)));
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#synDocKnowledgePortletSetting _ !CommonUtils.isCMAdmin(ctx) :" + !CommonUtils.isCMAdmin(ctx)));
        if (!this.isExistPersonPortletSetting(ctx) && !CommonUtils.isCMAdmin(ctx)) {
            try {
                DocKnowLedgeSettingCollection cols2;
                IDocKnowLedgePortlet idkp = DocKnowLedgePortletFactory.getLocalInstance(ctx);
                DocKnowLedgePortletCollection cols = idkp.getDocKnowLedgePortletCollection("where flag = 1 and state <> '02' and person is null");
                StringBuffer idStr = new StringBuffer();
                HashMap<BOSUuid, DocKnowLedgePortletInfo> idMap = new HashMap<BOSUuid, DocKnowLedgePortletInfo>();
                this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#synDocKnowledgePortletSetting.cols :" + (Object)((Object)cols)));
                if (null != cols && cols.size() > 0) {
                    DocKnowLedgePortletInfo setInfo = null;
                    String number = null;
                    int j = cols.size();
                    for (int i = 0; i < j; ++i) {
                        setInfo = cols.get(i);
                        number = setInfo.getPortletNumber();
                        if (null != knowLedgePortletInfo.get("parentNumber")) {
                            setInfo.put("parentNumber", knowLedgePortletInfo.get("parentNumber"));
                        }
                        if (knowLedgePortletInfo.getPortletNumber().equals(number)) {
                            knowLedgePortletInfo = setInfo;
                        }
                        idStr.append("'").append(setInfo.getId().toString()).append("',");
                        idMap.put(setInfo.getId(), setInfo);
                        BOSUuid bosUuid = BOSUuid.create((BOSObjectType)setInfo.getBOSType());
                        setInfo.setId(bosUuid);
                        setInfo.setPerson(personInfo);
                        setInfo.setFlag(false);
                        String currentTime = String.valueOf(System.currentTimeMillis()) + (int)(10000.0 * Math.random());
                        setInfo.setPortletNumber(currentTime);
                        setInfo.setPortletLongNumber("PN-" + currentTime);
                        idkp.addnew(setInfo);
                        if (null == knowLedgePortletInfo.get("parentNumber") || !((String)knowLedgePortletInfo.get("parentNumber")).equals(number)) continue;
                        knowLedgePortletInfo.put("parentNumber", number);
                    }
                }
                this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#synDocKnowledgePortletSetting.idStr :" + idStr));
                IDocKnowLedgeSetting idks = DocKnowLedgeSettingFactory.getLocalInstance(ctx);
                if (idStr.length() > 0 && null != (cols2 = idks.getDocKnowLedgeSettingCollection("where portlet in (" + idStr.toString().substring(0, idStr.toString().length() - 1) + ")")) && cols2.size() > 0) {
                    DocKnowLedgeSettingInfo setInfo = null;
                    int j = cols2.size();
                    for (int i = 0; i < j; ++i) {
                        setInfo = cols2.get(i);
                        setInfo.setPortlet((DocKnowLedgePortletInfo)idMap.get(setInfo.getPortlet().getId()));
                        setInfo.setId(BOSUuid.create((BOSObjectType)setInfo.getBOSType()));
                        idks.addnew(setInfo);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#synDocKnowledgePortletSetting.e :"), (Throwable)e);
                try {
                    DocKnowLedgePortletFactory.getLocalInstance(ctx).delete("where person = '" + personInfo.getId().toString() + "' and flag = 0 and state <> '02'");
                }
                catch (Exception deleteException) {
                    this.logger.error((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#synDocKnowledgePortletSetting.deleteException :" + deleteException));
                    deleteException.printStackTrace();
                }
                e.printStackTrace();
            }
        }
        return knowLedgePortletInfo;
    }

    @Override
    public boolean isExistPersonPortletSetting(Context ctx) {
        boolean hasPersonalSet = false;
        try {
            hasPersonalSet = DocKnowLedgePortletFactory.getLocalInstance(ctx).exists(" where person ='" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "' and flag = 0 and state <> '02'");
        }
        catch (Exception e) {
            this.logger.error((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#isExistPersonPortletSetting.e :"), (Throwable)e);
            e.printStackTrace();
        }
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#isExistPersonPortletSetting.hasPersonalSet :" + hasPersonalSet));
        return hasPersonalSet;
    }

    @Override
    public void updateDisplayOrder(String type, DocKnowLedgePortletInfo currentPortletInfo, DocKnowLedgePortletInfo parentPortletInfo, Context ctx) {
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#updateDisplayOrder.type :" + type));
        String updateSql = null;
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String sqlExt = null;
        sqlExt = null != personInfo && !CommonUtils.isCMAdmin(ctx) ? " and fpersonid='" + personInfo.getId().toString() + "' and fflag = 0 and fstate <> '02'" : "  and fflag = 1 and fstate <> '02'";
        String talbeName = "t_dm_docknowledgeportlet";
        try {
            IDocKnowLedgePortlet idkp = DocKnowLedgePortletFactory.getLocalInstance(ctx);
            this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#updateDisplayOrder _ currentPortletInfo.getDisplayOrder() :" + currentPortletInfo.getDisplayOrder()));
            this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#updateDisplayOrder _ parentPortletInfo.getDisplayOrder() :" + parentPortletInfo.getDisplayOrder()));
            if (currentPortletInfo.getDisplayOrder() > parentPortletInfo.getDisplayOrder()) {
                if (type.equals("above")) {
                    updateSql = "update " + talbeName + " set fdisplayOrder=fdisplayOrder+1 where fdisplayOrder>=" + parentPortletInfo.getDisplayOrder() + " and fdisplayOrder<" + currentPortletInfo.getDisplayOrder() + sqlExt;
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    currentPortletInfo.setDisplayOrder(parentPortletInfo.getDisplayOrder());
                    idkp.update((IObjectPK)new ObjectUuidPK(currentPortletInfo.getId()), currentPortletInfo);
                } else if (type.equals("below")) {
                    updateSql = "update " + talbeName + " set fdisplayOrder=fdisplayOrder+1 where fdisplayOrder>=" + (parentPortletInfo.getDisplayOrder() + 1) + " and fdisplayOrder<" + currentPortletInfo.getDisplayOrder() + sqlExt;
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    currentPortletInfo.setDisplayOrder(parentPortletInfo.getDisplayOrder() + 1);
                    idkp.update((IObjectPK)new ObjectUuidPK(currentPortletInfo.getId()), currentPortletInfo);
                }
            } else if (type.equals("above")) {
                updateSql = "update " + talbeName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentPortletInfo.getDisplayOrder() + " and fdisplayOrder<" + parentPortletInfo.getDisplayOrder() + sqlExt;
                DbUtil.execute((Context)ctx, (String)updateSql);
                currentPortletInfo.setDisplayOrder(parentPortletInfo.getDisplayOrder() - 1);
                idkp.update((IObjectPK)new ObjectUuidPK(currentPortletInfo.getId()), currentPortletInfo);
            } else if (type.equals("below")) {
                updateSql = "update " + talbeName + " set fdisplayOrder=fdisplayOrder-1 where fdisplayOrder>" + currentPortletInfo.getDisplayOrder() + " and fdisplayOrder<=" + parentPortletInfo.getDisplayOrder() + sqlExt;
                DbUtil.execute((Context)ctx, (String)updateSql);
                currentPortletInfo.setDisplayOrder(parentPortletInfo.getDisplayOrder());
                idkp.update((IObjectPK)new ObjectUuidPK(currentPortletInfo.getId()), currentPortletInfo);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgePortletServiceImpl#updateDisplayOrder.e :"), (Throwable)e);
            e.printStackTrace();
        }
    }

    @Override
    public void updatePortletStateByType(Context ctx, String state, String type) throws Exception {
        DocKnowledgePortletDaoImpl.getInstance().updatePortletStateByType(ctx, state, type);
    }
}

