/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class MessageCenterService {
    public static void sendMessage(Context ctx, PersonInfo personInfo, String titleStr, String senderName, String bodyStr, String billID) throws BOSException, EASBizException {
        ArrayList<PersonInfo> personColl = new ArrayList<PersonInfo>();
        personColl.add(personInfo);
        MessageCenterService.sendMessage(ctx, personColl, titleStr, senderName, bodyStr, billID);
    }

    public static void sendMessage(Context ctx, Collection personColl, String titleStr, String senderName, String bodyStr, String billID) throws BOSException, EASBizException {
        if (personColl == null || personColl.isEmpty()) {
            return;
        }
        List userIdList = MessageCenterService.getUserIdList(ctx, personColl);
        if (!userIdList.isEmpty()) {
            MessageCenterService.sendMessage(ctx, userIdList.toArray(new String[userIdList.size()]), titleStr, senderName, bodyStr, billID);
        }
    }

    public static List getUserIdList(Context ctx, Collection personColl) throws BOSException, EASBizException {
        ArrayList<String> userIdList = new ArrayList<String>();
        Set set = MessageCenterService.getPersonIdSet(personColl);
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() != 0) {
            Iterator iter = uc.iterator();
            for (int i = 0; i < uc.size(); ++i) {
                String userId = uc.get(i).getId().toString();
                if (userId == null) continue;
                userIdList.add(userId);
            }
        }
        return userIdList;
    }

    public static void sendMessage(Context ctx, String[] ids, String titleStr, String senderName, String bodyStr, String billID) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = MessageCenterService.getContextLocales(ctx);
        Locale locale2 = null;
        if (ids == null || ids.length == 0) {
            return;
        }
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (StringUtils.isEmpty((String)ids[i])) continue;
            Message message = MessageFactory.newMessage((String)"kingdee.workflow");
            for (Locale locale2 : lcla) {
                message.setLocaleStringHeader("title", titleStr, locale2);
                message.setLocaleStringHeader("sender", senderName, locale2);
                if (bodyStr == null) {
                    if (billID != null) {
                        message.setLocaleStringHeader("body", billID, locale2);
                        continue;
                    }
                    message.setLocaleStringHeader("body", titleStr, locale2);
                    continue;
                }
                message.setLocaleStringHeader("body", bodyStr, locale2);
            }
            message.setIntHeader("type", 0);
            message.setIntHeader("bizType", 20);
            message.setIntHeader("sourceStatus", 0);
            message.setIntHeader("priority", 10);
            message.setStringHeader("databaseCenter", ctx.getAIS());
            message.setStringHeader("solution", ctx.getSolution());
            message.setStringHeader("bizPackage", "com.kingdee.eas.cp.dm.app");
            message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.dm.app");
            message.setStringHeader("sourceID", "");
            String billURL = "/plt_cp/document/viewDocument.action?docId=" + billID;
            StringBuffer sourceIdsSB = new StringBuffer("CPOVMSG::billPassURL:null;billURL:");
            sourceIdsSB.append(billURL);
            sourceIdsSB.append(";billID:");
            sourceIdsSB.append(billID);
            message.setStringHeader("sourceIDs", sourceIdsSB.toString());
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public static Set getPersonIdSet(Collection personList) {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person2 = null;
        for (PersonInfo person2 : personList) {
            set.add(person2.getId().toString());
        }
        return set;
    }
}

