/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.utils;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.facade.portal.common.context.SimplePortalContext;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import java.util.List;

public class NewPortalUtil {
    private static String DM_CATEGORYID = "fb576e97-7bc1-4120-a8f3-1c7aed25a37d";

    public static PortletDefinition createPortletDefinition(Context ctx, String name, String columnName, String columnID, String descr) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletParam para = NewPortalUtil.builtPortletParam(name, columnName, columnID, descr);
        String portletName = "DMCategoryPortlet";
        PortletDefinition poreletDef = portletDefinitionServiceFacade.createPortletDefinition(simCtx, "plt_cp", portletName, para);
        return poreletDef;
    }

    public static void updatePortletDefinition(Context ctx, String name, String portletDefinitionId, String columnName, String columnID, String descr) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletParam para = NewPortalUtil.builtPortletParam(name, columnName, columnID, descr);
        portletDefinitionServiceFacade.updatePortletDefinition(simCtx, portletDefinitionId, para);
    }

    public static List findPortletDefinitionList(Context ctx, String columnName) throws PortalBizException {
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        DisplayName displayName = new DisplayName(columnName);
        String portletName = "DMCategoryPortlet";
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        List list = portletDefinitionServiceFacade.findPortletDefinitionList(simCtx, "plt_cp", portletName, displayName);
        return list;
    }

    public static PortletDefinition findPortletDefinitionById(Context ctx, String portletDefinitionId) throws PortalBizException {
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        PortletDefinition poreletDef = portletDefinitionServiceFacade.findPortletDefinitionById(simCtx, portletDefinitionId);
        return poreletDef;
    }

    public static void deletePortletDefinitionById(Context ctx, String portletDefinitionId) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        portletDefinitionServiceFacade.deletePortletDefinitionById(simCtx, portletDefinitionId);
    }

    public static void enablePortletDefinitionById(Context ctx, String portletDefinitionId) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletParam para = NewPortalUtil.buildPortletStateParam(StatusEnum.ENABLE);
        portletDefinitionServiceFacade.updatePortletDefinition(simCtx, portletDefinitionId, para);
    }

    public static void unablePortletDefinitionById(Context ctx, String portletDefinitionId) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletParam para = NewPortalUtil.buildPortletStateParam(StatusEnum.DISABLE);
        portletDefinitionServiceFacade.updatePortletDefinition(simCtx, portletDefinitionId, para);
    }

    private static PortletParam builtPortletParam(String name, String columnName, String columnID, String descr) {
        PortletParam para = new PortletParam();
        DisplayName displayName = new DisplayName(columnName);
        para.setDisplayName(displayName);
        Preferences preferences = new Preferences();
        Preference idPre = new Preference("categoryId", columnID);
        Preference namePre = new Preference("portletName", name);
        preferences.addPreference(idPre);
        preferences.addPreference(namePre);
        para.setPreferences(preferences);
        Description description = new Description(descr);
        para.setDescription(description);
        para.setCategoryId(DM_CATEGORYID);
        return para;
    }

    private static SimplePortalContext builtSimplePortalContext(Context ctx) {
        SimplePortalContext simCtx = new SimplePortalContext();
        simCtx.setUserId(ctx.getCaller().toString());
        simCtx.setUserCode(ctx.getUserName());
        simCtx.setDataCenter(ctx.getAIS());
        return simCtx;
    }

    private static PortletParam buildPortletStateParam(StatusEnum status) {
        PortletParam para = new PortletParam();
        para.setStatus(status);
        return para;
    }
}

