/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.cp.base.web.WebMenuUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.dm.AbstractDocKnowLedgePortletInfo;
import com.kingdee.eas.cp.dm.DocKnowLedgePortletFactory;
import com.kingdee.eas.cp.dm.DocKnowLedgePortletInfo;
import com.kingdee.eas.cp.dm.DocKnowLedgePortletStateEnum;
import com.kingdee.eas.cp.dm.DocKnowLedgeSettingFactory;
import com.kingdee.eas.cp.dm.DocKnowLedgeSettingInfo;
import com.kingdee.eas.cp.dm.IDocKnowLedgePortlet;
import com.kingdee.eas.cp.dm.service.DocKnowledgePortletServiceImpl;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class DocKnowledgeSettingAction
extends DispatchAction {
    private Logger logger = Logger.getLogger((String)DocKnowledgeSettingAction.class.getName());

    public ActionForward getDocKnowledgeSetting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String type = request.getParameter("type");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String userId = CommonUtils.getCurrentUserId(request);
        String personId = CommonUtils.getCurrentPersonId(request);
        JSONObject jsonObject = new JSONObject();
        String resultMsg = null;
        try {
            Map map = DocKnowledgePortletServiceImpl.getInstance().getDocKnowledgeSetting(type, personId, ctx);
            if (map != null && !map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    String key = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    jsonObject.put(key, (Object)value);
                }
            }
            resultMsg = WebMenuUtil.getSuccessMsg((String[])new String[]{jsonObject.toString()});
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            resultMsg = WebMenuUtil.getErrorMsg((String[])new String[]{jsonObject.toString()});
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgeSettingAction#getDocKnowledgeSetting.resultMsg : " + resultMsg));
        return null;
    }

    public ActionForward loadTreeNodeInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String portletNumber = request.getParameter("portletNumber");
        if (StringUtils.isBlank((String)portletNumber)) {
            return null;
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        JSONObject jsonObject = DocKnowledgePortletServiceImpl.getInstance().loadTreeNodeInfo(portletNumber, ctx);
        String resultMsg = jsonObject.toString();
        response.setContentType("text/json;charset=utf-8");
        response.getWriter().write(resultMsg);
        response.getWriter().flush();
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgeSettingAction#loadTreeNodeInfo.resultMsg : " + resultMsg));
        return null;
    }

    public ActionForward enablePortletMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updatePortletMenu(mapping, form, request, response, DocKnowLedgePortletStateEnum.ENABLE);
        return null;
    }

    public ActionForward disablePortletMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updatePortletMenu(mapping, form, request, response, DocKnowLedgePortletStateEnum.DISABLE);
        return null;
    }

    public ActionForward deletePortletMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.updatePortletMenu(mapping, form, request, response, DocKnowLedgePortletStateEnum.DELETED);
        return null;
    }

    public ActionForward dragDropTreeNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String type = request.getParameter("type");
        if (null == request.getParameter("currentRootId") || null == request.getParameter("parentRootId")) {
            this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "@@@" + request.getParameter("currentRootId")));
            this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "@@@" + request.getParameter("parentRootId")));
            return null;
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        AbstractDocKnowLedgePortletInfo docKnowLedgePortletInfo = null;
        String operMsg = null;
        String resultMsg = null;
        try {
            IDocKnowLedgePortlet idkp = DocKnowLedgePortletFactory.getLocalInstance(ctx);
            docKnowLedgePortletInfo = (DocKnowLedgePortletInfo)idkp.getValue(" where portletnumber ='" + request.getParameter("currentRootId") + "'");
            docKnowLedgePortletInfo.put("parentNumber", request.getParameter("parentRootId"));
            docKnowLedgePortletInfo = DocKnowledgePortletServiceImpl.getInstance().synDocKnowledgePortletSetting((DocKnowLedgePortletInfo)docKnowLedgePortletInfo, ctx);
            DocKnowLedgePortletInfo parentPortletInfo = idkp.getDocKnowLedgePortletInfo("where portletnumber = '" + docKnowLedgePortletInfo.get("parentNumber") + "'");
            DocKnowledgePortletServiceImpl.getInstance().updateDisplayOrder(type, (DocKnowLedgePortletInfo)docKnowLedgePortletInfo, parentPortletInfo, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        operMsg = "/root/" + docKnowLedgePortletInfo.getPortletNumber();
        resultMsg = WebMenuUtil.getSuccessMsg((String[])new String[]{operMsg});
        response.setContentType("text/json;charset=utf-8");
        response.getWriter().write(resultMsg);
        response.getWriter().flush();
        return null;
    }

    public ActionForward savePortletMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String userId = CommonUtils.getCurrentUserId(request);
        String personId = CommonUtils.getCurrentPersonId(request);
        String portletNumber = request.getParameter("portletNumber");
        String flagStr = request.getParameter("flag");
        boolean flag = false;
        if (StringUtils.equals((String)"true", (String)flagStr)) {
            flag = true;
        }
        String lineNumStr = request.getParameter("lineNum");
        String isNewLineStr = request.getParameter("isNewLine");
        String isReadCountStr = request.getParameter("isReadCount");
        String isReplyCountStr = request.getParameter("isReplyCount");
        String isDateStr = request.getParameter("isDate");
        String isAuthorStr = request.getParameter("isAuthor");
        String isCommendCountStr = request.getParameter("isCommendCount");
        int lineNum = 10;
        if (StringUtils.isNotBlank((String)lineNumStr)) {
            lineNum = Integer.parseInt(lineNumStr);
        }
        boolean isNewLine = false;
        boolean isReadCount = false;
        boolean isReplyCount = false;
        boolean isDate = false;
        boolean isAuthor = false;
        boolean isCommendCount = false;
        if (StringUtils.isNotBlank((String)isNewLineStr)) {
            isNewLine = true;
        }
        if (StringUtils.isNotBlank((String)isReadCountStr)) {
            isReadCount = true;
        }
        if (StringUtils.isNotBlank((String)isReplyCountStr)) {
            isReplyCount = true;
        }
        if (StringUtils.isNotBlank((String)isDateStr)) {
            isDate = true;
        }
        if (StringUtils.isNotBlank((String)isAuthorStr)) {
            isAuthor = true;
        }
        if (StringUtils.isNotBlank((String)isCommendCountStr)) {
            isCommendCount = true;
        }
        String operMsg = null;
        String resultMsg = null;
        try {
            if (CommonUtils.isCMAdmin(ctx)) {
                DocKnowLedgePortletInfo docKnowLedgePortletInfo = (DocKnowLedgePortletInfo)DocKnowLedgePortletFactory.getLocalInstance(ctx).getValue(" where portletnumber ='" + portletNumber + "'");
                String id = docKnowLedgePortletInfo.getId().toString();
                DocKnowLedgeSettingInfo docKnowLedgeSettingInfo = (DocKnowLedgeSettingInfo)DocKnowLedgeSettingFactory.getLocalInstance(ctx).getValue("where portlet = '" + id + "'");
                docKnowLedgeSettingInfo.setLineNum(lineNum);
                docKnowLedgeSettingInfo.setIsNewLine(isNewLine);
                docKnowLedgeSettingInfo.setIsReadCount(isReadCount);
                docKnowLedgeSettingInfo.setIsReplyCount(isReplyCount);
                docKnowLedgeSettingInfo.setIsDate(isDate);
                docKnowLedgeSettingInfo.setIsAuthor(isAuthor);
                docKnowLedgeSettingInfo.setIsCommendCount(isCommendCount);
                DocKnowLedgeSettingFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(docKnowLedgeSettingInfo.getId()), docKnowLedgeSettingInfo);
            } else {
                DocKnowLedgePortletInfo docKnowLedgePortletInfo = (DocKnowLedgePortletInfo)DocKnowLedgePortletFactory.getLocalInstance(ctx).getValue(" where portletnumber ='" + portletNumber + "'");
                docKnowLedgePortletInfo = DocKnowledgePortletServiceImpl.getInstance().synDocKnowledgePortletSetting(docKnowLedgePortletInfo, ctx);
                DocKnowLedgeSettingInfo settingInfo = (DocKnowLedgeSettingInfo)DocKnowLedgeSettingFactory.getLocalInstance(ctx).getValue("where portlet = '" + docKnowLedgePortletInfo.getId().toString() + "'");
                portletNumber = docKnowLedgePortletInfo.getPortletNumber();
                settingInfo.setLineNum(lineNum);
                settingInfo.setIsNewLine(isNewLine);
                settingInfo.setIsReadCount(isReadCount);
                settingInfo.setIsReplyCount(isReplyCount);
                settingInfo.setIsDate(isDate);
                settingInfo.setIsAuthor(isAuthor);
                settingInfo.setIsCommendCount(isCommendCount);
                settingInfo.setPortlet(docKnowLedgePortletInfo);
                DocKnowLedgeSettingFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(settingInfo.getId()), settingInfo);
            }
            operMsg = "/root/" + portletNumber;
            resultMsg = WebMenuUtil.getSuccessMsg((String[])new String[]{operMsg});
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            operMsg = "/root/" + portletNumber;
            resultMsg = WebMenuUtil.getErrorMsg((String[])new String[]{operMsg});
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
            e.printStackTrace();
        }
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgeSettingAction#updatePortletMenu.resultMsg : " + resultMsg));
        return null;
    }

    private void updatePortletMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, DocKnowLedgePortletStateEnum state) throws Exception {
        String operMsg = null;
        String personId = CommonUtils.getCurrentPersonId(request);
        String portletNumber = request.getParameter("portletNumber");
        String type = request.getParameter("type");
        String resultMsg = null;
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            DocKnowledgePortletServiceImpl.getInstance().updatePortletStateByType(ctx, state.getValue(), type);
            PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
            PortalServiceFacadeFactory.getLocalInstance((Context)ctx).refreshPortletCache();
            operMsg = StringUtils.equals((String)"02", (String)state.getValue()) ? "1" : "/root/" + portletNumber;
            resultMsg = WebMenuUtil.getSuccessMsg((String[])new String[]{operMsg});
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            operMsg = StringUtils.equals((String)"02", (String)state.getValue()) ? "2" : "/root/" + portletNumber;
            resultMsg = WebMenuUtil.getErrorMsg((String[])new String[]{operMsg});
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
            e.printStackTrace();
        }
        this.logger.info((Object)(CommonUtils.formatDate2String(new Date(), null) + "DocKnowledgeSettingAction#updatePortletMenu.resultMsg : " + resultMsg));
    }
}

