/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.cp.dm.DimensionFactory;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DocumentDimensionCollection;
import com.kingdee.eas.cp.dm.DocumentDimensionFactory;
import com.kingdee.eas.cp.dm.DocumentDimensionInfo;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.cp.dm.web.service.DefaultDmPermissionService;
import com.kingdee.eas.cp.dm.web.service.IDmPermissionService;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DimListHelper {
    protected static DimListHelper instance = new DimListHelper();

    protected DimListHelper() {
    }

    public static DimListHelper getInstance() {
        return instance;
    }

    public static List<String> getOperBtnItems(Context ctx, String dimensionId, String lv1DimId) {
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> perMissionSet = new HashSet<String>();
        ArrayList<String> lv1DimList = new ArrayList<String>();
        lv1DimList.add(lv1DimId);
        perMissionSet.add("12");
        Map<Object, Object> permssionMap = new HashMap();
        try {
            permssionMap = PermissionUtil.getHasPermDimIdMap(ctx, perMissionSet, new HashSet<String>(lv1DimList), "t_dm_dimension");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Set perssionSet = new HashSet();
        if (permssionMap != null && permssionMap.size() > 0) {
            perssionSet = (Set)permssionMap.get(lv1DimId);
        }
        if (perssionSet.contains(dimensionId)) {
            list.add("copyDoc");
            list.add("moveDoc");
            list.add("delDoc");
        }
        return list;
    }

    public static Set<String> getPermSetByLv1Dim(Context ctx, String dimensionId, String lv1DimId) {
        HashSet<String> perMissionSet = new HashSet<String>();
        ArrayList<String> lv1DimList = new ArrayList<String>();
        lv1DimList.add(lv1DimId);
        perMissionSet.add("12");
        Map<Object, Object> permssionMap = new HashMap();
        try {
            permssionMap = PermissionUtil.getHasPermDimIdMap(ctx, perMissionSet, new HashSet<String>(lv1DimList), "t_dm_dimension");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        Set<String> perssionSet = new HashSet<String>();
        if (permssionMap != null && permssionMap.size() > 0) {
            perssionSet = (Set)permssionMap.get(lv1DimId);
        }
        return perssionSet;
    }

    public FilterInfo buildTreeFilterSelectDimension(Context ctx, String id) {
        FilterInfo filterInfo = new FilterInfo();
        try {
            DimensionInfo dimInfo = (DimensionInfo)DimensionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(id));
            return this.buildTreeFilterSelectDimension(ctx, id, dimInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return filterInfo;
        }
    }

    public FilterInfo buildTreeFilterSelectDimension(Context ctx, String id, DimensionInfo dimInfo) {
        FilterInfo filterInfo = new FilterInfo();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        try {
            DocumentDimensionCollection ddCols = null;
            ddCols = dimInfo.getLevel() > 1 ? DocumentDimensionFactory.getLocalInstance(ctx).getDocumentDimensionCollection("select parent.id where dimension.id = '" + dimInfo.getId().toString() + "'") : DocumentDimensionFactory.getLocalInstance(ctx).getDocumentDimensionCollection("select parent.id where dimension.lv1dimension.id = '" + dimInfo.getId().toString() + "'");
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ddCols.size(); ++i) {
                DocumentDimensionInfo ddinfo = ddCols.get(i);
                set.add(ddinfo.getParent().getId().toString());
            }
            if (set.size() > 0) {
                String dataPermSql = this.getDmPermissionService().getHasPermDocIdSql(ctx, perId, userId);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)dataPermSql);
                HashSet<String> hasPermset = new HashSet<String>();
                try {
                    while (rs.next()) {
                        String docId = rs.getString("fid");
                        if (null == docId || "".equals(docId) || !set.contains(docId)) continue;
                        hasPermset.add(docId);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (hasPermset.size() > 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", hasPermset, CompareType.INCLUDE));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.INCLUDE));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("wfstate", (Object)3));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.INCLUDE));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public FilterInfo buildTreeFilterSelectDimension(Context ctx, Set lv1DimIdSet) {
        FilterInfo filterInfo = new FilterInfo();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        try {
            DocumentDimensionCollection ddCols = DocumentDimensionFactory.getLocalInstance(ctx).getDocumentDimensionCollection("select parent.id where dimension.lv1dimension.id in " + CommonUtils.getStrFromSet(lv1DimIdSet));
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < ddCols.size(); ++i) {
                DocumentDimensionInfo ddinfo = ddCols.get(i);
                set.add(ddinfo.getParent().getId().toString());
            }
            if (set.size() > 0) {
                String dataPermSql = this.getDmPermissionService().getHasPermDocIdSql(ctx, perId, userId);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)dataPermSql);
                HashSet<String> hasPermset = new HashSet<String>();
                try {
                    while (rs.next()) {
                        String docId = rs.getString("doc.fid");
                        if (null == docId || "".equals(docId)) continue;
                        hasPermset.add(docId);
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (hasPermset.size() > 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", hasPermset, CompareType.INCLUDE));
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.INCLUDE));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public SorterItemInfo getSorterItemInfo(int type) {
        SorterItemInfo sortInfo = new SorterItemInfo();
        switch (type) {
            case 0: {
                sortInfo.setPropertyName("issueTime");
                sortInfo.setSortType(SortType.DESCEND);
                break;
            }
            case 1: {
                sortInfo.setPropertyName("issueTime");
                sortInfo.setSortType(SortType.ASCEND);
                break;
            }
            case 2: {
                sortInfo.setPropertyName("commentCount");
                sortInfo.setSortType(SortType.DESCEND);
                break;
            }
            case 6: {
                sortInfo.setPropertyName("commentCount");
                sortInfo.setSortType(SortType.ASCEND);
                break;
            }
            case 3: {
                sortInfo.setPropertyName("readCount");
                sortInfo.setSortType(SortType.DESCEND);
                break;
            }
            case 7: {
                sortInfo.setPropertyName("readCount");
                sortInfo.setSortType(SortType.ASCEND);
                break;
            }
        }
        return sortInfo;
    }

    protected IDmPermissionService getDmPermissionService() {
        return DefaultDmPermissionService.getInstance();
    }
}

