/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.ArchiveModuleFactory;
import com.kingdee.eas.cp.dm.ArchiveModuleInfo;
import com.kingdee.eas.cp.dm.DocTemplateCollection;
import com.kingdee.eas.cp.dm.DocTemplateFactory;
import com.kingdee.eas.cp.dm.DocTemplateInfo;
import com.kingdee.eas.cp.dm.DocTemplateTypeCollection;
import com.kingdee.eas.cp.dm.DocTemplateTypeFactory;
import com.kingdee.eas.cp.dm.DocTemplateTypeInfo;
import com.kingdee.eas.cp.dm.web.dto.AllowModuleDTO;
import com.kingdee.eas.cp.dm.web.dto.LabelInfoDTO;
import com.kingdee.eas.cp.dm.web.dto.TemplateInfoDTO;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DMCommonService {
    protected static DMCommonService instance = new DMCommonService();

    protected DMCommonService() {
    }

    public static DMCommonService getInstance() {
        return instance;
    }

    public List<LabelInfoDTO> getLabelList(Context ctx, String searchKey) throws Exception {
        IRowSet rowSet;
        ArrayList<LabelInfoDTO> lbList = new ArrayList<LabelInfoDTO>();
        String sql = "select fid,fname_" + ctx.getLocale() + " as name from T_DM_Tag where fstate = 1 ";
        if (!StringUtil.isEmpty((String)searchKey)) {
            sql = sql + " and fname_" + ctx.getLocale() + " like '%" + searchKey + "%'";
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + " order by fcreatetime desc"))) != null) {
            while (rowSet.next()) {
                LabelInfoDTO lb = new LabelInfoDTO();
                lb.setId(rowSet.getString("fid"));
                lb.setLbName(rowSet.getString("name"));
                lb.setLeftFlag(1);
                lbList.add(lb);
            }
        }
        return lbList;
    }

    public List<AllowModuleDTO> getAllowModuleList(Context ctx) throws Exception {
        ArrayList<AllowModuleDTO> moduleList = new ArrayList<AllowModuleDTO>();
        Iterator ac = ArchiveModuleFactory.getLocalInstance(ctx).getCollection().iterator();
        if (ac != null) {
            while (ac.hasNext()) {
                ArchiveModuleInfo module = (ArchiveModuleInfo)ac.next();
                AllowModuleDTO am = new AllowModuleDTO();
                am.setId(module.getId().toString());
                am.setName(module.getName());
                am.setNumber(module.getNumber());
                am.setState(module.getState().toString());
                am.setDisplayOrder(module.getDisplayOrder());
                am.setIsCp(module.getIsCp().toString());
                moduleList.add(am);
            }
        }
        return moduleList;
    }

    public List<TemplateInfoDTO> getTemplateList(Context ctx, String type, String id, String templateType) throws Exception {
        List<Object> tiList = new ArrayList();
        if ("root".equals(type)) {
            tiList = this.getTemplateTypeTreeData(ctx, type);
        } else {
            type = templateType;
            tiList = this.getDocTemplateTreeData(ctx, type, id);
        }
        return tiList;
    }

    private List<TemplateInfoDTO> getTemplateTypeTreeData(Context ctx, String type) throws Exception {
        ArrayList<TemplateInfoDTO> tiList = new ArrayList<TemplateInfoDTO>();
        StringBuilder oql = this.getTemplateTypeOqlStr(ctx);
        DocTemplateTypeCollection docTempTypeCol = DocTemplateTypeFactory.getLocalInstance(ctx).getDocTemplateTypeCollection(oql.toString());
        for (int i = 0; i < docTempTypeCol.size(); ++i) {
            DocTemplateTypeInfo docTemplateTypeInfo = docTempTypeCol.get(i);
            TemplateInfoDTO ti = new TemplateInfoDTO();
            ti.setId(docTemplateTypeInfo.getId().toString());
            ti.setName(docTemplateTypeInfo.getName());
            ti.setType("category");
            ti.setIcon("");
            ti.setIsParent("true");
            ti.setpId("root");
            tiList.add(ti);
        }
        return tiList;
    }

    private StringBuilder getTemplateTypeOqlStr(Context ctx) {
        StringBuilder oql = new StringBuilder("select id,name,number,state,index where ");
        oql.append("state = 'ENABLE' ");
        oql.append("and cu.id = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "' ");
        oql.append("order by index");
        return oql;
    }

    private List<TemplateInfoDTO> getDocTemplateTreeData(Context ctx, String type, String tempTypeId) throws Exception {
        ArrayList<TemplateInfoDTO> tiList = new ArrayList<TemplateInfoDTO>();
        StringBuilder oql = this.getDocTemplateOqlStr(ctx, type, tempTypeId);
        DocTemplateCollection docTempCol = DocTemplateFactory.getLocalInstance(ctx).getDocTemplateCollection(oql.toString());
        for (int i = 0; i < docTempCol.size(); ++i) {
            DocTemplateInfo docTemplateInfo = docTempCol.get(i);
            TemplateInfoDTO ti = new TemplateInfoDTO();
            ti.setId(docTemplateInfo.getId().toString());
            ti.setName(docTemplateInfo.getName());
            ti.setType(docTemplateInfo.getType().toString());
            ti.setIcon("");
            ti.setpId(tempTypeId);
            String bodyContent = null;
            ti.setContent(bodyContent);
            tiList.add(ti);
        }
        return tiList;
    }

    private AttachmentInfo getAttacheByBizID(Context ctx, String seleID) {
        AttachmentInfo attachInfo = null;
        try {
            BOSUuid attachID = this.getAttachBOSId(ctx, seleID);
            attachInfo = (AttachmentInfo)AttachmentFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(attachID));
            if (attachInfo.getFile() == null) {
                byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attachID.toString());
                attachInfo.setFile(files);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return attachInfo;
    }

    private BOSUuid getAttachBOSId(Context ctx, String seleID) {
        BOSUuid attachID = null;
        IBoAttchAsso boAtt = null;
        BoAttchAssoInfo info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        try {
            boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            cols = boAtt.getBoAttchAssoCollection(ev);
            if (cols != null && cols.size() > 0) {
                info = cols.get(0);
            }
            if (info == null) {
                return null;
            }
            attachID = info.getAttachment().getId();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachID;
    }

    private StringBuilder getDocTemplateOqlStr(Context ctx, String type, String tempTypeId) {
        StringBuilder oql = new StringBuilder("select id,name,number,state ,type where ");
        oql.append("state = 'ENABLE' and tempType = '" + tempTypeId + "'");
        if (!(type == null || type.equals("1") || type.equals("2") || type.equals("3"))) {
            type = null;
        }
        if (type != null && !"".equals(type)) {
            oql.append(" and type = '" + type + "'");
        }
        oql.append(" and cu.id = '" + ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() + "'");
        return oql;
    }
}

