/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.DocumentReadNoteInfo;
import com.kingdee.eas.cp.dm.web.dto.DocBorrowHistoryDTO;
import com.kingdee.eas.cp.dm.web.dto.DocDistributeHistoryDTO;
import com.kingdee.eas.cp.dm.web.dto.DocReadHistoryDTO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DMContentOperService {
    private static final Logger logger = Logger.getLogger(DMContentOperService.class);
    protected static DMContentOperService instance = new DMContentOperService();

    protected DMContentOperService() {
    }

    public static DMContentOperService getInstance() {
        return instance;
    }

    public PagingResult<DocDistributeHistoryDTO> listDocDistributeHistory(Context ctx, DocDistributeHistoryDTO param, PagingParam pagingParam) throws Exception {
        String sql;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app.DocDistributeHistoryQuery");
        FilterInfo filter = new FilterInfo();
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        PagingResult pagingResult = new PagingResult();
        filter.getFilterItems().add(new FilterItemInfo("sourceDoc.id", (Object)param.getSourceDoc(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
        String countSql = sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") > 0) {
            countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
            total = countRowSet.getInt(1);
        }
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<DocDistributeHistoryDTO> list = new ArrayList<DocDistributeHistoryDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                DocDistributeHistoryDTO ct = new DocDistributeHistoryDTO();
                String createTime = rowSet.getString("createTime");
                ct.setCreateTime(createTime.substring(0, 16));
                ct.setSourceDoc(rowSet.getString("sourceDoc.id"));
                ct.setCreator(rowSet.getString("creator.name"));
                ct.setColumnId(rowSet.getString("targetCat.id"));
                ct.setColumnName(rowSet.getString("targetCat.name"));
                ct.setDistributeCount(rowSet.getString("distributeCount"));
                ct.setDocArea(rowSet.getString("docArea.name"));
                list.add(ct);
            }
        }
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    public PagingResult<DocReadHistoryDTO> listDocReadHistory(Context ctx, DocReadHistoryDTO param, PagingParam pagingParam) throws Exception {
        String sql;
        PagingResult pagingResult = new PagingResult();
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app.DocumentReadQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("READDOCUMENT.ID", (Object)param.getDocumentId(), CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)param.getShowSub()) && !StringUtils.isEmpty((String)param.getCUNumber())) {
            if (param.getShowSub().equals("true")) {
                filter.getFilterItems().add(new FilterItemInfo("CU.longNumber", (Object)("%" + param.getCUNumber() + "%"), CompareType.LIKE));
            } else if (param.getShowSub().equals("false")) {
                filter.getFilterItems().add(new FilterItemInfo("CU.number", (Object)param.getCUNumber(), CompareType.EQUALS));
            }
        }
        entityViewInfo.setFilter(filter);
        exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
        String countSql = sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") > 0) {
            countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
            total = countRowSet.getInt(1);
        }
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<DocReadHistoryDTO> list = new ArrayList<DocReadHistoryDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                DocReadHistoryDTO ct = new DocReadHistoryDTO();
                ct.setReaderId(rowSet.getString("reader.id"));
                ct.setReaderName(rowSet.getString("reader.name"));
                ct.setCUName(rowSet.getString("CU.name"));
                ct.setReadCount(String.valueOf(rowSet.getInt("readDocument.readCount")));
                ct.setCUNumber(rowSet.getString("CU.number"));
                ct.setCreatorNumber(rowSet.getString("creator.number"));
                String createTime = rowSet.getString("createTime");
                ct.setCreateTime(createTime.substring(0, 16));
                list.add(ct);
            }
        }
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    public PagingResult<DocBorrowHistoryDTO> listDocBorrowHistory(Context ctx, DocBorrowHistoryDTO param, PagingParam pagingParam) throws Exception {
        String sql;
        PagingResult pagingResult = new PagingResult();
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app.DocBorrowHistoryQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("document.id", (Object)param.getId(), CompareType.EQUALS));
        entityViewInfo.setFilter(filter);
        exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
        String countSql = sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") > 0) {
            countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
            total = countRowSet.getInt(1);
        }
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<DocBorrowHistoryDTO> list = new ArrayList<DocBorrowHistoryDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                DocBorrowHistoryDTO ct = new DocBorrowHistoryDTO();
                ct.setAdminOrgUnitId(rowSet.getString("AdminOrgUnit.id"));
                ct.setAdminOrgUnitName(rowSet.getString("AdminOrgUnit.name"));
                ct.setApplyDate(rowSet.getString("applyDate"));
                ct.setApplyTime(rowSet.getString("applyTime"));
                ct.setApproveDate(rowSet.getString("approveDate"));
                ct.setBorrowerId(rowSet.getString("borrower.id"));
                ct.setBorrowerName(rowSet.getString("borrower.name"));
                ct.setBorrowReason(rowSet.getString("borrowReason"));
                ct.setBorrowTime(rowSet.getString("borrowTime"));
                ct.setCUName(rowSet.getString("CU.name"));
                ct.setDocTitle(rowSet.getString("document.title"));
                ct.setId(rowSet.getString("id"));
                rowSet.getString("state");
                ct.setState(rowSet.getString("state"));
                list.add(ct);
            }
        }
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private List getReadHistoryList(Context ctx, String docId) {
        String sql = "select fid, ffirstReadTime, freaderId, freadDocumentId, fcontrolUnitId from t_dm_docReadNote where freadDocumentId = '" + docId + "' order by ffirstReadTime desc";
        ArrayList<DocumentReadNoteInfo> list = new ArrayList<DocumentReadNoteInfo>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                DocumentReadNoteInfo drnInfo = new DocumentReadNoteInfo();
                drnInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                drnInfo.setFirstReadTime(rs.getTimestamp("ffirstReadTime"));
                PersonInfo reader = new PersonInfo();
                reader.setId(BOSUuid.read((String)rs.getString("freaderId")));
                drnInfo.setReader(reader);
                DocumentInfo doc = new DocumentInfo();
                doc.setId(BOSUuid.read((String)rs.getString("freadDocumentId")));
                drnInfo.setReadDocument(doc);
                list.add(drnInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (UuidException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return list;
    }
}

