/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.dm.Dimension;
import com.kingdee.eas.cp.dm.DimensionAdminInfo;
import com.kingdee.eas.cp.dm.DimensionAdminOrgInfo;
import com.kingdee.eas.cp.dm.DimensionCollection;
import com.kingdee.eas.cp.dm.DimensionFactory;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DimensionPersonInfo;
import com.kingdee.eas.cp.dm.DimensionRoleInfo;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.IDimension;
import com.kingdee.eas.cp.dm.web.dto.ColumnParamsDTO;
import com.kingdee.eas.cp.dm.web.dto.ContentFilterParamDTO;
import com.kingdee.eas.cp.dm.web.dto.ContentListDTO;
import com.kingdee.eas.cp.dm.web.dto.DimF7DTO;
import com.kingdee.eas.cp.dm.web.dto.PermInfoDTO;
import com.kingdee.eas.cp.dm.web.dto.SubDimInfoDTO;
import com.kingdee.eas.cp.dm.web.helper.DimListHelper;
import com.kingdee.eas.cp.dm.web.util.PermFromDBUtil;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DimManagerService {
    private static final Logger logger = Logger.getLogger(DimManagerService.class);
    protected static DimManagerService instance = new DimManagerService();
    private boolean addNewBtnFlag;

    protected DimManagerService() {
    }

    public static DimManagerService getInstance() {
        return instance;
    }

    public List<DimensionInfo> getDefaultDimIdListByPerson(Context ctx) {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        ArrayList<DimensionInfo> dimList = new ArrayList<DimensionInfo>();
        ArrayList<String> curDimensionIdList = new ArrayList<String>();
        try {
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DimensionQuery"));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter("state!=2 and level = 1");
            ev.getSorter().clear();
            ev.getSorter().add(this.buildListSortType());
            queryExecutor.setObjectView(ev);
            IRowSet rs = queryExecutor.executeQuery();
            while (rs.next()) {
                DimensionInfo dim = new DimensionInfo();
                dim.setId(BOSUuid.read((String)rs.getString("id")));
                dim.setName(rs.getString("name"));
                dim.setState(DmState.getEnum(rs.getInt("state")));
                dimList.add(dim);
                curDimensionIdList.add(rs.getString("id"));
            }
            queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DefaultDIMQuery"));
            ev = new EntityViewInfo();
            ev.setFilter("person.id = '" + personId + "' and dimension.state != '2'");
            queryExecutor.setObjectView(ev);
            rs = queryExecutor.executeQuery();
            while (rs.next()) {
                String id = rs.getString("dimension.id");
                for (DimensionInfo di : dimList) {
                    if (id == null || !di.getId().toString().contains(id)) continue;
                    dimList.remove(di);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return dimList;
    }

    private SorterItemInfo buildListSortType() {
        SorterItemInfo sortInfo = new SorterItemInfo("index");
        sortInfo.setSortType(SortType.DESCEND);
        return sortInfo;
    }

    public DimensionInfo findDimFirstInfo(Context ctx, String dimId) {
        Dimension dimService = new Dimension(ctx);
        DimensionInfo dimInfo = new DimensionInfo();
        try {
            if (StringUtil.isEmpty((String)dimId)) {
                dimInfo.setState(DmState.ENABLE);
                dimInfo.setLv1dimension(dimInfo);
                dimInfo.setIndex(-1);
                dimInfo.setId(BOSUuid.create((BOSObjectType)dimInfo.getBOSType()));
            } else {
                dimInfo = dimService.getDimensionInfo((IObjectPK)new ObjectUuidPK(dimId), this.getDimFirstSelectors());
            }
        }
        catch (Exception e) {
            logger.error((Object)"findDocAreaInfoByAreaId error===", (Throwable)e);
        }
        return dimInfo;
    }

    public List<DimensionInfo> getDimIdListByPerson(Context ctx, String pId) {
        ArrayList<DimensionInfo> dimList = new ArrayList<DimensionInfo>();
        ArrayList<String> curDimensionIdList = new ArrayList<String>();
        try {
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DimensionQuery"));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter("state!=2 and parent.id = '" + pId + "'");
            queryExecutor.setObjectView(ev);
            IRowSet rs = queryExecutor.executeQuery();
            while (rs.next()) {
                DimensionInfo dim = new DimensionInfo();
                dim.setId(BOSUuid.read((String)rs.getString("id")));
                dim.setName(rs.getString("name"));
                dim.setState(DmState.getEnum(rs.getInt("state")));
                DimensionInfo lv1dimension = new DimensionInfo();
                lv1dimension.setId(BOSUuid.read((String)rs.getString("lv1dimension.id")));
                dim.setLv1dimension(lv1dimension);
                dimList.add(dim);
                curDimensionIdList.add(rs.getString("id"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return dimList;
    }

    public SelectorItemCollection getDimFirstSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("state");
        sic.add("level");
        sic.add("index");
        sic.add("description");
        sic.add("lv1dimension.id");
        sic.add("creator.id");
        sic.add("Admin.admin.id");
        sic.add("Admin.admin.name");
        sic.add("Admin.admin.number");
        sic.add("Admin.permList");
        return sic;
    }

    public DimensionInfo saveFirstDim(Context ctx, String dimId, String dimName, String cuId, String dimDesc, String addType) {
        DimensionInfo info = null;
        try {
            if ("edit".equals(addType)) {
                info = this.findDimFirstInfo(ctx, dimId);
            } else {
                info = new DimensionInfo();
                info.setState(DmState.ENABLE);
                info.setLv1dimension(info);
                info.setIndex(-1);
                info.setLevel(1);
                info.setId(BOSUuid.read((String)dimId));
            }
            info.setName(dimName);
            info.setDescription(dimDesc);
            info = this.setDimManager(info, cuId);
            Dimension dimService = new Dimension(ctx);
            dimService.save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.error((Object)"saveFirstDim error ===", (Throwable)e);
            info = null;
            try {
                throw new Exception(e);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return info;
    }

    private DimensionInfo setDimManager(DimensionInfo info, String cuId) {
        info.getAdmin().clear();
        String[] pers = cuId.split(",");
        for (int i = 0; i < pers.length; ++i) {
            DimensionAdminInfo item = new DimensionAdminInfo();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)pers[i]));
            item.setAdmin(personInfo);
            if (info.getAdmin().contains(item)) continue;
            info.getAdmin().add(item);
        }
        return info;
    }

    public boolean isExitDimName(Context ctx, String dimId, String dimName) {
        boolean isExist = false;
        try {
            IDimension idim = DimensionFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dimName, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)dimId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2");
            if (idim.exists(filter)) {
                isExist = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"isExitDimName error ===", (Throwable)e);
        }
        return isExist;
    }

    public DimensionInfo findSubDimByDimId(Context ctx, String dimId, String pId) throws Exception {
        DimensionInfo dim = null;
        if (StringUtil.isEmpty((String)dimId)) {
            dim = new DimensionInfo();
            DimensionInfo parent = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(pId), this.getDimSelectors());
            dim.setParent(parent);
            dim.setId(BOSUuid.create((BOSObjectType)dim.getBOSType()));
        } else {
            dim = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(dimId), this.getDimSelectors());
        }
        return dim;
    }

    public SelectorItemCollection getDimSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("state");
        sic.add("level");
        sic.add("index");
        sic.add("description");
        sic.add("lv1dimension.id");
        sic.add("creator.id");
        sic.add("parent.id");
        sic.add("parent.name");
        sic.add("Role.role.id");
        sic.add("Role.role.name");
        sic.add("Role.role.number");
        sic.add("Role.permList");
        sic.add("Person.person.id");
        sic.add("Person.person.name");
        sic.add("Person.person.number");
        sic.add("Person.permList");
        sic.add("AdminOrg.adminOrg.id");
        sic.add("AdminOrg.adminOrg.name");
        sic.add("AdminOrg.adminOrg.number");
        sic.add("AdminOrg.permList");
        return sic;
    }

    public List<PermInfoDTO> findDimPermPerson(Context ctx, DimensionInfo dim, boolean getSelfPerson) {
        String perId = "";
        if (getSelfPerson) {
            perId = "'" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "'";
        }
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (dim != null && dim.getPerson().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < dim.getPerson().size(); ++i) {
                DimensionPersonInfo info = dim.getPerson().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getPerson().getId().toString()).append("'");
                permList.put(info.getPerson().getId().toString(), info.getPermList());
            }
            perId = perIds.toString();
        }
        return PermFromDBUtil.getPermPersonFromDb(ctx, perId, permList);
    }

    public List<PermInfoDTO> findDimPermOrg(Context ctx, DimensionInfo dim) {
        String orgId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (dim != null && dim.getAdminOrg().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < dim.getAdminOrg().size(); ++i) {
                DimensionAdminOrgInfo info = dim.getAdminOrg().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getAdminOrg().getId().toString()).append("'");
                permList.put(info.getAdminOrg().getId().toString(), info.getPermList());
            }
            orgId = perIds.toString();
        }
        return PermFromDBUtil.getPermOrgFromDb(ctx, orgId, permList);
    }

    public List<PermInfoDTO> findDimPermRole(Context ctx, DimensionInfo dim) {
        String roleId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (dim != null && dim.getRole().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < dim.getRole().size(); ++i) {
                DimensionRoleInfo info = dim.getRole().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getRole().getId().toString()).append("'");
                permList.put(info.getRole().getId().toString(), info.getPermList());
            }
            roleId = perIds.toString();
        }
        return PermFromDBUtil.getPermRoleFromDb(ctx, roleId, permList);
    }

    public DimensionInfo saveSubDimInfo(Context ctx, SubDimInfoDTO subDimDto, String personMapStr, String orgMapStr, String roleMapStr) throws Exception {
        DimensionInfo info = null;
        if ("edit".equals(subDimDto.getAddType())) {
            info = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(subDimDto.getDimId()), this.getDimSelectors());
        } else {
            info = new DimensionInfo();
            info.setState(DmState.ENABLE);
            info.setIndex(-1);
            DimensionInfo parent = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(subDimDto.getpId()), this.getDimSelectors());
            info.setParent(parent);
            info.setId(BOSUuid.read((String)subDimDto.getDimId()));
            DimensionInfo lv1Dim = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(subDimDto.getLv1DimId()), this.getDimSelectors());
            info.setLv1dimension(lv1Dim);
        }
        info = this.setSubDimBasicInfo(info, subDimDto);
        info = this.setSubDimPerson(info, personMapStr);
        info = this.setSubDimOrg(info, orgMapStr);
        info = this.setSubDimRole(info, roleMapStr);
        DimensionFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        return info;
    }

    private DimensionInfo setSubDimBasicInfo(DimensionInfo info, SubDimInfoDTO subDimDto) {
        info.setName(subDimDto.getDimName());
        info.setDescription(subDimDto.getDimDesc());
        return info;
    }

    private DimensionInfo setSubDimPerson(DimensionInfo info, String personMapStr) throws JSONException {
        info.getPerson().clear();
        JSONObject personMap = new JSONObject(personMapStr);
        DimensionPersonInfo dimensionPersonInfo = null;
        Iterator iter = personMap.keys();
        PersonInfo perInfo = null;
        String key = null;
        while (iter.hasNext()) {
            dimensionPersonInfo = new DimensionPersonInfo();
            key = (String)iter.next();
            String permColumn = (String)personMap.get(key);
            if ("".equals(permColumn)) continue;
            perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)key));
            dimensionPersonInfo.setPerson(perInfo);
            dimensionPersonInfo.setPermList((String)personMap.get(key));
            info.getPerson().add(dimensionPersonInfo);
        }
        return info;
    }

    private DimensionInfo setSubDimOrg(DimensionInfo info, String orgMapStr) throws JSONException {
        info.getAdminOrg().clear();
        JSONObject orgMap = new JSONObject(orgMapStr);
        DimensionAdminOrgInfo dimensionAdminOrgInfo = null;
        Iterator iter = orgMap.keys();
        String key = null;
        while (iter.hasNext()) {
            dimensionAdminOrgInfo = new DimensionAdminOrgInfo();
            key = (String)iter.next();
            String permColumn = (String)orgMap.get(key);
            if ("".equals(permColumn)) continue;
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)key));
            dimensionAdminOrgInfo.setAdminOrg(adminInfo);
            dimensionAdminOrgInfo.setPermList((String)orgMap.get(key));
            info.getAdminOrg().add(dimensionAdminOrgInfo);
        }
        return info;
    }

    private DimensionInfo setSubDimRole(DimensionInfo info, String roleMapStr) throws JSONException {
        info.getRole().clear();
        JSONObject roleMap = new JSONObject(roleMapStr);
        Iterator iter = roleMap.keys();
        String key = null;
        while (iter.hasNext()) {
            DimensionRoleInfo dimensionRoleInfo = new DimensionRoleInfo();
            key = (String)iter.next();
            String permColumn = (String)roleMap.get(key);
            if ("".equals(permColumn)) continue;
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)key));
            dimensionRoleInfo.setRole(roleInfo);
            dimensionRoleInfo.setPermList((String)roleMap.get(key));
            info.getRole().add(dimensionRoleInfo);
        }
        return info;
    }

    public void enableDim(Context ctx, String dimId) throws Exception {
        DimensionInfo dim = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(dimId), this.getDimSelectors());
        Dimension dimServce = new Dimension(ctx);
        dimServce.enable(dim);
    }

    public void disableDim(Context ctx, String dimId) throws Exception {
        DimensionInfo dim = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(dimId), this.getDimSelectors());
        Dimension dimServce = new Dimension(ctx);
        dimServce.disable(dim);
    }

    public String deleteDim(Context ctx, String dimId) throws Exception {
        DimensionInfo dim = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(dimId), this.getDimSelectors());
        String result = this.verifyDeleteModel(ctx, dim);
        if ("success".equals(result)) {
            Dimension dimServce = new Dimension(ctx);
            dimServce.delete(dim);
        }
        return result;
    }

    private String verifyDeleteModel(Context ctx, DimensionInfo dim) throws Exception {
        if (dim == null) {
            return "dimnull";
        }
        if (dim.getState().getValue() != 0) {
            return "dimenable";
        }
        String dimId = dim.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from t_dm_dimension where fid in ");
        sql.append("(select child.fid from t_dm_dimension child left join t_dm_dimension parent on parent.fid=child.fparentid");
        sql.append(" where parent.fid in (");
        sql.append(" select child.fid from t_dm_dimension child left join t_dm_dimension parent on parent.fid=child.fparentid");
        sql.append(" where parent.fid='" + dimId + "'");
        sql.append(" ) or child.fid in (");
        sql.append(" select child.fid from t_dm_dimension child left join t_dm_dimension parent on parent.fid=child.fparentid");
        sql.append(" where parent.fid='" + dimId + "'))");
        sql.append(" and fstate = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.size() > 0) {
            return "hassubenable";
        }
        sql = new StringBuffer("SELECT doc.* FROM t_dm_document doc left join T_DM_DocumentDimension docdim on docdim.fparentid = doc.fid left join T_DM_Dimension dim on dim.fid = docdim.fdimensionid where doc.fstate = 1 and doc.fwfstate =3  and (dim.fid ='" + dim.getId().toString() + "' or dim.flongnumber LIKE '" + dim.getLongNumber() + "!%')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return "hasDoc";
        }
        return "success";
    }

    public List<DimensionInfo> findDimList4F7(Context ctx) {
        StringBuffer oql = new StringBuffer("select id,level,name,description,longnumber,lv1dimension.id where state = 1 and level = 1");
        DimensionCollection dimColl = null;
        ArrayList<DimensionInfo> dimList = new ArrayList<DimensionInfo>();
        try {
            dimColl = DimensionFactory.getLocalInstance(ctx).getDimensionCollection(oql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashSet<String> adminLv1Set = new HashSet<String>();
        int length = dimColl.size();
        for (int i = 0; i < length; ++i) {
            if (adminLv1Set.contains(dimColl.get(i).getId().toString())) continue;
            adminLv1Set.add(dimColl.get(i).getId().toString());
        }
        HashSet<String> perMissionSet = new HashSet<String>();
        perMissionSet.add("12");
        Map<Object, Object> docViewmap = new HashMap();
        try {
            docViewmap = PermissionUtil.getHasPermDimIdMap(ctx, perMissionSet, adminLv1Set, "t_dm_dimension");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        for (String item : docViewmap.keySet()) {
            int m = dimColl.size();
            for (int j = 0; j < m; ++j) {
                if (!item.equals(dimColl.get(j).getId().toString())) continue;
                dimList.add(dimColl.get(j));
            }
        }
        return dimList;
    }

    /*
     * WARNING - void declaration
     */
    public List<DimensionInfo> findSubDimList4F7(Context ctx, DimF7DTO dimF7Dto) {
        void var9_13;
        HashSet<String> PermIdSet = new HashSet<String>();
        HashSet<String> perMissionSet = new HashSet<String>();
        perMissionSet.add("12");
        FilterInfo filterAdmin = new FilterInfo();
        HashSet<String> bizSet = new HashSet<String>();
        bizSet.add(dimF7Dto.getLv1DimId());
        filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        Map<Object, Object> dimAdminmap = new HashMap();
        try {
            dimAdminmap = PermissionUtil.getHasPermDimIdMap(ctx, perMissionSet, bizSet, "t_dm_dimension");
        }
        catch (BOSException e) {
            logger.error((Object)("findSubDimList4F7 error===" + e.getMessage()));
        }
        for (String string : dimAdminmap.keySet()) {
            HashSet set = (HashSet)dimAdminmap.get(string);
            for (String dimid : set) {
                PermIdSet.add(dimid);
            }
        }
        if (!"checked".equals(dimF7Dto.getSearchAllArea())) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermIdSet == null ? "" : PermIdSet, CompareType.INCLUDE));
            if ("checked".equals(dimF7Dto.getIncludSub())) {
                filterAdmin.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(dimF7Dto.getLongNumber() + "!%"), CompareType.LIKE));
            } else {
                filterAdmin.getFilterItems().add(new FilterItemInfo("parent.id", (Object)dimF7Dto.getpId()));
            }
        }
        if (!StringUtil.isEmpty((String)dimF7Dto.getMyinput())) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + dimF7Dto.getMyinput() + "%"), CompareType.LIKE));
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filterAdmin);
        Object var9_11 = null;
        ArrayList<DimensionInfo> dimList = new ArrayList<DimensionInfo>();
        try {
            DimensionCollection dimensionCollection = DimensionFactory.getLocalInstance(ctx).getDimensionCollection(ev);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        int m = var9_13.size();
        for (int j = 0; j < m; ++j) {
            dimList.add(var9_13.get(j));
        }
        return dimList;
    }

    public PagingResult<ContentListDTO> findDocList(Context ctx, ContentFilterParamDTO param, PagingParam pagingParam) throws Exception {
        ContentListDTO ct;
        String sql;
        PagingResult pagingResult = new PagingResult();
        String dimId = param.getAreaId();
        FilterInfo filterInfo = new FilterInfo();
        DimensionInfo dimInfo = null;
        dimInfo = "dim".equals(param.getCateType()) ? (DimensionInfo)DimensionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(dimId)) : (DimensionInfo)DimensionFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(param.getColumnId()));
        filterInfo = DimListHelper.getInstance().buildTreeFilterSelectDimension(ctx, dimId, dimInfo);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app", "DocumentQuery");
        SorterItemInfo sortInfo = new SorterItemInfo("index");
        sortInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().clear();
        entityViewInfo.getSorter().add(sortInfo);
        FilterInfo docStatusFilter = new FilterInfo();
        docStatusFilter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)Boolean.FALSE, CompareType.EQUALS));
        docStatusFilter.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(2), CompareType.NOTEQUALS));
        String mark = " ( #0 and #1 )";
        if (null != param.getSearchKey() && !"".equals(param.getSearchKey())) {
            docStatusFilter.getFilterItems().add(new FilterItemInfo("title", (Object)("%" + param.getSearchKey() + "%"), CompareType.LIKE));
            mark = " ( #0 and #1 and #2 )";
        }
        docStatusFilter.setMaskString(mark);
        filterInfo.mergeFilter(docStatusFilter, "and");
        entityViewInfo.setFilter(filterInfo);
        exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
        String countSql = sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") > 0) {
            countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
            total = countRowSet.getInt(1);
        }
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<ContentListDTO> list = new ArrayList<ContentListDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                ct = new ContentListDTO();
                ct.setId(rowSet.getString("id"));
                ct.setTitle(rowSet.getString("title"));
                ct.setAuthorName(rowSet.getString("AUTHOR.NAME"));
                if ("\u7981\u7528".equals(rowSet.getString("STATE"))) {
                    ct.setState(rowSet.getString("STATE"));
                } else {
                    ct.setState(rowSet.getString("wfState"));
                }
                ct.setIsArchive(rowSet.getString("isArchive"));
                ct.setViewCount(rowSet.getString("READCOUNT"));
                ct.setCreateTime(rowSet.getString("CREATETIME"));
                ct.setDistbuteTime(rowSet.getString("CREATETIME"));
                ct.setSummary(rowSet.getString("summary"));
                ct.setContentType(rowSet.getString("contentType"));
                ct.setAddNewBtnFlag(this.addNewBtnFlag);
                list.add(ct);
            }
        }
        ct = new ContentListDTO();
        ct.setId("1");
        ct.setAddNewBtnFlag(this.addNewBtnFlag);
        list.add(ct);
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public boolean saveLv1DimSort(HttpServletRequest request, Context ctx, String dimIds, String pId) throws Exception {
        List<DimensionInfo> dimList = this.getDefaultDimIdListByPerson(ctx);
        CoreBaseCollection colls = new CoreBaseCollection();
        HashMap<String, DimensionInfo> dimMap = new HashMap<String, DimensionInfo>();
        int maxIndex = dimList.size();
        String[] strs = dimIds.split(",");
        block0: for (int j = 0; j < strs.length; ++j) {
            for (int i = 0; i < dimList.size(); ++i) {
                DimensionInfo dim = dimList.get(i);
                if (!dimMap.containsKey(dim.getId().toString())) {
                    dimMap.put(dim.getId().toString(), this.findDimFirstInfo(ctx, dim.getId().toString()));
                }
                if (!dim.getId().toString().equals(strs[j])) continue;
                DimensionInfo dim_ = (DimensionInfo)dimMap.get(dim.getId().toString());
                dim_.setIndex(maxIndex - j);
                colls.add((CoreBaseInfo)dim_);
                continue block0;
            }
        }
        DimensionFactory.getLocalInstance(ctx).update(colls);
        return true;
    }

    public boolean saveSubDimSort(Context ctx, String ids, String pId) throws Exception {
        List<DimensionInfo> dimList = DimManagerService.getInstance().getDimIdListByPerson(ctx, pId);
        CoreBaseCollection colls = new CoreBaseCollection();
        String[] strs = ids.split(",");
        for (int j = 0; j < strs.length; ++j) {
            for (int i = 0; i < dimList.size(); ++i) {
                DimensionInfo dim = dimList.get(i);
                if (dim.getId().toString().equals(strs[j])) {
                    dim.setIndex(j + 1);
                    continue;
                }
                colls.add((CoreBaseInfo)dim);
            }
        }
        DimensionFactory.getLocalInstance(ctx).save(colls);
        return true;
    }

    public boolean moveInNode(Context ctx, String sourceId, String targetId) throws Exception {
        DimensionInfo dim = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(sourceId), this.getDimSelectors());
        DimensionInfo targetDimNode = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(targetId), this.getDimSelectors());
        DimensionFactory.getLocalInstance(ctx).moveTreeNode(dim, targetDimNode);
        return true;
    }

    public boolean moveInParentNode(Context ctx, String sourceId, String targetId, ColumnParamsDTO columnParamDto, String ids) throws Exception {
        boolean result = false;
        boolean moveInResult = this.moveInNode(ctx, sourceId, columnParamDto.getId());
        if (moveInResult) {
            this.saveSubDimSort(ctx, ids, columnParamDto.getId());
            result = true;
        }
        return result;
    }

    public boolean isAddNewBtnFlag() {
        return this.addNewBtnFlag;
    }

    public void setAddNewBtnFlag(boolean addNewBtnFlag) {
        this.addNewBtnFlag = addNewBtnFlag;
    }
}

