/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocAreaFactory;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.cp.dm.web.bussiness.ITreeMap;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DmCatMapTreeDataProvider {
    private static final Logger LOGGER = Logger.getLogger(DmCatMapTreeDataProvider.class);
    private ITreeMap treeMap;
    private Map<String, List<TreeBaseInfo>> tempMap;
    private Map<String, List<TreeBaseInfo>> permTreeMap;
    private boolean permTreeFlag = false;

    public DmCatMapTreeDataProvider(ITreeMap treeMap) {
        this.treeMap = treeMap;
    }

    public Object[] getChildren(Context ctx, Object userData) {
        String key = null;
        Iterator<String> iter = null;
        if (userData == null) {
            this.tempMap = this.treeMap.createMapTreeData();
            iter = this.tempMap.keySet().iterator();
            if (iter.hasNext()) {
                key = iter.next();
            }
        } else {
            if (this.tempMap == null) {
                this.tempMap = this.treeMap.createMapTreeData();
            }
            if ("ROOT".equals(userData)) {
                List<String> keyList = this.treeMap.getBizIdList();
                if (keyList != null && keyList.size() > 0) {
                    try {
                        return DocAreaFactory.getLocalInstance(ctx).getDocAreaCollection("select id,name,number,index,state where id in" + CommonUtils.getStrFromList(keyList) + " order by index desc").toArray();
                    }
                    catch (BOSException e) {
                        LOGGER.info((Object)"\u83b7\u53d6\u6587\u6863\u533a\u96c6\u5408\u5931\u8d25\uff01");
                        e.printStackTrace();
                        return null;
                    }
                }
                return null;
            }
            if (userData instanceof DocAreaInfo) {
                key = ((DocAreaInfo)userData).getId().toString();
                return this.handleEmptyKey(ctx, userData, key);
            }
            key = ((TreeBaseInfo)userData).getLongNumber() + "!";
        }
        return this.handleEmptyKey(ctx, userData, key);
    }

    private Object[] handleEmptyKey(Context ctx, Object userData, String key) {
        if (userData == null) {
            return new Object[]{"ROOT"};
        }
        if (this.tempMap.get(key) != null) {
            if (this.permTreeFlag) {
                List<TreeBaseInfo> treeList = this.tempMap.get(key);
                LinkedList<TreeBaseInfo> resultList = new LinkedList<TreeBaseInfo>();
                block3: for (TreeBaseInfo baseInfo : treeList) {
                    if (this.containsKey(baseInfo.getId().toString())) {
                        resultList.add(baseInfo);
                        continue;
                    }
                    Iterator<String> iter = null;
                    for (String tempkey : this.permTreeMap.keySet()) {
                        if (!tempkey.equals(baseInfo.getLongNumber()) && !tempkey.startsWith(baseInfo.getLongNumber())) continue;
                        resultList.add(baseInfo);
                        continue block3;
                    }
                }
                return resultList.toArray();
            }
            return this.tempMap.get(key).toArray();
        }
        try {
            if (StringUtils.isEmpty((String)key)) {
                return null;
            }
            if (userData instanceof CategoryInfo || userData instanceof DocAreaInfo) {
                return null;
            }
            return new Object[]{DocAreaFactory.getLocalInstance(ctx).getDocAreaInfo("select id,name,number,state where id ='" + key.substring(4) + "'")};
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getHref(Object userData) {
        return null;
    }

    public String getHrefTarget(Object userData) {
        return null;
    }

    public String getIcon(Object userData) {
        if (userData != null) {
            if (userData instanceof DocAreaInfo) {
                if ("22222222-2222-2222-2222-222222222222CCE7AED4".equals(((DocAreaInfo)userData).getId().toString())) {
                    return "resources/image/tree_myindividual.gif";
                }
                if ("MelW/dHHTYOlHlNhgLZyRMNdkBQ=".equals(((DocAreaInfo)userData).getId().toString())) {
                    return "resources/image/tree_myspace.gif";
                }
                if ("33333333-3333-3333-3333-333333333333CCE7AED4".equals(((DocAreaInfo)userData).getId().toString())) {
                    return "resources/image/tree_share.gif";
                }
                return "resources/image/docArea.gif";
            }
            if (userData instanceof CategoryInfo) {
                String catId = ((CategoryInfo)userData).getId().toString();
                if ("wZxsk5DbTK2xj0F9sAl/n8NdkBQ=".equals(catId)) {
                    return "resources/image/tree_myputout.gif";
                }
                if ("R8+LZe0FRBam4nGMFLckacNdkBQ=".equals(catId)) {
                    return "resources/image/tree_myauditing.gif";
                }
                if ("ol7h/gioRX2/D4oOLU1cUsNdkBQ=".equals(catId)) {
                    return "resources/image/tree_myrecommend.gif";
                }
                if ("MirOKDKL9ECnz0xqo7IajsNdkBQ=".equals(catId)) {
                    return "resources/image/tree_myborrow.gif";
                }
                return "resources/image/category.gif";
            }
            return "resources/image/tree_folder.gif";
        }
        return "resources/image/tree_folder.gif";
    }

    private boolean containsKey(String key) {
        if (this.permTreeMap.containsKey(key)) {
            return true;
        }
        Iterator<String> iter = null;
        for (String tempkey : this.permTreeMap.keySet()) {
            List<TreeBaseInfo> treeList = this.permTreeMap.get(tempkey);
            if (treeList == null) continue;
            for (TreeBaseInfo treeBaseInfo : treeList) {
                CategoryInfo categoryInfo;
                if (!(treeBaseInfo instanceof CategoryInfo) || !(categoryInfo = (CategoryInfo)treeBaseInfo).getId().toString().equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public String getText(Object userData) {
        if (userData instanceof TreeBaseInfo) {
            if (userData instanceof CategoryInfo) {
                if (((CategoryInfo)userData).getState() == DmState.ENABLE) {
                    CategoryInfo categoryInfo;
                    String key;
                    if (this.permTreeFlag && !this.containsKey(key = (categoryInfo = (CategoryInfo)userData).getId().toString())) {
                        return "<span style=\"color:gray\">" + this.getTextName(userData) + "</span>";
                    }
                    return this.getTextName(userData);
                }
                return "<span style=\"color:gray\">" + this.getTextName(userData) + "</span>";
            }
            return this.getTextName(userData);
        }
        if (userData instanceof DocAreaInfo) {
            String daID = ((DocAreaInfo)userData).getId().toString();
            if (((DocAreaInfo)userData).getState() == DmState.ENABLE || "22222222-2222-2222-2222-222222222222CCE7AED4".equals(daID) || "MelW/dHHTYOlHlNhgLZyRMNdkBQ=".equals(daID) || "33333333-3333-3333-3333-333333333333CCE7AED4".equals(daID)) {
                return "<span style=\"font-weight:bold;\">" + this.getTextStr(userData) + "</span>";
            }
            return "<span style=\"color:gray; font-weight:bold;\">" + this.getTextStr(userData) + "</span>";
        }
        return this.getTextStr(userData);
    }

    private String getTextStr(Object userData) {
        return userData.toString().length() > 12 ? userData.toString().substring(0, 10) + "..." : userData.toString();
    }

    private String getTextName(Object userData) {
        String name = ((TreeBaseInfo)userData).getName();
        return name.length() > 12 ? name.substring(0, 10) + "..." : name;
    }

    public boolean isCascade(Object userData) {
        return false;
    }

    public Boolean isChecked(Object userData) {
        return null;
    }

    public boolean isExpanded(Context ctx, Object userData) {
        Boolean isLeaf = false;
        Object[] o = this.getChildren(ctx, userData);
        isLeaf = o == null || o.length == 0;
        return isLeaf;
    }

    public ITreeMap getTreeMap() {
        return this.treeMap;
    }

    public void setTreeMap(ITreeMap treeMap) {
        this.treeMap = treeMap;
    }

    public String getId(Object arg0) {
        if (arg0 == null) {
            LOGGER.info((Object)"tree id error ,id is null");
            return "dm_error";
        }
        if (arg0 instanceof DocAreaInfo) {
            return "DA_" + ((DocAreaInfo)arg0).getIndex();
        }
        if (arg0 instanceof CategoryInfo) {
            if (((CategoryInfo)arg0).getNumber() != null) {
                return "Cat_" + ((CategoryInfo)arg0).getNumber();
            }
            LOGGER.info((Object)"Error: category number is null");
            return "Cat_" + ((CategoryInfo)arg0).getIndex();
        }
        if (arg0 instanceof String) {
            if ("ROOT".equals((String)arg0)) {
                return "DM_ROOT";
            }
            LOGGER.info((Object)"tree id ERROR");
            return "DM_TREE_ERROR";
        }
        LOGGER.info((Object)"tree id ERROR");
        return "DM_TREE_ERROR";
    }

    public String getCls(Object arg0) {
        return null;
    }

    public String getIconCls(Object arg0) {
        return null;
    }

    public String getQtip(Object arg0) {
        return null;
    }

    public boolean isDisabled(Object arg0) {
        return false;
    }

    public boolean isLeaf(Context ctx, Object arg0) {
        Boolean isLeaf = false;
        Object[] o = this.getChildren(ctx, arg0);
        isLeaf = o == null || o.length == 0;
        return isLeaf;
    }

    public boolean isSingleClickExpand(Object arg0) {
        return false;
    }

    public Map<String, List<TreeBaseInfo>> getPermTreeMap() {
        return this.permTreeMap;
    }

    public void setPermTreeMap(Map<String, List<TreeBaseInfo>> permTreeMap) {
        this.permTreeMap = permTreeMap;
    }

    public boolean isPermTreeFlag() {
        return this.permTreeFlag;
    }

    public void setPermTreeFlag(boolean permTreeFlag) {
        this.permTreeFlag = permTreeFlag;
    }
}

