/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.web.util.CommonUtils;
import com.kingdee.eas.cp.dm.web.util.DmCommonUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DmPermissionServiceNewHelper {
    private static final Logger LOGGER = Logger.getLogger(DmPermissionServiceNewHelper.class);
    private static DmPermissionServiceNewHelper dmPermServiceHelper;

    public static DmPermissionServiceNewHelper getInstance() {
        if (dmPermServiceHelper == null) {
            dmPermServiceHelper = new DmPermissionServiceNewHelper();
        }
        return dmPermServiceHelper;
    }

    public boolean hasTopCatPermission(Context ctx) throws BOSException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        boolean hasFunctionPermission = false;
        try {
            hasFunctionPermission = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "docArea_maintain");
        }
        catch (EASBizException e) {
            LOGGER.info((Object)"\u83b7\u53d6\u6587\u6863\u533a\u7ba1\u7406\u5458\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return hasFunctionPermission;
    }

    public boolean hasTopDimPermission(Context ctx) throws BOSException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        boolean hasFunctionPermission = false;
        try {
            hasFunctionPermission = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "dimension_maintain");
        }
        catch (EASBizException e) {
            LOGGER.info((Object)"\u83b7\u53d6\u7ef4\u5ea6\u7ba1\u7406\u5458\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return hasFunctionPermission;
    }

    public boolean checkHasPermission(Context ctx, String perId, String userId, String operStr, String bizId, String bizTableName) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add(operStr);
        return this.checkHasPermission(ctx, perId, userId, operStrNumSet, bizId, bizTableName);
    }

    public boolean checkHasPermission(Context ctx, String perId, String userId, Set<String> operStrNumSet, String bizId, String bizTableName) {
        assert (operStrNumSet != null);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select bizadmin.FPermList, bizperson.FPermList, bizrole.FPermList, biz.fid  from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("' or bizperson.fpersonid = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("' or bizadmin.fadminid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tSELECT  ADMIN.FID \n");
        selectSql.append("\t\t\tFROM T_BD_Person AS PERSON  \n");
        selectSql.append("\t\t\tINNER JOIN T_HR_PersonPosition AS PP  \n");
        selectSql.append("\t\t\tON PERSON.FID = PP.FPersonID  \n");
        selectSql.append("\t\t\tINNER JOIN T_ORG_PositionMember AS PM  \n");
        selectSql.append("\t\t\tON PERSON.FID = PM.FPersonID  \n");
        selectSql.append("\t\t\tINNER JOIN T_PM_USER AS PMUSER \n");
        selectSql.append("\t\t\tON PMUSER.FPERSONID = PERSON.FID \n");
        selectSql.append("\t\t\tINNER JOIN T_ORG_Position AS POSITION  \n");
        selectSql.append("\t\t\tON PM.FPositionID = POSITION.FID  \n");
        selectSql.append("\t\t\tINNER JOIN T_ORG_Admin AS ADMIN  \n");
        selectSql.append("\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t)  \n");
        selectSql.append("\t\tor bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where FOrgID = '");
        selectSql.append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        selectSql.append("'  \n");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\tAND (");
        selectSql.append(this.makeWhereExpByOperNumSet(operStrNumSet));
        selectSql.append(")  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return false;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public Map<String, Set<String>> getBizPermMap(Context ctx, String perId, String userId, String bizId, String bizTableName) {
        HashMap<String, Set<String>> bizPermMap = new HashMap<String, Set<String>>();
        HashSet<String> permSet = new HashSet<String>();
        this.getBizPermMapAdmin(ctx, perId, userId, bizId, bizTableName, permSet);
        this.getBizPermMapPerson(ctx, perId, userId, bizId, bizTableName, permSet);
        this.getBizPermMapRole(ctx, perId, userId, bizId, bizTableName, permSet);
        bizPermMap.put(perId + bizId, permSet);
        return bizPermMap;
    }

    private Set<String> getBizPermMapPerson(Context ctx, String perId, String userId, String bizId, String bizTableName, Set<String> permSet) {
        Set<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select bizperson.FPermList as adminList from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("' or bizperson.fpersonid = '");
        String sqlStr = "select FControlUnitID from " + bizTableName + " where fId = '" + bizId + "'";
        String docAreaCUId = this.getColumnValue(ctx, sqlStr, "FControlUnitID");
        if (!"".equals(docAreaCUId) && DmCommonUtils.isPersonInCU(ctx, perId, docAreaCUId)) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("'\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("adminList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnSet;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnSet;
        }
        return rtnSet;
    }

    public Set<String> getBizPermMapAdmin(Context ctx, String perId, String userId, String bizId, String bizTableName, Set<String> permSet) {
        Set<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizadmin.FPermList as personList  from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        if ("t_dm_dimension".equals(bizTableName)) {
            selectSql.append("adminorg bizadmin on bizadmin.fparentid = biz.fid \n");
            selectSql.append(" where  bizadmin.fadminorgid  \n");
        } else {
            selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
            selectSql.append(" where  bizadmin.fadminid  \n");
        }
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tSELECT  ADMIN.FID \n");
        selectSql.append("\t\t\tFROM T_BD_Person AS PERSON  \n");
        selectSql.append("\t\t\tINNER JOIN T_HR_PersonPosition AS PP  \n");
        selectSql.append("\t\t\tON PERSON.FID = PP.FPersonID  \n");
        selectSql.append("\t\t\tINNER JOIN T_ORG_PositionMember AS PM  \n");
        selectSql.append("\t\t\tON PERSON.FID = PM.FPersonID  \n");
        selectSql.append("\t\t\tINNER JOIN T_PM_USER AS PMUSER \n");
        selectSql.append("\t\t\tON PMUSER.FPERSONID = PERSON.FID \n");
        selectSql.append("\t\t\tINNER JOIN T_ORG_Position AS POSITION  \n");
        selectSql.append("\t\t\tON PM.FPositionID = POSITION.FID  \n");
        selectSql.append("\t\t\tINNER JOIN T_ORG_Admin AS ADMIN  \n");
        selectSql.append("\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t)  \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("personList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnSet;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnSet;
        }
        return rtnSet;
    }

    public Set<String> getBizPermMapRole(Context ctx, String perId, String userId, String bizId, String bizTableName, Set<String> permSet) {
        Set<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizrole.FPermList as roleList from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("\t\t bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where FOrgID = '");
        selectSql.append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        selectSql.append("'  \n");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("roleList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnSet;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnSet;
        }
        return rtnSet;
    }

    private String makeWhereExpByOperNumSet(Set<String> operStrNumSet) {
        return this.makeWhereExpByOperNumSet(null, operStrNumSet);
    }

    private String makeWhereExpByOperNumSet(String symExp, Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizadmin.FPermList like '").append(permLikeValue).append("' or bizperson.FPermList like '").append(permLikeValue).append("' or bizrole.FPermList like '").append(permLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permEndLikeValue).append("' or bizperson.FPermList like '").append(permEndLikeValue).append("' or bizrole.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permMiddleLikeValue).append("' or bizperson.FPermList like '").append(permMiddleLikeValue).append("' or bizrole.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizadmin.FPermList = '").append(operNum).append("' or bizperson.FPermList = '").append(operNum).append("' or bizrole.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    private String makeWhereExpByOperNumSetPerson(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizperson.FPermList like '").append(permLikeValue).append("' or ").append(" bizperson.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizperson.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizperson.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    private String makeWhereExpByOperNumSetAdmin(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizadmin.FPermList like '").append(permLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizadmin.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    private String makeWhereExpByOperNumSetRole(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizrole.FPermList like '").append(permLikeValue).append("' or ").append(" bizrole.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizrole.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizrole.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    public Set<String> getHasPermCatIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, String bizId, String bizTableName) {
        assert (bizId != null);
        HashSet<String> bizIdSet = new HashSet<String>();
        bizIdSet.add(bizId);
        return this.getHasPermCatIdSet(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName).get(bizId);
    }

    public Map<String, Set<String>> getHasPermDocAreaIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) {
        return this.getHasPermDocAreaIdSet(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, new int[]{0, 1});
    }

    public Map<String, Set<String>> getHasPermDocAreaIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        this.getHasPermDocAreaCatIdSet(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        return daCatMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) {
        return this.getHasPermCatIdSet(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, new int[]{0, 1});
    }

    public Map<String, Set<String>> getHasPermCatIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        this.getHasPermCatIdSetPerson(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermCatIdSetAdmin(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermCatIdSetRole(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        return daCatMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSetExcludeNull(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        this.getHasPermCatIdSetPerson(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermCatIdSetAdmin(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermCatIdSetRole(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        if (daCatMap != null) {
            for (String str : daCatMap.keySet()) {
                if (((Set)daCatMap.get(str)).size() > 0) continue;
                daCatMap.remove(str);
            }
        }
        return daCatMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSetPerson(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap) {
        return this.getHasPermCatIdSetPerson(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, new int[]{0, 1});
    }

    public Map<String, Set<String>> getHasPermCatIdSetAdmin(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap) {
        return this.getHasPermCatIdSetAdmin(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, new int[]{0, 1});
    }

    public Map<String, Set<String>> getHasPermCatIdSetRole(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap) {
        return this.getHasPermCatIdSetRole(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, new int[]{0, 1});
    }

    public Map<String, Set<String>> getHasPermDocAreaCatIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        Map<String, Set<String>> rtnMap = daCatMap;
        String bizName = bizTableName;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append(" select da.FPermList as FPermList,cat.fid as fid,da.daid as daid from ( ");
        selectSql.append(" select  bizperson.FPermList,biz.FID as daid  from t_dm_docarea biz ");
        selectSql.append(" left outer join t_dm_docareaperson bizperson on bizperson.fparentid = biz.fid ");
        selectSql.append(" where  bizperson.fpersonid = ").append("'").append(perId).append("'");
        selectSql.append(" AND  biz.FID in ");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append(" AND (").append(this.makeWhereExpByOperNumSetPerson(tempSet)).append(")");
        selectSql.append(" and (  biz.fstate=0 or  biz.fstate=1 )");
        selectSql.append(" union ");
        selectSql.append(" select bizadmin.FPermList, biz.FID as daid  from t_dm_docarea biz ");
        selectSql.append(" left outer join t_dm_docareaadmin bizadmin on bizadmin.fparentid = biz.fid ");
        selectSql.append(" where bizadmin.fadminid  ");
        Map res = this.getCurrentUserAdminIncludeParent(ctx, userId);
        String currentAdminId = (String)res.get(userId);
        selectSql.append(" in ").append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet((Set)res.get(currentAdminId)));
        selectSql.append(" AND  biz.FID in ");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append(" AND (").append(this.makeWhereExpByOperNumSetAdmin(tempSet)).append(")");
        selectSql.append(" and bizadmin.fadminid='" + currentAdminId + "' ");
        selectSql.append(" and (  biz.fstate=0 or  biz.fstate=1 )");
        selectSql.append(" union ");
        selectSql.append(" select bizrole.FPermList, biz.FID as daid  from t_dm_docarea biz ");
        selectSql.append(" left outer join t_dm_docarearole bizrole on bizrole.fparentid = biz.fid ");
        selectSql.append(" where  bizrole.froleid  in( select froleid from T_PM_UserRoleOrg where FOrgID = ");
        selectSql.append("'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        selectSql.append(" AND  fuserid =").append("'").append(userId).append("'").append(")");
        selectSql.append(" AND  biz.FID in ");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append(" AND (").append(this.makeWhereExpByOperNumSetRole(tempSet)).append(")");
        selectSql.append(" and (  biz.fstate=0 or  biz.fstate=1 )");
        selectSql.append(" ) da , t_dm_category cat where cat.fdocareaid=da.daid and ( cat.fstate=0 or  cat.fstate=1 )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("daid");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSetPerson(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        Map<String, Set<String>> rtnMap = daCatMap;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizperson.FPermList,biz.fid, da.FID as daid  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_docarea da ");
        selectSql.append(" on biz.fdocareaid = da.fid \n");
        selectSql.append("where  \n");
        if (tempSet.size() != 0) {
            selectSql.append("   (bizperson.fpersonid = '");
            selectSql.append(perId);
            selectSql.append("' or bizperson.fpersonid = '");
            if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
                selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
            } else {
                selectSql.append("nodata");
            }
            selectSql.append("'     ) \n");
            selectSql.append(" AND");
        }
        selectSql.append("   da.FID in");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("\tAND (");
            selectSql.append(this.makeWhereExpByOperNumSetPerson(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("daid");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSetAdmin(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select bizadmin.FPermList, biz.fid, da.FID as daid  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_docarea da ");
        selectSql.append(" on biz.fdocareaid = da.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   ( ");
        selectSql.append(" bizadmin.fadminid  \n");
        Map res = this.getCurrentUserAdminIncludeParent(ctx, userId);
        String currentAdminId = (String)res.get(userId);
        selectSql.append(" in ").append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet((Set)res.get(currentAdminId)));
        selectSql.append("  ) \n");
        selectSql.append("    AND da.FID in");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetAdmin(tempSet));
            selectSql.append(")  \n");
        }
        selectSql.append("  and (bizadmin.fincludesub=1 or bizadmin.fadminid='" + currentAdminId + "') ");
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("daid");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSetRole(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select bizrole.FPermList, biz.fid, da.FID as daid  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_docarea da ");
        selectSql.append(" on biz.fdocareaid = da.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   ( ");
        selectSql.append("      bizrole.froleid  \n");
        selectSql.append("      in( \n");
        selectSql.append("          select froleid from T_PM_UserRoleOrg where FOrgID = '");
        selectSql.append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        selectSql.append("'  \n");
        selectSql.append("          and fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("      ) \n");
        selectSql.append("  ) \n");
        if (bizIdSet.size() <= 0) {
            selectSql.append("    AND da.FID ='nodata' ");
        } else {
            selectSql.append("    AND da.FID in");
            selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
            selectSql.append("  \n");
        }
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetRole(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("daid");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    public String getHasPermDocIdSql(Context ctx, String perId, String userId) {
        String personSql = this.getHasPermDocIdSqlPerson(ctx, perId, userId);
        String adminSql = this.getHasPermDocIdSqlAdmin(ctx, perId, userId);
        String roleSql = this.getHasPermDocIdSqlRole(ctx, perId, userId);
        StringBuffer allSql = new StringBuffer();
        allSql.append(" ( ");
        allSql.append(personSql).append(" union ").append(adminSql).append(" union ").append(roleSql).append(" ) ");
        return allSql.toString();
    }

    public String getHasPermDocIdSqlPerson(Context ctx, String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("3");
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n");
        selectSql.append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n");
        selectSql.append("left outer join t_dm_categoryperson bizperson on bizperson.fparentid = biz.fid  \n");
        selectSql.append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n");
        selectSql.append("where ");
        selectSql.append("(bizperson.FPermList LIKE '%4%' OR ");
        selectSql.append("bizperson.FPermList LIKE '%5%'or bizperson.FPermList LIKE '%3%' or bizperson.FPermList LIKE '%2%') AND (biz.FState < 2)");
        selectSql.append("and (doc.fwfstate > 2 or doc.fauthorId = '" + perId + "' or doc.fcreatePersonId='" + perId + "') and ");
        selectSql.append("(bizperson.FPersonID = '" + perId + "' OR ");
        selectSql.append("bizperson.FPersonID = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("')");
        return selectSql.toString();
    }

    public String getHasPermDocIdSqlAdmin(Context ctx, String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n").append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n").append("inner join t_bd_person author on doc.fauthorid = author.fid \n").append("left outer join t_dm_categoryadmin bizadmin on bizadmin.fparentid = biz.fid  \n").append("left outer join t_dm_categoryrole bizrole on bizrole.fparentid = biz.fid  \n").append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n").append("where   \n").append(" bizadmin.fadminid in(  \n").append("\t\t\t\tSELECT  ADMIN.FID  \n").append("\t\t\t\tFROM T_BD_Person AS PERSON   \n").append("\t\t\t\tINNER JOIN T_HR_PersonPosition AS PP   \n").append("\t\t\t\tON PERSON.FID = PP.FPersonID   \n").append("\t\t\t\tINNER JOIN T_ORG_PositionMember AS PM   \n").append("\t\t\t\tON PERSON.FID = PM.FPersonID   \n").append("\t\t\t\tINNER JOIN T_PM_USER AS PMUSER  \n").append("\t\t\t\tON PMUSER.FPERSONID = PERSON.FID  \n").append("\t\t\t\tINNER JOIN T_ORG_Position AS POSITION   \n").append("\t\t\t\tON PM.FPositionID = POSITION.FID   \n").append("\t\t\t\tINNER JOIN T_ORG_Admin AS ADMIN   \n").append("\t\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '").append(userId).append("'  \n").append("\t\t\t)   \n").append("\n").append("\n").append("\t\tAND (  \n");
        selectSql.append("     (doc.fwfstate=").append(3).append(" and (bizadmin.FPermList like '%4%' or bizadmin.FPermList like '%5%')) \n");
        selectSql.append("      or(  \n");
        selectSql.append("      ((bizadmin.FPermList like '%6%' ) \n");
        selectSql.append("      and doc.fwfstate in (4,5) \n");
        selectSql.append("      and author.fid = '").append(perId).append("')");
        selectSql.append("      or((bizadmin.FPermList like '%6%') \n");
        selectSql.append("      )) \n");
        selectSql.append("      ) \n").append(" and ( biz.fstate = ").append(1).append(" or ").append(" (biz.fstate = ").append(0).append(" and ( ").append(this.makeWhereExpByOperNumSetAdmin(operStrNumSet)).append("))) ");
        return selectSql.toString();
    }

    public String getHasPermDocIdSqlRole(Context ctx, String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n").append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n");
        selectSql.append("inner join t_bd_person author on doc.fauthorid = author.fid \n").append("left outer join t_dm_categoryrole bizrole on bizrole.fparentid = biz.fid  \n").append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n").append("where   \n").append("\t\t\tbizrole.froleid   \n").append("\t\t\tin(  \n").append("\t\t\t\tselect froleid from T_PM_UserRoleOrg where FOrgID = '").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'  \n").append("\t\t\t\tand fuserid = '").append(userId).append("'\n").append("\t\t)  \n").append("\t\tAND \n");
        selectSql.append("((doc.fwfstate=3 and (bizrole.FPermList like '%4%' or bizrole.FPermList like '%5%'))");
        selectSql.append("or ( bizrole.FPermList like '%3%' or bizrole.FPermList like '%2%' or bizrole.FPermList like '%4%')");
        selectSql.append("or (bizrole.FPermList like '%6%' and doc.fwfstate in (4,5) and author.fid = '" + perId + "'))");
        selectSql.append("and (biz.fstate = 1 or  (biz.fstate = 0 and (bizrole.FPermList like '6,%' or  bizrole.FPermList like '%,6' or  bizrole.FPermList like '%,6,%' or bizrole.FPermList = '6'");
        selectSql.append("))) and (doc.fwfstate > 2 or doc.fauthorId = '" + perId + "')");
        return selectSql.toString();
    }

    public String getHasPermDocIdSqlOld(Context ctx, String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("3");
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n").append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n").append("inner join t_bd_person author on doc.fauthorid = author.fid \n").append("left outer join t_dm_categoryadmin bizadmin on bizadmin.fparentid = biz.fid  \n").append("left outer join t_dm_categoryperson bizperson on bizperson.fparentid = biz.fid  \n").append("left outer join t_dm_categoryrole bizrole on bizrole.fparentid = biz.fid  \n").append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n").append("where   \n").append("  (bizperson.fpersonid = '").append(perId).append("'\n or bizperson.fpersonid = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("'\n  or bizadmin.fadminid in(  \n").append("\t\t\t\tSELECT  ADMIN.FID  \n").append("\t\t\t\tFROM T_BD_Person AS PERSON   \n").append("\t\t\t\tINNER JOIN T_HR_PersonPosition AS PP   \n").append("\t\t\t\tON PERSON.FID = PP.FPersonID   \n").append("\t\t\t\tINNER JOIN T_ORG_PositionMember AS PM   \n").append("\t\t\t\tON PERSON.FID = PM.FPersonID   \n").append("\t\t\t\tINNER JOIN T_PM_USER AS PMUSER  \n").append("\t\t\t\tON PMUSER.FPERSONID = PERSON.FID  \n").append("\t\t\t\tINNER JOIN T_ORG_Position AS POSITION   \n").append("\t\t\t\tON PM.FPositionID = POSITION.FID   \n").append("\t\t\t\tINNER JOIN T_ORG_Admin AS ADMIN   \n").append("\t\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '").append(userId).append("'  \n").append("\t\t\t)   \n").append("\t\t\tor bizrole.froleid   \n").append("\t\t\tin(  \n").append("\t\t\t\tselect froleid from T_PM_UserRoleOrg where FOrgID = '").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'  \n").append("\t\t\t\tand fuserid = '").append(userId).append("'\n").append("\t\t\t)  \n").append("\t\t)  \n").append("\n").append("\n").append("\t\tAND (  \n").append("\t\t\t\t((bizadmin.FPermList != '6' or bizperson.FPermList != '6' or bizrole.FPermList !='6' or  \n").append("\t\t\t\t\tbizadmin.FPermList not like '6,%' or bizperson.FPermList not like '6,%' or bizrole.FPermList not like '6,%' or \n").append("\t\t\t\t\tbizadmin.FPermList not like '%,6,%' or bizperson.FPermList not like '%,6,%' or bizrole.FPermList not like '%,6,%' or \n").append("\tbizadmin.FPermList not like '%,6' or bizperson.FPermList not like '%,6' or bizrole.FPermList not like '%,6' \n").append("\t\t\t\t) and ((doc.fwfstate in (").append(0).append(",").append(2).append(",").append(4).append(",").append(5).append(") and author.fid = '").append(perId).append("') or  doc.fwfstate = ").append(3).append(") \n").append("\t\t\t\t) \n").append("\t\t\t\tor \n").append("\t((bizadmin.FPermList = '6' or bizperson.FPermList = '6' or bizrole.FPermList ='6' or \n").append("\t\t\t\t\tbizadmin.FPermList like '6,%' or bizperson.FPermList like '6,%' or bizrole.FPermList like '6,%' or \n").append("\t\t\t\t\tbizadmin.FPermList like '%,6,%' or bizperson.FPermList like '%,6,%' or bizrole.FPermList like '%,6,%' or \n").append("\tbizadmin.FPermList like '%,6' or bizperson.FPermList like '%,6' or bizrole.FPermList like '%,6' \n").append("\t\t\t\t) and ((doc.fwfstate in (").append(0).append(",").append(2).append(") and author.fid = '").append(perId).append("') or  doc.fwfstate in (").append(3).append(",").append(4).append(",").append(5).append(")) \n").append("\t\t\t\t) \n").append("\t)   \n").append("\n").append("\n").append(" and ( biz.fstate = ").append(1).append(" or ").append(" (biz.fstate = ").append(0).append(" and ( ").append(this.makeWhereExpByOperNumSet("", operStrNumSet)).append("))) ");
        return selectSql.toString();
    }

    protected String getUserSqlByRole(Context ctx, String orgId, List<String> roleIdList) throws BOSException, EASBizException {
        assert (roleIdList != null);
        String oId = orgId;
        if (orgId == null) {
            oId = ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT UserRoleOrg.FUserID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_User U ON U.FID = UserRoleOrg.FUserID ").append(" WHERE UserRoleOrg.FOrgID = '").append(oId).append("' AND UserRoleOrg.FRoleID in ").append(CommonUtils.getStrFromList(roleIdList));
        return sql.toString();
    }

    protected UserCollection getUsers(Context ctx, IObjectPK orgPK, IObjectPK rolePK) throws BOSException, EASBizException {
        assert (orgPK != null && rolePK != null);
        try {
            UserCollection collection = new UserCollection();
            StringBuffer sql = new StringBuffer(200);
            String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
            Object[] params = new Object[]{orgPK.toString(), rolePK.toString()};
            sql.append("SELECT UserRoleOrg.FUserID, ").append(" U.FNumber , U.").append(nameField).append(" FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_User U ON U.FID = UserRoleOrg.FUserID ").append(" WHERE UserRoleOrg.FOrgID = ? ").append(" AND UserRoleOrg.FRoleID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FUserID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                userInfo.setName(rowSet.getString(nameField));
                collection.add(userInfo);
            }
            return collection;
        }
        catch (SQLException e) {
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, (Throwable)e);
        }
    }

    private String getColumnValue(Context ctx, String sqlStr, String fieldName) {
        String rtnVal = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rs.next()) {
                try {
                    rtnVal = rs.getString(fieldName);
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rtnVal;
    }

    public Map<String, Set<String>> getHasPermDimIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        this.getHasPermDimIdSetPerson(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermDimIdSetAdmin(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermDimIdSetRole(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        return daCatMap;
    }

    public Map<String, Set<String>> getHasPermDimIdSetPerson(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        Map<String, Set<String>> rtnMap = daCatMap;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("13");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_dimension";
        }
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizperson.FPermList,biz.fid, biz.FLv1dimensionID as lv1dim  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        if (tempSet.size() != 0) {
            selectSql.append("   (bizperson.fpersonid = '");
            selectSql.append(perId);
            selectSql.append("' or bizperson.fpersonid = '");
            if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
                selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
            } else {
                selectSql.append("nodata");
            }
            selectSql.append("'     ) \n");
            selectSql.append(" AND");
        }
        selectSql.append("   biz.FLv1dimensionID in");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetPerson(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("lv1dim");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermDimIdSetAdmin(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("13");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_dimension";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizadmin.FPermList,biz.fid, biz.FLv1dimensionID as lv1dim  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("adminorg bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   ( ");
        selectSql.append(" bizadmin.FAdminOrgID  \n");
        selectSql.append("      in( \n");
        selectSql.append("          SELECT  ADMIN.FID \n");
        selectSql.append("          FROM T_BD_Person AS PERSON  \n");
        selectSql.append("          INNER JOIN T_HR_PersonPosition AS PP  \n");
        selectSql.append("          ON PERSON.FID = PP.FPersonID  \n");
        selectSql.append("          INNER JOIN T_ORG_PositionMember AS PM  \n");
        selectSql.append("          ON PERSON.FID = PM.FPersonID  \n");
        selectSql.append("          INNER JOIN T_PM_USER AS PMUSER \n");
        selectSql.append("          ON PMUSER.FPERSONID = PERSON.FID \n");
        selectSql.append("          INNER JOIN T_ORG_Position AS POSITION  \n");
        selectSql.append("          ON PM.FPositionID = POSITION.FID  \n");
        selectSql.append("          INNER JOIN T_ORG_Admin AS ADMIN  \n");
        selectSql.append("           ON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("      )  \n");
        selectSql.append("  ) \n");
        selectSql.append("  and  biz.FLv1dimensionID in");
        selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetAdmin(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("lv1dim");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)e.getMessage());
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermDimIdSetRole(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("13");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_dimension";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizrole.FPermList,biz.fid, biz.FLv1dimensionID as lv1dim  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   ( ");
        selectSql.append("      bizrole.froleid  \n");
        selectSql.append("      in( \n");
        selectSql.append("           select froleid from T_PM_UserRoleOrg where FOrgID = '");
        selectSql.append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        selectSql.append("'  \n");
        selectSql.append("          and fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("      ) \n");
        selectSql.append("  ) \n");
        if (bizIdSet.size() <= 0) {
            selectSql.append("   and biz.FLv1dimensionID='nodata' ");
        } else {
            selectSql.append("  and biz.FLv1dimensionID in");
            selectSql.append(com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(bizIdSet));
            selectSql.append("  \n");
        }
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetRole(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("lv1dim");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            LOGGER.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            LOGGER.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    private Map getCurrentUserAdminIncludeParent(Context ctx, String userId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        HashSet<String> adminIdSet = new HashSet<String>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("          SELECT  ADMIN.FID,ADMIN.FLONGNUMBER \n");
        selectSql.append("          FROM T_BD_Person AS PERSON  \n");
        selectSql.append("          INNER JOIN T_HR_PersonPosition AS PP  \n");
        selectSql.append("          ON PERSON.FID = PP.FPersonID  \n");
        selectSql.append("          INNER JOIN T_ORG_PositionMember AS PM  \n");
        selectSql.append("          ON PERSON.FID = PM.FPersonID  \n");
        selectSql.append("          INNER JOIN T_PM_USER AS PMUSER \n");
        selectSql.append("          ON PMUSER.FPERSONID = PERSON.FID \n");
        selectSql.append("          INNER JOIN T_ORG_Position AS POSITION  \n");
        selectSql.append("          ON PM.FPositionID = POSITION.FID  \n");
        selectSql.append("          INNER JOIN T_ORG_Admin AS ADMIN  \n");
        selectSql.append("           ON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                resMap.put(userId, rs.getString("FID"));
                String longNumber = rs.getString("FLONGNUMBER");
                Object s = null;
                String[] numberArr = longNumber.split("!");
                String insql = com.kingdee.eas.cp.dm.utils.CommonUtils.getStrFromSet(new HashSet<String>(Arrays.asList(numberArr)));
                rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID FROM T_ORG_Admin WHERE FNUMBER IN " + insql + ""));
                while (rs.next()) {
                    adminIdSet.add(rs.getString("FID"));
                }
                resMap.put((String)resMap.get(userId), adminIdSet);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resMap;
    }
}

