/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Set;

public class CommonUtils {
    public static final String PORTLET_DELETE_PERMISSION = "cp_dm_portlet_delete";
    public static final String PORTLET_CANCEL_PERMISSION = "cp_dm_portlet_cancel";
    public static final String PORTLET_CANCELCANCEL_PERMISSION = "cp_dm_portlet_cancelCancel";

    public static String getStrFromList(List<String> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append(list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append(list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append(list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static String getStrFromSet(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        int len = set.size();
        for (String s : set) {
            sb.append("'").append(s).append("'");
            if (i < len - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getPersonId(Context ctx) {
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            return ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        return null;
    }

    public static String getUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
    }

    public static String getCUId(Context ctx) {
        return ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
    }

    public static boolean isExistsPermission(Context ctx, String permissionItem) {
        boolean flag = false;
        if (StringUtils.isEmpty((String)permissionItem)) {
            return flag;
        }
        try {
            CommonUtils.checkPermission(ctx, permissionItem);
            flag = true;
        }
        catch (EASBizException e) {
            System.out.println("NO Permission");
            flag = false;
        }
        catch (BOSException e) {
            System.out.println("NO Permission");
            flag = false;
        }
        return flag;
    }

    public static void checkPermission(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (cuId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(cuId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }
}

