/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.search;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.fts.app.HighlightFinder;
import com.kingdee.eas.cp.eip.fts.app.I_TermHighlighter;
import com.kingdee.eas.cp.eps.ISearchResource;
import com.kingdee.eas.cp.eps.ModuleInfo;
import com.kingdee.eas.cp.eps.SearchResourceFactory;
import com.kingdee.eas.cp.eps.SearchResourceInfo;
import com.kingdee.eas.cp.eps.analysis.AnalyzerManager;
import com.kingdee.eas.cp.eps.plugin.IModulePlugin;
import com.kingdee.eas.cp.eps.plugin.ModulePluginFactory;
import com.kingdee.eas.cp.eps.search.SearchParameters;
import com.kingdee.eas.cp.eps.search.SearchResult;
import com.kingdee.eas.cp.eps.utils.EPSUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.document.Document;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.queryParser.ParseException;
import org.apache.lucene1.queryParser.QueryParser;
import org.apache.lucene1.search.BooleanQuery;
import org.apache.lucene1.search.Hits;
import org.apache.lucene1.search.IndexSearcher;
import org.apache.lucene1.search.MultiSearcher;
import org.apache.lucene1.search.Query;
import org.apache.lucene1.search.Searchable;
import org.apache.lucene1.search.TermQuery;
import org.apache.lucene1.store.Directory;
import org.apache.lucene1.store.FSDirectory;

public class SearchManager {
    public static final String knowledgeID = "m+gpp9QsS9C8wDVHlCzm1+IeFuU=";

    public synchronized List search(Context ctx, SearchParameters sp) {
        ArrayList<ModuleInfo> moduleList = new ArrayList<ModuleInfo>();
        try {
            ISearchResource service = SearchResourceFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("isDisable"));
            sic.add(new SelectorItemInfo("domain.id"));
            sic.add(new SelectorItemInfo("domain.name"));
            sic.add(new SelectorItemInfo("e1.id"));
            sic.add(new SelectorItemInfo("e1.module.id"));
            sic.add(new SelectorItemInfo("e1.module.name"));
            sic.add(new SelectorItemInfo("e1.module.number"));
            sic.add(new SelectorItemInfo("e1.module.className"));
            sic.add(new SelectorItemInfo("e1.module.lastRefreshTime"));
            sic.add(new SelectorItemInfo("e1.module.isBuilding"));
            SearchResourceInfo info = (SearchResourceInfo)service.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)knowledgeID)), sic);
            if (!info.isIsDisable() && info.getE1() != null && info.getE1().size() > 0) {
                int size = info.getE1().size();
                for (int n = 0; n < size; ++n) {
                    ModuleInfo moduleInfo = info.getE1().get(n).getModule();
                    if (StringUtils.isEmpty((String)moduleInfo.getClassName()) || !StringUtils.isEmpty((String)sp.getModule()) && !moduleInfo.getNumber().equals(sp.getModule())) continue;
                    moduleList.add(moduleInfo);
                }
            }
            if (moduleList.size() == 0) {
                return null;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return this.search(ctx, moduleList, sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List search(Context ctx, List moduleList, SearchParameters sp) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        IndexSearcher[] searchers = this.getIndexSearchers(ctx, moduleList);
        Map pluginMap = this.getPluginMap(ctx, moduleList);
        Query query = this.getQuery(sp);
        MultiSearcher multisearcher = null;
        try {
            multisearcher = new MultiSearcher((Searchable[])searchers);
            Hits hits = multisearcher.search(query);
            int hitCount = hits.length();
            String excerpt = null;
            boolean timeFilter = !StringUtils.isEmpty((String)sp.getTimeRange());
            String startTime = "";
            String endTime = "";
            if (timeFilter) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                startTime = sp.getStartTime() == null ? "" : dateFormat.format(sp.getStartTime());
                endTime = sp.getEndTime() == null ? "" : dateFormat.format(sp.getEndTime());
            }
            boolean categoryFilter = !StringUtils.isEmpty((String)sp.getCategory());
            boolean attachFilter = !StringUtils.isEmpty((String)sp.getAttachType());
            boolean hasPerm = true;
            if (hits != null) {
                int cnt = 0;
                for (int i = 0; i < hitCount; ++i) {
                    Document doc = hits.doc(i);
                    if (timeFilter && (startTime != "" && startTime.compareTo(doc.getField("createTime") == null ? "999" : doc.getField("createTime").stringValue()) > 0 || endTime != "" && endTime.compareTo(doc.getField("createTime") == null ? "" : doc.getField("createTime").stringValue()) < 0) || categoryFilter && !sp.getCategory().equals(doc.getField("category") == null ? "" : doc.getField("category").stringValue()) || attachFilter && (doc.getField("attachType") == null ? "" : doc.getField("attachType").stringValue()).indexOf(sp.getAttachType()) < 0 && (!"rar".equals(sp.getAttachType()) || (doc.getField("attachType") == null ? "" : doc.getField("attachType").stringValue()).indexOf("zip") <= -1) && (!"swf".equals(sp.getAttachType()) || (doc.getField("attachType") == null ? "" : doc.getField("attachType").stringValue()).indexOf("fla") <= -1) || !(hasPerm = true)) continue;
                    excerpt = doc.getField("content") != null && doc.getField("content").stringValue() != null ? this.getExcerpt(doc.getField("content").stringValue(), query, this.getAnalyzer()) : null;
                    SearchResult searchResult = new SearchResult(i, Math.round(hits.score(i) * 100.0f), doc, excerpt);
                    result.add(searchResult);
                    ++cnt;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (multisearcher != null) {
                try {
                    multisearcher.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private boolean hasReadPermission(IModulePlugin modulePlugin, String bizID) {
        boolean result = true;
        try {
            result = modulePlugin.hasPermission(bizID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getExcerpt(String content, Query searchQuery, Analyzer analyzer) throws IOException {
        if (content == null) {
            return null;
        }
        I_TermHighlighter termHighlighterHtml = new I_TermHighlighter(){

            public int highlightLength() {
                return 27;
            }

            public String highlightTerm(String term) {
                return term;
            }
        };
        HighlightFinder highlighter = new HighlightFinder(termHighlighterHtml, searchQuery, analyzer);
        String excerpt = highlighter.getBestFragments(content, 140, 5, " ... ");
        excerpt = excerpt.replace('\t', ' ');
        excerpt = excerpt.replace('\n', ' ');
        excerpt = excerpt.replace('\r', ' ');
        excerpt = excerpt.replace('\f', ' ');
        int maxLength = 200;
        int lightLen = highlighter.getScore() * termHighlighterHtml.highlightLength();
        if (excerpt != null && excerpt.length() > maxLength + lightLen) {
            excerpt = excerpt.substring(0, maxLength + lightLen);
        }
        return excerpt;
    }

    private Analyzer getAnalyzer() {
        return AnalyzerManager.getAnalyzer();
    }

    private Query getQuery(SearchParameters sp) {
        BooleanQuery bQuery = new BooleanQuery();
        BooleanQuery fieldsQuery = new BooleanQuery();
        try {
            Query t_Query = QueryParser.parse((String)sp.getFakeKey(), (String)"content", (Analyzer)this.getAnalyzer());
            fieldsQuery.add(t_Query, false, false);
            Query t_Query2 = QueryParser.parse((String)sp.getFakeKey(), (String)"title", (Analyzer)this.getAnalyzer());
            fieldsQuery.add(t_Query2, false, false);
            Query t_Query3 = QueryParser.parse((String)sp.getFakeKey(), (String)"createuser", (Analyzer)this.getAnalyzer());
            fieldsQuery.add(t_Query3, false, false);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        bQuery.add((Query)fieldsQuery, true, false);
        return bQuery;
    }

    private Map getPluginMap(Context ctx, List moduleList) {
        HashMap<String, IModulePlugin> pluginMap = new HashMap<String, IModulePlugin>();
        int size = moduleList.size();
        for (int n = 0; n < size; ++n) {
            ModuleInfo moduleInfo = (ModuleInfo)moduleList.get(n);
            try {
                pluginMap.put(moduleInfo.getNumber(), ModulePluginFactory.getModulePlugin(ctx, moduleInfo));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return pluginMap;
    }

    private IndexSearcher[] getIndexSearchers(Context ctx, List moduleList) {
        IndexSearcher[] searchers = new IndexSearcher[moduleList.size()];
        int size = moduleList.size();
        for (int n = 0; n < size; ++n) {
            ModuleInfo moduleInfo = (ModuleInfo)moduleList.get(n);
            try {
                searchers[n] = new IndexSearcher(EPSUtils.getIndexDbPath(ctx.getAIS(), moduleInfo.getNumber()));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return searchers;
    }

    public List search(Context ctx, ModuleInfo moduleInfo, SearchParameters sp, int page, int matchesPerPage) {
        List result = null;
        String indexPath = EPSUtils.getIndexDbPath(ctx.getAIS(), moduleInfo.getNumber());
        try {
            FSDirectory fsDir = FSDirectory.getDirectory((String)indexPath, (boolean)false);
            IndexSearcher searcher = new IndexSearcher((Directory)fsDir);
            BooleanQuery bQuery = new BooleanQuery();
            Term term = new Term("content", sp.getKey());
            TermQuery termQuery = new TermQuery(term);
            bQuery.add((Query)termQuery, true, false);
            Hits hits = searcher.search((Query)bQuery);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

