/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.search;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.cp.eip.mc.web.URLInfo;
import com.kingdee.eas.cp.eps.search.AbstractSearcher;
import com.kingdee.eas.cp.eps.search.SearchParameters;
import com.kingdee.eas.cp.eps.utils.EPSUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkflowSearcher
extends AbstractSearcher {
    private static Logger logger = Logger.getLogger((String)WorkflowSearcher.class.getName());
    private static final String queryPackage = "com.kingdee.bos.workflow.metas";
    private static final String queryName = "AssignUnionQuery";

    public FilterInfo getFilterInfo() {
        StringBuffer sb = new StringBuffer("");
        sb.append(" PERSONUSERID = '" + this.getCtx().getCaller().toString() + "'");
        sb.append(" and SUBJECT");
        sb.append(" ");
        sb.append("like");
        sb.append(" ");
        sb.append("'");
        sb.append("%");
        sb.append("" + this.queryKey + "");
        sb.append("%");
        sb.append("'");
        sb.append(" and BIZPACKAGE like 'com.kingdee.eas.cp.%'");
        if (this.sp != null && !StringUtils.isEmpty((String)this.sp.getModule())) {
            sb.append(" and BIZPACKAGE like '%." + this.sp.getModule() + ".%' ");
        }
        String as = sb.toString();
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(as);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    public List getAllData(SearchParameters sp) {
        this.sp = sp;
        this.queryKey = sp.getKey();
        LinkedList<Map> pageList = new LinkedList<Map>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getSql());
            if (rs != null) {
                this.totalCount = rs.size();
                while (rs.next()) {
                    pageList.add(this.getRowResult(rs));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pageList;
    }

    protected IMetaDataPK getQueryPK() {
        return new MetaDataPK(queryPackage, queryName);
    }

    protected Map getRowResult(IRowSet rowSet) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            result.put("dtype", "flow");
            result.put("flowtype", rowSet.getString("flowType"));
            result.put("procName", rowSet.getString("PROCDEFNAME"));
            result.put("assignID", rowSet.getString("ASSIGNID"));
            result.put("title", rowSet.getString("SUBJECT"));
            result.put("state", rowSet.getString("STATE"));
            result.put("package", rowSet.getString("BILLENTITY"));
            result.put("module", EPSUtils.getModuleName(rowSet.getString("BILLENTITY")));
            result.put("person", rowSet.getString("PERSONEMPNAME"));
            result.put("initiator", rowSet.getString("INITIATOR"));
            result.put("bizObjID", rowSet.getString("BIZOBJID"));
            result.put("personID", rowSet.getString("PERSONEMPID"));
            result.put("createTime", rowSet.getDate("CREATEDTIME") == null ? "" : new SimpleDateFormat("yyyy-MM-dd HH:mm").format(rowSet.getDate("CREATEDTIME")));
            result.put("url", this.getUrl(rowSet));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected String getUrl(IRowSet rowSet) {
        return "";
    }

    private String getSql() {
        Timestamp d;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ( ");
        sql.append("\t\tSELECT 'todo' as flowType,'001' as serial, ");
        sql.append("\t\tASSIGN.FASSIGNID AS ASSIGNID,  ");
        sql.append("\t\tASSIGN.FSUBJECT_l2 AS SUBJECT,  ");
        sql.append("ASSIGN.FSTATE AS STATE, ");
        sql.append("ASSIGN.FPERSONUSERID AS PERSONUSERID, ");
        sql.append("ASSIGN.FPERSONUSERNAME_l2 AS PERSONUSERNAME, ");
        sql.append("ASSIGN.FPERSONEMPID AS PERSONEMPID, ");
        sql.append("PROCINST.finitiatorname_l2 AS INITIATOR, ");
        sql.append("ASSIGN.FPERSONEMPNAME_l2 AS PERSONEMPNAME, ");
        sql.append("ASSIGN.FPERFORMERUID AS PERFORMERUID, ");
        sql.append("ASSIGN.FPERFORMERUNAME_l2 AS PERFORMERUNAME, ");
        sql.append("ASSIGN.FPERFORMEREID AS PERFORMEREID,  ");
        sql.append("ASSIGN.FPERFORMERENAME_l2 AS PERFORMERENAME,  ");
        sql.append("ASSIGN.FACTINSTID AS ACTINSTID,  ");
        sql.append("ASSIGN.FACTDEFID AS ACTDEFID,  ");
        sql.append("ASSIGN.FACTDEFNAME_l2 AS ACTDEFNAME,  ");
        sql.append("ASSIGN.FPROCDEFHASH AS PROCDEFHASH,  ");
        sql.append("ASSIGN.FPROCDEFID AS PROCDEFID,  ");
        sql.append("ASSIGN.FPROCDEFNAME_l2 AS PROCDEFNAME,  ");
        sql.append("ASSIGN.FPROCINSTID AS PROCINSTID,  ");
        sql.append("ASSIGN.FENDTIME AS ENDTIME,  ");
        sql.append("ASSIGN.FLASTSTATETIME AS LASTSTATETIME,  ");
        sql.append("ASSIGN.FCREATEDTIME AS CREATEDTIME,  ");
        sql.append("ASSIGN.FACCEPTTIME AS ACCEPTTIME,  ");
        sql.append("ASSIGN.FBIZPACKAGE AS BIZPACKAGE,  ");
        sql.append("ASSIGN.FBIZFUNCTION AS BIZFUNCTION,  ");
        sql.append("ASSIGN.FBIZOPERATION AS BIZOPERATION,  ");
        sql.append("ASSIGN.FBIZOBJID AS BIZOBJID,  ");
        sql.append("ASSIGN.FAPPDEFID AS APPDEFID,  ");
        sql.append("ASSIGN.FPRIORITY AS PRIORITY,  ");
        sql.append("ASSIGN.FWAITINGTIME AS WAITINGTIME,  ");
        sql.append("ASSIGN.FDURATION AS DURATION,  ");
        sql.append("ASSIGN.FWORKINGTIME AS WORKINGTIME,  ");
        sql.append("ASSIGN.FIsSendMsg AS ISSENDMSG,  ");
        sql.append("ASSIGN.FPRIORPERFORMER AS PRIORPERFORMERID,  ");
        sql.append("ASSIGN.FPRIORPERFORMERNAME_l2 AS PRIORPERFORMNAME,  ");
        sql.append("ASSIGN.FBILLENTITY AS BILLENTITY ");
        sql.append("FROM T_WFR_Assign AS ASSIGN ,T_WFR_PROCINST as PROCINST ");
        sql.append("where ASSIGN.FPROCINSTID = PROCINST.FPROCINSTID  ");
        sql.append("and ASSIGN.FBILLENTITY LIKE 'com.kingdee.eas.cp.%' ");
        sql.append("and ASSIGN.FPERSONUSERID = '" + this.ctx.getCaller().toString() + "' ");
        sql.append("union all ");
        sql.append("SELECT 'done' as flowType,'004' as serial, ");
        sql.append("ASSIGN.FASSIGNID AS ASSIGNID,  ");
        sql.append("ASSIGN.FSUBJECT_l2 AS SUBJECT,  ");
        sql.append("ASSIGN.FSTATE AS STATE,  ");
        sql.append("ASSIGN.FPERSONUSERID AS PERSONUSERID,  ");
        sql.append("ASSIGN.FPERSONUSERNAME_l2 AS PERSONUSERNAME,  ");
        sql.append("ASSIGN.FPERSONEMPID AS PERSONEMPID,  ");
        sql.append("PROCINST.finitiatorname_l2 AS INITIATOR, ");
        sql.append("ASSIGN.FPERSONEMPNAME_l2 AS PERSONEMPNAME,  ");
        sql.append("ASSIGN.FPERFORMERUID AS PERFORMERUID,  ");
        sql.append("ASSIGN.FPERFORMERUNAME_l2 AS PERFORMERUNAME,  ");
        sql.append("ASSIGN.FPERFORMEREID AS PERFORMEREID,  ");
        sql.append("ASSIGN.FPERFORMERENAME_l2 AS PERFORMERENAME,  ");
        sql.append("ASSIGN.FACTINSTID AS ACTINSTID,  ");
        sql.append("ASSIGN.FACTDEFID AS ACTDEFID,  ");
        sql.append("ASSIGN.FACTDEFNAME_l2 AS ACTDEFNAME,  ");
        sql.append("ASSIGN.FPROCDEFHASH AS PROCDEFHASH,  ");
        sql.append("ASSIGN.FPROCDEFID AS PROCDEFID,  ");
        sql.append("ASSIGN.FPROCDEFNAME_l2 AS PROCDEFNAME,  ");
        sql.append("ASSIGN.FPROCINSTID AS PROCINSTID,  ");
        sql.append("ASSIGN.FENDTIME AS ENDTIME,  ");
        sql.append("ASSIGN.FLASTSTATETIME AS LASTSTATETIME,  ");
        sql.append("ASSIGN.FLASTSTATETIME AS CREATEDTIME,  ");
        sql.append("ASSIGN.FACCEPTTIME AS ACCEPTTIME,  ");
        sql.append("ASSIGN.FBIZPACKAGE AS BIZPACKAGE,  ");
        sql.append("ASSIGN.FBIZFUNCTION AS BIZFUNCTION,  ");
        sql.append("ASSIGN.FBIZOPERATION AS BIZOPERATION,  ");
        sql.append("ASSIGN.FBIZOBJID AS BIZOBJID,  ");
        sql.append("ASSIGN.FAPPDEFID AS APPDEFID,  ");
        sql.append("ASSIGN.FPRIORITY AS PRIORITY,  ");
        sql.append("ASSIGN.FWAITINGTIME AS WAITINGTIME,  ");
        sql.append("ASSIGN.FDURATION AS DURATION,  ");
        sql.append("ASSIGN.FWORKINGTIME AS WORKINGTIME,  ");
        sql.append("ASSIGN.FIsSendMsg AS ISSENDMSG,  ");
        sql.append("ASSIGN.FPRIORPERFORMER AS PRIORPERFORMERID,  ");
        sql.append("ASSIGN.FPRIORPERFORMERNAME_l2 AS PRIORPERFORMNAME,  ");
        sql.append("ASSIGN.FBILLENTITY AS BILLENTITY ");
        sql.append("FROM T_WFR_AssignDetail AS ASSIGN ,T_WFR_PROCINST as PROCINST ");
        sql.append("where ASSIGN.FPROCINSTID = PROCINST.FPROCINSTID  ");
        sql.append("AND ASSIGN.FBILLENTITY LIKE 'com.kingdee.eas.cp.%' ");
        sql.append("and ASSIGN.FSTATE != 4 ");
        sql.append("and ASSIGN.FPERSONUSERID = '" + this.ctx.getCaller().toString() + "' ");
        sql.append("union all ");
        sql.append("SELECT 'done' as flowType,'004' as serial, ");
        sql.append("ASSIGN.FASSIGNID AS ASSIGNID,  ");
        sql.append("ASSIGN.FSUBJECT_l2 AS SUBJECT,  ");
        sql.append("ASSIGN.FSTATE AS STATE,  ");
        sql.append("ASSIGN.FPERSONUSERID AS PERSONUSERID,  ");
        sql.append("ASSIGN.FPERSONUSERNAME_l2 AS PERSONUSERNAME,  ");
        sql.append("ASSIGN.FPERSONEMPID AS PERSONEMPID,  ");
        sql.append("PROCINST.finitiatorname_l2 AS INITIATOR, ");
        sql.append("ASSIGN.FPERSONEMPNAME_l2 AS PERSONEMPNAME,  ");
        sql.append("ASSIGN.FPERFORMERUID AS PERFORMERUID,  ");
        sql.append("ASSIGN.FPERFORMERUNAME_l2 AS PERFORMERUNAME,  ");
        sql.append("ASSIGN.FPERFORMEREID AS PERFORMEREID,  ");
        sql.append("ASSIGN.FPERFORMERENAME_l2 AS PERFORMERENAME,  ");
        sql.append("ASSIGN.FACTINSTID AS ACTINSTID,  ");
        sql.append("ASSIGN.FACTDEFID AS ACTDEFID,  ");
        sql.append("ASSIGN.FACTDEFNAME_l2 AS ACTDEFNAME,  ");
        sql.append("ASSIGN.FPROCDEFHASH AS PROCDEFHASH,  ");
        sql.append("ASSIGN.FPROCDEFID AS PROCDEFID,  ");
        sql.append("ASSIGN.FPROCDEFNAME_l2 AS PROCDEFNAME,  ");
        sql.append("ASSIGN.FPROCINSTID AS PROCINSTID,  ");
        sql.append("ASSIGN.FENDTIME AS ENDTIME,  ");
        sql.append("ASSIGN.FLASTSTATETIME AS LASTSTATETIME,  ");
        sql.append("ASSIGN.FLASTSTATETIME AS CREATEDTIME,  ");
        sql.append("ASSIGN.FACCEPTTIME AS ACCEPTTIME,  ");
        sql.append("ASSIGN.FBIZPACKAGE AS BIZPACKAGE,  ");
        sql.append("ASSIGN.FBIZFUNCTION AS BIZFUNCTION,  ");
        sql.append("ASSIGN.FBIZOPERATION AS BIZOPERATION,  ");
        sql.append("ASSIGN.FBIZOBJID AS BIZOBJID,  ");
        sql.append("ASSIGN.FAPPDEFID AS APPDEFID,  ");
        sql.append("ASSIGN.FPRIORITY AS PRIORITY,  ");
        sql.append("ASSIGN.FWAITINGTIME AS WAITINGTIME,  ");
        sql.append("ASSIGN.FDURATION AS DURATION,  ");
        sql.append("ASSIGN.FWORKINGTIME AS WORKINGTIME,  ");
        sql.append("ASSIGN.FIsSendMsg AS ISSENDMSG,  ");
        sql.append("ASSIGN.FPRIORPERFORMER AS PRIORPERFORMERID,  ");
        sql.append("ASSIGN.FPRIORPERFORMERNAME_l2 AS PRIORPERFORMNAME,  ");
        sql.append("ASSIGN.FBILLENTITY AS BILLENTITY ");
        sql.append("FROM T_WFR_Assignhst AS ASSIGN ,T_WFR_PROCINSThst as PROCINST ");
        sql.append("where ASSIGN.FPROCINSTID = PROCINST.FPROCINSTID  ");
        sql.append("AND ASSIGN.FBILLENTITY LIKE 'com.kingdee.eas.cp.%' ");
        sql.append("and ASSIGN.FSTATE != 4 ");
        sql.append("and ASSIGN.FPERSONUSERID = '" + this.ctx.getCaller().toString() + "' ");
        sql.append("union all ");
        sql.append("SELECT 'mine' as flowType,'003' as serial, ");
        sql.append("ASSIGN.FASSIGNID AS ASSIGNID,  ");
        sql.append("ASSIGN.FSUBJECT_l2 AS SUBJECT,  ");
        sql.append("ASSIGN.FSTATE AS STATE,  ");
        sql.append("ASSIGN.FPERSONUSERID AS PERSONUSERID,  ");
        sql.append("ASSIGN.FPERSONUSERNAME_l2 AS PERSONUSERNAME,  ");
        sql.append("ASSIGN.FPERSONEMPID AS PERSONEMPID,  ");
        sql.append("PROCINST.finitiatorname_l2 AS INITIATOR, ");
        sql.append("ASSIGN.FPERSONEMPNAME_l2 AS PERSONEMPNAME,  ");
        sql.append("ASSIGN.FPERFORMERUID AS PERFORMERUID,  ");
        sql.append("ASSIGN.FPERFORMERUNAME_l2 AS PERFORMERUNAME,  ");
        sql.append("ASSIGN.FPERFORMEREID AS PERFORMEREID,  ");
        sql.append("ASSIGN.FPERFORMERENAME_l2 AS PERFORMERENAME,  ");
        sql.append("ASSIGN.FACTINSTID AS ACTINSTID,  ");
        sql.append("ASSIGN.FACTDEFID AS ACTDEFID,  ");
        sql.append("ASSIGN.FACTDEFNAME_l2 AS ACTDEFNAME,  ");
        sql.append("ASSIGN.FPROCDEFHASH AS PROCDEFHASH,  ");
        sql.append("ASSIGN.FPROCDEFID AS PROCDEFID,  ");
        sql.append("ASSIGN.FPROCDEFNAME_l2 AS PROCDEFNAME,  ");
        sql.append("ASSIGN.FPROCINSTID AS PROCINSTID,  ");
        sql.append("ASSIGN.FENDTIME AS ENDTIME,  ");
        sql.append("ASSIGN.FLASTSTATETIME AS LASTSTATETIME,  ");
        sql.append("PROCINST.FCREATEDTIME AS CREATEDTIME,  ");
        sql.append("ASSIGN.FACCEPTTIME AS ACCEPTTIME,  ");
        sql.append("ASSIGN.FBIZPACKAGE AS BIZPACKAGE,  ");
        sql.append("ASSIGN.FBIZFUNCTION AS BIZFUNCTION,  ");
        sql.append("ASSIGN.FBIZOPERATION AS BIZOPERATION,  ");
        sql.append("ASSIGN.FBIZOBJID AS BIZOBJID,  ");
        sql.append("ASSIGN.FAPPDEFID AS APPDEFID,  ");
        sql.append("ASSIGN.FPRIORITY AS PRIORITY,  ");
        sql.append("ASSIGN.FWAITINGTIME AS WAITINGTIME,  ");
        sql.append("ASSIGN.FDURATION AS DURATION,  ");
        sql.append("ASSIGN.FWORKINGTIME AS WORKINGTIME,  ");
        sql.append("ASSIGN.FIsSendMsg AS ISSENDMSG,  ");
        sql.append("ASSIGN.FPRIORPERFORMER AS PRIORPERFORMERID,  ");
        sql.append("ASSIGN.FPRIORPERFORMERNAME_l2 AS PRIORPERFORMNAME,  ");
        sql.append("ASSIGN.FBILLENTITY AS BILLENTITY ");
        sql.append("FROM T_WFR_Assign AS ASSIGN ,T_WFR_PROCINST as PROCINST ");
        sql.append("where ASSIGN.FPROCINSTID = PROCINST.FPROCINSTID  ");
        sql.append("AND ASSIGN.FBILLENTITY LIKE 'com.kingdee.eas.cp.%' ");
        sql.append("and ASSIGN.FSTATE != 4 ");
        sql.append("and PROCINST.FINITIATORID = '" + this.ctx.getCaller().toString() + "') AS ASSIGNQUERY ");
        sql.append("WHERE (ASSIGNQUERY.SUBJECT LIKE '%" + this.queryKey + "%' or ASSIGNQUERY.PROCDEFNAME LIKE '%" + this.queryKey + "%') ");
        if (!StringUtils.isEmpty((String)this.sp.getState())) {
            sql.append("AND ASSIGNQUERY.flowType = '" + this.sp.getState() + "' ");
        }
        if (StringUtils.isEmpty((String)this.sp.getModule())) {
            sql.append("AND ASSIGNQUERY.BILLENTITY LIKE 'com.kingdee.eas.cp.%' ");
        } else if ("cm".equals(this.sp.getModule())) {
            sql.append("AND ASSIGNQUERY.BILLENTITY LIKE 'com.kingdee.eas.cp.eip.cm.%' ");
        } else {
            sql.append("AND ASSIGNQUERY.BILLENTITY LIKE 'com.kingdee.eas.cp." + this.sp.getModule() + ".%' ");
        }
        if (this.sp.getStartTime() != null) {
            d = new Timestamp(this.sp.getStartTime().getTime());
            sql.append("AND ASSIGNQUERY.CREATEDTIME > {" + d + "} ");
        }
        if (this.sp.getEndTime() != null) {
            d = new Timestamp(this.sp.getEndTime().getTime());
            sql.append("AND ASSIGNQUERY.CREATEDTIME < {" + d + "} ");
        }
        sql.append("order by serial,CREATEDTIME ");
        if (StringUtils.isEmpty((String)this.sp.getSortType())) {
            sql.append("DESC");
        } else {
            sql.append(this.sp.getSortType());
        }
        return sql.toString();
    }

    public URLInfo getEditUrlInfoByAssign(String assignid) {
        URLInfo info = new URLInfo();
        if (!assignid.endsWith("WFWKITEM")) {
            return info;
        }
        try {
            ExtendedAttributeDef extend1;
            ApproveActivityDef approDef;
            ExtendedAttributeDef extend;
            Map m;
            Object act;
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(this.ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignid);
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            String billID = "";
            if (bizObjectID != null && bizObjectID[0] != null) {
                billID = bizObjectID[0];
                info.setBillID(billID);
            }
            if (billID != null) {
                billID = billID.replaceAll(" ", "+");
            }
            if ((act = (m = iEnactmentService.getActivityDefAndActivityInstInfo(assInfo.getAssignmentId())).get("ACTIVITYDEF")) instanceof WebBillManpowerActivityDef) {
                Map argumentMap = iEnactmentService.getAssignmentArgument(assInfo.getAssignmentId(), true);
                StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                if (webUrl.length() > 0) {
                    Iterator it = argumentMap.keySet().iterator();
                    while (it.hasNext()) {
                        String paraName = it.next().toString();
                        if (!"formid".equalsIgnoreCase(paraName)) continue;
                        String paraValue = null;
                        try {
                            paraValue = StringUtils.replace((String)URLEncoder.encode(String.valueOf(argumentMap.get(paraName)), "utf-8"), (String)"+", (String)"%2B");
                        }
                        catch (Exception ex) {
                            paraValue = "";
                        }
                        webUrl.append(webUrl.indexOf("?") < 0 ? "?" : "&").append(paraName).append("=").append(paraValue);
                        break;
                    }
                    logger.info((Object)("WebBillManpowerActivityDef webUrl = " + webUrl.toString()));
                    info.setURL(webUrl.toString());
                }
            } else if (act instanceof ApproveActivityDef && (extend = (approDef = (ApproveActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillApprove")) != null && "true".equalsIgnoreCase(extend.getValue()) && (extend1 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl")) != null && !StringUtils.isEmpty((String)extend1.getValue())) {
                info.setURL(extend1.getValue());
                logger.info((Object)("ApproveActivityDef url = " + extend1.getValue()));
            }
            if (StringUtils.isEmpty((String)info.getURL())) {
                String myUrl = this.getWebBillURL(billID);
                if (!StringUtils.isEmpty((String)myUrl)) {
                    info.setURL(myUrl);
                    logger.info((Object)("getEditUrlInfoByAssign1 myUrl = " + info.getURL()));
                    return info;
                }
                String editUIName = null;
                if (!StringUtils.isEmpty((String)billID) && "09DEC9DC".equals(BOSUuid.read((String)billID).getType().toString())) {
                    IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)this.ctx);
                    Map argumentMap = service.getAssignmentArgument(assInfo.getAssignmentId(), true);
                    editUIName = (String)argumentMap.get("UIClassName");
                }
                if (StringUtils.isEmpty(editUIName)) {
                    editUIName = ProcessCenterUtil.getEditUIClassByBillId((String)billID, (Context)this.ctx);
                }
                String[] results = this.getURLByClassName(editUIName);
                info.setURL(results[0]);
                info.setHeight(results[1]);
                info.setWidth(results[2]);
                info.setOpenWay(results[3]);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPageError", (Throwable)e);
        }
        logger.info((Object)("getEditUrlInfoByAssign1 url = " + info.getURL()));
        return info;
    }

    private String[] getURLByClassName(String className) {
        String[] result = new String[4];
        try {
            if (className != null) {
                String name = className.substring(className.lastIndexOf(".") + 1, className.length());
                UIObjectCtrl ctrl = new UIObjectCtrl(this.ctx);
                String bizPackgeName = className.substring(0, className.lastIndexOf("."));
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, name);
                UIObjectInfo ui = ctrl.getValue((IMetaDataPK)metaPK);
                Map map = ui.getExtendedProperties();
                if (map != null && map.size() > 0) {
                    result[0] = (String)map.get("url");
                    if (StringUtils.isEmpty((String)result[0])) {
                        logger.warn((Object)("UI " + className + "URL"));
                    }
                    result[1] = (String)map.get("height");
                    result[2] = (String)map.get("width");
                    result[3] = (String)map.get("openWay");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("get url error: " + className), (Throwable)e);
        }
        return result;
    }

    private String getWebBillURL(String billID) {
        String[] dynamicEditUrl = ProcessCenterUtil.getDynamicEditURLByBillId((String)billID, (Context)this.ctx);
        if (dynamicEditUrl != null && dynamicEditUrl.length == 2) {
            StringBuffer urlStr = new StringBuffer(dynamicEditUrl[0]);
            if (!StringUtils.isEmpty((String)dynamicEditUrl[1])) {
                urlStr.append(urlStr.indexOf("?") < 0 ? "?" : "&").append("uipk").append("=").append(dynamicEditUrl[1]);
            }
            logger.info((Object)("getWebBillURL-urlStr.toString()= " + urlStr.toString()));
            return urlStr.toString();
        }
        String webUIurl = StoreUtils.getWebUIurl((String)billID, (Context)this.ctx);
        if (webUIurl != null) {
            logger.info((Object)("getWebBillURL-webUIurl= " + webUIurl));
            return webUIurl;
        }
        return "";
    }
}

