/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.business;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.cp.eip.fts.FullTextModuleEnum;
import com.kingdee.eas.cp.eip.fts.app.BusinessDataObject;
import com.kingdee.eas.cp.eip.fts.business.BusinessResource;
import com.kingdee.eas.cp.eip.fts.documents.I_ExtractionResult;
import com.kingdee.eas.cp.eip.fts.documents.I_TextExtractor;
import com.kingdee.eas.cp.eip.fts.documents.RichTextDocumentManager;
import com.kingdee.eas.cp.eip.fts.utils.FtsContext;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EasAttachmentResource
extends BusinessResource {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.fts.business.EasAttachmentResource");

    public EasAttachmentResource() {
        this.fullTextModuleEnum = FullTextModuleEnum.OTHER;
    }

    protected List query(Context context, FtsContext ctx) {
        SelectorItemCollection sic = new SelectorItemCollection();
        ArrayList<BusinessDataObject> list = new ArrayList<BusinessDataObject>();
        BusinessDataObject obj = null;
        try {
            Timestamp max = this.getLastRunTime();
            Timestamp cur = null;
            IAttachment ia = AttachmentFactory.getLocalInstance((Context)context);
            EntityViewInfo view = new EntityViewInfo();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simplename"));
            sic.add(new SelectorItemInfo("file"));
            sic.add(new SelectorItemInfo("boAttchAsso.boID"));
            sic.add(new SelectorItemInfo("description"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            FilterInfo filter = new FilterInfo();
            if (this.getLastRunTime() != null) {
                filter.getFilterItems().add(new FilterItemInfo("FLastUpdateTime", (Object)this.getLastRunTime(), CompareType.GREATER_EQUALS));
                view.setFilter(filter);
            }
            SorterItemInfo item = new SorterItemInfo("FLastUpdateTime");
            view.getSorter().add(item);
            String sub = view.toString();
            IRowSet rowset = DbUtil.executeQuery((Context)context, (String)("select top 100 FID,FLastUpdateTime  from T_BAS_Attachment " + sub));
            RichTextDocumentManager richMgr = new RichTextDocumentManager();
            I_TextExtractor textExt = null;
            AttachmentInfo info = null;
            String ctxStr = null;
            while (rowset.next()) {
                try {
                    String _id = rowset.getString("FID");
                    info = ia.getAttachmentInfo((IObjectPK)new ObjectUuidPK(_id), sic);
                    obj = new BusinessDataObject();
                    String boId = null;
                    if (info.getBoAttchAsso() != null && info.getBoAttchAsso().size() > 0) {
                        boId = info.getBoAttchAsso().get(0).getBoID();
                    }
                    obj.setUuid(boId + ";" + info.getId().toString());
                    obj.setTitle(Utils.formatType(info.getSimpleName(), -1) + " " + info.getName());
                    this.logger.info((Object)("%%%%%%%%new update index.............,attachment:" + info.getSimpleName() + ",name:" + info.getName() + ",displayname:" + info.getDisplayName()));
                    textExt = richMgr.getTextExtractor(info.getSimpleName());
                    ctxStr = info.getDescription();
                    if (textExt != null) {
                        obj.setContent(ctxStr + textExt.extractText(Utils.unpack(info.getFile())).getContent());
                    } else {
                        obj.setContent(ctxStr);
                    }
                    if (info.getCreator() != null) {
                        obj.setCreateUser(info.getCreator().getName());
                    }
                    if (boId != null) {
                        obj.setGategory(Utils.getGategoryById(boId));
                    }
                    if (boId != null && "b".equals(info.getSimpleName())) {
                        obj.setPath("cm/ContentView.do?contentId=" + URLEncoder.encode(boId, "utf-8"));
                    } else {
                        obj.setPath("easDownload.do?downloadId=" + URLEncoder.encode(info.getId().toString(), "utf-8"));
                    }
                    obj.setCreateTime(info.getCreateTime());
                    cur = info.getLastUpdateTime();
                    if (max == null || max.before(cur)) {
                        max = cur;
                    }
                    obj.setLastUpdateTime(cur);
                    list.add(obj);
                }
                catch (Exception e) {
                    this.logger.info((Object)("\u951f\u65a4\u62f7\u951f\u65a4\u62f7" + info.getName() + "\u951f\u65a4\u62f7b\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u5931\u951f\u65a4\u62f7" + " :"), (Throwable)e);
                }
            }
            this.setLastRunTime(max);
            if (sub != null && sub.indexOf("ORDER BY") > -1) {
                sub = sub.substring(0, sub.indexOf("ORDER BY"));
            }
            IRowSet row = DbUtil.executeQuery((Context)context, (String)("select count(*)  from T_BAS_Attachment " + sub));
            int total = 0;
            while (row.next()) {
                total = row.getInt(1);
            }
            if (total > 100) {
                ctx.addResource(this);
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u951f\u65a4\u62f7b\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u5931\u951f\u65a4\u62f7" + e.getMessage()));
        }
        return list;
    }

    protected List format(IRowSet rowSet) {
        ArrayList<BusinessDataObject> list = new ArrayList<BusinessDataObject>();
        BusinessDataObject obj = null;
        RichTextDocumentManager richMgr = new RichTextDocumentManager();
        I_TextExtractor textExt = null;
        try {
            while (rowSet.next()) {
                I_ExtractionResult extResult;
                obj = new BusinessDataObject();
                obj.setUuid(rowSet.getString("id"));
                obj.setTitle(rowSet.getString("name"));
                textExt = richMgr.getTextExtractor(rowSet.getString("simplename"));
                obj.setGategory(Utils.getGategoryById(rowSet.getString("boAttchAsso.boID")));
                obj.setKeyWord(rowSet.getString("name"));
                String txt = rowSet.getString("file");
                if (txt == null) {
                    txt = "";
                }
                if ((extResult = textExt.extractText(txt.getBytes("utf-8"))) != null) {
                    obj.setContent(extResult.getContent());
                }
                obj.setCreateUser(rowSet.getString("creator.name"));
                obj.setCreateTime(rowSet.getTimestamp("createTime"));
                obj.setLastUpdateUser(rowSet.getString("lastUpdateUser.name"));
                obj.setLastUpdateTime(rowSet.getTimestamp("lastUpdateTime"));
                list.add(obj);
            }
        }
        catch (SQLException e) {
            this.logger.info((Object)Utils.buildDetail(e));
        }
        catch (ClassNotFoundException e) {
            this.logger.warn((Object)("index build error:" + e));
        }
        catch (InstantiationException e) {
            this.logger.warn((Object)("index build error:" + e));
        }
        catch (IllegalAccessException e) {
            this.logger.warn((Object)("index build error:" + e));
        }
        catch (Exception e) {
            this.logger.info((Object)Utils.buildDetail(e));
        }
        return list;
    }
}

