/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.business;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.fme.app.DocumentFactory;
import com.kingdee.eas.base.fme.app.IDocument;
import com.kingdee.eas.cp.eip.fts.FullTextModuleEnum;
import com.kingdee.eas.cp.eip.fts.app.BusinessDataObject;
import com.kingdee.eas.cp.eip.fts.business.EasBusinessResource;
import com.kingdee.eas.cp.eip.fts.documents.I_TextExtractor;
import com.kingdee.eas.cp.eip.fts.documents.RichTextDocumentManager;
import com.kingdee.eas.cp.eip.fts.utils.FtsContext;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EasCPDocumentResource
extends EasBusinessResource {
    Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.fts.business.EasCPDocumentResource");
    private static Context ctx = null;
    private String localDirectoryAndFileName = null;

    public EasCPDocumentResource() {
        this.queryName = "DocumentQuery";
        this.queryPackage = "com.kingdee.eas.cp.dm.app";
        this.fullTextModuleEnum = FullTextModuleEnum.CPDM;
    }

    protected List format(IRowSet rowSet) {
        ArrayList<BusinessDataObject> list = new ArrayList<BusinessDataObject>();
        BusinessDataObject obj = null;
        try {
            Timestamp max = this.getLastRunTime();
            Timestamp cur = null;
            while (rowSet.next()) {
                obj = new BusinessDataObject();
                obj.setUuid(rowSet.getString("fid"));
                obj.setTitle(StringUtils.defaultString((String)rowSet.getString("ftitle")) + " " + StringUtils.defaultString((String)this.fullTextModuleEnum.getAlias(this.context.getLocale())));
                obj.setCreateTime(rowSet.getTimestamp("fcreateTime"));
                cur = rowSet.getTimestamp("flastUpdateTime");
                if (max == null || max.before(cur)) {
                    max = cur;
                }
                obj.setLastUpdateTime(rowSet.getTimestamp("flastUpdateTime"));
                obj.setKeyWord(StringUtils.defaultString((String)rowSet.getString("ftitle")));
                obj.setPath("/easGui?uuid=" + rowSet.getString("fid"));
                obj.setContent(this.getContent(rowSet));
                obj.setGategory(this.fullTextModuleEnum.getValue());
                obj.setPeritemName("dm_Document_View");
                list.add(obj);
            }
            this.setLastRunTime(max);
        }
        catch (SQLException e) {
            this.logger.warn((Object)("\u93c2\u56e8\u3002\u9350\u546d\ue190\u7487\u8bf2\u5f47\u6fb6\u8fab\u89e6\u951b\ufffd" + e.getMessage()));
        }
        catch (BOSException ex) {
            this.logger.error((Object)ex.getMessage(), ex.getCause());
        }
        return list;
    }

    protected List query(Context context, FtsContext ctx) {
        EasCPDocumentResource.ctx = context;
        try {
            Timestamp max = this.getLastRunTime();
            Object cur = null;
            IDocument document = DocumentFactory.getLocalInstance((Context)context);
            StringBuffer sqlStr = new StringBuffer();
            sqlStr.append("select d.FDocMarkNumber, d.fcontenttype, d.fid, a.fid as attachmentId, d.ftitle,d.fcreatetime, a.ftype,");
            sqlStr.append("a.fsize,d.fcreatetime, d.flastUpdateTime, d.FSummary,d.FTag, d.FVerComment ");
            sqlStr.append(", (select fname_l2 from t_bd_person where fid = d.fauthorid) as fauthorName");
            sqlStr.append(", (select fname_l2 from t_dm_category where fid = d.fcategoryId) as fcategoryName");
            sqlStr.append(" from t_dm_document d inner join T_BAS_BoAttchAsso bo on bo.fboid=d.fid inner join T_BAS_Attachment  a on a.fid =bo.fattachmentID  ");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sqlStr.toString());
            if (rs != null) {
                this.logger.info((Object)("%%%%%%%%new update index.............,@EasBusinessResource, rs.size() :" + rs.size()));
                int total = rs.getMaxRows();
                ctx.addResource(this);
            }
            return this.format(rs);
        }
        catch (Exception e) {
            this.logger.info((Object)Utils.buildDetail(e));
            return null;
        }
    }

    protected String getContent(IRowSet rowSet) throws SQLException, BOSException {
        StringBuffer content = new StringBuffer();
        Object sql = null;
        Object conn = null;
        Object statement = null;
        RichTextDocumentManager richMgr = new RichTextDocumentManager();
        I_TextExtractor textExt = null;
        AttachmentInfo info = null;
        String ctxStr = null;
        IAttachment ia = AttachmentFactory.getLocalInstance((Context)ctx);
        BusinessDataObject obj = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("simplename"));
        sic.add(new SelectorItemInfo("file"));
        sic.add(new SelectorItemInfo("boAttchAsso.boID"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        int contentType = rowSet.getInt("fcontenttype");
        Timestamp cur = null;
        String docType = Utils.mapType(rowSet.getString("ftype"), contentType);
        try {
            String _id = rowSet.getString("attachmentId");
            info = ia.getAttachmentInfo((IObjectPK)new ObjectUuidPK(_id), sic);
            obj = new BusinessDataObject();
            String boId = null;
            if (info.getBoAttchAsso() != null && info.getBoAttchAsso().size() > 0) {
                boId = info.getBoAttchAsso().get(0).getBoID();
            }
            obj.setUuid(boId + ";" + info.getId().toString());
            obj.setTitle(Utils.formatType(docType, contentType) + " " + info.getName());
            this.logger.info((Object)("%%%%%%%%new update index.............,attachment:" + info.getSimpleName() + ",name:" + info.getName() + ",displayname:" + info.getDisplayName()));
            textExt = richMgr.getTextExtractor(docType);
            ctxStr = info.getDescription();
            if (textExt != null) {
                obj.setContent(ctxStr + textExt.extractText(Utils.unpack(info.getFile())).getContent());
            } else {
                obj.setContent(ctxStr);
            }
            if (info.getCreator() != null) {
                obj.setCreateUser(info.getCreator().getName());
            }
            if (boId != null) {
                obj.setGategory(Utils.getGategoryById(boId));
            }
            if (boId != null && "b".equals(info.getSimpleName())) {
                obj.setPath("cm/ContentView.do?contentId=" + URLEncoder.encode(boId, "utf-8"));
            } else {
                obj.setPath("easDownload.do?downloadId=" + URLEncoder.encode(info.getId().toString(), "utf-8"));
            }
            obj.setCreateTime(info.getCreateTime());
            cur = info.getLastUpdateTime();
            obj.setLastUpdateTime(cur);
        }
        catch (Exception e) {
            this.logger.info((Object)("\u951f\u65a4\u62f7\u951f\u65a4\u62f7" + info.getName() + "\u951f\u65a4\u62f7b\u951f\u65a4\u62f7\u951f\u65a4\u62f7\u5931\u951f\u65a4\u62f7" + " :"), (Throwable)e);
        }
        String docId = rowSet.getString("fid");
        String attachmentName = this.getAttachmentName(docId, ctx);
        Object entry = null;
        Object rs = null;
        content.append("" + StringUtils.defaultString((String)rowSet.getString("ftitle")) + "" + StringUtils.defaultString((String)attachmentName));
        content.append(obj.getTitle() + obj.getKeyWord() + obj.getContent() + StringUtils.defaultString((String)rowSet.getString("FSummary")) + StringUtils.defaultString((String)rowSet.getString("FTag")) + StringUtils.defaultString((String)rowSet.getString("FVerComment")) + StringUtils.defaultString((String)rowSet.getString("FDocMarkNumber")));
        content.append(StringUtils.defaultString((String)rowSet.getString("fauthorName")));
        content.append(StringUtils.defaultString((String)rowSet.getString("fcategoryName")));
        return content.toString();
    }

    public String convertBlobToString(Blob blob) {
        String result = "";
        try {
            ByteArrayInputStream msgContent = (ByteArrayInputStream)blob.getBinaryStream();
            byte[] byte_data = new byte[msgContent.available()];
            msgContent.read(byte_data, 0, byte_data.length);
            result = new String(byte_data);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getAttachmentName(String docId, Context ctx) {
        String rtnVal = "";
        String selectSql = "select fdisplayname from T_FME_BusiDoc where FbusinessId= '" + docId + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            StringBuffer temp = new StringBuffer();
            while (rowSet.next()) {
                temp.append(rowSet.getString("fdisplayname") + ",");
            }
            rtnVal = temp.toString();
            if (rtnVal.endsWith(",")) {
                rtnVal = rtnVal.substring(0, rtnVal.length() - 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return rtnVal;
    }
}

