/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.documents;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMContentUtils {
    public static HashMap linkParams = new HashMap();

    public static final boolean getText(StringBuffer sb, Node node, boolean abortOnNestedAnchors) {
        return DOMContentUtils.getTextHelper(sb, node, abortOnNestedAnchors, 0);
    }

    public static final void getText(StringBuffer sb, Node node) {
        DOMContentUtils.getText(sb, node, false);
    }

    private static final boolean getTextHelper(StringBuffer sb, Node node, boolean abortOnNestedAnchors, int anchorDepth) {
        if ("script".equalsIgnoreCase(node.getNodeName())) {
            return false;
        }
        if ("style".equalsIgnoreCase(node.getNodeName())) {
            return false;
        }
        if (abortOnNestedAnchors && "a".equalsIgnoreCase(node.getNodeName()) && ++anchorDepth > 1) {
            return true;
        }
        if (node.getNodeType() == 8) {
            return false;
        }
        if (node.getNodeType() == 3) {
            String text = node.getNodeValue();
            text = text.replaceAll("\\s+", " ");
            if ((text = text.trim()).length() > 0) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(text);
            }
        }
        boolean abort = false;
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (!DOMContentUtils.getTextHelper(sb, children.item(i), abortOnNestedAnchors, anchorDepth)) continue;
                abort = true;
                break;
            }
        }
        return abort;
    }

    public static final boolean getTitle(StringBuffer sb, Node node) {
        if (node.getNodeType() == 1 && "title".equalsIgnoreCase(node.getNodeName())) {
            DOMContentUtils.getText(sb, node);
            return true;
        }
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (!DOMContentUtils.getTitle(sb, children.item(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static final URL getBase(Node node) {
        NodeList children;
        if (node.getNodeType() == 1 && "base".equalsIgnoreCase(node.getNodeName())) {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                if (!"href".equalsIgnoreCase(attr.getNodeName())) continue;
                try {
                    return new URL(attr.getNodeValue());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                URL base = DOMContentUtils.getBase(children.item(i));
                if (base == null) continue;
                return base;
            }
        }
        return null;
    }

    private static boolean hasOnlyWhiteSpace(Node node) {
        String val = node.getNodeValue();
        for (int i = 0; i < val.length(); ++i) {
            if (Character.isWhitespace(val.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldThrowAwayLink(Node node, NodeList children, int childLen, LinkParams params) {
        if (childLen == 0) {
            return params.childLen != 0;
        }
        if (childLen == 1 && children.item(0).getNodeType() == 1 && params.elName.equalsIgnoreCase(children.item(0).getNodeName())) {
            return true;
        }
        if (childLen == 2) {
            Node c0 = children.item(0);
            Node c1 = children.item(1);
            if (c0.getNodeType() == 1 && params.elName.equalsIgnoreCase(c0.getNodeName()) && c1.getNodeType() == 3 && DOMContentUtils.hasOnlyWhiteSpace(c1)) {
                return true;
            }
            if (c1.getNodeType() == 1 && params.elName.equalsIgnoreCase(c1.getNodeName()) && c0.getNodeType() == 3 && DOMContentUtils.hasOnlyWhiteSpace(c0)) {
                return true;
            }
        } else if (childLen == 3) {
            Node c0 = children.item(0);
            Node c1 = children.item(1);
            Node c2 = children.item(2);
            if (c1.getNodeType() == 1 && params.elName.equalsIgnoreCase(c1.getNodeName()) && c0.getNodeType() == 3 && c2.getNodeType() == 3 && DOMContentUtils.hasOnlyWhiteSpace(c0) && DOMContentUtils.hasOnlyWhiteSpace(c2)) {
                return true;
            }
        }
        return false;
    }

    static {
        linkParams.put("a", new LinkParams("a", "href", 1));
        linkParams.put("area", new LinkParams("area", "href", 0));
        linkParams.put("frame", new LinkParams("frame", "src", 0));
        linkParams.put("iframe", new LinkParams("iframe", "src", 0));
    }

    public static class LinkParams {
        public String elName;
        public String attrName;
        public int childLen;

        public LinkParams(String elName, String attrName, int childLen) {
            this.elName = elName;
            this.attrName = attrName;
            this.childLen = childLen;
        }

        public String toString() {
            return "LP[el=" + this.elName + ",attr=" + this.attrName + ",len=" + this.childLen + "]";
        }
    }
}

