/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene1.analysis.Token;
import org.apache.lucene1.analysis.TokenFilter;
import org.apache.lucene1.analysis.TokenStream;

public final class StopFilter
extends TokenFilter {
    private Set stopWords;

    public StopFilter(TokenStream in, String[] stopWords) {
        super(in);
        this.stopWords = StopFilter.makeStopSet(stopWords);
    }

    public StopFilter(TokenStream in, Hashtable stopTable) {
        super(in);
        this.stopWords = new HashSet(stopTable.keySet());
    }

    public StopFilter(TokenStream in, Set stopWords) {
        super(in);
        this.stopWords = stopWords;
    }

    public static final Hashtable makeStopTable(String[] stopWords) {
        Hashtable<String, String> stopTable = new Hashtable<String, String>(stopWords.length);
        for (int i = 0; i < stopWords.length; ++i) {
            stopTable.put(stopWords[i], stopWords[i]);
        }
        return stopTable;
    }

    public static final Set makeStopSet(String[] stopWords) {
        HashSet<String> stopTable = new HashSet<String>(stopWords.length);
        for (int i = 0; i < stopWords.length; ++i) {
            stopTable.add(stopWords[i]);
        }
        return stopTable;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            if (!this.stopWords.contains(token.termText)) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }
}

